"""annotations table

Revision ID: 0008
Revises: 0007
Create Date: 2025-02-02 16:17:32.835732

"""

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql
from sqlmodel.sql.sqltypes import AutoString

# revision identifiers, used by Alembic.
revision: str = "0008"
down_revision: str | None = "0007"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    sa.Enum("MANUAL", "VERIFIED", "EDITED", name="evaluationtype").create(op.get_bind())
    sa.Enum("PASS", "FAIL", name="label").create(op.get_bind())
    op.create_table(
        "annotations",
        sa.Column("uuid", sa.Uuid(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("organization_uuid", sa.Uuid(), nullable=False),
        sa.Column(
            "label",
            postgresql.ENUM("PASS", "FAIL", name="label", create_type=False),
            nullable=True,
        ),
        sa.Column("reasoning", AutoString(), nullable=True),
        sa.Column(
            "type",
            postgresql.ENUM(
                "MANUAL", "VERIFIED", "EDITED", name="evaluationtype", create_type=False
            ),
            nullable=True,
        ),
        sa.Column("assigned_to", sa.Uuid(), nullable=True),
        sa.Column("project_uuid", sa.Uuid(), nullable=True),
        sa.Column("span_uuid", sa.Uuid(), nullable=True),
        sa.Column("generation_uuid", sa.Uuid(), nullable=True),
        sa.ForeignKeyConstraint(
            ["assigned_to"],
            ["users.uuid"],
            name=op.f("annotations_assigned_to_users_fkey"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["generation_uuid"],
            ["generations.uuid"],
            name=op.f("annotations_generation_uuid_generations_fkey"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["organization_uuid"],
            ["organizations.uuid"],
            name=op.f("annotations_organization_uuid_organizations_fkey"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["project_uuid"],
            ["projects.uuid"],
            name=op.f("annotations_project_uuid_projects_fkey"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["span_uuid"],
            ["spans.uuid"],
            name=op.f("annotations_span_uuid_spans_fkey"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("uuid", name=op.f("annotations_pkey")),
    )
    with op.batch_alter_table("annotations", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("annotations_label_idx"), ["label"], unique=False
        )
        batch_op.create_index(
            batch_op.f("annotations_organization_uuid_idx"),
            ["organization_uuid"],
            unique=False,
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("annotations", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("annotations_organization_uuid_idx"))
        batch_op.drop_index(batch_op.f("annotations_label_idx"))

    op.drop_table("annotations")
    sa.Enum("PASS", "FAIL", name="label").drop(op.get_bind())
    sa.Enum("MANUAL", "VERIFIED", "EDITED", name="evaluationtype").drop(op.get_bind())
    # ### end Alembic commands ###
