# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03_nums.ipynb.

# %% auto 0
__all__ = ['asint', 'asfloat', 'ascomplex', 'asnum']

# %% ../nbs/03_nums.ipynb 6
#| export


# %% ../nbs/03_nums.ipynb 8
from typing import Any, Union, TypeAlias, ParamSpec

# %% ../nbs/03_nums.ipynb 10
#| export


# %% ../nbs/03_nums.ipynb 12
from atyp import NumberQ
from calr import applyfns
from chck import isnum

# %% ../nbs/03_nums.ipynb 14
from .cast import caster

# %% ../nbs/03_nums.ipynb 16
@caster(int, retnone=False)
def asint(x, retnone: bool = False) -> Union[int, None]:
    'Converts `x` to an `int` if possible, otherwise returns `None`.'

@caster(float, retnone=False)
def asfloat(x, retnone: bool = False) -> Union[float, None]:
    'Converts `x` to an `int` if possible, otherwise returns `None`.'

@caster(complex, retnone=False)
def ascomplex(x, retnone: bool = False) -> Union[float, None]:
    'Converts `x` to an `int` if possible, otherwise returns `None`.'

# %% ../nbs/03_nums.ipynb 17
def asnum(x, retnone: bool = False) -> NumberQ:
    return applyfns(x, (asint, asfloat, ascomplex, ), check=isnum, retnone=retnone)
