# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/08_sets.ipynb.

# %% auto 0
__all__ = ['try2set', 'any2set', 'setchain', 'asset']

# %% ../nbs/08_sets.ipynb 6
#| export


# %% ../nbs/08_sets.ipynb 8
from typing import Optional

# %% ../nbs/08_sets.ipynb 10
#| export


# %% ../nbs/08_sets.ipynb 12
from atyp import IntQ, ListQ
from calr import applyfns
from chck import isiter, islist, istuple, isset, isslice, isiter, isiternotstr

# %% ../nbs/08_sets.ipynb 14
#| export


# %% ../nbs/08_sets.ipynb 16
def try2set(a) -> set:
    if isset(a): return a
    try: return set([a]) if not isiternotstr(a) else set(a)
    except: return a

# %% ../nbs/08_sets.ipynb 17
def any2set(obj) -> set:
    '''Tries to convert any object to a set. If the object is a string, it will be converted to a set of length 1.'''    
    if isinstance(obj, str): obj = set((obj, ))
    elif not isiter(obj): obj = set((obj, )) # not a string and not iterable

    elif any(c(obj) for c in (isiter, islist, istuple)) and not isset(obj):    
        obj = set(obj)
    elif hasattr(obj, '__hash__'): obj = {obj, }
    else:
        try: obj = set(obj)
        except TypeError: obj = set()
    return obj if isset(obj) else set()

# %% ../nbs/08_sets.ipynb 18
def setchain(x, funcs, *args, **kwargs): 
    return applyfns(x, funcs, *args, check=isset, **kwargs)

# %% ../nbs/08_sets.ipynb 20
def asset(a, *args, **kwargs) -> slice:
    if isset(a): return a
    chain = (any2set, try2set, )
    return setchain(a, chain, *args, **kwargs)
