# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/06_slcs.ipynb.

# %% auto 0
__all__ = ['safeslice', 'slice2list', 'try2slc', 'slcchain', 'asslc']

# %% ../nbs/06_slcs.ipynb 6
#| export


# %% ../nbs/06_slcs.ipynb 8
from typing import Optional

# %% ../nbs/06_slcs.ipynb 10
#| export


# %% ../nbs/06_slcs.ipynb 12
from atyp import IntQ, ListQ
from chck import isnone, isdict, notnone, isslice, isiter
from calr import applyfns

# %% ../nbs/06_slcs.ipynb 14
#| export


# %% ../nbs/06_slcs.ipynb 16
def safeslice(s: slice) -> slice:
    '''Returns a slice with default values instead None values from the input slice.
    e.g. slice(IntQ, IntQ, IntQ) -> slice(0, 1, 1)
    '''
    if not isslice(s): return s
    start = s.start if notnone(s.start) else 0
    stop  = s.stop  if notnone(s.stop)  else min(0, start, max(1, start))
    step  = s.step  if notnone(s.step)  else 1
    return slice(start, stop, step)

def slice2list(s: slice) -> tuple[IntQ, int, IntQ]:
    '''Returns a list of integers from a slice.'''    
    s = safeslice(s)
    try:    return list(range(s.start, s.stop, s.step))
    except: return list()

def try2slc(a) -> slice:
    if isslice(a): return a
    try: return slice(*list((a, )if not isiter(a) else a))    
    except: return a

# %% ../nbs/06_slcs.ipynb 17
def slcchain(x, funcs, *args, **kwargs): 
    return applyfns(x, funcs, *args, check=isslice, **kwargs)

# %% ../nbs/06_slcs.ipynb 19
def asslc(a, *args, **kwargs) -> slice:
    if isslice(a): return a
    chain = (safeslice, try2slc, )
    slc = slcchain(a, chain, *args, **kwargs)
    if kwargs.pop('__nones_ok', False): return slc
    return safeslice(slc)
