"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import common.healthcheck.v1beta.healthcheck_pb2
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _View:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_View.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    VIEW_UNSPECIFIED: _View.ValueType  # 0
    """Unspecified, equivalent to BASIC."""
    VIEW_BASIC: _View.ValueType  # 1
    """Default view, only includes basic information."""
    VIEW_FULL: _View.ValueType  # 2
    """Full representation."""

class View(_View, metaclass=_ViewEnumTypeWrapper):
    """View defines how a resource is presented. It can be used as a parameter in a
    method request to allow clients to select the amount of information they
    want in the response.
    """

VIEW_UNSPECIFIED: View.ValueType  # 0
"""Unspecified, equivalent to BASIC."""
VIEW_BASIC: View.ValueType  # 1
"""Default view, only includes basic information."""
VIEW_FULL: View.ValueType  # 2
"""Full representation."""
global___View = View

class _OwnerType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OwnerTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OwnerType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    OWNER_TYPE_UNSPECIFIED: _OwnerType.ValueType  # 0
    """OwnerType: UNSPECIFIED"""
    OWNER_TYPE_USER: _OwnerType.ValueType  # 1
    """OwnerType: USER"""
    OWNER_TYPE_ORGANIZATION: _OwnerType.ValueType  # 2
    """OwnerType: ORGANIZATION"""

class OwnerType(_OwnerType, metaclass=_OwnerTypeEnumTypeWrapper):
    """OwnerType enumerates the owner type of any resource"""

OWNER_TYPE_UNSPECIFIED: OwnerType.ValueType  # 0
"""OwnerType: UNSPECIFIED"""
OWNER_TYPE_USER: OwnerType.ValueType  # 1
"""OwnerType: USER"""
OWNER_TYPE_ORGANIZATION: OwnerType.ValueType  # 2
"""OwnerType: ORGANIZATION"""
global___OwnerType = OwnerType

class _MembershipState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MembershipStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MembershipState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    MEMBERSHIP_STATE_UNSPECIFIED: _MembershipState.ValueType  # 0
    """Unspecified."""
    MEMBERSHIP_STATE_ACTIVE: _MembershipState.ValueType  # 1
    """Active."""
    MEMBERSHIP_STATE_PENDING: _MembershipState.ValueType  # 2
    """Pending, i.e., a request has been sent to the user to join an
    organization.
    """

class MembershipState(_MembershipState, metaclass=_MembershipStateEnumTypeWrapper):
    """MembershipState describes the state of a user membership to an organization."""

MEMBERSHIP_STATE_UNSPECIFIED: MembershipState.ValueType  # 0
"""Unspecified."""
MEMBERSHIP_STATE_ACTIVE: MembershipState.ValueType  # 1
"""Active."""
MEMBERSHIP_STATE_PENDING: MembershipState.ValueType  # 2
"""Pending, i.e., a request has been sent to the user to join an
organization.
"""
global___MembershipState = MembershipState

class _OnboardingStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OnboardingStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OnboardingStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ONBOARDING_STATUS_UNSPECIFIED: _OnboardingStatus.ValueType  # 0
    """Unspecified."""
    ONBOARDING_STATUS_IN_PROGRESS: _OnboardingStatus.ValueType  # 1
    """In progress, i.e., the user has initiated the onboarding process
    but has not yet completed it.
    """
    ONBOARDING_STATUS_COMPLETED: _OnboardingStatus.ValueType  # 2
    """Completed."""

class OnboardingStatus(_OnboardingStatus, metaclass=_OnboardingStatusEnumTypeWrapper):
    """OnboardingStatus describes the status of the user onboarding process."""

ONBOARDING_STATUS_UNSPECIFIED: OnboardingStatus.ValueType  # 0
"""Unspecified."""
ONBOARDING_STATUS_IN_PROGRESS: OnboardingStatus.ValueType  # 1
"""In progress, i.e., the user has initiated the onboarding process
but has not yet completed it.
"""
ONBOARDING_STATUS_COMPLETED: OnboardingStatus.ValueType  # 2
"""Completed."""
global___OnboardingStatus = OnboardingStatus

@typing_extensions.final
class LivenessRequest(google.protobuf.message.Message):
    """Common

    LivenessRequest represents a request to check a service liveness status
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___LivenessRequest = LivenessRequest

@typing_extensions.final
class LivenessResponse(google.protobuf.message.Message):
    """LivenessResponse represents a response for a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___LivenessResponse = LivenessResponse

@typing_extensions.final
class ReadinessRequest(google.protobuf.message.Message):
    """ReadinessRequest represents a request to check a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___ReadinessRequest = ReadinessRequest

@typing_extensions.final
class ReadinessResponse(google.protobuf.message.Message):
    """ReadinessResponse represents a response for a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___ReadinessResponse = ReadinessResponse

@typing_extensions.final
class UserProfile(google.protobuf.message.Message):
    """UserProfile describes the public data of a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SocialProfileLinksEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    BIO_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    PUBLIC_EMAIL_FIELD_NUMBER: builtins.int
    COMPANY_NAME_FIELD_NUMBER: builtins.int
    SOCIAL_PROFILE_LINKS_FIELD_NUMBER: builtins.int
    display_name: builtins.str
    """Display name."""
    bio: builtins.str
    """Biography."""
    avatar: builtins.str
    """Avatar in base64 format."""
    public_email: builtins.str
    """Public email."""
    company_name: builtins.str
    """Company name."""
    @property
    def social_profile_links(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Social profile links list the links to the user's social profiles.
        The key represents the provider, and the value is the corresponding URL.
        """
    def __init__(
        self,
        *,
        display_name: builtins.str | None = ...,
        bio: builtins.str | None = ...,
        avatar: builtins.str | None = ...,
        public_email: builtins.str | None = ...,
        company_name: builtins.str | None = ...,
        social_profile_links: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_avatar", b"_avatar", "_bio", b"_bio", "_company_name", b"_company_name", "_display_name", b"_display_name", "_public_email", b"_public_email", "avatar", b"avatar", "bio", b"bio", "company_name", b"company_name", "display_name", b"display_name", "public_email", b"public_email"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_avatar", b"_avatar", "_bio", b"_bio", "_company_name", b"_company_name", "_display_name", b"_display_name", "_public_email", b"_public_email", "avatar", b"avatar", "bio", b"bio", "company_name", b"company_name", "display_name", b"display_name", "public_email", b"public_email", "social_profile_links", b"social_profile_links"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_avatar", b"_avatar"]) -> typing_extensions.Literal["avatar"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_bio", b"_bio"]) -> typing_extensions.Literal["bio"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_company_name", b"_company_name"]) -> typing_extensions.Literal["company_name"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_display_name", b"_display_name"]) -> typing_extensions.Literal["display_name"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_public_email", b"_public_email"]) -> typing_extensions.Literal["public_email"] | None: ...

global___UserProfile = UserProfile

@typing_extensions.final
class OrganizationProfile(google.protobuf.message.Message):
    """OrganizationProfile describes the public data of an organization."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SocialProfileLinksEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    BIO_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    PUBLIC_EMAIL_FIELD_NUMBER: builtins.int
    SOCIAL_PROFILE_LINKS_FIELD_NUMBER: builtins.int
    display_name: builtins.str
    """Display name."""
    bio: builtins.str
    """Biography."""
    avatar: builtins.str
    """Avatar in base64 format."""
    public_email: builtins.str
    """Public email."""
    @property
    def social_profile_links(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Social profile links list the links to the organization's social profiles.
        The key represents the provider, and the value is the corresponding URL.
        """
    def __init__(
        self,
        *,
        display_name: builtins.str | None = ...,
        bio: builtins.str | None = ...,
        avatar: builtins.str | None = ...,
        public_email: builtins.str | None = ...,
        social_profile_links: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_avatar", b"_avatar", "_bio", b"_bio", "_display_name", b"_display_name", "_public_email", b"_public_email", "avatar", b"avatar", "bio", b"bio", "display_name", b"display_name", "public_email", b"public_email"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_avatar", b"_avatar", "_bio", b"_bio", "_display_name", b"_display_name", "_public_email", b"_public_email", "avatar", b"avatar", "bio", b"bio", "display_name", b"display_name", "public_email", b"public_email", "social_profile_links", b"social_profile_links"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_avatar", b"_avatar"]) -> typing_extensions.Literal["avatar"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_bio", b"_bio"]) -> typing_extensions.Literal["bio"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_display_name", b"_display_name"]) -> typing_extensions.Literal["display_name"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_public_email", b"_public_email"]) -> typing_extensions.Literal["public_email"] | None: ...

global___OrganizationProfile = OrganizationProfile

@typing_extensions.final
class AuthenticatedUser(google.protobuf.message.Message):
    """AuthenticatedUser contains the information of an authenticated user, i.e.,
    the public user information plus some fields that should only be accessed by
    the user themselves.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    CUSTOMER_ID_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    NEWSLETTER_SUBSCRIPTION_FIELD_NUMBER: builtins.int
    COOKIE_TOKEN_FIELD_NUMBER: builtins.int
    ONBOARDING_STATUS_FIELD_NUMBER: builtins.int
    PROFILE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the user, defined by its ID.
    - Format: `users/{user.id}`.
    """
    uid: builtins.str
    """User UUID. This field is optionally set by users on creation (it will be
    server-generated if unspecified).
    """
    id: builtins.str
    """Resource ID (used in `name` as the last segment). This conforms to
    RFC-1034, which restricts to letters, numbers, and hyphen, with the first
    character a letter, the last a letter or a number, and a 63 character
    maximum.

    Note that the ID can be updated.
    """
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Update time."""
    email: builtins.str
    """Email."""
    customer_id: builtins.str
    """Stripe customer ID. This field is used in Instill Cloud."""
    role: builtins.str
    """Role.

    It must be one of the following allowed roles:
    - `manager`
    - `ai-researcher`
    - `ai-engineer`
    - `data-engineer`
    - `data-scientist`
    - `analytics-engineer`
    - `hobbyist`
    """
    newsletter_subscription: builtins.bool
    """This defines whether the user is subscribed to Instill AI's newsletter."""
    cookie_token: builtins.str
    """Console cookie token."""
    onboarding_status: global___OnboardingStatus.ValueType
    """Onboarding Status."""
    @property
    def profile(self) -> global___UserProfile:
        """Profile."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str | None = ...,
        id: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        email: builtins.str = ...,
        customer_id: builtins.str = ...,
        role: builtins.str | None = ...,
        newsletter_subscription: builtins.bool = ...,
        cookie_token: builtins.str | None = ...,
        onboarding_status: global___OnboardingStatus.ValueType = ...,
        profile: global___UserProfile | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_cookie_token", b"_cookie_token", "_role", b"_role", "_uid", b"_uid", "cookie_token", b"cookie_token", "create_time", b"create_time", "profile", b"profile", "role", b"role", "uid", b"uid", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_cookie_token", b"_cookie_token", "_role", b"_role", "_uid", b"_uid", "cookie_token", b"cookie_token", "create_time", b"create_time", "customer_id", b"customer_id", "email", b"email", "id", b"id", "name", b"name", "newsletter_subscription", b"newsletter_subscription", "onboarding_status", b"onboarding_status", "profile", b"profile", "role", b"role", "uid", b"uid", "update_time", b"update_time"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_cookie_token", b"_cookie_token"]) -> typing_extensions.Literal["cookie_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_role", b"_role"]) -> typing_extensions.Literal["role"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_uid", b"_uid"]) -> typing_extensions.Literal["uid"] | None: ...

global___AuthenticatedUser = AuthenticatedUser

@typing_extensions.final
class Owner(google.protobuf.message.Message):
    """Owner is a wrapper for User and Organization, used to embed owner information in other resources."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    ORGANIZATION_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___User:
        """User."""
    @property
    def organization(self) -> global___Organization:
        """Organization."""
    def __init__(
        self,
        *,
        user: global___User | None = ...,
        organization: global___Organization | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["organization", b"organization", "owner", b"owner", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["organization", b"organization", "owner", b"owner", "user", b"user"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["owner", b"owner"]) -> typing_extensions.Literal["user", "organization"] | None: ...

global___Owner = Owner

@typing_extensions.final
class User(google.protobuf.message.Message):
    """User describes an individual that interacts with Instill AI. It doesn't
    contain any private information about the user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    PROFILE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the user, defined by its ID.
    - Format: `users/{user.id}`.
    """
    uid: builtins.str
    """User UUID. This field is optionally set by users on creation (it will be
    server-generated if unspecified).
    """
    id: builtins.str
    """Resource ID (used in `name` as the last segment). This conforms to
    RFC-1034, which restricts to letters, numbers, and hyphen, with the first
    character a letter, the last a letter or a number, and a 63 character
    maximum.

    Note that the ID can be updated.
    """
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Update time."""
    @property
    def profile(self) -> global___UserProfile:
        """Profile."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str | None = ...,
        id: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        profile: global___UserProfile | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_uid", b"_uid", "create_time", b"create_time", "profile", b"profile", "uid", b"uid", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_uid", b"_uid", "create_time", b"create_time", "id", b"id", "name", b"name", "profile", b"profile", "uid", b"uid", "update_time", b"update_time"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_uid", b"_uid"]) -> typing_extensions.Literal["uid"] | None: ...

global___User = User

@typing_extensions.final
class ListUsersAdminRequest(google.protobuf.message.Message):
    """ListUsersAdminRequest represents a request to list all users by admin"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of users to return. If this parameter is unspecified,
    at most 10 pipelines will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___View.ValueType | None = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListUsersAdminRequest = ListUsersAdminRequest

@typing_extensions.final
class ListUsersAdminResponse(google.protobuf.message.Message):
    """ListUsersAdminResponse represents a response for a list of users"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___User]:
        """A list of users"""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of users."""
    def __init__(
        self,
        *,
        users: collections.abc.Iterable[global___User] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "total_size", b"total_size", "users", b"users"]) -> None: ...

global___ListUsersAdminResponse = ListUsersAdminResponse

@typing_extensions.final
class GetUserAdminRequest(google.protobuf.message.Message):
    """GetUserAdminRequest represents a request to query a user by admin"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name of a user. For example:
    "users/local-user"
    """
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserAdminRequest = GetUserAdminRequest

@typing_extensions.final
class GetUserAdminResponse(google.protobuf.message.Message):
    """GetUserAdminResponse represents a response for a user resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___User:
        """A user resource"""
    def __init__(
        self,
        *,
        user: global___User | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["user", b"user"]) -> None: ...

global___GetUserAdminResponse = GetUserAdminResponse

@typing_extensions.final
class LookUpUserAdminRequest(google.protobuf.message.Message):
    """LookUpUserAdminRequest represents a request to query a user via permalink by
    admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """Permalink of a user. For example:
    "users/{uid}"
    """
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpUserAdminRequest = LookUpUserAdminRequest

@typing_extensions.final
class LookUpUserAdminResponse(google.protobuf.message.Message):
    """LookUpUserAdminResponse represents a response for a user resource by admin"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___User:
        """A user resource"""
    def __init__(
        self,
        *,
        user: global___User | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["user", b"user"]) -> None: ...

global___LookUpUserAdminResponse = LookUpUserAdminResponse

@typing_extensions.final
class ListOrganizationsAdminRequest(google.protobuf.message.Message):
    """ListOrganizationsAdminRequest represents a request to list all organizations by admin"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of organizations to return. If this parameter is
    unspecified, at most 10 pipelines will be returned. The cap value for this
    parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___View.ValueType | None = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListOrganizationsAdminRequest = ListOrganizationsAdminRequest

@typing_extensions.final
class ListOrganizationsAdminResponse(google.protobuf.message.Message):
    """ListOrganizationsAdminResponse represents a response for a list of organizations"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def organizations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Organization]:
        """A list of organizations"""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of organizations."""
    def __init__(
        self,
        *,
        organizations: collections.abc.Iterable[global___Organization] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "organizations", b"organizations", "total_size", b"total_size"]) -> None: ...

global___ListOrganizationsAdminResponse = ListOrganizationsAdminResponse

@typing_extensions.final
class GetOrganizationAdminRequest(google.protobuf.message.Message):
    """GetOrganizationAdminRequest represents a request to query a organization by admin"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name of a organization. For example:
    "organizations/local-organization"
    """
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetOrganizationAdminRequest = GetOrganizationAdminRequest

@typing_extensions.final
class GetOrganizationAdminResponse(google.protobuf.message.Message):
    """GetOrganizationAdminResponse represents a response for a organization resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_FIELD_NUMBER: builtins.int
    @property
    def organization(self) -> global___Organization:
        """A organization resource"""
    def __init__(
        self,
        *,
        organization: global___Organization | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["organization", b"organization"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["organization", b"organization"]) -> None: ...

global___GetOrganizationAdminResponse = GetOrganizationAdminResponse

@typing_extensions.final
class LookUpOrganizationAdminRequest(google.protobuf.message.Message):
    """LookUpOrganizationAdminRequest represents a request to query a organization via permalink by
    admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """Permalink of a organization. For example:
    "organizations/{uid}"
    """
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpOrganizationAdminRequest = LookUpOrganizationAdminRequest

@typing_extensions.final
class LookUpOrganizationAdminResponse(google.protobuf.message.Message):
    """LookUpOrganizationAdminResponse represents a response for a organization resource by admin"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_FIELD_NUMBER: builtins.int
    @property
    def organization(self) -> global___Organization:
        """A organization resource"""
    def __init__(
        self,
        *,
        organization: global___Organization | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["organization", b"organization"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["organization", b"organization"]) -> None: ...

global___LookUpOrganizationAdminResponse = LookUpOrganizationAdminResponse

@typing_extensions.final
class ListUsersRequest(google.protobuf.message.Message):
    """ListUsersRequest represents a request to list all users."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of users to return. If this parameter is unspecified,
    at most 10 pipelines will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___View.ValueType | None = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListUsersRequest = ListUsersRequest

@typing_extensions.final
class ListUsersResponse(google.protobuf.message.Message):
    """ListUsersResponse contains a list of users."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___User]:
        """A list of user resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of users."""
    def __init__(
        self,
        *,
        users: collections.abc.Iterable[global___User] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "total_size", b"total_size", "users", b"users"]) -> None: ...

global___ListUsersResponse = ListUsersResponse

@typing_extensions.final
class GetUserRequest(google.protobuf.message.Message):
    """GetUserRequest represents a request to fetch the details of a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the user, which allows its access by ID.
    - Format: `users/{user.id}`.
    """
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserRequest = GetUserRequest

@typing_extensions.final
class GetUserResponse(google.protobuf.message.Message):
    """GetUserResponse contains the requested user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___User:
        """The user resource."""
    def __init__(
        self,
        *,
        user: global___User | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["user", b"user"]) -> None: ...

global___GetUserResponse = GetUserResponse

@typing_extensions.final
class GetAuthenticatedUserRequest(google.protobuf.message.Message):
    """GetAuthenticatedUserRequest represents a request to get the
    authenticated user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetAuthenticatedUserRequest = GetAuthenticatedUserRequest

@typing_extensions.final
class GetAuthenticatedUserResponse(google.protobuf.message.Message):
    """GetAuthenticatedUserResponse contains the requested authenticated user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___AuthenticatedUser:
        """The authenticated user resource."""
    def __init__(
        self,
        *,
        user: global___AuthenticatedUser | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["user", b"user"]) -> None: ...

global___GetAuthenticatedUserResponse = GetAuthenticatedUserResponse

@typing_extensions.final
class PatchAuthenticatedUserRequest(google.protobuf.message.Message):
    """PatchAuthenticatedUserRequest represents a request to update the
    authenticated user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___AuthenticatedUser:
        """The user fields that will replace the existing ones."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        user: global___AuthenticatedUser | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["update_mask", b"update_mask", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["update_mask", b"update_mask", "user", b"user"]) -> None: ...

global___PatchAuthenticatedUserRequest = PatchAuthenticatedUserRequest

@typing_extensions.final
class PatchAuthenticatedUserResponse(google.protobuf.message.Message):
    """PatchAuthenticatedUserResponse contains the updated user.
    the authenticated user resource
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___AuthenticatedUser:
        """The updated user resource."""
    def __init__(
        self,
        *,
        user: global___AuthenticatedUser | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["user", b"user"]) -> None: ...

global___PatchAuthenticatedUserResponse = PatchAuthenticatedUserResponse

@typing_extensions.final
class CheckNamespaceRequest(google.protobuf.message.Message):
    """CheckNamespaceRequest represents a request to verify if a namespace is
    available.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The namespace ID to be checked."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___CheckNamespaceRequest = CheckNamespaceRequest

@typing_extensions.final
class CheckNamespaceResponse(google.protobuf.message.Message):
    """CheckNamespaceResponse contains the availability of a namespace or the type
    of resource that's using it.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Namespace:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _NamespaceEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[CheckNamespaceResponse._Namespace.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NAMESPACE_UNSPECIFIED: CheckNamespaceResponse._Namespace.ValueType  # 0
        """Unspecified."""
        NAMESPACE_AVAILABLE: CheckNamespaceResponse._Namespace.ValueType  # 1
        """Available."""
        NAMESPACE_USER: CheckNamespaceResponse._Namespace.ValueType  # 2
        """Namespace belongs to a user."""
        NAMESPACE_ORGANIZATION: CheckNamespaceResponse._Namespace.ValueType  # 3
        """Namespace belongs to an organization."""
        NAMESPACE_RESERVED: CheckNamespaceResponse._Namespace.ValueType  # 4
        """Reserved."""

    class Namespace(_Namespace, metaclass=_NamespaceEnumTypeWrapper):
        """Namespace contains information about the availability of a namespace."""

    NAMESPACE_UNSPECIFIED: CheckNamespaceResponse.Namespace.ValueType  # 0
    """Unspecified."""
    NAMESPACE_AVAILABLE: CheckNamespaceResponse.Namespace.ValueType  # 1
    """Available."""
    NAMESPACE_USER: CheckNamespaceResponse.Namespace.ValueType  # 2
    """Namespace belongs to a user."""
    NAMESPACE_ORGANIZATION: CheckNamespaceResponse.Namespace.ValueType  # 3
    """Namespace belongs to an organization."""
    NAMESPACE_RESERVED: CheckNamespaceResponse.Namespace.ValueType  # 4
    """Reserved."""

    TYPE_FIELD_NUMBER: builtins.int
    type: global___CheckNamespaceResponse.Namespace.ValueType
    """Namespace type."""
    def __init__(
        self,
        *,
        type: global___CheckNamespaceResponse.Namespace.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["type", b"type"]) -> None: ...

global___CheckNamespaceResponse = CheckNamespaceResponse

@typing_extensions.final
class ApiToken(google.protobuf.message.Message):
    """API tokens allow users to make requests to the Instill AI API."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _State:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ApiToken._State.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATE_UNSPECIFIED: ApiToken._State.ValueType  # 0
        """Unspecified."""
        STATE_INACTIVE: ApiToken._State.ValueType  # 1
        """Inactive."""
        STATE_ACTIVE: ApiToken._State.ValueType  # 2
        """Active."""
        STATE_EXPIRED: ApiToken._State.ValueType  # 3
        """Expired."""

    class State(_State, metaclass=_StateEnumTypeWrapper):
        """State describes the state of an API token."""

    STATE_UNSPECIFIED: ApiToken.State.ValueType  # 0
    """Unspecified."""
    STATE_INACTIVE: ApiToken.State.ValueType  # 1
    """Inactive."""
    STATE_ACTIVE: ApiToken.State.ValueType  # 2
    """Active."""
    STATE_EXPIRED: ApiToken.State.ValueType  # 3
    """Expired."""

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    ACCESS_TOKEN_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    TOKEN_TYPE_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    EXPIRE_TIME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the token, define by its ID.
    - Format: `tokens/{token.id}`.
    """
    uid: builtins.str
    """API token UUID."""
    id: builtins.str
    """API token resource ID (used in `name` as the last segment). This conforms
    to RFC-1034, which restricts to letters, numbers, and hyphen, with the
    first character a letter, the last a letter or a number, and a 63
    character maximum.

    This field can reflect the client(s) that will use the token.
    """
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Update time."""
    access_token: builtins.str
    """An opaque access token representing the API token string.

    To validate the token, the recipient of the token needs to call the server
    that issued the token.
    """
    state: global___ApiToken.State.ValueType
    """State."""
    token_type: builtins.str
    """Token type. Value is fixed to "Bearer"."""
    ttl: builtins.int
    """The time-to-live in seconds for this resource."""
    @property
    def expire_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Expiration time."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        access_token: builtins.str = ...,
        state: global___ApiToken.State.ValueType = ...,
        token_type: builtins.str = ...,
        ttl: builtins.int = ...,
        expire_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "expiration", b"expiration", "expire_time", b"expire_time", "ttl", b"ttl", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["access_token", b"access_token", "create_time", b"create_time", "expiration", b"expiration", "expire_time", b"expire_time", "id", b"id", "name", b"name", "state", b"state", "token_type", b"token_type", "ttl", b"ttl", "uid", b"uid", "update_time", b"update_time"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["expiration", b"expiration"]) -> typing_extensions.Literal["ttl", "expire_time"] | None: ...

global___ApiToken = ApiToken

@typing_extensions.final
class CreateTokenRequest(google.protobuf.message.Message):
    """CreateTokenRequest represents a request to create an API token."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKEN_FIELD_NUMBER: builtins.int
    @property
    def token(self) -> global___ApiToken:
        """The properties of the token to be created."""
    def __init__(
        self,
        *,
        token: global___ApiToken | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["token", b"token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["token", b"token"]) -> None: ...

global___CreateTokenRequest = CreateTokenRequest

@typing_extensions.final
class CreateTokenResponse(google.protobuf.message.Message):
    """CreateTokenResponse contains the created token."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKEN_FIELD_NUMBER: builtins.int
    @property
    def token(self) -> global___ApiToken:
        """The created API token resource."""
    def __init__(
        self,
        *,
        token: global___ApiToken | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["token", b"token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["token", b"token"]) -> None: ...

global___CreateTokenResponse = CreateTokenResponse

@typing_extensions.final
class ListTokensRequest(google.protobuf.message.Message):
    """ListTokensRequest represents a request to list the API tokens of a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of tokens to return. If this parameter is unspecified,
    at most 10 pipelines will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "page_size", b"page_size", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...

global___ListTokensRequest = ListTokensRequest

@typing_extensions.final
class ListTokensResponse(google.protobuf.message.Message):
    """ListTokensResponse contains a list of API tokens."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKENS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def tokens(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ApiToken]:
        """A list of API token resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of API token resources."""
    def __init__(
        self,
        *,
        tokens: collections.abc.Iterable[global___ApiToken] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "tokens", b"tokens", "total_size", b"total_size"]) -> None: ...

global___ListTokensResponse = ListTokensResponse

@typing_extensions.final
class GetTokenRequest(google.protobuf.message.Message):
    """GetTokenRequest represents a request to fetch the details of an API token"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the token, which allows its access by ID.
    - Format: `tokens/{token.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___GetTokenRequest = GetTokenRequest

@typing_extensions.final
class GetTokenResponse(google.protobuf.message.Message):
    """GetTokenResponse contains the requested token."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKEN_FIELD_NUMBER: builtins.int
    @property
    def token(self) -> global___ApiToken:
        """The API token resource."""
    def __init__(
        self,
        *,
        token: global___ApiToken | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["token", b"token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["token", b"token"]) -> None: ...

global___GetTokenResponse = GetTokenResponse

@typing_extensions.final
class DeleteTokenRequest(google.protobuf.message.Message):
    """DeleteTokenRequest represents a request to delete an API token resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the token, which allows its access by ID.
    - Format: `tokens/{token.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteTokenRequest = DeleteTokenRequest

@typing_extensions.final
class DeleteTokenResponse(google.protobuf.message.Message):
    """DeleteTokenResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteTokenResponse = DeleteTokenResponse

@typing_extensions.final
class ValidateTokenRequest(google.protobuf.message.Message):
    """ValidateTokenRequest represents a request to validate a token."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ValidateTokenRequest = ValidateTokenRequest

@typing_extensions.final
class ValidateTokenResponse(google.protobuf.message.Message):
    """ValidateTokenResponse contains the validation of a token."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_UID_FIELD_NUMBER: builtins.int
    user_uid: builtins.str
    """If token is valid, UUID of the user that owns it."""
    def __init__(
        self,
        *,
        user_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["user_uid", b"user_uid"]) -> None: ...

global___ValidateTokenResponse = ValidateTokenResponse

@typing_extensions.final
class AuthTokenIssuerRequest(google.protobuf.message.Message):
    """AuthTokenIssuerRequest represents a request to fetch the issuer details of a
    token.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERNAME_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    username: builtins.str
    """Username."""
    password: builtins.str
    """Password."""
    def __init__(
        self,
        *,
        username: builtins.str = ...,
        password: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["password", b"password", "username", b"username"]) -> None: ...

global___AuthTokenIssuerRequest = AuthTokenIssuerRequest

@typing_extensions.final
class AuthTokenIssuerResponse(google.protobuf.message.Message):
    """AuthTokenIssuerResponse contains the token issuer details."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class UnsignedAccessToken(google.protobuf.message.Message):
        """UnsignedAccessToken contains the token issuer information."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        AUD_FIELD_NUMBER: builtins.int
        ISS_FIELD_NUMBER: builtins.int
        SUB_FIELD_NUMBER: builtins.int
        JTI_FIELD_NUMBER: builtins.int
        EXP_FIELD_NUMBER: builtins.int
        aud: builtins.str
        """Audience."""
        iss: builtins.str
        """Issuer."""
        sub: builtins.str
        """Subject."""
        jti: builtins.str
        """Unique identifier of the user."""
        exp: builtins.int
        """Expiration date."""
        def __init__(
            self,
            *,
            aud: builtins.str = ...,
            iss: builtins.str = ...,
            sub: builtins.str = ...,
            jti: builtins.str = ...,
            exp: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["aud", b"aud", "exp", b"exp", "iss", b"iss", "jti", b"jti", "sub", b"sub"]) -> None: ...

    ACCESS_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def access_token(self) -> global___AuthTokenIssuerResponse.UnsignedAccessToken:
        """Access token information."""
    def __init__(
        self,
        *,
        access_token: global___AuthTokenIssuerResponse.UnsignedAccessToken | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["access_token", b"access_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["access_token", b"access_token"]) -> None: ...

global___AuthTokenIssuerResponse = AuthTokenIssuerResponse

@typing_extensions.final
class AuthLoginRequest(google.protobuf.message.Message):
    """AuthLoginRequest represents a request for user login."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERNAME_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    username: builtins.str
    """Username."""
    password: builtins.str
    """Password."""
    def __init__(
        self,
        *,
        username: builtins.str = ...,
        password: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["password", b"password", "username", b"username"]) -> None: ...

global___AuthLoginRequest = AuthLoginRequest

@typing_extensions.final
class AuthLoginResponse(google.protobuf.message.Message):
    """AuthLoginResponse contains the access token of the authenticated user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCESS_TOKEN_FIELD_NUMBER: builtins.int
    access_token: builtins.str
    """User access token."""
    def __init__(
        self,
        *,
        access_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["access_token", b"access_token"]) -> None: ...

global___AuthLoginResponse = AuthLoginResponse

@typing_extensions.final
class AuthLogoutRequest(google.protobuf.message.Message):
    """AuthLogoutRequest represents a request for user logout."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___AuthLogoutRequest = AuthLogoutRequest

@typing_extensions.final
class AuthLogoutResponse(google.protobuf.message.Message):
    """AuthLogoutResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___AuthLogoutResponse = AuthLogoutResponse

@typing_extensions.final
class AuthValidateAccessTokenRequest(google.protobuf.message.Message):
    """AuthValidateAccessTokenRequest represents a request for access token validation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___AuthValidateAccessTokenRequest = AuthValidateAccessTokenRequest

@typing_extensions.final
class AuthValidateAccessTokenResponse(google.protobuf.message.Message):
    """AuthValidateAccessTokenResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___AuthValidateAccessTokenResponse = AuthValidateAccessTokenResponse

@typing_extensions.final
class AuthChangePasswordRequest(google.protobuf.message.Message):
    """AuthChangePasswordRequest represents a request to update a user's password."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OLD_PASSWORD_FIELD_NUMBER: builtins.int
    NEW_PASSWORD_FIELD_NUMBER: builtins.int
    old_password: builtins.str
    """Old password."""
    new_password: builtins.str
    """New password."""
    def __init__(
        self,
        *,
        old_password: builtins.str = ...,
        new_password: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["new_password", b"new_password", "old_password", b"old_password"]) -> None: ...

global___AuthChangePasswordRequest = AuthChangePasswordRequest

@typing_extensions.final
class AuthChangePasswordResponse(google.protobuf.message.Message):
    """AuthChangePasswordResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___AuthChangePasswordResponse = AuthChangePasswordResponse

@typing_extensions.final
class Organization(google.protobuf.message.Message):
    """Organizations group several users. As entities, they can own resources such
    as pipelines or releases.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    PROFILE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the organization, defined by its ID.
    - Format: `organization/{organization.id}`.
    """
    uid: builtins.str
    """Organization UUID."""
    id: builtins.str
    """Resource ID (used in `name` as the last segment). This conforms to
    RFC-1034, which restricts to letters, numbers, and hyphen, with the first
    character a letter, the last a letter or a number, and a 63 character
    maximum.

    Note that the ID can be updated.
    """
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Update time."""
    @property
    def owner(self) -> global___User:
        """The user that owns the organization."""
    @property
    def profile(self) -> global___OrganizationProfile:
        """Profile."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        owner: global___User | None = ...,
        profile: global___OrganizationProfile | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "owner", b"owner", "profile", b"profile", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "id", b"id", "name", b"name", "owner", b"owner", "profile", b"profile", "uid", b"uid", "update_time", b"update_time"]) -> None: ...

global___Organization = Organization

@typing_extensions.final
class ListOrganizationsRequest(google.protobuf.message.Message):
    """ListOrganizationsRequest represents a request to list all organizations"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of organizations to return. If this parameter is
    unspecified, at most 10 pipelines will be returned. The cap value for this
    parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___View.ValueType | None = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListOrganizationsRequest = ListOrganizationsRequest

@typing_extensions.final
class ListOrganizationsResponse(google.protobuf.message.Message):
    """ListOrganizationsResponse represents a response for a list of organizations"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def organizations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Organization]:
        """A list of organizations"""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of organizations."""
    def __init__(
        self,
        *,
        organizations: collections.abc.Iterable[global___Organization] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "organizations", b"organizations", "total_size", b"total_size"]) -> None: ...

global___ListOrganizationsResponse = ListOrganizationsResponse

@typing_extensions.final
class CreateOrganizationRequest(google.protobuf.message.Message):
    """CreateOrganizationRequest represents a request to create an organization."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_FIELD_NUMBER: builtins.int
    @property
    def organization(self) -> global___Organization:
        """The properties of the organization to be created."""
    def __init__(
        self,
        *,
        organization: global___Organization | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["organization", b"organization"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["organization", b"organization"]) -> None: ...

global___CreateOrganizationRequest = CreateOrganizationRequest

@typing_extensions.final
class CreateOrganizationResponse(google.protobuf.message.Message):
    """CreateOrganizationResponse contains the created organization."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_FIELD_NUMBER: builtins.int
    @property
    def organization(self) -> global___Organization:
        """The organization resource."""
    def __init__(
        self,
        *,
        organization: global___Organization | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["organization", b"organization"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["organization", b"organization"]) -> None: ...

global___CreateOrganizationResponse = CreateOrganizationResponse

@typing_extensions.final
class GetOrganizationRequest(google.protobuf.message.Message):
    """GetOrganizationRequest represents a request to fetch the details of an
    organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the organization, which allows its access by ID.
    - Format: `organizations/{organization.id}`.
    """
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetOrganizationRequest = GetOrganizationRequest

@typing_extensions.final
class GetOrganizationResponse(google.protobuf.message.Message):
    """GetOrganizationResponse contains the requested organization."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_FIELD_NUMBER: builtins.int
    @property
    def organization(self) -> global___Organization:
        """The organization resource."""
    def __init__(
        self,
        *,
        organization: global___Organization | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["organization", b"organization"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["organization", b"organization"]) -> None: ...

global___GetOrganizationResponse = GetOrganizationResponse

@typing_extensions.final
class UpdateOrganizationRequest(google.protobuf.message.Message):
    """UpdateOrganizationRequest represents a request to update an organization."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def organization(self) -> global___Organization:
        """The organization fields that will replace the existing ones."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        organization: global___Organization | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["organization", b"organization", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["organization", b"organization", "update_mask", b"update_mask"]) -> None: ...

global___UpdateOrganizationRequest = UpdateOrganizationRequest

@typing_extensions.final
class UpdateOrganizationResponse(google.protobuf.message.Message):
    """UpdateOrganizationResponse contains the updated organization."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_FIELD_NUMBER: builtins.int
    @property
    def organization(self) -> global___Organization:
        """The organization resource."""
    def __init__(
        self,
        *,
        organization: global___Organization | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["organization", b"organization"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["organization", b"organization"]) -> None: ...

global___UpdateOrganizationResponse = UpdateOrganizationResponse

@typing_extensions.final
class DeleteOrganizationRequest(google.protobuf.message.Message):
    """DeleteOrganizationRequest represents a request to delete an organization."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the organization, which allows its access by ID.
    - Format: `organizations/{organization.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteOrganizationRequest = DeleteOrganizationRequest

@typing_extensions.final
class DeleteOrganizationResponse(google.protobuf.message.Message):
    """DeleteOrganizationResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteOrganizationResponse = DeleteOrganizationResponse

@typing_extensions.final
class OrganizationMembership(google.protobuf.message.Message):
    """An organization membership defines the relationship between an organization
    and a user that is attached to it.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    ORGANIZATION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the membership, which allows its access by
    organization and user ID.
    - Format: `organizations/{organization.id}/memberships/{user.id}`.
    """
    role: builtins.str
    """Role of the user in the organization."""
    state: global___MembershipState.ValueType
    """State of the membership."""
    @property
    def user(self) -> global___User:
        """User information."""
    @property
    def organization(self) -> global___Organization:
        """Organization information."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        role: builtins.str = ...,
        state: global___MembershipState.ValueType = ...,
        user: global___User | None = ...,
        organization: global___Organization | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["organization", b"organization", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "organization", b"organization", "role", b"role", "state", b"state", "user", b"user"]) -> None: ...

global___OrganizationMembership = OrganizationMembership

@typing_extensions.final
class UserMembership(google.protobuf.message.Message):
    """A user membership defines the relationship between a user and an
    organization they belong to.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    ORGANIZATION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the membership, which allows its access by user and
    organization ID.
    - Format: `users/{user.id}/memberships/{organization.id}`.
    """
    role: builtins.str
    """Role of the user in the organization."""
    state: global___MembershipState.ValueType
    """State of the membership."""
    @property
    def user(self) -> global___User:
        """User information."""
    @property
    def organization(self) -> global___Organization:
        """Organization information."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        role: builtins.str = ...,
        state: global___MembershipState.ValueType = ...,
        user: global___User | None = ...,
        organization: global___Organization | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["organization", b"organization", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "organization", b"organization", "role", b"role", "state", b"state", "user", b"user"]) -> None: ...

global___UserMembership = UserMembership

@typing_extensions.final
class ListUserMembershipsRequest(google.protobuf.message.Message):
    """ListUserMembershipsRequest represents a request to list the memberships of a
    user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent resource, i.e., the user to which the memberships belong.
    Format: `users/{user.id}`.
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent"]) -> None: ...

global___ListUserMembershipsRequest = ListUserMembershipsRequest

@typing_extensions.final
class ListUserMembershipsResponse(google.protobuf.message.Message):
    """ListUserMembershipsResponse contains a list of memberships."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMBERSHIPS_FIELD_NUMBER: builtins.int
    @property
    def memberships(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserMembership]:
        """The user memberships, i.e., the organizations the user belongs to."""
    def __init__(
        self,
        *,
        memberships: collections.abc.Iterable[global___UserMembership] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["memberships", b"memberships"]) -> None: ...

global___ListUserMembershipsResponse = ListUserMembershipsResponse

@typing_extensions.final
class GetUserMembershipRequest(google.protobuf.message.Message):
    """GetUserMembershipRequest represents a request to query a user's membership."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the membership, which allows its access by user and
    organization ID.
    - Format: `users/{user.id}/memberships/{organization.id}`.
    """
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserMembershipRequest = GetUserMembershipRequest

@typing_extensions.final
class GetUserMembershipResponse(google.protobuf.message.Message):
    """GetUserMembershipResponse contains the user membership."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMBERSHIP_FIELD_NUMBER: builtins.int
    @property
    def membership(self) -> global___UserMembership:
        """The requested user membership."""
    def __init__(
        self,
        *,
        membership: global___UserMembership | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["membership", b"membership"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["membership", b"membership"]) -> None: ...

global___GetUserMembershipResponse = GetUserMembershipResponse

@typing_extensions.final
class UpdateUserMembershipRequest(google.protobuf.message.Message):
    """UpdateUserMembershipRequest represents a request to update a user membership."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMBERSHIP_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def membership(self) -> global___UserMembership:
        """The membership fields to update."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        membership: global___UserMembership | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["membership", b"membership", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["membership", b"membership", "update_mask", b"update_mask"]) -> None: ...

global___UpdateUserMembershipRequest = UpdateUserMembershipRequest

@typing_extensions.final
class UpdateUserMembershipResponse(google.protobuf.message.Message):
    """UpdateUserMembershipResponse contains the updated membership."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMBERSHIP_FIELD_NUMBER: builtins.int
    @property
    def membership(self) -> global___UserMembership:
        """The updated membership resource."""
    def __init__(
        self,
        *,
        membership: global___UserMembership | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["membership", b"membership"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["membership", b"membership"]) -> None: ...

global___UpdateUserMembershipResponse = UpdateUserMembershipResponse

@typing_extensions.final
class DeleteUserMembershipRequest(google.protobuf.message.Message):
    """DeleteUserMembershipRequest represents a request to delete a user
    membership.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the membership, which allows its access by user and
    organization ID.
    - Format: `users/{user.id}/memberships/{organization.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteUserMembershipRequest = DeleteUserMembershipRequest

@typing_extensions.final
class DeleteUserMembershipResponse(google.protobuf.message.Message):
    """DeleteUserMembershipResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserMembershipResponse = DeleteUserMembershipResponse

@typing_extensions.final
class ListOrganizationMembershipsRequest(google.protobuf.message.Message):
    """ListOrganizationMembershipsRequest represents a request to list the
    memberships of an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent resource, i.e., the organization to which the memberships
    belong.
    Format: `organizations/{organization.id}`.
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent"]) -> None: ...

global___ListOrganizationMembershipsRequest = ListOrganizationMembershipsRequest

@typing_extensions.final
class ListOrganizationMembershipsResponse(google.protobuf.message.Message):
    """ListOrganizationMembershipsResponse contains a list of memberships."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMBERSHIPS_FIELD_NUMBER: builtins.int
    @property
    def memberships(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OrganizationMembership]:
        """The organization memberships, i.e., the users that belong to the
        organization.
        """
    def __init__(
        self,
        *,
        memberships: collections.abc.Iterable[global___OrganizationMembership] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["memberships", b"memberships"]) -> None: ...

global___ListOrganizationMembershipsResponse = ListOrganizationMembershipsResponse

@typing_extensions.final
class GetOrganizationMembershipRequest(google.protobuf.message.Message):
    """GetOrganizationMembershipRequest represents a request to query a user's
    membership to an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the membership, which allows its access by
    organization and user ID.
    - Format: `organizations/{organization.id}/memberships/{user.id}`.
    """
    view: global___View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetOrganizationMembershipRequest = GetOrganizationMembershipRequest

@typing_extensions.final
class GetOrganizationMembershipResponse(google.protobuf.message.Message):
    """GetOrganizationMembershipResponse contains the organization membership."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMBERSHIP_FIELD_NUMBER: builtins.int
    @property
    def membership(self) -> global___OrganizationMembership:
        """The requested organization membership."""
    def __init__(
        self,
        *,
        membership: global___OrganizationMembership | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["membership", b"membership"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["membership", b"membership"]) -> None: ...

global___GetOrganizationMembershipResponse = GetOrganizationMembershipResponse

@typing_extensions.final
class UpdateOrganizationMembershipRequest(google.protobuf.message.Message):
    """UpdateOrganizationMembershipRequest represents a request to update an
    organization membership.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMBERSHIP_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def membership(self) -> global___OrganizationMembership:
        """The membership fields to update."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        membership: global___OrganizationMembership | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["membership", b"membership", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["membership", b"membership", "update_mask", b"update_mask"]) -> None: ...

global___UpdateOrganizationMembershipRequest = UpdateOrganizationMembershipRequest

@typing_extensions.final
class UpdateOrganizationMembershipResponse(google.protobuf.message.Message):
    """UpdateOrganizationMembershipResponse contains the updated membership."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMBERSHIP_FIELD_NUMBER: builtins.int
    @property
    def membership(self) -> global___OrganizationMembership:
        """The updated membership resource."""
    def __init__(
        self,
        *,
        membership: global___OrganizationMembership | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["membership", b"membership"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["membership", b"membership"]) -> None: ...

global___UpdateOrganizationMembershipResponse = UpdateOrganizationMembershipResponse

@typing_extensions.final
class DeleteOrganizationMembershipRequest(google.protobuf.message.Message):
    """DeleteOrganizationMembershipRequest represents a request to delete an
    organization membership.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the membership, which allows its access by
    organization and user ID.
    - Format: `organizations/{organization.id}/memberships/{user.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteOrganizationMembershipRequest = DeleteOrganizationMembershipRequest

@typing_extensions.final
class DeleteOrganizationMembershipResponse(google.protobuf.message.Message):
    """DeleteOrganizationMembershipResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteOrganizationMembershipResponse = DeleteOrganizationMembershipResponse

@typing_extensions.final
class StripeSubscriptionDetail(google.protobuf.message.Message):
    """StripeSubscriptionDetail describes the details of a subscription in Stripe."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StripeSubscriptionDetail._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: StripeSubscriptionDetail._Status.ValueType  # 0
        """Unspecified status."""
        STATUS_INCOMPLETE: StripeSubscriptionDetail._Status.ValueType  # 1
        """Incomplete."""
        STATUS_INCOMPLETE_EXPIRED: StripeSubscriptionDetail._Status.ValueType  # 2
        """Incomplete Expired."""
        STATUS_TRIALING: StripeSubscriptionDetail._Status.ValueType  # 3
        """Trialing."""
        STATUS_ACTIVE: StripeSubscriptionDetail._Status.ValueType  # 4
        """Active."""
        STATUS_PAST_DUE: StripeSubscriptionDetail._Status.ValueType  # 5
        """Past due."""
        STATUS_CANCELED: StripeSubscriptionDetail._Status.ValueType  # 6
        """Canceled."""
        STATUS_UNPAID: StripeSubscriptionDetail._Status.ValueType  # 7
        """Unpaid."""
        STATUS_PAUSED: StripeSubscriptionDetail._Status.ValueType  # 8
        """Paused."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Enumerates the status types for the user's subscription."""

    STATUS_UNSPECIFIED: StripeSubscriptionDetail.Status.ValueType  # 0
    """Unspecified status."""
    STATUS_INCOMPLETE: StripeSubscriptionDetail.Status.ValueType  # 1
    """Incomplete."""
    STATUS_INCOMPLETE_EXPIRED: StripeSubscriptionDetail.Status.ValueType  # 2
    """Incomplete Expired."""
    STATUS_TRIALING: StripeSubscriptionDetail.Status.ValueType  # 3
    """Trialing."""
    STATUS_ACTIVE: StripeSubscriptionDetail.Status.ValueType  # 4
    """Active."""
    STATUS_PAST_DUE: StripeSubscriptionDetail.Status.ValueType  # 5
    """Past due."""
    STATUS_CANCELED: StripeSubscriptionDetail.Status.ValueType  # 6
    """Canceled."""
    STATUS_UNPAID: StripeSubscriptionDetail.Status.ValueType  # 7
    """Unpaid."""
    STATUS_PAUSED: StripeSubscriptionDetail.Status.ValueType  # 8
    """Paused."""

    PRODUCT_NAME_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    ITEM_ID_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    CANCELED_AT_FIELD_NUMBER: builtins.int
    TRIAL_END_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    product_name: builtins.str
    """Product name associated with the subscription in Stripe."""
    id: builtins.str
    """Unique identifier for the subscription."""
    item_id: builtins.str
    """Identifier for the specific item within the subscription."""
    price: builtins.float
    """Price of the subscription."""
    canceled_at: builtins.int
    """Optional timestamp indicating when the subscription was canceled, if applicable."""
    trial_end: builtins.int
    """Optional timestamp indicating when the trial ended, if applicable."""
    status: global___StripeSubscriptionDetail.Status.ValueType
    """Status of the subscription."""
    def __init__(
        self,
        *,
        product_name: builtins.str = ...,
        id: builtins.str = ...,
        item_id: builtins.str = ...,
        price: builtins.float = ...,
        canceled_at: builtins.int | None = ...,
        trial_end: builtins.int | None = ...,
        status: global___StripeSubscriptionDetail.Status.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_canceled_at", b"_canceled_at", "_trial_end", b"_trial_end", "canceled_at", b"canceled_at", "trial_end", b"trial_end"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_canceled_at", b"_canceled_at", "_trial_end", b"_trial_end", "canceled_at", b"canceled_at", "id", b"id", "item_id", b"item_id", "price", b"price", "product_name", b"product_name", "status", b"status", "trial_end", b"trial_end"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_canceled_at", b"_canceled_at"]) -> typing_extensions.Literal["canceled_at"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_trial_end", b"_trial_end"]) -> typing_extensions.Literal["trial_end"] | None: ...

global___StripeSubscriptionDetail = StripeSubscriptionDetail

@typing_extensions.final
class UserSubscription(google.protobuf.message.Message):
    """UserSubscription details describe the plan (i.e., features) a user has access to."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Plan:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PlanEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[UserSubscription._Plan.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PLAN_UNSPECIFIED: UserSubscription._Plan.ValueType  # 0
        """Unspecified plan."""
        PLAN_FREEMIUM: UserSubscription._Plan.ValueType  # 1
        """Freemium plan."""
        PLAN_PRO: UserSubscription._Plan.ValueType  # 2
        """Pro plan."""

    class Plan(_Plan, metaclass=_PlanEnumTypeWrapper):
        """Enumerates the plan types for the user subscription."""

    PLAN_UNSPECIFIED: UserSubscription.Plan.ValueType  # 0
    """Unspecified plan."""
    PLAN_FREEMIUM: UserSubscription.Plan.ValueType  # 1
    """Freemium plan."""
    PLAN_PRO: UserSubscription.Plan.ValueType  # 2
    """Pro plan."""

    PLAN_FIELD_NUMBER: builtins.int
    DETAIL_FIELD_NUMBER: builtins.int
    plan: global___UserSubscription.Plan.ValueType
    """Plan identifier."""
    @property
    def detail(self) -> global___StripeSubscriptionDetail:
        """Details of the associated Stripe subscription."""
    def __init__(
        self,
        *,
        plan: global___UserSubscription.Plan.ValueType = ...,
        detail: global___StripeSubscriptionDetail | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["detail", b"detail"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["detail", b"detail", "plan", b"plan"]) -> None: ...

global___UserSubscription = UserSubscription

@typing_extensions.final
class OrganizationSubscription(google.protobuf.message.Message):
    """OrganizationSubscription details describe the plan (i.e., features) an organization has access to."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Plan:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PlanEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[OrganizationSubscription._Plan.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PLAN_UNSPECIFIED: OrganizationSubscription._Plan.ValueType  # 0
        """Unspecified plan."""
        PLAN_FREEMIUM: OrganizationSubscription._Plan.ValueType  # 1
        """Freemium plan."""
        PLAN_TEAM: OrganizationSubscription._Plan.ValueType  # 2
        """Team plan."""
        PLAN_ENTERPRISE: OrganizationSubscription._Plan.ValueType  # 3
        """Enterprise plan."""

    class Plan(_Plan, metaclass=_PlanEnumTypeWrapper):
        """Enumerates the plan types for the organization subscription."""

    PLAN_UNSPECIFIED: OrganizationSubscription.Plan.ValueType  # 0
    """Unspecified plan."""
    PLAN_FREEMIUM: OrganizationSubscription.Plan.ValueType  # 1
    """Freemium plan."""
    PLAN_TEAM: OrganizationSubscription.Plan.ValueType  # 2
    """Team plan."""
    PLAN_ENTERPRISE: OrganizationSubscription.Plan.ValueType  # 3
    """Enterprise plan."""

    PLAN_FIELD_NUMBER: builtins.int
    DETAIL_FIELD_NUMBER: builtins.int
    MAX_SEATS_FIELD_NUMBER: builtins.int
    USED_SEATS_FIELD_NUMBER: builtins.int
    plan: global___OrganizationSubscription.Plan.ValueType
    """Plan identifier."""
    @property
    def detail(self) -> global___StripeSubscriptionDetail:
        """Details of the associated Stripe subscription."""
    max_seats: builtins.int
    """Maximum number of seats allowed."""
    used_seats: builtins.int
    """Number of used seats within the organization subscription."""
    def __init__(
        self,
        *,
        plan: global___OrganizationSubscription.Plan.ValueType = ...,
        detail: global___StripeSubscriptionDetail | None = ...,
        max_seats: builtins.int = ...,
        used_seats: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["detail", b"detail"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["detail", b"detail", "max_seats", b"max_seats", "plan", b"plan", "used_seats", b"used_seats"]) -> None: ...

global___OrganizationSubscription = OrganizationSubscription

@typing_extensions.final
class GetAuthenticatedUserSubscriptionRequest(google.protobuf.message.Message):
    """GetAuthenticatedUserSubscriptionRequest represents a query to fetch the subscription
    details of the authenticated user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetAuthenticatedUserSubscriptionRequest = GetAuthenticatedUserSubscriptionRequest

@typing_extensions.final
class GetAuthenticatedUserSubscriptionResponse(google.protobuf.message.Message):
    """GetAuthenticatedUserSubscriptionResponse contains the requested subscription."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_FIELD_NUMBER: builtins.int
    @property
    def subscription(self) -> global___UserSubscription:
        """The subscription resource."""
    def __init__(
        self,
        *,
        subscription: global___UserSubscription | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["subscription", b"subscription"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["subscription", b"subscription"]) -> None: ...

global___GetAuthenticatedUserSubscriptionResponse = GetAuthenticatedUserSubscriptionResponse

@typing_extensions.final
class GetOrganizationSubscriptionRequest(google.protobuf.message.Message):
    """GetOrganizationSubscriptionRequest represents a query to fetch the
    subscription details of an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent resource, i.e., the organization to which the subscription
    refers.
    Format: `organizations/{organization.id}`.
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent"]) -> None: ...

global___GetOrganizationSubscriptionRequest = GetOrganizationSubscriptionRequest

@typing_extensions.final
class GetOrganizationSubscriptionResponse(google.protobuf.message.Message):
    """GetOrganizationSubscriptionResponse contains the requested subscription."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_FIELD_NUMBER: builtins.int
    @property
    def subscription(self) -> global___OrganizationSubscription:
        """The subscription resource."""
    def __init__(
        self,
        *,
        subscription: global___OrganizationSubscription | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["subscription", b"subscription"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["subscription", b"subscription"]) -> None: ...

global___GetOrganizationSubscriptionResponse = GetOrganizationSubscriptionResponse

@typing_extensions.final
class GetUserSubscriptionAdminRequest(google.protobuf.message.Message):
    """GetUserSubscriptionAdminRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """parent"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent"]) -> None: ...

global___GetUserSubscriptionAdminRequest = GetUserSubscriptionAdminRequest

@typing_extensions.final
class GetUserSubscriptionAdminResponse(google.protobuf.message.Message):
    """GetUserSubscriptionAdminResponse"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_FIELD_NUMBER: builtins.int
    @property
    def subscription(self) -> global___UserSubscription:
        """Subscription"""
    def __init__(
        self,
        *,
        subscription: global___UserSubscription | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["subscription", b"subscription"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["subscription", b"subscription"]) -> None: ...

global___GetUserSubscriptionAdminResponse = GetUserSubscriptionAdminResponse

@typing_extensions.final
class GetOrganizationSubscriptionAdminRequest(google.protobuf.message.Message):
    """GetOrganizationSubscriptionAdminRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """parent"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent"]) -> None: ...

global___GetOrganizationSubscriptionAdminRequest = GetOrganizationSubscriptionAdminRequest

@typing_extensions.final
class GetOrganizationSubscriptionAdminResponse(google.protobuf.message.Message):
    """GetOrganizationSubscriptionAdminResponse"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_FIELD_NUMBER: builtins.int
    @property
    def subscription(self) -> global___OrganizationSubscription:
        """Subscription"""
    def __init__(
        self,
        *,
        subscription: global___OrganizationSubscription | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["subscription", b"subscription"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["subscription", b"subscription"]) -> None: ...

global___GetOrganizationSubscriptionAdminResponse = GetOrganizationSubscriptionAdminResponse
