"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import common.healthcheck.v1beta.healthcheck_pb2
import common.task.v1alpha.task_pb2
import core.mgmt.v1beta.mgmt_pb2
import google.longrunning.operations_pb2
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import model.model.v1alpha.model_definition_pb2
import model.model.v1alpha.task_classification_pb2
import model.model.v1alpha.task_detection_pb2
import model.model.v1alpha.task_image_to_image_pb2
import model.model.v1alpha.task_instance_segmentation_pb2
import model.model.v1alpha.task_keypoint_pb2
import model.model.v1alpha.task_ocr_pb2
import model.model.v1alpha.task_semantic_segmentation_pb2
import model.model.v1alpha.task_text_generation_chat_pb2
import model.model.v1alpha.task_text_generation_pb2
import model.model.v1alpha.task_text_to_image_pb2
import model.model.v1alpha.task_unspecified_pb2
import model.model.v1alpha.task_visual_question_answering_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class LivenessRequest(google.protobuf.message.Message):
    """LivenessRequest represents a request to check a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___LivenessRequest = LivenessRequest

@typing_extensions.final
class LivenessResponse(google.protobuf.message.Message):
    """LivenessResponse represents a response for a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___LivenessResponse = LivenessResponse

@typing_extensions.final
class ReadinessRequest(google.protobuf.message.Message):
    """ReadinessRequest represents a request to check a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___ReadinessRequest = ReadinessRequest

@typing_extensions.final
class ReadinessResponse(google.protobuf.message.Message):
    """ReadinessResponse represents a response for a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___ReadinessResponse = ReadinessResponse

@typing_extensions.final
class Model(google.protobuf.message.Message):
    """Model represents an AI model, i.e. a program that performs tasks as decision
    making or or pattern recognition based on its training data
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Visibility:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _VisibilityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Model._Visibility.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VISIBILITY_UNSPECIFIED: Model._Visibility.ValueType  # 0
        """Unspecified, equivalent to PRIVATE."""
        VISIBILITY_PRIVATE: Model._Visibility.ValueType  # 1
        """Only the owner can see the model."""
        VISIBILITY_PUBLIC: Model._Visibility.ValueType  # 2
        """Other users can see the model."""

    class Visibility(_Visibility, metaclass=_VisibilityEnumTypeWrapper):
        """Visibility defines who can access the model."""

    VISIBILITY_UNSPECIFIED: Model.Visibility.ValueType  # 0
    """Unspecified, equivalent to PRIVATE."""
    VISIBILITY_PRIVATE: Model.Visibility.ValueType  # 1
    """Only the owner can see the model."""
    VISIBILITY_PUBLIC: Model.Visibility.ValueType  # 2
    """Other users can see the model."""

    class _State:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Model._State.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATE_UNSPECIFIED: Model._State.ValueType  # 0
        """Unspecified. This state can occur while a model is being deployed."""
        STATE_OFFLINE: Model._State.ValueType  # 1
        """Offline is the default state when a model is initially created. A model
        can be switched from ONLINE to this state by using the `undeploy`
        method.
        """
        STATE_ONLINE: Model._State.ValueType  # 2
        """Online is the state of a model when it has been deployed (i.e. when the
        `deploy` method has been used on an OFFLINE model).
        """
        STATE_ERROR: Model._State.ValueType  # 3
        """Error is the state when the model is undeployable on Instill Model."""

    class State(_State, metaclass=_StateEnumTypeWrapper):
        """State describes the state of a model. See [Deploy
        Models](https://www.instill.tech/docs/latest/model/deploy) for more
        information.
        """

    STATE_UNSPECIFIED: Model.State.ValueType  # 0
    """Unspecified. This state can occur while a model is being deployed."""
    STATE_OFFLINE: Model.State.ValueType  # 1
    """Offline is the default state when a model is initially created. A model
    can be switched from ONLINE to this state by using the `undeploy`
    method.
    """
    STATE_ONLINE: Model.State.ValueType  # 2
    """Online is the state of a model when it has been deployed (i.e. when the
    `deploy` method has been used on an OFFLINE model).
    """
    STATE_ERROR: Model.State.ValueType  # 3
    """Error is the state when the model is undeployable on Instill Model."""

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    MODEL_DEFINITION_FIELD_NUMBER: builtins.int
    CONFIGURATION_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    OWNER_NAME_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by owner and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    uid: builtins.str
    """Model UUID."""
    id: builtins.str
    """Model resource ID (used in `name` as the last segment). This conforms to
    RFC-1034, which restricts to letters, numbers, and hyphen, with the first
    character a letter, the last a letter or a number, and a 63 character
    maximum.
    """
    description: builtins.str
    """Model description."""
    model_definition: builtins.str
    """The model definition that has been used to import the model."""
    @property
    def configuration(self) -> google.protobuf.struct_pb2.Struct:
        """Model configuration. This field is validated against the model
        specification in the model definition (i.e. the `model_spec` field in the
        model definition).
        """
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Model task."""
    state: global___Model.State.ValueType
    """Model state."""
    visibility: global___Model.Visibility.ValueType
    """Model visibility."""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Model creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Model update time."""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Model deletion time."""
    owner_name: builtins.str
    """Resource name of the owner."""
    @property
    def owner(self) -> core.mgmt.v1beta.mgmt_pb2.Owner:
        """Model owner."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        description: builtins.str | None = ...,
        model_definition: builtins.str = ...,
        configuration: google.protobuf.struct_pb2.Struct | None = ...,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        state: global___Model.State.ValueType = ...,
        visibility: global___Model.Visibility.ValueType = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        owner_name: builtins.str = ...,
        owner: core.mgmt.v1beta.mgmt_pb2.Owner | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_description", b"_description", "_owner", b"_owner", "configuration", b"configuration", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "owner", b"owner", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_description", b"_description", "_owner", b"_owner", "configuration", b"configuration", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "id", b"id", "model_definition", b"model_definition", "name", b"name", "owner", b"owner", "owner_name", b"owner_name", "state", b"state", "task", b"task", "uid", b"uid", "update_time", b"update_time", "visibility", b"visibility"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_description", b"_description"]) -> typing_extensions.Literal["description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_owner", b"_owner"]) -> typing_extensions.Literal["owner"] | None: ...

global___Model = Model

@typing_extensions.final
class ModelCard(google.protobuf.message.Message):
    """ModelCard represents a README.md file that accompanies the model to describe
    handy information with additional model metadata. Under the hood, a model
    card is associated with a specific model. It is an crucial for
    reproducibility, sharing and discoverability.

    Each model has exactly one README card.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    ENCODING_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model card, which allows its access by parent
    user and model ID.
    - Format: `users/{user.id}/models/{model.id}/readme`.
    """
    size: builtins.int
    """Size of the file in bytes."""
    type: builtins.str
    """Type of the resource. Its value is fixed to `file`."""
    content: builtins.bytes
    """Content of the README file in bytes and base64 format."""
    encoding: builtins.str
    """Encoding type of the content. Its value is fixed to `base64`."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        size: builtins.int = ...,
        type: builtins.str = ...,
        content: builtins.bytes = ...,
        encoding: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["content", b"content", "encoding", b"encoding", "name", b"name", "size", b"size", "type", b"type"]) -> None: ...

global___ModelCard = ModelCard

@typing_extensions.final
class ListModelsRequest(google.protobuf.message.Message):
    """ListModelsRequest represents a request to list  models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of models to return. If this parameter is unspecified,
    at most 10 models will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    show_deleted: builtins.bool
    """Include soft-deleted models in the result."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListModelsRequest = ListModelsRequest

@typing_extensions.final
class ListModelsResponse(google.protobuf.message.Message):
    """ListModelsResponse contains a list of models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """A list of model resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of models."""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListModelsResponse = ListModelsResponse

@typing_extensions.final
class LookUpModelRequest(google.protobuf.message.Message):
    """LookUpModelRequest represents a request to query a model by its UID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """The permalink of the model, which allows its access by UID.
    - Format: `models/{model.uid}`.
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpModelRequest = LookUpModelRequest

@typing_extensions.final
class LookUpModelResponse(google.protobuf.message.Message):
    """LookUpModelResponse contains the requested model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The requested model."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___LookUpModelResponse = LookUpModelResponse

@typing_extensions.final
class CreateUserModelRequest(google.protobuf.message.Message):
    """CreateUserModelRequest represents a request from a user to create a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The properties of the model to be created."""
    parent: builtins.str
    """The parent resource, i.e., the user that creates the model.
    Format: `users/{user.id}`.
    """
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "parent", b"parent"]) -> None: ...

global___CreateUserModelRequest = CreateUserModelRequest

@typing_extensions.final
class CreateUserModelResponse(google.protobuf.message.Message):
    """CreateUserModelResponse contains the information to access the status of the
    model creation operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___CreateUserModelResponse = CreateUserModelResponse

@typing_extensions.final
class CreateUserModelBinaryFileUploadRequest(google.protobuf.message.Message):
    """CreateUserModelBinaryFileUploadRequest represents a request to create a
    model by uploading its content in bytes.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The properties of the model to be created."""
    content: builtins.bytes
    """Model content in bytes."""
    parent: builtins.str
    """The parent resource, i.e., the user that creates the model.
    Format: `users/{user.id}`.
    """
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        content: builtins.bytes = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["content", b"content", "model", b"model", "parent", b"parent"]) -> None: ...

global___CreateUserModelBinaryFileUploadRequest = CreateUserModelBinaryFileUploadRequest

@typing_extensions.final
class CreateUserModelBinaryFileUploadResponse(google.protobuf.message.Message):
    """CreateUserModelBinaryFileUploadResponse contains the information to access
    the status of the model creation operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___CreateUserModelBinaryFileUploadResponse = CreateUserModelBinaryFileUploadResponse

@typing_extensions.final
class ListUserModelsRequest(google.protobuf.message.Message):
    """ListUserModelsRequest represents a request to list the models of a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of models to return. If this parameter is unspecified,
    at most 10 models will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    parent: builtins.str
    """The parent resource, i.e., the user that created the models.
    - Format: `users/{user.id}`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted models in the result."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListUserModelsRequest = ListUserModelsRequest

@typing_extensions.final
class ListUserModelsResponse(google.protobuf.message.Message):
    """ListUserModelsResponse contains a list of models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """A list of model resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of models."""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListUserModelsResponse = ListUserModelsResponse

@typing_extensions.final
class GetUserModelRequest(google.protobuf.message.Message):
    """GetUserModelRequest represents a request to fetch the details of a model
    owned by a user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserModelRequest = GetUserModelRequest

@typing_extensions.final
class GetUserModelResponse(google.protobuf.message.Message):
    """GetUserModelResponse contains the requested model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___GetUserModelResponse = GetUserModelResponse

@typing_extensions.final
class UpdateUserModelRequest(google.protobuf.message.Message):
    """UpdateUserModelRequest represents a request to update a model owned by a
    user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The model to update"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "update_mask", b"update_mask"]) -> None: ...

global___UpdateUserModelRequest = UpdateUserModelRequest

@typing_extensions.final
class UpdateUserModelResponse(google.protobuf.message.Message):
    """UpdateUserModelResponse contains the updated model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The updated model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___UpdateUserModelResponse = UpdateUserModelResponse

@typing_extensions.final
class DeleteUserModelRequest(google.protobuf.message.Message):
    """DeleteUserModelRequest represents a request to delete a model owned by a
    user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteUserModelRequest = DeleteUserModelRequest

@typing_extensions.final
class DeleteUserModelResponse(google.protobuf.message.Message):
    """DeleteUserModelResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserModelResponse = DeleteUserModelResponse

@typing_extensions.final
class RenameUserModelRequest(google.protobuf.message.Message):
    """RenameUserModelRequest represents a request to rename a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_MODEL_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    new_model_id: builtins.str
    """The new resource ID. This will transform the resource name into
    `users/{user.id}/models/{new_model_id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_model_id", b"new_model_id"]) -> None: ...

global___RenameUserModelRequest = RenameUserModelRequest

@typing_extensions.final
class RenameUserModelResponse(google.protobuf.message.Message):
    """RenameUserModelResponse contains a renamed model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The renamed model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___RenameUserModelResponse = RenameUserModelResponse

@typing_extensions.final
class PublishUserModelRequest(google.protobuf.message.Message):
    """PublisUserhModelRequest represents a request to publish a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___PublishUserModelRequest = PublishUserModelRequest

@typing_extensions.final
class PublishUserModelResponse(google.protobuf.message.Message):
    """PublishUserModelResponse contains a published model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The published model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___PublishUserModelResponse = PublishUserModelResponse

@typing_extensions.final
class UnpublishUserModelRequest(google.protobuf.message.Message):
    """UnpublishUserModelRequest represents a request to unpublish a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___UnpublishUserModelRequest = UnpublishUserModelRequest

@typing_extensions.final
class UnpublishUserModelResponse(google.protobuf.message.Message):
    """UnpublishUserModelResponse contains an unpublished model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The unpublished model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___UnpublishUserModelResponse = UnpublishUserModelResponse

@typing_extensions.final
class DeployUserModelRequest(google.protobuf.message.Message):
    """DeployUserModelRequest represents a request to set a model to an ONLINE
    state.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeployUserModelRequest = DeployUserModelRequest

@typing_extensions.final
class DeployUserModelResponse(google.protobuf.message.Message):
    """DeployUserModelResponse contains the ID of the deployed model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """ID of the deployed model, e.g. `llava-7b`."""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id"]) -> None: ...

global___DeployUserModelResponse = DeployUserModelResponse

@typing_extensions.final
class UndeployUserModelRequest(google.protobuf.message.Message):
    """UndeployUserModelRequest represents a request to set a model to an OFFLINE
    state.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___UndeployUserModelRequest = UndeployUserModelRequest

@typing_extensions.final
class UndeployUserModelResponse(google.protobuf.message.Message):
    """UndeployUserModelResponse contains the ID of the undeployed model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """ID of the undeployed model, e.g. `llava-7b`."""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id"]) -> None: ...

global___UndeployUserModelResponse = UndeployUserModelResponse

@typing_extensions.final
class GetUserModelCardRequest(google.protobuf.message.Message):
    """GetUserModelCardRequest represents a request to fetch the README card of a
    model.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model card, which allows its access by parent
    user and model ID.
    - Format: `users/{user.id}/models/{model.id}/readme`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___GetUserModelCardRequest = GetUserModelCardRequest

@typing_extensions.final
class GetUserModelCardResponse(google.protobuf.message.Message):
    """GetUserModelCardResponse contains the model's README card."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    README_FIELD_NUMBER: builtins.int
    @property
    def readme(self) -> global___ModelCard:
        """A model card resource."""
    def __init__(
        self,
        *,
        readme: global___ModelCard | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["readme", b"readme"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["readme", b"readme"]) -> None: ...

global___GetUserModelCardResponse = GetUserModelCardResponse

@typing_extensions.final
class WatchUserModelRequest(google.protobuf.message.Message):
    """WatchUserModelRequest represents a request to fetch current state of a model
    and its long-running operation progress.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___WatchUserModelRequest = WatchUserModelRequest

@typing_extensions.final
class WatchUserModelResponse(google.protobuf.message.Message):
    """WatchUserModelResponse contains the state and progress of a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    PROGRESS_FIELD_NUMBER: builtins.int
    state: global___Model.State.ValueType
    """State."""
    progress: builtins.int
    """Long-running operation progress. If there are no ongoing operations, the
    value will be 0.
    """
    def __init__(
        self,
        *,
        state: global___Model.State.ValueType = ...,
        progress: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["progress", b"progress", "state", b"state"]) -> None: ...

global___WatchUserModelResponse = WatchUserModelResponse

@typing_extensions.final
class TaskInput(google.protobuf.message.Message):
    """//////////////////////////////////
     Trigger methods
    //////////////////////////////////

    TaskInput represents a question or task for an AI model.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLASSIFICATION_FIELD_NUMBER: builtins.int
    DETECTION_FIELD_NUMBER: builtins.int
    KEYPOINT_FIELD_NUMBER: builtins.int
    OCR_FIELD_NUMBER: builtins.int
    INSTANCE_SEGMENTATION_FIELD_NUMBER: builtins.int
    SEMANTIC_SEGMENTATION_FIELD_NUMBER: builtins.int
    TEXT_TO_IMAGE_FIELD_NUMBER: builtins.int
    IMAGE_TO_IMAGE_FIELD_NUMBER: builtins.int
    TEXT_GENERATION_FIELD_NUMBER: builtins.int
    TEXT_GENERATION_CHAT_FIELD_NUMBER: builtins.int
    VISUAL_QUESTION_ANSWERING_FIELD_NUMBER: builtins.int
    UNSPECIFIED_FIELD_NUMBER: builtins.int
    @property
    def classification(self) -> model.model.v1alpha.task_classification_pb2.ClassificationInput:
        """Image classification input."""
    @property
    def detection(self) -> model.model.v1alpha.task_detection_pb2.DetectionInput:
        """Object detection input."""
    @property
    def keypoint(self) -> model.model.v1alpha.task_keypoint_pb2.KeypointInput:
        """Keypoint detection input."""
    @property
    def ocr(self) -> model.model.v1alpha.task_ocr_pb2.OcrInput:
        """Optical Character Recognition input."""
    @property
    def instance_segmentation(self) -> model.model.v1alpha.task_instance_segmentation_pb2.InstanceSegmentationInput:
        """Instance segmentation input."""
    @property
    def semantic_segmentation(self) -> model.model.v1alpha.task_semantic_segmentation_pb2.SemanticSegmentationInput:
        """Semantic segmentation input."""
    @property
    def text_to_image(self) -> model.model.v1alpha.task_text_to_image_pb2.TextToImageInput:
        """Text to image input."""
    @property
    def image_to_image(self) -> model.model.v1alpha.task_image_to_image_pb2.ImageToImageInput:
        """Image to image input."""
    @property
    def text_generation(self) -> model.model.v1alpha.task_text_generation_pb2.TextGenerationInput:
        """Text generation input."""
    @property
    def text_generation_chat(self) -> model.model.v1alpha.task_text_generation_chat_pb2.TextGenerationChatInput:
        """Conversational text generation input."""
    @property
    def visual_question_answering(self) -> model.model.v1alpha.task_visual_question_answering_pb2.VisualQuestionAnsweringInput:
        """Visual question answering input."""
    @property
    def unspecified(self) -> model.model.v1alpha.task_unspecified_pb2.UnspecifiedInput:
        """Unspecified task input."""
    def __init__(
        self,
        *,
        classification: model.model.v1alpha.task_classification_pb2.ClassificationInput | None = ...,
        detection: model.model.v1alpha.task_detection_pb2.DetectionInput | None = ...,
        keypoint: model.model.v1alpha.task_keypoint_pb2.KeypointInput | None = ...,
        ocr: model.model.v1alpha.task_ocr_pb2.OcrInput | None = ...,
        instance_segmentation: model.model.v1alpha.task_instance_segmentation_pb2.InstanceSegmentationInput | None = ...,
        semantic_segmentation: model.model.v1alpha.task_semantic_segmentation_pb2.SemanticSegmentationInput | None = ...,
        text_to_image: model.model.v1alpha.task_text_to_image_pb2.TextToImageInput | None = ...,
        image_to_image: model.model.v1alpha.task_image_to_image_pb2.ImageToImageInput | None = ...,
        text_generation: model.model.v1alpha.task_text_generation_pb2.TextGenerationInput | None = ...,
        text_generation_chat: model.model.v1alpha.task_text_generation_chat_pb2.TextGenerationChatInput | None = ...,
        visual_question_answering: model.model.v1alpha.task_visual_question_answering_pb2.VisualQuestionAnsweringInput | None = ...,
        unspecified: model.model.v1alpha.task_unspecified_pb2.UnspecifiedInput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["classification", b"classification", "detection", b"detection", "image_to_image", b"image_to_image", "input", b"input", "instance_segmentation", b"instance_segmentation", "keypoint", b"keypoint", "ocr", b"ocr", "semantic_segmentation", b"semantic_segmentation", "text_generation", b"text_generation", "text_generation_chat", b"text_generation_chat", "text_to_image", b"text_to_image", "unspecified", b"unspecified", "visual_question_answering", b"visual_question_answering"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["classification", b"classification", "detection", b"detection", "image_to_image", b"image_to_image", "input", b"input", "instance_segmentation", b"instance_segmentation", "keypoint", b"keypoint", "ocr", b"ocr", "semantic_segmentation", b"semantic_segmentation", "text_generation", b"text_generation", "text_generation_chat", b"text_generation_chat", "text_to_image", b"text_to_image", "unspecified", b"unspecified", "visual_question_answering", b"visual_question_answering"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["input", b"input"]) -> typing_extensions.Literal["classification", "detection", "keypoint", "ocr", "instance_segmentation", "semantic_segmentation", "text_to_image", "image_to_image", "text_generation", "text_generation_chat", "visual_question_answering", "unspecified"] | None: ...

global___TaskInput = TaskInput

@typing_extensions.final
class TaskInputStream(google.protobuf.message.Message):
    """TaskInputStream represents the input to trigger a model with stream method"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLASSIFICATION_FIELD_NUMBER: builtins.int
    DETECTION_FIELD_NUMBER: builtins.int
    KEYPOINT_FIELD_NUMBER: builtins.int
    OCR_FIELD_NUMBER: builtins.int
    INSTANCE_SEGMENTATION_FIELD_NUMBER: builtins.int
    SEMANTIC_SEGMENTATION_FIELD_NUMBER: builtins.int
    TEXT_TO_IMAGE_FIELD_NUMBER: builtins.int
    IMAGE_TO_IMAGE_FIELD_NUMBER: builtins.int
    TEXT_GENERATION_FIELD_NUMBER: builtins.int
    TEXT_GENERATION_CHAT_FIELD_NUMBER: builtins.int
    VISUAL_QUESTION_ANSWERING_FIELD_NUMBER: builtins.int
    UNSPECIFIED_FIELD_NUMBER: builtins.int
    @property
    def classification(self) -> model.model.v1alpha.task_classification_pb2.ClassificationInputStream:
        """The classification input"""
    @property
    def detection(self) -> model.model.v1alpha.task_detection_pb2.DetectionInputStream:
        """The detection input"""
    @property
    def keypoint(self) -> model.model.v1alpha.task_keypoint_pb2.KeypointInputStream:
        """The keypoint input"""
    @property
    def ocr(self) -> model.model.v1alpha.task_ocr_pb2.OcrInputStream:
        """The ocr input"""
    @property
    def instance_segmentation(self) -> model.model.v1alpha.task_instance_segmentation_pb2.InstanceSegmentationInputStream:
        """The instance segmentation input"""
    @property
    def semantic_segmentation(self) -> model.model.v1alpha.task_semantic_segmentation_pb2.SemanticSegmentationInputStream:
        """The semantic segmentation input"""
    @property
    def text_to_image(self) -> model.model.v1alpha.task_text_to_image_pb2.TextToImageInput:
        """The text to image input"""
    @property
    def image_to_image(self) -> model.model.v1alpha.task_image_to_image_pb2.ImageToImageInput:
        """The image to image input"""
    @property
    def text_generation(self) -> model.model.v1alpha.task_text_generation_pb2.TextGenerationInput:
        """The text generation input"""
    @property
    def text_generation_chat(self) -> model.model.v1alpha.task_text_generation_chat_pb2.TextGenerationChatInput:
        """The text generation chat input"""
    @property
    def visual_question_answering(self) -> model.model.v1alpha.task_visual_question_answering_pb2.VisualQuestionAnsweringInput:
        """The visual question answering input"""
    @property
    def unspecified(self) -> model.model.v1alpha.task_unspecified_pb2.UnspecifiedInput:
        """The unspecified task input"""
    def __init__(
        self,
        *,
        classification: model.model.v1alpha.task_classification_pb2.ClassificationInputStream | None = ...,
        detection: model.model.v1alpha.task_detection_pb2.DetectionInputStream | None = ...,
        keypoint: model.model.v1alpha.task_keypoint_pb2.KeypointInputStream | None = ...,
        ocr: model.model.v1alpha.task_ocr_pb2.OcrInputStream | None = ...,
        instance_segmentation: model.model.v1alpha.task_instance_segmentation_pb2.InstanceSegmentationInputStream | None = ...,
        semantic_segmentation: model.model.v1alpha.task_semantic_segmentation_pb2.SemanticSegmentationInputStream | None = ...,
        text_to_image: model.model.v1alpha.task_text_to_image_pb2.TextToImageInput | None = ...,
        image_to_image: model.model.v1alpha.task_image_to_image_pb2.ImageToImageInput | None = ...,
        text_generation: model.model.v1alpha.task_text_generation_pb2.TextGenerationInput | None = ...,
        text_generation_chat: model.model.v1alpha.task_text_generation_chat_pb2.TextGenerationChatInput | None = ...,
        visual_question_answering: model.model.v1alpha.task_visual_question_answering_pb2.VisualQuestionAnsweringInput | None = ...,
        unspecified: model.model.v1alpha.task_unspecified_pb2.UnspecifiedInput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["classification", b"classification", "detection", b"detection", "image_to_image", b"image_to_image", "input", b"input", "instance_segmentation", b"instance_segmentation", "keypoint", b"keypoint", "ocr", b"ocr", "semantic_segmentation", b"semantic_segmentation", "text_generation", b"text_generation", "text_generation_chat", b"text_generation_chat", "text_to_image", b"text_to_image", "unspecified", b"unspecified", "visual_question_answering", b"visual_question_answering"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["classification", b"classification", "detection", b"detection", "image_to_image", b"image_to_image", "input", b"input", "instance_segmentation", b"instance_segmentation", "keypoint", b"keypoint", "ocr", b"ocr", "semantic_segmentation", b"semantic_segmentation", "text_generation", b"text_generation", "text_generation_chat", b"text_generation_chat", "text_to_image", b"text_to_image", "unspecified", b"unspecified", "visual_question_answering", b"visual_question_answering"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["input", b"input"]) -> typing_extensions.Literal["classification", "detection", "keypoint", "ocr", "instance_segmentation", "semantic_segmentation", "text_to_image", "image_to_image", "text_generation", "text_generation_chat", "visual_question_answering", "unspecified"] | None: ...

global___TaskInputStream = TaskInputStream

@typing_extensions.final
class TaskOutput(google.protobuf.message.Message):
    """TaskOutput represents the result of an AI task performed by a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLASSIFICATION_FIELD_NUMBER: builtins.int
    DETECTION_FIELD_NUMBER: builtins.int
    KEYPOINT_FIELD_NUMBER: builtins.int
    OCR_FIELD_NUMBER: builtins.int
    INSTANCE_SEGMENTATION_FIELD_NUMBER: builtins.int
    SEMANTIC_SEGMENTATION_FIELD_NUMBER: builtins.int
    TEXT_TO_IMAGE_FIELD_NUMBER: builtins.int
    IMAGE_TO_IMAGE_FIELD_NUMBER: builtins.int
    TEXT_GENERATION_FIELD_NUMBER: builtins.int
    TEXT_GENERATION_CHAT_FIELD_NUMBER: builtins.int
    VISUAL_QUESTION_ANSWERING_FIELD_NUMBER: builtins.int
    UNSPECIFIED_FIELD_NUMBER: builtins.int
    @property
    def classification(self) -> model.model.v1alpha.task_classification_pb2.ClassificationOutput:
        """Image classification output."""
    @property
    def detection(self) -> model.model.v1alpha.task_detection_pb2.DetectionOutput:
        """Object detection output."""
    @property
    def keypoint(self) -> model.model.v1alpha.task_keypoint_pb2.KeypointOutput:
        """Keypoint detection output."""
    @property
    def ocr(self) -> model.model.v1alpha.task_ocr_pb2.OcrOutput:
        """Optical Character Recognition output."""
    @property
    def instance_segmentation(self) -> model.model.v1alpha.task_instance_segmentation_pb2.InstanceSegmentationOutput:
        """Instance segmentation output."""
    @property
    def semantic_segmentation(self) -> model.model.v1alpha.task_semantic_segmentation_pb2.SemanticSegmentationOutput:
        """Semantic segmentation output."""
    @property
    def text_to_image(self) -> model.model.v1alpha.task_text_to_image_pb2.TextToImageOutput:
        """Text to image output."""
    @property
    def image_to_image(self) -> model.model.v1alpha.task_image_to_image_pb2.ImageToImageOutput:
        """Image to image output."""
    @property
    def text_generation(self) -> model.model.v1alpha.task_text_generation_pb2.TextGenerationOutput:
        """Text generation output."""
    @property
    def text_generation_chat(self) -> model.model.v1alpha.task_text_generation_chat_pb2.TextGenerationChatOutput:
        """Conversational text generation output."""
    @property
    def visual_question_answering(self) -> model.model.v1alpha.task_visual_question_answering_pb2.VisualQuestionAnsweringOutput:
        """Visual question answering output."""
    @property
    def unspecified(self) -> model.model.v1alpha.task_unspecified_pb2.UnspecifiedOutput:
        """Unspecified task output."""
    def __init__(
        self,
        *,
        classification: model.model.v1alpha.task_classification_pb2.ClassificationOutput | None = ...,
        detection: model.model.v1alpha.task_detection_pb2.DetectionOutput | None = ...,
        keypoint: model.model.v1alpha.task_keypoint_pb2.KeypointOutput | None = ...,
        ocr: model.model.v1alpha.task_ocr_pb2.OcrOutput | None = ...,
        instance_segmentation: model.model.v1alpha.task_instance_segmentation_pb2.InstanceSegmentationOutput | None = ...,
        semantic_segmentation: model.model.v1alpha.task_semantic_segmentation_pb2.SemanticSegmentationOutput | None = ...,
        text_to_image: model.model.v1alpha.task_text_to_image_pb2.TextToImageOutput | None = ...,
        image_to_image: model.model.v1alpha.task_image_to_image_pb2.ImageToImageOutput | None = ...,
        text_generation: model.model.v1alpha.task_text_generation_pb2.TextGenerationOutput | None = ...,
        text_generation_chat: model.model.v1alpha.task_text_generation_chat_pb2.TextGenerationChatOutput | None = ...,
        visual_question_answering: model.model.v1alpha.task_visual_question_answering_pb2.VisualQuestionAnsweringOutput | None = ...,
        unspecified: model.model.v1alpha.task_unspecified_pb2.UnspecifiedOutput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["classification", b"classification", "detection", b"detection", "image_to_image", b"image_to_image", "instance_segmentation", b"instance_segmentation", "keypoint", b"keypoint", "ocr", b"ocr", "output", b"output", "semantic_segmentation", b"semantic_segmentation", "text_generation", b"text_generation", "text_generation_chat", b"text_generation_chat", "text_to_image", b"text_to_image", "unspecified", b"unspecified", "visual_question_answering", b"visual_question_answering"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["classification", b"classification", "detection", b"detection", "image_to_image", b"image_to_image", "instance_segmentation", b"instance_segmentation", "keypoint", b"keypoint", "ocr", b"ocr", "output", b"output", "semantic_segmentation", b"semantic_segmentation", "text_generation", b"text_generation", "text_generation_chat", b"text_generation_chat", "text_to_image", b"text_to_image", "unspecified", b"unspecified", "visual_question_answering", b"visual_question_answering"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["output", b"output"]) -> typing_extensions.Literal["classification", "detection", "keypoint", "ocr", "instance_segmentation", "semantic_segmentation", "text_to_image", "image_to_image", "text_generation", "text_generation_chat", "visual_question_answering", "unspecified"] | None: ...

global___TaskOutput = TaskOutput

@typing_extensions.final
class TriggerUserModelRequest(google.protobuf.message.Message):
    """TriggerUserModelRequest represents a request to trigger a model inference."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskInput]:
        """Inference input parameters."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        task_inputs: collections.abc.Iterable[global___TaskInput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs"]) -> None: ...

global___TriggerUserModelRequest = TriggerUserModelRequest

@typing_extensions.final
class TriggerUserModelResponse(google.protobuf.message.Message):
    """TriggerUserModelResponse contains the model inference results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskOutput]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[global___TaskOutput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerUserModelResponse = TriggerUserModelResponse

@typing_extensions.final
class TriggerUserModelBinaryFileUploadRequest(google.protobuf.message.Message):
    """TriggerUserModelBinaryFileUploadRequest represents a request trigger a model
    inference by uploading a binary file as the input.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TASK_INPUT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/models/{model.id}`.
    """
    @property
    def task_input(self) -> global___TaskInputStream:
        """Inference input as a binary file."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        task_input: global___TaskInputStream | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["task_input", b"task_input"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_input", b"task_input"]) -> None: ...

global___TriggerUserModelBinaryFileUploadRequest = TriggerUserModelBinaryFileUploadRequest

@typing_extensions.final
class TriggerUserModelBinaryFileUploadResponse(google.protobuf.message.Message):
    """TriggerUserModelBinaryFileUploadResponse contains the model inference results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskOutput]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[global___TaskOutput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerUserModelBinaryFileUploadResponse = TriggerUserModelBinaryFileUploadResponse

@typing_extensions.final
class CreateOrganizationModelRequest(google.protobuf.message.Message):
    """//////////////////////////////////
     Organization methods
    //////////////////////////////////

    CreateOrganizationModelRequest represents a request from an organization to create a model.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The properties of the model to be created."""
    parent: builtins.str
    """The parent resource, i.e., the organization that creates the model.
    Format: `organizations/{organization.id}`.
    """
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "parent", b"parent"]) -> None: ...

global___CreateOrganizationModelRequest = CreateOrganizationModelRequest

@typing_extensions.final
class CreateOrganizationModelResponse(google.protobuf.message.Message):
    """CreateOrganizationModelResponse contains the information to access the status of the
    model creation operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___CreateOrganizationModelResponse = CreateOrganizationModelResponse

@typing_extensions.final
class CreateOrganizationModelBinaryFileUploadRequest(google.protobuf.message.Message):
    """CreateOrganizationModelBinaryFileUploadRequest represents a request to create a
    model by uploading its content in bytes.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The properties of the model to be created."""
    content: builtins.bytes
    """Model content in bytes."""
    parent: builtins.str
    """The parent resource, i.e., the organization that creates the model.
    Format: `organizations/{organization.id}`.
    """
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        content: builtins.bytes = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["content", b"content", "model", b"model", "parent", b"parent"]) -> None: ...

global___CreateOrganizationModelBinaryFileUploadRequest = CreateOrganizationModelBinaryFileUploadRequest

@typing_extensions.final
class CreateOrganizationModelBinaryFileUploadResponse(google.protobuf.message.Message):
    """CreateOrganizationModelBinaryFileUploadResponse contains the information to access
    the status of the model creation operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___CreateOrganizationModelBinaryFileUploadResponse = CreateOrganizationModelBinaryFileUploadResponse

@typing_extensions.final
class ListOrganizationModelsRequest(google.protobuf.message.Message):
    """ListOrganizationModelsRequest represents a request to list the models
    of an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of models to return. If this parameter is unspecified,
    at most 10 models will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    parent: builtins.str
    """The parent resource, i.e., the organization that created the models.
    - Format: `organizations/{organizations.id}`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted models in the result."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListOrganizationModelsRequest = ListOrganizationModelsRequest

@typing_extensions.final
class ListOrganizationModelsResponse(google.protobuf.message.Message):
    """ListOrganizationModelsResponse contains a list of models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """A list of model resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of models."""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListOrganizationModelsResponse = ListOrganizationModelsResponse

@typing_extensions.final
class GetOrganizationModelRequest(google.protobuf.message.Message):
    """GetOrganizationModelRequest represents a request to fetch the details of a model
    owned by an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent organization
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetOrganizationModelRequest = GetOrganizationModelRequest

@typing_extensions.final
class GetOrganizationModelResponse(google.protobuf.message.Message):
    """GetOrganizationModelResponse contains the requested model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___GetOrganizationModelResponse = GetOrganizationModelResponse

@typing_extensions.final
class UpdateOrganizationModelRequest(google.protobuf.message.Message):
    """UpdateOrganizationModelRequest represents a request to update a model owned by an
    organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The model to update"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "update_mask", b"update_mask"]) -> None: ...

global___UpdateOrganizationModelRequest = UpdateOrganizationModelRequest

@typing_extensions.final
class UpdateOrganizationModelResponse(google.protobuf.message.Message):
    """UpdateOrganizationModelResponse contains the updated model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The updated model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___UpdateOrganizationModelResponse = UpdateOrganizationModelResponse

@typing_extensions.final
class DeleteOrganizationModelRequest(google.protobuf.message.Message):
    """DeleteOrganizationModelRequest represents a request to delete a model owned by an
    organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent organization
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteOrganizationModelRequest = DeleteOrganizationModelRequest

@typing_extensions.final
class DeleteOrganizationModelResponse(google.protobuf.message.Message):
    """DeleteOrganizationModelResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteOrganizationModelResponse = DeleteOrganizationModelResponse

@typing_extensions.final
class RenameOrganizationModelRequest(google.protobuf.message.Message):
    """RenameOrganizationModelRequest represents a request to rename a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_MODEL_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent organization
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    new_model_id: builtins.str
    """The new resource ID. This will transform the resource name into
    `organizations/{organization.id}/models/{new_model_id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_model_id", b"new_model_id"]) -> None: ...

global___RenameOrganizationModelRequest = RenameOrganizationModelRequest

@typing_extensions.final
class RenameOrganizationModelResponse(google.protobuf.message.Message):
    """RenameOrganizationModelResponse contains a renamed model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The renamed model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___RenameOrganizationModelResponse = RenameOrganizationModelResponse

@typing_extensions.final
class PublishOrganizationModelRequest(google.protobuf.message.Message):
    """PublisOrganizationhModelRequest represents a request to publish a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent organization
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___PublishOrganizationModelRequest = PublishOrganizationModelRequest

@typing_extensions.final
class PublishOrganizationModelResponse(google.protobuf.message.Message):
    """PublishOrganizationModelResponse contains a published model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The published model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___PublishOrganizationModelResponse = PublishOrganizationModelResponse

@typing_extensions.final
class UnpublishOrganizationModelRequest(google.protobuf.message.Message):
    """UnpublishOrganizationModelRequest represents a request to unpublish a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent organization
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___UnpublishOrganizationModelRequest = UnpublishOrganizationModelRequest

@typing_extensions.final
class UnpublishOrganizationModelResponse(google.protobuf.message.Message):
    """UnpublishOrganizationModelResponse contains an unpublished model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The unpublished model resource."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___UnpublishOrganizationModelResponse = UnpublishOrganizationModelResponse

@typing_extensions.final
class DeployOrganizationModelRequest(google.protobuf.message.Message):
    """DeployOrganizationModelRequest represents a request to set a model to an ONLINE
    state.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent organization
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeployOrganizationModelRequest = DeployOrganizationModelRequest

@typing_extensions.final
class DeployOrganizationModelResponse(google.protobuf.message.Message):
    """DeployOrganizationModelResponse contains the ID of the deployed model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """ID of the deployed model, e.g. `llava-7b`."""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id"]) -> None: ...

global___DeployOrganizationModelResponse = DeployOrganizationModelResponse

@typing_extensions.final
class UndeployOrganizationModelRequest(google.protobuf.message.Message):
    """UndeployOrganizationModelRequest represents a request to set a model to an OFFLINE
    state.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent organization
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___UndeployOrganizationModelRequest = UndeployOrganizationModelRequest

@typing_extensions.final
class UndeployOrganizationModelResponse(google.protobuf.message.Message):
    """UndeployOrganizationModelResponse contains the ID of the undeployed model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """ID of the undeployed model, e.g. `llava-7b`."""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id"]) -> None: ...

global___UndeployOrganizationModelResponse = UndeployOrganizationModelResponse

@typing_extensions.final
class GetOrganizationModelCardRequest(google.protobuf.message.Message):
    """GetOrganizationModelCardRequest represents a request to fetch the README card of a
    model.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model card, which allows its access by parent
    organization and model ID.
    - Format: `organizations/{organization.id}/models/{model.id}/readme`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___GetOrganizationModelCardRequest = GetOrganizationModelCardRequest

@typing_extensions.final
class GetOrganizationModelCardResponse(google.protobuf.message.Message):
    """GetOrganizationModelCardResponse contains the model's README card."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    README_FIELD_NUMBER: builtins.int
    @property
    def readme(self) -> global___ModelCard:
        """A model card resource."""
    def __init__(
        self,
        *,
        readme: global___ModelCard | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["readme", b"readme"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["readme", b"readme"]) -> None: ...

global___GetOrganizationModelCardResponse = GetOrganizationModelCardResponse

@typing_extensions.final
class WatchOrganizationModelRequest(google.protobuf.message.Message):
    """WatchOrganizationModelRequest represents a request to fetch current state of a model
    and its long-running operation progress.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access by parent organization
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___WatchOrganizationModelRequest = WatchOrganizationModelRequest

@typing_extensions.final
class WatchOrganizationModelResponse(google.protobuf.message.Message):
    """WatchOrganizationModelResponse contains the state and progress of a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    PROGRESS_FIELD_NUMBER: builtins.int
    state: global___Model.State.ValueType
    """State."""
    progress: builtins.int
    """Long-running operation progress. If there are no ongoing operations, the
    value will be 0.
    """
    def __init__(
        self,
        *,
        state: global___Model.State.ValueType = ...,
        progress: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["progress", b"progress", "state", b"state"]) -> None: ...

global___WatchOrganizationModelResponse = WatchOrganizationModelResponse

@typing_extensions.final
class TriggerOrganizationModelRequest(google.protobuf.message.Message):
    """TriggerOrganizationModelRequest represents a request to trigger a model inference."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent organization
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskInput]:
        """Inference input parameters."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        task_inputs: collections.abc.Iterable[global___TaskInput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs"]) -> None: ...

global___TriggerOrganizationModelRequest = TriggerOrganizationModelRequest

@typing_extensions.final
class TriggerOrganizationModelResponse(google.protobuf.message.Message):
    """TriggerOrganizationModelResponse contains the model inference results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskOutput]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[global___TaskOutput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerOrganizationModelResponse = TriggerOrganizationModelResponse

@typing_extensions.final
class TriggerOrganizationModelBinaryFileUploadRequest(google.protobuf.message.Message):
    """TriggerOrganizationModelBinaryFileUploadRequest represents a request trigger a model
    inference by uploading a binary file as the input.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TASK_INPUT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model , which allows its access by parent organization
    and ID.
    - Format: `organizations/{organization.id}/models/{model.id}`.
    """
    @property
    def task_input(self) -> global___TaskInputStream:
        """Inference input as a binary file."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        task_input: global___TaskInputStream | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["task_input", b"task_input"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_input", b"task_input"]) -> None: ...

global___TriggerOrganizationModelBinaryFileUploadRequest = TriggerOrganizationModelBinaryFileUploadRequest

@typing_extensions.final
class TriggerOrganizationModelBinaryFileUploadResponse(google.protobuf.message.Message):
    """TriggerOrganizationModelBinaryFileUploadResponse contains the model inference results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Task type."""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskOutput]:
        """Model inference outputs."""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[global___TaskOutput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerOrganizationModelBinaryFileUploadResponse = TriggerOrganizationModelBinaryFileUploadResponse

@typing_extensions.final
class GetModelOperationRequest(google.protobuf.message.Message):
    """GerModelOperationRequest represents a request to fetch a long-running
    operation performed on a model.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model, which allows its access ID.
    - Format: `operations/{operation.id}`.
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View allows clients to specify the desired model view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetModelOperationRequest = GetModelOperationRequest

@typing_extensions.final
class GetModelOperationResponse(google.protobuf.message.Message):
    """GetModelOperationRequest represents a request to query a long-running
    operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """The long-running operation."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___GetModelOperationResponse = GetModelOperationResponse

@typing_extensions.final
class ListModelsAdminRequest(google.protobuf.message.Message):
    """========== Private endpoints

    ListModelsAdminRequest represents a request to list all models from all users
    by admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """Page size: the maximum number of resources to return. The service may
    return fewer than this value. If unspecified, at most 10 models will be
    returned. The maximum value is 100; values above 100 will be coereced to
    100.
    """
    page_token: builtins.str
    """Page token"""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """Model view (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `Model.configuration`
    VIEW_FULL: show full information
    """
    show_deleted: builtins.bool
    """Return soft_deleted models"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListModelsAdminRequest = ListModelsAdminRequest

@typing_extensions.final
class ListModelsAdminResponse(google.protobuf.message.Message):
    """ListModelsAdminResponse represents a response for a list of models"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """a list of Models"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total number of models."""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListModelsAdminResponse = ListModelsAdminResponse

@typing_extensions.final
class LookUpModelAdminRequest(google.protobuf.message.Message):
    """LookUpModelAdminRequest represents a request to query a model via
    permalink by admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """Permalink of a model. For example:
    "models/{uid}"
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """Model view (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `Model.configuration`
    VIEW_FULL: show full information
    """
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpModelAdminRequest = LookUpModelAdminRequest

@typing_extensions.final
class LookUpModelAdminResponse(google.protobuf.message.Message):
    """LookUpModelResponse represents a response for a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """A model resource"""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___LookUpModelAdminResponse = LookUpModelAdminResponse

@typing_extensions.final
class CheckModelAdminRequest(google.protobuf.message.Message):
    """CheckModelAdminRequest represents a private request to query
    a model current state and longrunning progress
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_PERMALINK_FIELD_NUMBER: builtins.int
    model_permalink: builtins.str
    """Permalink of a model. For example:
    "models/{uid}"
    """
    def __init__(
        self,
        *,
        model_permalink: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_permalink", b"model_permalink"]) -> None: ...

global___CheckModelAdminRequest = CheckModelAdminRequest

@typing_extensions.final
class CheckModelAdminResponse(google.protobuf.message.Message):
    """CheckModelAdminResponse represents a response to fetch a model's
    current state and longrunning progress
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___Model.State.ValueType
    """Retrieved model state"""
    def __init__(
        self,
        *,
        state: global___Model.State.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___CheckModelAdminResponse = CheckModelAdminResponse

@typing_extensions.final
class DeployModelAdminRequest(google.protobuf.message.Message):
    """DeployModelAdminRequest represents a request to deploy a model to online state"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_PERMALINK_FIELD_NUMBER: builtins.int
    model_permalink: builtins.str
    """Permalink for the model to be deployed.
    Format: "models/{uid}"
    """
    def __init__(
        self,
        *,
        model_permalink: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_permalink", b"model_permalink"]) -> None: ...

global___DeployModelAdminRequest = DeployModelAdminRequest

@typing_extensions.final
class DeployModelAdminResponse(google.protobuf.message.Message):
    """DeployModelAdminResponse represents a response for a deployed model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Deploy operation message"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___DeployModelAdminResponse = DeployModelAdminResponse

@typing_extensions.final
class UndeployModelAdminRequest(google.protobuf.message.Message):
    """UndeployModelAdminRequest represents a request to undeploy a model to offline
    state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_PERMALINK_FIELD_NUMBER: builtins.int
    model_permalink: builtins.str
    """Permalink for the model to be undeployed.
    Format: "models/{uid}"
    """
    def __init__(
        self,
        *,
        model_permalink: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_permalink", b"model_permalink"]) -> None: ...

global___UndeployModelAdminRequest = UndeployModelAdminRequest

@typing_extensions.final
class UndeployModelAdminResponse(google.protobuf.message.Message):
    """UndeployModelAdminResponse represents a response for a undeployed model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Undeploy operation message"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___UndeployModelAdminResponse = UndeployModelAdminResponse
