/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.task;

import com.google.common.base.Preconditions;
import org.ray.api.id.ObjectId;
import org.ray.runtime.object.NativeRayObject;

public class FunctionArg {
    public final ObjectId id;
    public final NativeRayObject value;

    private FunctionArg(ObjectId id, NativeRayObject value) {
        Preconditions.checkState(id == null != (value == null));
        this.id = id;
        this.value = value;
    }

    public static FunctionArg passByReference(ObjectId id) {
        return new FunctionArg(id, null);
    }

    public static FunctionArg passByValue(NativeRayObject value) {
        return new FunctionArg(null, value);
    }

    public String toString() {
        if (this.id != null) {
            return "<id>: " + this.id.toString();
        }
        return this.value.toString();
    }
}

