/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.core.common;

import java.io.Serializable;
import java.util.Random;

public class AbstractID
implements Comparable<AbstractID>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Random RANDOM = new Random();
    private static final int SIZE_OF_LONG = 8;
    private static final int SIZE_OF_UPPER_PART = 8;
    private static final int SIZE_OF_LOWER_PART = 8;
    public static final int SIZE = 16;
    protected final long upperPart;
    protected final long lowerPart;
    private String toString;

    public AbstractID(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            throw new IllegalArgumentException("Argument bytes must by an array of 16 bytes");
        }
        this.lowerPart = AbstractID.byteArrayToLong(bytes, 0);
        this.upperPart = AbstractID.byteArrayToLong(bytes, 8);
    }

    public AbstractID(long lowerPart, long upperPart) {
        this.lowerPart = lowerPart;
        this.upperPart = upperPart;
    }

    public AbstractID(AbstractID id) {
        if (id == null) {
            throw new IllegalArgumentException("Id must not be null.");
        }
        this.lowerPart = id.lowerPart;
        this.upperPart = id.upperPart;
    }

    public AbstractID() {
        this.lowerPart = RANDOM.nextLong();
        this.upperPart = RANDOM.nextLong();
    }

    public long getLowerPart() {
        return this.lowerPart;
    }

    public long getUpperPart() {
        return this.upperPart;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[16];
        AbstractID.longToByteArray(this.lowerPart, bytes, 0);
        AbstractID.longToByteArray(this.upperPart, bytes, 8);
        return bytes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            AbstractID that = (AbstractID)obj;
            return that.lowerPart == this.lowerPart && that.upperPart == this.upperPart;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.lowerPart ^ (int)(this.lowerPart >>> 32) ^ (int)this.upperPart ^ (int)(this.upperPart >>> 32);
    }

    public String toString() {
        if (this.toString == null) {
            byte[] ba = new byte[16];
            AbstractID.longToByteArray(this.lowerPart, ba, 0);
            AbstractID.longToByteArray(this.upperPart, ba, 8);
            this.toString = new String(ba);
        }
        return this.toString;
    }

    @Override
    public int compareTo(AbstractID abstractID) {
        int diff1 = Long.compare(this.upperPart, abstractID.upperPart);
        int diff2 = Long.compare(this.lowerPart, abstractID.lowerPart);
        return diff1 == 0 ? diff2 : diff1;
    }

    private static long byteArrayToLong(byte[] begin, int offset) {
        long longNum = 0L;
        for (int i = 0; i < 8; ++i) {
            longNum |= ((long)begin[offset + 8 - 1 - i] & 0xFFL) << (i << 3);
        }
        return longNum;
    }

    private static void longToByteArray(long longNum, byte[] byteArray, int offset) {
        for (int i = 0; i < 8; ++i) {
            int shift = i << 3;
            byteArray[offset + 8 - 1 - i] = (byte)((longNum & 255L << shift) >>> shift);
        }
    }
}

