/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.core.graph.executiongraph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobVertex;
import org.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertex;

public class ExecutionGraph
implements Serializable {
    private final String jobName;
    private Map<String, String> jobConfig;
    private Map<Integer, ExecutionJobVertex> executionJobVertexMap;
    private int maxParallelism;
    private long buildTime;

    public ExecutionGraph(String jobName) {
        this.jobName = jobName;
        this.buildTime = System.currentTimeMillis();
    }

    public String getJobName() {
        return this.jobName;
    }

    public List<ExecutionJobVertex> getExecutionJobVertexLices() {
        return new ArrayList<ExecutionJobVertex>(this.executionJobVertexMap.values());
    }

    public Map<Integer, ExecutionJobVertex> getExecutionJobVertexMap() {
        return this.executionJobVertexMap;
    }

    public void setExecutionJobVertexMap(Map<Integer, ExecutionJobVertex> executionJobVertexMap) {
        this.executionJobVertexMap = executionJobVertexMap;
    }

    public Map<String, String> getJobConfig() {
        return this.jobConfig;
    }

    public void setJobConfig(Map<String, String> jobConfig) {
        this.jobConfig = jobConfig;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public void setMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public List<ExecutionVertex> getAllExecutionVertices() {
        return this.executionJobVertexMap.values().stream().map(ExecutionJobVertex::getExecutionVertices).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ExecutionVertex> getAllAddedExecutionVertices() {
        return this.executionJobVertexMap.values().stream().map(ExecutionJobVertex::getExecutionVertices).flatMap(Collection::stream).filter(vertex -> vertex.is2Add()).collect(Collectors.toList());
    }

    public ExecutionVertex getExecutionJobVertexByJobVertexId(int vertexId) {
        for (ExecutionJobVertex executionJobVertex : this.executionJobVertexMap.values()) {
            for (ExecutionVertex executionVertex : executionJobVertex.getExecutionVertices()) {
                if (executionVertex.getVertexId() != vertexId) continue;
                return executionVertex;
            }
        }
        throw new RuntimeException("Vertex " + vertexId + " does not exist!");
    }
}

