# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/dataStrcuture/02_team_lineup.ipynb.

# %% auto 0
__all__ = ['Player', 'StartingPlayer', 'TeamSheet']

# %% ../../nbs/dataStrcuture/02_team_lineup.ipynb 3
import pandas as pd
import mongoengine
import datetime
import logging

# %% ../../nbs/dataStrcuture/02_team_lineup.ipynb 5
class Player(mongoengine.EmbeddedDocument):
    "Stores main information about a player reported on the team sheet"
    # Player Ids.
    opta_id = mongoengine.IntField(db_field="player_optaId")
    inStat_id = mongoengine.IntField(db_field="player_inStatId")
    fotMob_id = mongoengine.IntField(db_field="player_fotmobId")
    player_id = mongoengine.StringField(
        db_field="playerId", required=False, default="Unknown"
    )
    # Player name.
    name = mongoengine.StringField(
        db_field="playerName", required=False, default="Unknown"
    )
    # Player number.
    jersey_number = mongoengine.IntField(required=False)

    meta = {"allow_inheritance": True}


class StartingPlayer(Player):
    "Extends the `Player` class with extra information about a Player starting the game"
    # Formation id.
    formation_id = mongoengine.IntField(db_field="formationId", required=True)
    # Formation name.
    formation = mongoengine.StringField(db_field="formationName")
    # Formation slots.
    slot = mongoengine.IntField(required=True, choices=set(range(1, 12)))
    # Positions.
    position = mongoengine.StringField(required=True)
    # Lines.
    line = mongoengine.IntField(required=True, choices=set(range(1, 5)))

# %% ../../nbs/dataStrcuture/02_team_lineup.ipynb 7
class TeamSheet(mongoengine.Document):
    "Store the team-sheet information for a given game."
    
    # Team info.
    team_id = mongoengine.StringField(db_field="teamId", required=True)
    name = mongoengine.StringField(db_field="teamName")
    team_color = mongoengine.StringField(db_field="teamColor", required=False)

    # Optional metadata.
    is_official = mongoengine.BooleanField(
        db_field="is_official", required=False, default=True
    )
    competition_id = mongoengine.StringField(db_field="competitionId", required=False)
    competition_fotmob_id = mongoengine.StringField(
        db_field="competition_fotmobId", required=False
    )

    # Ids.
    opta_id = mongoengine.IntField(db_field="team_optaId")
    inStat_id = mongoengine.IntField(db_field="team_inStatId")
    fotMob_id = mongoengine.IntField(db_field="team_fotmobId")

    # Game ids.
    game_id = mongoengine.StringField(db_field="gameId", required=False)
    game_opta_id = mongoengine.IntField(db_field="game_optaId")
    game_inStat_id = mongoengine.IntField(db_field="game_inStatId")
    game_fotMob_id = mongoengine.IntField(db_field="game_fotmobId")
    game_date = mongoengine.DateTimeField(db_field="gameDate", required=False)

    # Manager info (optional).
    manager_id = mongoengine.StringField(db_field="managerId", required=False)
    manager_name = mongoengine.StringField(db_field="managerName", required=False)
    manager_fotmob_id = mongoengine.IntField(
        db_field="manager_fotmobId", required=False
    )

    # Referee name (optional).
    referee_name = mongoengine.StringField(db_field="refereeName", required=False)
    referee_country = mongoengine.StringField(db_field="refereeCountry", required=False)

    # Data-source.
    received_at = mongoengine.DateTimeField(
        db_field="timeReceived", default=datetime.datetime.now
    )
    source = mongoengine.StringField(db_field="lineupSource")

    # Players.
    starting = mongoengine.EmbeddedDocumentListField(StartingPlayer)
    bench = mongoengine.EmbeddedDocumentListField(Player)

    meta = {
        "db_alias": "features",
        "collection": "lineups",
        "ordering": ["-received_at"],
    }

    @classmethod
    def get_latest(
        cls,
        ra_team_id: str,  # Real-analytics game identifier.
        date: datetime.datetime = None, # Find the lastest data document prior to `date`.
    ): # TeamSheet output.
        if date is None:
            date = datetime.datetime.now()
        return (
            cls.objects(team_id=ra_team_id, received_at__lt=date)
            .order_by("-received_at")
            .first()
        )
