# coding: utf-8

"""
    AI model Service Restful API

    This is an ai model service  # noqa: E501

    OpenAPI spec version: 1.0.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ai_service_python_sdk.client.models.aigc_train_request import AIGCTrainRequest
from ai_service_python_sdk.client.models.aigc_create_request import AIGCCreateRequest
from ai_service_python_sdk.client.models.aigc_check_request import AIGCCheckRequest
from ai_service_python_sdk.client.models.aigc_sd_request import AIGCSDRequest


class AIGCImagesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        self.api_client = api_client

    def aigc_images_check(self, images, model_name, configure):
        request = AIGCCheckRequest('AIGCImageCheck', images, model_name, configure)
        thread = self.aigc_images_check_post(request)
        return thread

    def aigc_images_create(self, model_id, template_image, model_name, configure):
        request = AIGCCreateRequest('AIGCImageCreate', model_id=model_id, model_name=model_name, template_image=template_image, configure=configure)
        thread = self.aigc_images_create_post(request)
        return thread

    def aigc_images_create_by_multi_model_ids(self, model_ids, template_image, model_name, configure):
        request = AIGCCreateRequest('AIGCImageCreate', model_ids=model_ids, model_name=model_name, template_image=template_image, configure=configure)
        thread = self.aigc_images_create_post(request)
        return thread

    def aigc_images_train(self, images, model_name, configure):
        request = AIGCTrainRequest('AIGCImageTrain', images, model_name, configure)
        thread = self.aigc_images_train_post(request)
        return thread

    def aigc_images_sd(self, model_name, configure):
        request = AIGCSDRequest('AIGCImageSD', model_name=model_name, configure=configure)
        thread = self.aigc_images_sd_post(request)
        return thread

    def aigc_images_check_post(self, body, **kwargs):  # noqa: E501
        """aigc图像检测  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.aigc_images_check_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AIGCCheckRequest body: aigc检测body (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.aigc_images_check_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.aigc_images_check_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def aigc_images_check_with_http_info(self, body, **kwargs):  # noqa: E501
        """aigc图像检测  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.aigc_images_check_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AIGCCheckRequest body: aigc检测body (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method aigc_images_check_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `aigc_images_check_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        path = "/api/v1/aigc_images/check"

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['auth', 'requestTime']  # noqa: E501

        sign = self.api_client.client_create_sign(self.api_client.configuration, path, 'POST',
                                                  body_params.to_dict(),
                                                  path_params)

        header_params['Authorization'] = self.api_client.configuration.appid + ':' + sign

        return self.api_client.call_api(
            path, 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def aigc_images_create_post(self, body, **kwargs):  # noqa: E501
        """aigc预测  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.aigc_images_create_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AIGCCreatRequest body: aigc预测body (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.aigc_images_create_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.aigc_images_create_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def aigc_images_create_with_http_info(self, body, **kwargs):  # noqa: E501
        """aigc预测  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.aigc_images_create_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AIGCCreatRequest body: aigc预测body (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method aigc_images_create_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `aigc_images_create_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        path = "/api/v1/aigc_images/create"

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['auth', 'requestTime']  # noqa: E501

        sign = self.api_client.client_create_sign(self.api_client.configuration, path, 'POST',
                                                  body_params.to_dict(),
                                                  path_params)

        header_params['Authorization'] = self.api_client.configuration.appid + ':' + sign

        return self.api_client.call_api(
            path, 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def aigc_images_train_post(self, body, **kwargs):  # noqa: E501
        """aigc图像  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.aigc_images_train_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AIGCTrainRequest body: aigc图像body (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.aigc_images_train_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.aigc_images_train_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def aigc_images_train_with_http_info(self, body, **kwargs):  # noqa: E501
        """aigc图像  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.aigc_images_train_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AIGCTrainRequest body: aigc图像body (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method aigc_images_train_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `aigc_images_train_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        path = "/api/v1/aigc_images/train"

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['auth', 'requestTime']  # noqa: E501

        sign = self.api_client.client_create_sign(self.api_client.configuration, path, 'POST',
                                                  body_params.to_dict(),
                                                  path_params)

        header_params['Authorization'] = self.api_client.configuration.appid + ':' + sign

        return self.api_client.call_api(
            path, 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def aigc_images_sd_post(self, body, **kwargs):  # noqa: E501
        """aigc预测  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.aigc_images_create_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AIGCCreatRequest body: aigc预测body (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.aigc_images_sd_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.aigc_images_sd_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def aigc_images_sd_with_http_info(self, body, **kwargs):  # noqa: E501
        """aigc预测  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.aigc_images_create_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AIGCCreatRequest body: aigc预测body (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method aigc_images_create_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `aigc_images_create_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        path = "/api/v1/aigc_images/sd"

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['auth', 'requestTime']  # noqa: E501

        sign = self.api_client.client_create_sign(self.api_client.configuration, path, 'POST',
                                                  body_params.to_dict(),
                                                  path_params)

        header_params['Authorization'] = self.api_client.configuration.appid + ':' + sign

        return self.api_client.call_api(
            path, 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
