# coding: utf-8

"""
    AI model Service Restful API

    This is an ai model service  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ai_service_python_sdk.client.models.image_request import ImageRequest


class AiServiceImageApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client):
        self.api_client = api_client

    def ai_model_image(self, body, **kwargs):  # noqa: E501
        """图片检测接口  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ai_model_image(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImageRequest body: 图片检测body (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ai_model_image_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.ai_model_image_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def ai_model_image_with_http_info(self, body, **kwargs):  # noqa: E501
        """图片检测接口  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ai_model_image_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImageRequest body: 图片检测body (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_model_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `ai_model_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        path = "/api/v1/images"

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['auth', 'requestTime']  # noqa: E501

        sign = self.api_client.client_create_sign(self.api_client.configuration, path, 'POST',
                                                  body_params.to_dict(),
                                                  path_params)

        header_params['Authorization'] = self.api_client.configuration.appid + ':' + sign

        return self.api_client.call_api(
            path, 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ocr_image(self, image, model_name, configure):
        request = ImageRequest('OCRImage', image, model_name, configure)
        thread = self.ai_model_image(request)
        return thread

    def classify_image(self, image, model_name, configure):
        request = ImageRequest('ClassifyImage', image, model_name, configure)
        thread = self.ai_model_image(request)
        return thread

    def multi_label_image(self, image, model_name, configure):
        request = ImageRequest('MultiLabelImage', image, model_name, configure)
        thread = self.ai_model_image(request)
        return thread

    def multi_label_image_v2(self, image, model_name, configure):
        request = ImageRequest('MultiLabelImageV2', image, model_name, configure)
        thread = self.ai_model_image(request)
        return thread

    def detect_classify_image(self, image, model_name, configure):
        request = ImageRequest('DetectClassifyImage', image, model_name, configure)
        thread = self.ai_model_image(request)
        return thread

    def face_recognition_image(self, image, model_name, configure):
        request = ImageRequest('FaceRecognitionImage', image, model_name, configure)
        thread = self.ai_model_image(request)
        return thread

    def scan_image(self, image, model_name, configure):
        request = ImageRequest('ScanImage', image, model_name, configure)
        thread = self.ai_model_image(request)
        return thread

    def face_beauty_image(self, image, model_name, configure):
        request = ImageRequest('FaceBeautyImage', image, model_name, configure)
        thread = self.ai_model_image(request)
        return thread

    def image_qa(self, image, model_name, configure):
        request = ImageRequest('ImageQA', image, model_name, configure)
        thread = self.ai_model_image(request)
        return thread

    def face_attr_image(self, image, model_name, configure):
        request = ImageRequest('FaceAttrImage', image, model_name, configure)
        thread = self.ai_model_image(request)
        return thread
