# -*- coding: utf-8 -*-

"""
swaggerpetstore

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from swaggerpetstore.decorators import lazy_property
from swaggerpetstore.configuration import Configuration
from swaggerpetstore.configuration import Environment
from swaggerpetstore.http.auth.custom_header_authentication import CustomHeaderAuthentication
from swaggerpetstore.http.auth.o_auth_2 import OAuth2
from swaggerpetstore.controllers.pet_controller import PetController
from swaggerpetstore.controllers.user_controller import UserController
from swaggerpetstore.controllers.store_controller import StoreController


class SwaggerpetstoreClient(object):

    @lazy_property
    def pet(self):
        return PetController(self.config, self.auth_managers)

    @lazy_property
    def user(self):
        return UserController(self.config, self.auth_managers)

    @lazy_property
    def store(self):
        return StoreController(self.config, self.auth_managers)

    def __init__(self, http_client_instance=None,
                 override_http_client_configuration=False, http_call_back=None,
                 timeout=60, max_retries=0, backoff_factor=2,
                 retry_statuses=[408, 413, 429, 500, 502, 503, 504, 521, 522, 524],
                 retry_methods=['GET', 'PUT'],
                 environment=Environment.PRODUCTION,
                 custom_header_api_key='TODO: Replace',
                 o_auth_client_id='TODO: Replace',
                 o_auth_redirect_uri='TODO: Replace', o_auth_token=None,
                 o_auth_scopes='TODO: Replace', config=None):
        if config is None:
            self.config = Configuration(
                                         http_client_instance=http_client_instance,
                                         override_http_client_configuration=override_http_client_configuration,
                                         http_call_back=http_call_back,
                                         timeout=timeout,
                                         max_retries=max_retries,
                                         backoff_factor=backoff_factor,
                                         retry_statuses=retry_statuses,
                                         retry_methods=retry_methods,
                                         environment=environment,
                                         custom_header_api_key=custom_header_api_key,
                                         o_auth_client_id=o_auth_client_id,
                                         o_auth_redirect_uri=o_auth_redirect_uri,
                                         o_auth_token=o_auth_token,
                                         o_auth_scopes=o_auth_scopes)
        else:
            self.config = config
        self.initialize_auth_managers(self.config)

    def initialize_auth_managers(self, config):
        self.auth_managers = { key: None for key in ['apiKey', 'petstoreAuth']}
        self.auth_managers['apiKey'] = CustomHeaderAuthentication(config.custom_header_api_key)
        self.auth_managers['petstoreAuth'] = OAuth2(config.o_auth_client_id, config.o_auth_redirect_uri, config.o_auth_token, config, self, config.o_auth_scopes)
        return self.auth_managers
