"""
    Production API

    API exposing endpoints for managing well  and daily production.  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

import nulltype  # noqa: F401

from openapi_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)


class Well(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('type',): {
            'PRODUCER': "PRODUCER",
            'INJECTOR': "INJECTOR",
        },
        ('fluid',): {
            'OIL': "OIL",
            'GAS': "GAS",
            'WATER': "WATER",
        },
        ('lift_type',): {
            'NATURAL_FLOW': "NATURAL_FLOW",
            'GAS_LIFT': "GAS_LIFT",
            'ROD_PUMP': "ROD_PUMP",
            'ESP': "ESP",
            'PLUNGER_LIFT': "PLUNGER_LIFT",
            'GAS_ASSISTED_PLUNGER_LIFT': "GAS_ASSISTED_PLUNGER_LIFT",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'xid': (str,),  # noqa: E501
            'source_id': (str,),  # noqa: E501
            'uwi': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'fluid': (str,),  # noqa: E501
            'lift_type': (str,),  # noqa: E501
            'lat': (float,),  # noqa: E501
            'lon': (float,),  # noqa: E501
            'group1': (str, none_type,),  # noqa: E501
            'group2': (str, none_type,),  # noqa: E501
            'group3': (str, none_type,),  # noqa: E501
            'mud_line': (float, none_type,),  # noqa: E501
            'timezone': (str, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'xid': 'xid',  # noqa: E501
        'source_id': 'sourceId',  # noqa: E501
        'uwi': 'uwi',  # noqa: E501
        'name': 'name',  # noqa: E501
        'type': 'type',  # noqa: E501
        'fluid': 'fluid',  # noqa: E501
        'lift_type': 'liftType',  # noqa: E501
        'lat': 'lat',  # noqa: E501
        'lon': 'lon',  # noqa: E501
        'group1': 'group1',  # noqa: E501
        'group2': 'group2',  # noqa: E501
        'group3': 'group3',  # noqa: E501
        'mud_line': 'mudLine',  # noqa: E501
        'timezone': 'timezone',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, xid, source_id, uwi, name, lat, lon, *args, **kwargs):  # noqa: E501
        """Well - a model defined in OpenAPI

        Args:
            xid (str):
            source_id (str):
            uwi (str):
            name (str):
            lat (float):
            lon (float):

        Keyword Args:
            type (str): defaults to "PRODUCER", must be one of ["PRODUCER", "INJECTOR", ]  # noqa: E501
            fluid (str): defaults to "OIL", must be one of ["OIL", "GAS", "WATER", ]  # noqa: E501
            lift_type (str): defaults to "NATURAL_FLOW", must be one of ["NATURAL_FLOW", "GAS_LIFT", "ROD_PUMP", "ESP", "PLUNGER_LIFT", "GAS_ASSISTED_PLUNGER_LIFT", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            group1 (str, none_type): [optional]  # noqa: E501
            group2 (str, none_type): [optional]  # noqa: E501
            group3 (str, none_type): [optional]  # noqa: E501
            mud_line (float, none_type): [optional]  # noqa: E501
            timezone (str, none_type): [optional]  # noqa: E501
        """

        type = kwargs.get('type', "PRODUCER")
        fluid = kwargs.get('fluid', "OIL")
        lift_type = kwargs.get('lift_type', "NATURAL_FLOW")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.xid = xid
        self.source_id = source_id
        self.uwi = uwi
        self.name = name
        self.type = type
        self.fluid = fluid
        self.lift_type = lift_type
        self.lat = lat
        self.lon = lon
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
