# generated by datamodel-codegen:
#   filename:  api/domains/createDataProduct.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityReference, entityReferenceList


class CreateDataProductRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(..., description='A unique name of the DataProduct')
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName of the Domain.'
    )
    displayName: Optional[str] = Field(
        None,
        description="Name used for display purposes. Example 'Customer Churn', 'Sentiment Analysis', etc.",
    )
    description: basic.Markdown = Field(
        ..., description='Description of the DataProduct.'
    )
    style: Optional[basic.Style] = None
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this DataProduct.'
    )
    domain: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description='Fully qualified name of the Domain the DataProduct belongs to.',
    )
    experts: Optional[List[str]] = Field(
        None,
        description='List of user/login names of users who are experts in this DataProduct.',
    )
    assets: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='Data assets collection that is part of this data product.'
    )
