# generated by datamodel-codegen:
#   filename:  entity/applications/marketplace/createAppMarketPlaceDefinitionReq.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from ....type import basic, entityReference, tagLabel
from .. import app
from ..configuration import applicationConfig


class CreateAppMarketPlaceDefinitionReq(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(..., description='Name of the Application.')
    displayName: Optional[str] = Field(
        None, description='Display Name for the application.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the Application.'
    )
    features: Optional[basic.Markdown] = Field(
        None, description='Features of the Application.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this workflow.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags associated with the entity.'
    )
    developer: Optional[str] = Field(None, description='Developer For the Application.')
    developerUrl: Optional[str] = Field(None, description='Url for the developer')
    privacyPolicyUrl: Optional[str] = Field(
        None, description='Privacy Policy for the developer'
    )
    supportEmail: Optional[str] = Field(
        None, description='Support Email for the application'
    )
    className: str = Field(
        ..., description='Full Qualified ClassName for the the application'
    )
    sourcePythonClass: Optional[str] = Field(
        None,
        description='Fully Qualified class name for the Python source that will execute the external application.',
    )
    appType: app.AppType = Field(
        ..., description='This schema defines the type of application.'
    )
    scheduleType: app.ScheduleType = Field(
        ..., description='This schema defines the Schedule Type of Application.'
    )
    permission: app.Permissions = Field(
        ..., description='Permission used by Native Applications.'
    )
    runtime: Optional[app.ExecutionContext] = Field(
        None,
        description='If app type is live, user can provide additional runtime context.',
    )
    allowConfiguration: Optional[bool] = Field(
        True,
        description='Allow users to configure the app from the UI. If `false`, the `configure` step will be hidden.',
    )
    appConfiguration: Optional[applicationConfig.AppConfig] = Field(
        None, description='Application Configuration object.'
    )
    appLogoUrl: Optional[AnyUrl] = Field(None, description='Application Logo Url.')
    appScreenshots: Optional[List[str]] = Field(
        None, description='Application Screenshots.', unique_items=True
    )
