# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/domoDatabaseConnection.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class DomoDatabaseType(Enum):
    DomoDatabase = 'DomoDatabase'


class DomoDatabaseConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DomoDatabaseType] = Field(
        DomoDatabaseType.DomoDatabase, description='Service Type', title='Service Type'
    )
    clientId: str = Field(..., description='Client ID for DOMO', title='Client ID')
    secretToken: CustomSecretStr = Field(
        ..., description='Secret Token to connect DOMO', title='Secret Token'
    )
    accessToken: Optional[str] = Field(
        None, description='Access token to connect to DOMO', title='Access Token'
    )
    apiHost: Optional[str] = Field(
        'api.domo.com',
        description='API Host to connect to DOMO instance',
        title='API Host',
    )
    instanceDomain: AnyUrl = Field(
        ...,
        description='URL of your Domo instance, e.g., https://openmetadata.domo.com',
        title='Instance Domain',
    )
    databaseName: Optional[str] = Field(
        None,
        description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
        title='Database Name',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
