# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/postgresConnection.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from .....security.ssl import verifySSLConfig
from .. import connectionBasicType
from .common import basicAuth, iamAuthConfig


class SslMode(Enum):
    disable = 'disable'
    allow = 'allow'
    prefer = 'prefer'
    require = 'require'
    verify_ca = 'verify-ca'
    verify_full = 'verify-full'


class PostgresType(Enum):
    Postgres = 'Postgres'


class PostgresScheme(Enum):
    postgresql_psycopg2 = 'postgresql+psycopg2'
    pgspider_psycopg2 = 'pgspider+psycopg2'


class PostgresConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[PostgresType] = Field(
        PostgresType.Postgres, description='Service Type', title='Service Type'
    )
    scheme: Optional[PostgresScheme] = Field(
        PostgresScheme.postgresql_psycopg2,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='Username to connect to Postgres. This user should have privileges to read all the metadata in Postgres.',
        title='Username',
    )
    authType: Optional[
        Union[basicAuth.BasicAuth, iamAuthConfig.IamAuthConfigurationSource]
    ] = Field(
        None, description='Choose Auth Config Type.', title='Auth Configuration Type'
    )
    hostPort: str = Field(
        ..., description='Host and port of the source service.', title='Host and Port'
    )
    database: str = Field(
        ...,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
        title='Database',
    )
    ingestAllDatabases: Optional[bool] = Field(
        False,
        description='Ingest data from all databases in Postgres. You can use databaseFilterPattern on top of this.',
        title='Ingest All Databases',
    )
    sslMode: Optional[SslMode] = Field(
        SslMode.disable,
        description='SSL Mode to connect to postgres database.',
        title='SSL Mode',
    )
    sslConfig: Optional[verifySSLConfig.SslConfig] = None
    classificationName: Optional[str] = Field(
        'PostgresPolicyTags',
        description='Custom OpenMetadata Classification name for Postgres policy tags.',
        title='Classification Name',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
    supportsLineageExtraction: Optional[
        connectionBasicType.SupportsLineageExtraction
    ] = None
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    supportsDatabase: Optional[connectionBasicType.SupportsDatabase] = Field(
        None, title='Supports Database'
    )
    supportsQueryComment: Optional[connectionBasicType.SupportsQueryComment] = Field(
        None, title='Supports Query Comment'
    )
    sampleDataStorageConfig: Optional[
        connectionBasicType.SampleDataStorageConfig
    ] = Field(None, title='Storage Config for Sample Data')
