# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/trinoConnection.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, Optional, Union

from pydantic import BaseModel, Extra, Field

from .. import connectionBasicType
from .common import basicAuth, jwtAuth


class TrinoType(Enum):
    Trino = 'Trino'


class TrinoScheme(Enum):
    trino = 'trino'


class TrinoConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[TrinoType] = Field(
        TrinoType.Trino, description='Service Type', title='Service Type'
    )
    scheme: Optional[TrinoScheme] = Field(
        TrinoScheme.trino,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='Username to connect to Trino. This user should have privileges to read all the metadata in Trino.',
        title='Username',
    )
    authType: Optional[Union[basicAuth.BasicAuth, jwtAuth.JwtAuth]] = Field(
        None, description='Choose Auth Config Type.', title='Auth Configuration Type'
    )
    hostPort: str = Field(
        ..., description='Host and port of the Trino service.', title='Host and Port'
    )
    catalog: Optional[str] = Field(
        None, description='Catalog of the data source.', title='Catalog'
    )
    databaseSchema: Optional[str] = Field(
        None,
        description='databaseSchema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single databaseSchema. When left blank, OpenMetadata Ingestion attempts to scan all the databaseSchema.',
        title='databaseSchema',
    )
    proxies: Optional[Dict[str, str]] = Field(
        None,
        description='Proxies for the connection to Trino data source',
        title='Proxies',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = Field(None, title='Supports Usage Extraction')
    supportsLineageExtraction: Optional[
        connectionBasicType.SupportsLineageExtraction
    ] = Field(None, title='Supports Lineage Extraction')
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    supportsDatabase: Optional[connectionBasicType.SupportsDatabase] = Field(
        None, title='Supports Database'
    )
    supportsQueryComment: Optional[connectionBasicType.SupportsQueryComment] = Field(
        None, title='Supports Query Comment'
    )
    sampleDataStorageConfig: Optional[
        connectionBasicType.SampleDataStorageConfig
    ] = Field(None, title='Storage Config for Sample Data')
