# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceProfilerPipeline.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ..entity.data import table
from ..type import filterPattern


class ProfilerConfigType(Enum):
    Profiler = 'Profiler'


class DatabaseServiceProfilerPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[ProfilerConfigType] = Field(
        ProfilerConfigType.Profiler, description='Pipeline type'
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
        title='Schema Filter Pattern',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex exclude tables or databases that matches the pattern.',
        title='Table Filter Pattern',
    )
    databaseFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch databases that matches the pattern.',
        title='Database Filter Pattern',
    )
    includeViews: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for views.',
        title='Include Views',
    )
    processPiiSensitive: Optional[bool] = Field(
        False,
        description='Optional configuration to automatically tag columns that might contain sensitive information',
        title='Auto Tag PII',
    )
    confidence: Optional[float] = Field(
        80,
        description='Set the Confidence value for which you want the column to be marked',
        title='Confidence',
    )
    profileSample: Optional[float] = Field(
        None,
        description='Percentage of data or no. of rows we want to execute the profiler and tests on',
        title='Profile Sample',
    )
    profileSampleType: Optional[table.ProfileSampleType] = Field(
        table.ProfileSampleType.PERCENTAGE, title='Profile Sample Type'
    )
    generateSampleData: Optional[bool] = Field(
        True,
        description='Option to turn on/off generating sample data.',
        title='Generate Sample Data',
    )
    computeMetrics: Optional[bool] = Field(
        True,
        description='Option to turn on/off computing profiler metrics.',
        title='Compute Metrics',
    )
    sampleDataCount: Optional[int] = Field(
        50,
        description='Number of row of sample data to be generated',
        title='Sample Data Rows Count',
    )
    threadCount: Optional[float] = Field(
        5,
        description='Number of threads to use during metric computations',
        title='Thread Count',
    )
    timeoutSeconds: Optional[int] = Field(
        43200, description='Profiler Timeout in Seconds', title='Timeout (in sec.)'
    )
    useFqnForFiltering: Optional[bool] = Field(
        False,
        description='Regex will be applied on fully qualified name (e.g service_name.db_name.schema_name.table_name) instead of raw name (e.g. table_name)',
        title='Use FQN For Filtering',
    )
