# generated by datamodel-codegen:
#   filename:  tests/basic.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional

from pydantic import BaseModel, Field

from ..type import basic


class Basic(BaseModel):
    __root__: Any = Field(
        ...,
        description='This schema defines basic types that are used by other test schemas.',
        title='Basic',
    )


class TestSummary(BaseModel):
    success: Optional[int] = Field(
        None, description='Number of test cases that passed.'
    )
    failed: Optional[int] = Field(None, description='Number of test cases that failed.')
    aborted: Optional[int] = Field(
        None, description='Number of test cases that aborted.'
    )
    queued: Optional[int] = Field(
        None, description='Number of test cases that are queued for execution.'
    )
    total: Optional[int] = Field(None, description='Total number of test cases.')


class TestResultValue(BaseModel):
    name: Optional[str] = Field(None, description='name of the value')
    value: Optional[str] = Field(None, description='test result value')


class TestCaseStatus(Enum):
    Success = 'Success'
    Failed = 'Failed'
    Aborted = 'Aborted'
    Queued = 'Queued'


class TestCaseResult(BaseModel):
    timestamp: Optional[basic.Timestamp] = Field(
        None, description='Data one which test case result is taken.'
    )
    testCaseStatus: Optional[TestCaseStatus] = Field(
        None, description='Status of Test Case run.'
    )
    result: Optional[str] = Field(None, description='Details of test case results.')
    sampleData: Optional[str] = Field(
        None,
        description="sample data to capture rows/columns that didn't match the expressed testcase.",
    )
    testResultValue: Optional[List[TestResultValue]] = None
    passedRows: Optional[int] = Field(None, description='Number of rows that passed.')
    failedRows: Optional[int] = Field(None, description='Number of rows that failed.')
    passedRowsPercentage: Optional[float] = Field(
        None, description='Percentage of rows that passed.'
    )
    failedRowsPercentage: Optional[float] = Field(
        None, description='Percentage of rows that failed.'
    )
    incidentId: Optional[basic.Uuid] = Field(
        None,
        description='Incident State ID associated with this result. This association happens when the result is created, and will stay there even when the incident is resolved.',
    )


class TestSuiteExecutionFrequency(Enum):
    Hourly = 'Hourly'
    Daily = 'Daily'
    Weekly = 'Weekly'
