# generated by datamodel-codegen:
#   filename:  tests/testSuite.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ..api.tests import createTestSuite
from ..entity.services.connections import testConnectionResult
from ..type import basic, entityHistory, entityReference, entityReferenceList
from . import basic as basic_1


class ServiceType(Enum):
    TestSuite = 'TestSuite'


class TestSuiteConnection(BaseModel):
    config: None = None


class ResultSummary(BaseModel):
    testCaseName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='Name of the test case.'
    )
    status: Optional[basic_1.TestCaseStatus] = Field(
        None, description='Status of the test case.'
    )
    timestamp: Optional[basic.Timestamp] = Field(
        None, description='Timestamp of the test case execution.'
    )


class TestSuite(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier of this test suite instance.'
    )
    name: createTestSuite.TestSuiteEntityName = Field(
        ..., description='Name that identifies this test suite.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this test suite.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the test suite.'
    )
    tests: Optional[List[entityReference.EntityReference]] = None
    connection: Optional[TestSuiteConnection] = None
    testConnectionResult: Optional[testConnectionResult.TestConnectionResult] = None
    pipelines: Optional[entityReferenceList.EntityReferenceList] = Field(
        None,
        description='References to pipelines deployed for this database service to extract metadata, usage, lineage etc..',
    )
    serviceType: Optional[ServiceType] = Field(
        ServiceType.TestSuite,
        description='Type of database service such as MySQL, BigQuery, Snowflake, Redshift, Postgres...',
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this TestCase definition.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    executable: Optional[bool] = Field(
        False,
        description='Indicates if the test suite is executable. Set on the backend.',
    )
    executableEntityReference: Optional[entityReference.EntityReference] = Field(
        None,
        description='Entity reference the test suite is executed against. Only applicable if the test suite is executable.',
    )
    summary: Optional[basic_1.TestSummary] = Field(
        None,
        description='Summary of the previous day test cases execution for this test suite.',
    )
    testCaseResultSummary: Optional[List[ResultSummary]] = Field(
        None, description='Summary of test case execution'
    )
