# generated by datamodel-codegen:
#   filename:  entity/applications/app.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference, entityReferenceList
from ..services.connections.metadata import openMetadataConnection
from . import liveExecutionContext, scheduledExecutionContext
from .configuration import applicationConfig


class ScheduleType(Enum):
    Live = 'Live'
    Scheduled = 'Scheduled'


class ScheduleTimeline(Enum):
    Hourly = 'Hourly'
    field_Daily = ' Daily'
    Weekly = 'Weekly'
    Monthly = 'Monthly'
    Custom = 'Custom'


class AppSchedule(BaseModel):
    class Config:
        extra = Extra.forbid

    scheduleType: ScheduleTimeline
    cronExpression: Optional[str] = Field(
        None, description='Cron Expression in case of Custom scheduled Trigger'
    )


class AppType(Enum):
    internal = 'internal'
    external = 'external'


class Permissions(Enum):
    All = 'All'


class ExecutionContext(BaseModel):
    __root__: Union[
        liveExecutionContext.JobRun, scheduledExecutionContext.JobRun
    ] = Field(..., description='Execution Configuration.')


class App(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(..., description='Unique identifier of this application.')
    name: basic.EntityName = Field(..., description='Name of the Application.')
    displayName: Optional[str] = Field(
        None, description='Display Name for the application.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the Application.'
    )
    features: Optional[basic.Markdown] = Field(
        None, description='Features of the Application.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this workflow.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    developer: Optional[str] = Field(None, description='Developer For the Application.')
    developerUrl: Optional[str] = Field(None, description='Url for the developer')
    privacyPolicyUrl: Optional[str] = Field(
        None, description='Privacy Policy for the developer'
    )
    supportEmail: Optional[str] = Field(
        None, description='Support Email for the application'
    )
    className: str = Field(
        ..., description='Fully Qualified ClassName for the Schedule'
    )
    sourcePythonClass: Optional[str] = Field(
        None,
        description='Fully Qualified class name for the Python source that will execute the external application.',
    )
    appType: AppType = Field(
        ..., description='This schema defines the type of application.'
    )
    scheduleType: ScheduleType = Field(
        ..., description='This schema defines the Schedule Type of Application.'
    )
    permission: Permissions = Field(
        ..., description='Permission used by Native Applications.'
    )
    bot: Optional[entityReference.EntityReference] = Field(
        None, description='Bot User Associated with this application.'
    )
    runtime: ExecutionContext = Field(..., description='Execution Configuration.')
    allowConfiguration: Optional[bool] = Field(
        True,
        description='Allow users to configure the app from the UI. If `false`, the `configure` step will be hidden.',
    )
    appConfiguration: Optional[applicationConfig.AppConfig] = Field(
        None, description='Application Configuration object.'
    )
    privateConfiguration: Optional[applicationConfig.PrivateConfig] = Field(
        None, description='Application Private configuration loaded at runtime.'
    )
    pipelines: Optional[entityReferenceList.EntityReferenceList] = Field(
        None,
        description='References to pipelines deployed for this database service to extract metadata, usage, lineage etc..',
    )
    appSchedule: AppSchedule = Field(
        ...,
        description='In case the app supports scheduling, list of different app schedules',
    )
    openMetadataServerConnection: Optional[
        openMetadataConnection.OpenMetadataConnection
    ] = None
    appLogoUrl: Optional[AnyUrl] = Field(None, description='Application Logo Url.')
    appScreenshots: Optional[List[str]] = Field(
        None, description='Application Screenshots.', unique_items=True
    )
