# generated by datamodel-codegen:
#   filename:  entity/docStore/document.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory


class Data(BaseModel):
    pass

    class Config:
        extra = Extra.allow


class Document(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = None
    name: basic.EntityName = Field(..., description='Name of the DocStore')
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this column name.'
    )
    fullyQualifiedName: basic.FullyQualifiedEntityName
    description: Optional[str] = Field(
        None, description='Description of the DocStore Entity.'
    )
    entityType: str = Field(..., description='Type of the Entity stored in DocStore.')
    data: Data
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
