# generated by datamodel-codegen:
#   filename:  entity/services/connections/metadata/openMetadataConnection.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, Optional

from pydantic import BaseModel, Extra, Field

from .....security.client import openMetadataJWTClientConfig
from .....security.secrets import secretsManagerClientLoader, secretsManagerProvider
from .....security.ssl import verifySSLConfig
from .....type import basic
from .. import connectionBasicType


class ElasticsSearch(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str = Field(..., description='Type of sink component ex: metadata')
    config: Optional[basic.ComponentConfig] = None


class OpenmetadataType(Enum):
    OpenMetadata = 'OpenMetadata'


class ExtraHeaders(BaseModel):
    __root__: Optional[Dict[str, str]] = None


class AuthProvider(Enum):
    basic = 'basic'
    azure = 'azure'
    google = 'google'
    okta = 'okta'
    auth0 = 'auth0'
    aws_cognito = 'aws-cognito'
    custom_oidc = 'custom-oidc'
    ldap = 'ldap'
    saml = 'saml'
    openmetadata = 'openmetadata'


class OpenMetadataConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    clusterName: Optional[str] = Field(
        'openmetadata',
        description='Cluster name to differentiate OpenMetadata Server instance',
    )
    type: Optional[OpenmetadataType] = Field(
        OpenmetadataType.OpenMetadata, description='Service Type'
    )
    hostPort: str = Field(
        ...,
        description='OpenMetadata Server Config. Must include API end point ex: http://localhost:8585/api',
    )
    authProvider: Optional[AuthProvider] = AuthProvider.basic
    verifySSL: Optional[verifySSLConfig.VerifySSL] = verifySSLConfig.VerifySSL.no_ssl
    sslConfig: Optional[verifySSLConfig.SslConfig] = None
    securityConfig: Optional[
        openMetadataJWTClientConfig.OpenMetadataJWTClientConfig
    ] = Field(None, description='OpenMetadata Client security configuration.')
    secretsManagerProvider: Optional[
        secretsManagerProvider.SecretsManagerProvider
    ] = secretsManagerProvider.SecretsManagerProvider.db
    secretsManagerLoader: Optional[
        secretsManagerClientLoader.SecretsManagerClientLoader
    ] = secretsManagerClientLoader.SecretsManagerClientLoader.noop
    apiVersion: Optional[str] = Field(
        'v1', description='OpenMetadata server API version to use.'
    )
    includeTopics: Optional[bool] = Field(
        True, description='Include Topics for Indexing'
    )
    includeTables: Optional[bool] = Field(
        True, description='Include Tables for Indexing'
    )
    includeDashboards: Optional[bool] = Field(
        True, description='Include Dashboards for Indexing'
    )
    includePipelines: Optional[bool] = Field(
        True, description='Include Pipelines for Indexing'
    )
    includeMlModels: Optional[bool] = Field(
        True, description='Include MlModels for Indexing'
    )
    includeUsers: Optional[bool] = Field(True, description='Include Users for Indexing')
    includeTeams: Optional[bool] = Field(True, description='Include Teams for Indexing')
    includeGlossaryTerms: Optional[bool] = Field(
        True, description='Include Glossary Terms for Indexing'
    )
    includeTags: Optional[bool] = Field(True, description='Include Tags for Indexing')
    includePolicy: Optional[bool] = Field(True, description='Include Tags for Policy')
    includeMessagingServices: Optional[bool] = Field(
        True, description='Include Messaging Services for Indexing'
    )
    enableVersionValidation: Optional[bool] = Field(
        True, description='Validate Openmetadata Server & Client Version.'
    )
    includeDatabaseServices: Optional[bool] = Field(
        True, description='Include Database Services for Indexing'
    )
    includePipelineServices: Optional[bool] = Field(
        True, description='Include Pipeline Services for Indexing'
    )
    limitRecords: Optional[int] = Field(
        '1000', description='Limit the number of records for Indexing.'
    )
    forceEntityOverwriting: Optional[bool] = Field(
        False, description='Force the overwriting of any entity during the ingestion.'
    )
    storeServiceConnection: Optional[bool] = Field(
        True,
        description='If set to true, when creating a service during the ingestion we will store its Service Connection. Otherwise, the ingestion will create a bare service without connection details.',
    )
    elasticsSearch: Optional[ElasticsSearch] = Field(
        None,
        description='Configuration for Sink Component in the OpenMetadata Ingestion Framework.',
    )
    supportsDataInsightExtraction: Optional[
        connectionBasicType.SupportsDataInsightExtraction
    ] = None
    supportsElasticSearchReindexingExtraction: Optional[
        connectionBasicType.SupportsElasticSearchReindexingExtraction
    ] = None
    extraHeaders: Optional[ExtraHeaders] = Field(None, title='Extra Headers')
