# generated by datamodel-codegen:
#   filename:  entity/services/databaseService.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference, entityReferenceList, tagLabel
from .connections import testConnectionResult
from .connections.database import (
    athenaConnection,
    azureSQLConnection,
    bigQueryConnection,
    bigTableConnection,
    clickhouseConnection,
    couchbaseConnection,
    customDatabaseConnection,
    databricksConnection,
    datalakeConnection,
    db2Connection,
    deltaLakeConnection,
    domoDatabaseConnection,
    dorisConnection,
    druidConnection,
    dynamoDBConnection,
    glueConnection,
    greenplumConnection,
    hiveConnection,
    icebergConnection,
    impalaConnection,
    mariaDBConnection,
    mongoDBConnection,
    mssqlConnection,
    mysqlConnection,
    oracleConnection,
    pinotDBConnection,
    postgresConnection,
    prestoConnection,
    redshiftConnection,
    salesforceConnection,
    sapHanaConnection,
    sasConnection,
    singleStoreConnection,
    snowflakeConnection,
    sqliteConnection,
    trinoConnection,
    unityCatalogConnection,
    verticaConnection,
)


class DatabaseServiceType(Enum):
    BigQuery = 'BigQuery'
    BigTable = 'BigTable'
    Mysql = 'Mysql'
    Redshift = 'Redshift'
    Snowflake = 'Snowflake'
    Postgres = 'Postgres'
    Mssql = 'Mssql'
    Oracle = 'Oracle'
    Athena = 'Athena'
    Hive = 'Hive'
    Impala = 'Impala'
    Presto = 'Presto'
    Trino = 'Trino'
    Vertica = 'Vertica'
    Glue = 'Glue'
    MariaDB = 'MariaDB'
    Druid = 'Druid'
    Db2 = 'Db2'
    Clickhouse = 'Clickhouse'
    Databricks = 'Databricks'
    AzureSQL = 'AzureSQL'
    DynamoDB = 'DynamoDB'
    SingleStore = 'SingleStore'
    SQLite = 'SQLite'
    DeltaLake = 'DeltaLake'
    Salesforce = 'Salesforce'
    PinotDB = 'PinotDB'
    Datalake = 'Datalake'
    DomoDatabase = 'DomoDatabase'
    QueryLog = 'QueryLog'
    CustomDatabase = 'CustomDatabase'
    Dbt = 'Dbt'
    SapHana = 'SapHana'
    MongoDB = 'MongoDB'
    Couchbase = 'Couchbase'
    Greenplum = 'Greenplum'
    Doris = 'Doris'
    UnityCatalog = 'UnityCatalog'
    SAS = 'SAS'
    Iceberg = 'Iceberg'


class DatabaseConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    config: Optional[
        Union[
            bigQueryConnection.BigQueryConnection,
            bigTableConnection.BigTableConnection,
            athenaConnection.AthenaConnection,
            azureSQLConnection.AzureSQLConnection,
            clickhouseConnection.ClickhouseConnection,
            databricksConnection.DatabricksConnection,
            db2Connection.Db2Connection,
            deltaLakeConnection.DeltaLakeConnection,
            druidConnection.DruidConnection,
            dynamoDBConnection.DynamoDBConnection,
            glueConnection.GlueConnection,
            hiveConnection.HiveConnection,
            impalaConnection.ImpalaConnection,
            mariaDBConnection.MariaDBConnection,
            mssqlConnection.MssqlConnection,
            mysqlConnection.MysqlConnection,
            sqliteConnection.SQLiteConnection,
            oracleConnection.OracleConnection,
            postgresConnection.PostgresConnection,
            prestoConnection.PrestoConnection,
            redshiftConnection.RedshiftConnection,
            salesforceConnection.SalesforceConnection,
            singleStoreConnection.SingleStoreConnection,
            snowflakeConnection.SnowflakeConnection,
            trinoConnection.TrinoConnection,
            verticaConnection.VerticaConnection,
            pinotDBConnection.PinotDBConnection,
            datalakeConnection.DatalakeConnection,
            domoDatabaseConnection.DomoDatabaseConnection,
            customDatabaseConnection.CustomDatabaseConnection,
            sapHanaConnection.SapHanaConnection,
            mongoDBConnection.MongoDBConnection,
            couchbaseConnection.CouchbaseConnection,
            greenplumConnection.GreenplumConnection,
            dorisConnection.DorisConnection,
            unityCatalogConnection.UnityCatalogConnection,
            sasConnection.SASConnection,
            icebergConnection.IcebergConnection,
        ]
    ] = None


class DatabaseService(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier of this database service instance.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that identifies this database service.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this database service.'
    )
    serviceType: DatabaseServiceType = Field(
        ...,
        description='Type of database service such as MySQL, BigQuery, Snowflake, Redshift, Postgres...',
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of a database service instance.'
    )
    connection: Optional[DatabaseConnection] = None
    pipelines: Optional[entityReferenceList.EntityReferenceList] = Field(
        None,
        description='References to pipelines deployed for this database service to extract metadata, usage, lineage etc..',
    )
    testConnectionResult: Optional[testConnectionResult.TestConnectionResult] = Field(
        None, description='Last test connection results for this service'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this Database Service.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this database service.'
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this database service.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    dataProducts: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='List of data products this entity is part of.'
    )
    domain: Optional[entityReference.EntityReference] = Field(
        None, description='Domain the Database service belongs to.'
    )
