# generated by datamodel-codegen:
#   filename:  events/eventSubscription.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Extra, Field

from ..entity.events import webhook
from ..type import basic, entityHistory, entityReference
from . import emailAlertConfig, eventFilterRule


class Argument(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = Field(None, description='Name of the Argument')
    input: Optional[List[str]] = Field(None, description='Value of the Argument')


class ArgumentsInput(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = Field(None, description='Name of the filter')
    effect: Optional[eventFilterRule.Effect] = eventFilterRule.Effect.include
    arguments: Optional[List[Argument]] = Field(None, description='Arguments List')


class AlertFilteringInput(BaseModel):
    class Config:
        extra = Extra.forbid

    filters: Optional[List[ArgumentsInput]] = Field(
        None, description='List of filters for the event subscription.'
    )
    actions: Optional[List[ArgumentsInput]] = Field(
        None, description='List of filters for the event subscription.'
    )


class TriggerType(Enum):
    RealTime = 'RealTime'
    Scheduled = 'Scheduled'


class AlertType(Enum):
    Notification = 'Notification'
    Observability = 'Observability'
    ActivityFeed = 'ActivityFeed'


class SubscriptionCategory(Enum):
    Users = 'Users'
    Teams = 'Teams'
    Admins = 'Admins'
    Assignees = 'Assignees'
    Owners = 'Owners'
    Followers = 'Followers'
    External = 'External'


class SubscriptionType(Enum):
    Generic = 'Generic'
    Slack = 'Slack'
    MsTeams = 'MsTeams'
    GChat = 'GChat'
    Email = 'Email'
    ActivityFeed = 'ActivityFeed'


class Status(Enum):
    disabled = 'disabled'
    failed = 'failed'
    retryLimitReached = 'retryLimitReached'
    awaitingRetry = 'awaitingRetry'
    active = 'active'


class SubscriptionStatus(BaseModel):
    class Config:
        extra = Extra.forbid

    status: Optional[Status] = None
    lastSuccessfulAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last non-successful callback time in UNIX UTC epoch time in milliseconds.',
    )
    lastFailedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last non-successful callback time in UNIX UTC epoch time in milliseconds.',
    )
    lastFailedStatusCode: Optional[int] = Field(
        None,
        description='Last non-successful activity response code received during callback.',
    )
    lastFailedReason: Optional[str] = Field(
        None,
        description='Last non-successful activity response reason received during callback.',
    )
    nextAttempt: Optional[basic.Timestamp] = Field(
        None,
        description='Next retry will be done at this time in Unix epoch time milliseconds. Only valid is `status` is `awaitingRetry`.',
    )
    timestamp: Optional[basic.Timestamp] = None


class ScheduleInfo(Enum):
    Daily = 'Daily'
    Weekly = 'Weekly'
    Monthly = 'Monthly'
    Custom = 'Custom'


class Trigger(BaseModel):
    class Config:
        extra = Extra.forbid

    triggerType: TriggerType
    scheduleInfo: Optional[ScheduleInfo] = Field(
        ScheduleInfo.Weekly, description='Schedule Info'
    )
    cronExpression: Optional[str] = Field(
        None, description='Cron Expression in case of Custom scheduled Trigger'
    )


class Destination(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier that identifies this Event Subscription.'
    )
    category: SubscriptionCategory
    type: SubscriptionType
    statusDetails: Optional[SubscriptionStatus] = None
    timeout: Optional[int] = Field(
        10, description='Connection timeout in seconds. (Default 10s).'
    )
    readTimeout: Optional[int] = Field(
        12, description='Read timeout in seconds. (Default 12s).'
    )
    enabled: Optional[bool] = Field(True, description='Is the subscription enabled.')
    config: Optional[Union[webhook.Webhook, emailAlertConfig.EmailAlertConfig]] = None


class FilteringRules(BaseModel):
    class Config:
        extra = Extra.forbid

    resources: List[str] = Field(
        ...,
        description='Defines a list of resources that triggers the Event Subscription, Eg All, User, Teams etc.',
    )
    rules: Optional[List[eventFilterRule.EventFilterRule]] = Field(
        None, description='A set of filter rules associated with the Alert.'
    )
    actions: Optional[List[eventFilterRule.EventFilterRule]] = Field(
        None, description='A set of filter rules associated with the Alert.'
    )


class EventSubscription(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies this Event Subscription.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that uniquely identifies this Event Subscription.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description='FullyQualifiedName that uniquely identifies a Event Subscription.',
    )
    displayName: Optional[str] = Field(
        None, description='Display name for this Event Subscription.'
    )
    description: Optional[basic.Markdown] = Field(
        None,
        description='A short description of the Event Subscription, comprehensible to regular users.',
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Event Subscription.'
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the Event Subscription.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the Event Subscription in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that led to this version of the Event Subscription.'
    )
    alertType: AlertType = Field(..., description='Type of Alert')
    trigger: Optional[Trigger] = Field(
        None, description='Trigger information for Alert.'
    )
    filteringRules: Optional[FilteringRules] = Field(
        None,
        description='Set of rules that the Event Subscription Contains to allow conditional control for alerting.',
    )
    destinations: List[Destination] = Field(..., description='Destination Config.')
    enabled: Optional[bool] = Field(
        True, description='Is the event Subscription enabled.'
    )
    batchSize: Optional[int] = Field(
        100, description='Maximum number of events sent in a batch (Default 100).'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    retries: Optional[int] = Field(
        3, description='Number of times to retry callback on failure. (Default 3).'
    )
    pollInterval: Optional[int] = Field(10, description='Poll Interval in seconds.')
    input: Optional[AlertFilteringInput] = Field(
        None, description='Input for the Filters.'
    )
