# generated by datamodel-codegen:
#   filename:  metadataIngestion/application.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field

from ..entity.applications.configuration import applicationConfig
from ..type import basic
from . import workflow


class OpenMetadataApplicationConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    workflowConfig: workflow.WorkflowConfig = Field(
        ...,
        description='General Workflow configuration, such as the OpenMetadata server connection and logging level',
    )
    sourcePythonClass: Optional[str] = Field(
        None, description='Source Python Class Name to run the application'
    )
    appConfig: Optional[applicationConfig.AppConfig] = Field(
        None, description='External Application configuration'
    )
    appPrivateConfig: Optional[applicationConfig.PrivateConfig] = Field(
        None, description='External Application Private configuration'
    )
    ingestionPipelineFQN: Optional[str] = Field(
        None,
        description='Fully qualified name of ingestion pipeline, used to identify the current ingestion pipeline',
    )
    pipelineRunId: Optional[basic.Uuid] = Field(
        None,
        description='Unique identifier of pipeline run, used to identify the current pipeline run',
    )
