# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceQueryLineagePipeline.json
#   timestamp: 2024-03-01T08:53:21+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ..type import filterPattern


class DatabaseLineageConfigType(Enum):
    DatabaseLineage = 'DatabaseLineage'


class DatabaseServiceQueryLineagePipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DatabaseLineageConfigType] = Field(
        DatabaseLineageConfigType.DatabaseLineage, description='Pipeline type'
    )
    queryLogDuration: Optional[int] = Field(
        1,
        description='Configuration to tune how far we want to look back in query logs to process lineage data.',
        title='Query Log Duration',
    )
    queryLogFilePath: Optional[str] = Field(
        None,
        description='Configuration to set the file path for query logs',
        title='Query Log File Path',
    )
    resultLimit: Optional[int] = Field(
        1000,
        description='Configuration to set the limit for query logs',
        title='Result Limit',
    )
    parsingTimeoutLimit: Optional[int] = Field(
        300,
        description='Configuration to set the timeout for parsing the query in seconds.',
        title='Parsing Timeout Limit',
    )
    filterCondition: Optional[str] = Field(
        None,
        description='Configuration the condition to filter the query history.',
        title='Filter Condition',
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
        title='Schema Filter Pattern',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex exclude tables or databases that matches the pattern.',
        title='Table Filter Pattern',
    )
    databaseFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch databases that matches the pattern.',
        title='Database Filter Pattern',
    )
