"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontToApiGatewayToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const aws_cloudfront_apigateway_1 = require("@aws-solutions-constructs/aws-cloudfront-apigateway");
class CloudFrontToApiGatewayToLambda extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the CloudFrontToApiGatewayToLambda class.
     * @param {Construct} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckLambdaProps(props);
        // CheckCloudFrontProps() is called by internal aws-cloudfront-apigateway construct
        if (!props.apiGatewayProps?.defaultMethodOptions?.authorizationType) {
            defaults.printWarning('As of v2.48.0, apiGatewayProps.defaultMethodOptions.authorizationType is\
      required. To update your instantiation call, add the following to your CloudFrontToApiGatewayToLambdaProps argument\
      \n\napiGatewayProps: { defaultMethodOptions: { authorizationType: api.AuthorizationType.NONE }},\n\nSee Issue1043 for an explanation.');
            throw new Error('As of v2.48.0, an explicit authorization type is required for CloudFront/API Gateway patterns');
        }
        else if (props.apiGatewayProps.defaultMethodOptions.authorizationType === "AWS_IAM") {
            throw new Error('Amazon API Gateway Rest APIs integrated with Amazon CloudFront do not support AWS_IAM authorization');
        }
        // All our tests are based upon this behavior being on, so we're setting
        // context here rather than assuming the client will set it
        this.node.setContext("@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy", true);
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps
        });
        // We can't default to IAM authentication with a CloudFront distribution, so
        // we'll instruct core to not use any default auth to avoid override warnings
        const regionalLambdaRestApiResponse = defaults.RegionalLambdaRestApi(this, this.lambdaFunction, props.apiGatewayProps, props.logGroupProps, false);
        this.apiGateway = regionalLambdaRestApiResponse.api;
        this.apiGatewayCloudWatchRole = regionalLambdaRestApiResponse.role;
        this.apiGatewayLogGroup = regionalLambdaRestApiResponse.group;
        const apiCloudfront = new aws_cloudfront_apigateway_1.CloudFrontToApiGateway(this, 'CloudFrontToApiGateway', {
            existingApiGatewayObj: this.apiGateway,
            cloudFrontDistributionProps: props.cloudFrontDistributionProps,
            insertHttpSecurityHeaders: props.insertHttpSecurityHeaders,
            cloudFrontLoggingBucketProps: props.cloudFrontLoggingBucketProps,
            responseHeadersPolicyProps: props.responseHeadersPolicyProps
        });
        this.cloudFrontWebDistribution = apiCloudfront.cloudFrontWebDistribution;
        this.cloudFrontFunction = apiCloudfront.cloudFrontFunction;
        this.cloudFrontLoggingBucket = apiCloudfront.cloudFrontLoggingBucket;
    }
}
exports.CloudFrontToApiGatewayToLambda = CloudFrontToApiGatewayToLambda;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontToApiGatewayToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-cloudfront-apigateway-lambda.CloudFrontToApiGatewayToLambda", version: "2.63.0" };
//# sourceMappingURL=data:application/json;base64,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