/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import junit.framework.TestCase;
import org.openqa.selenium.server.HtmlIdentifier;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.log.LoggingManager;

public class HtmlIdentifierTest
extends TestCase {
    public void setUp() throws Exception {
        SeleniumServer.setBrowserSideLogEnabled((boolean)true);
        LoggingManager.configureLogging((RemoteControlConfiguration)new RemoteControlConfiguration(), (boolean)true);
    }

    public void testMetaEquiv() {
        boolean result = HtmlIdentifier.shouldBeInjected((String)"/selenium-server/tests/proxy_injection_meta_equiv_test.js", (String)"application/x-javascript", (String)"<!DOCTYPE html PUBLIC \\\"-//W3C//DTD XHTML 1.0 Transitional//EN \\\" \\\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\\\"><html xmlns=\\\"http://www.w3.org/1999/xhtml\\\">\\n<head>\\n  <meta http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=ISO-8859-\"; var s2=\"1\\\" />\\n  <title>Insert</title>\\n</head>\\n<body>n<p><strong>DWR tests passed</strong></p>\\n\\n</body>\\n</html>\\n\";");
        HtmlIdentifierTest.assertEquals((String)"improper injection", (boolean)false, (boolean)result);
    }

    public void testGoogleScenario() {
        boolean result = HtmlIdentifier.shouldBeInjected((String)"http://www.google.com/webhp", (String)"text/html; charset=UTF-8", (String)"<html>...</html>");
        HtmlIdentifierTest.assertEquals((String)"improper injection", (boolean)true, (boolean)result);
    }

    public void testStupidDellDotComScenario() {
        boolean result = HtmlIdentifier.shouldBeInjected((String)"/menu.htm", (String)"text/html", (String)"var x = ''; someOtherJavaScript++; blahblahblah;");
        HtmlIdentifierTest.assertEquals((String)"improper injection", (boolean)false, (boolean)result);
    }
}

