/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.locators.Firefox2or3Locator;

public class FirefoxChromeLauncher
extends AbstractBrowserLauncher {
    public static final String CHROME_URL = "chrome://killff/content/kill.html";
    private static Log LOGGER = LogFactory.getLog(FirefoxChromeLauncher.class);
    private File customProfileDir = null;
    private String[] cmdarray;
    private boolean closed = false;
    private BrowserInstallation browserInstallation;
    private Process process = null;
    private AsyncExecute shell = new AsyncExecute();
    private static boolean changeMaxConnections = false;

    public FirefoxChromeLauncher(RemoteControlConfiguration configuration, String sessionId) {
        this(configuration, sessionId, (String)null);
    }

    public FirefoxChromeLauncher(RemoteControlConfiguration configuration, String sessionId, String browserString) throws InvalidBrowserExecutableException {
        this(configuration, sessionId, ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation("chrome", browserString, new Firefox2or3Locator()));
        if (this.browserInstallation == null) {
            throw new InvalidBrowserExecutableException("The specified path to the browser executable is invalid.");
        }
    }

    public FirefoxChromeLauncher(RemoteControlConfiguration configuration, String sessionId, BrowserInstallation browserInstallation) {
        super(sessionId, configuration);
        if (browserInstallation == null) {
            LOGGER.warn("The specified path to the browser executable is invalid.");
            return;
        }
        this.browserInstallation = browserInstallation;
        this.shell.setLibraryPath(browserInstallation.libraryPath());
        this.shell.setEnvironmentVariable("MOZ_NO_REMOTE", "1");
    }

    protected void launch(String url) {
        this.launch(url, null);
    }

    protected void launch(String url, BrowserConfigurationOptions config) {
        String profile = "";
        try {
            String homePage = new ChromeUrlConvert().convert(url);
            if (config != null) {
                profile = config.getProfile();
            }
            String profilePath = this.makeCustomProfile(homePage, profile);
            this.populateCustomProfileDirectory(profilePath);
            LOGGER.info("Launching Firefox...");
            this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), "-profile", profilePath};
            this.shell.setCommandline(this.cmdarray);
            this.process = this.shell.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void populateCustomProfileDirectory(String profilePath) throws IOException {
        this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), "-profile", profilePath, "-chrome", CHROME_URL};
        LOGGER.info("Preparing Firefox profile...");
        this.shell.setCommandline(this.cmdarray);
        this.shell.execute();
        this.waitForFullProfileToBeCreated(20000L);
    }

    private String makeCustomProfile(String homePage, String profile) throws IOException {
        this.customProfileDir = LauncherUtils.createCustomProfileDir(this.sessionId);
        String sourceLocationName = "/customProfileDirCUSTFFCHROME";
        File firefoxProfileTemplate = null;
        if (!"".equals(this.getConfiguration().getProfilesLocation()) && !"".equals(profile)) {
            File profileDirectory = this.getConfiguration().getProfilesLocation();
            firefoxProfileTemplate = new File(profileDirectory + "/" + profile);
            if (!firefoxProfileTemplate.exists()) {
                throw new RuntimeException("The profile specified '" + firefoxProfileTemplate.getAbsolutePath() + "' does not exist");
            }
        } else {
            firefoxProfileTemplate = this.getConfiguration().getFirefoxProfileTemplate();
        }
        if (firefoxProfileTemplate != null) {
            LauncherUtils.copyDirectory(firefoxProfileTemplate, this.customProfileDir);
        }
        ResourceExtractor.extractResourcePath(this.getClass(), sourceLocationName, this.customProfileDir);
        this.copyRunnerHtmlFiles();
        LauncherUtils.generatePacAndPrefJs(this.customProfileDir, this.getPort(), LauncherUtils.ProxySetting.NO_PROXY, homePage, changeMaxConnections, this.getConfiguration());
        return this.customProfileDir.getAbsolutePath();
    }

    private void copyRunnerHtmlFiles() {
        String guid = "{503A0CD4-EDC8-489b-853B-19E0BAA8F0A4}";
        File extensionDir = new File(this.customProfileDir, "extensions/" + guid);
        File htmlDir = new File(extensionDir, "chrome");
        htmlDir.mkdirs();
        LauncherUtils.extractHTAFile(htmlDir, this.getPort(), "/core/TestRunner.html", "TestRunner.html");
        LauncherUtils.extractHTAFile(htmlDir, this.getPort(), "/core/TestPrompt.html", "TestPrompt.html");
        LauncherUtils.extractHTAFile(htmlDir, this.getPort(), "/core/RemoteRunner.html", "RemoteRunner.html");
    }

    public void close() {
        if (this.closed) {
            return;
        }
        FileLockRemainedException fileLockException = null;
        if (this.process != null) {
            try {
                this.killFirefoxProcess();
            }
            catch (FileLockRemainedException flre) {
                fileLockException = flre;
            }
        }
        if (this.customProfileDir != null) {
            try {
                this.removeCustomProfileDir();
            }
            catch (RuntimeException e) {
                if (fileLockException != null) {
                    LOGGER.error("Couldn't delete custom Firefox profile directory", e);
                    LOGGER.error("Perhaps caused by this exception:");
                    if (fileLockException != null) {
                        LOGGER.error("Perhaps caused by this exception:", fileLockException);
                    }
                    throw new RuntimeException("Couldn't delete custom Firefox profile directory, presumably because task kill failed; see error LOGGER!", e);
                }
                throw e;
            }
        }
        this.closed = true;
    }

    protected void removeCustomProfileDir() throws RuntimeException {
        LauncherUtils.deleteTryTryAgain(this.customProfileDir, 6);
    }

    protected void killFirefoxProcess() throws FileLockRemainedException {
        LOGGER.info("Killing Firefox...");
        int exitValue = AsyncExecute.killProcess(this.process);
        if (exitValue == 0) {
            LOGGER.warn("Firefox seems to have ended on its own (did we kill the real browser???)");
        }
        this.waitForFileLockToGoAway(0L, 500L);
    }

    public Process getProcess() {
        return this.process;
    }

    private void waitForFileLockToGoAway(long timeout, long timeToWait) throws FileLockRemainedException {
        File lock = new File(this.customProfileDir, "parent.lock");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (lock.exists() || !this.makeSureFileLockRemainsGone(lock, timeToWait)) continue;
            return;
        }
        if (lock.exists()) {
            throw new FileLockRemainedException("Lock file still present! " + lock.getAbsolutePath());
        }
    }

    private boolean makeSureFileLockRemainsGone(File lock, long timeToWait) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            AsyncExecute.sleepTight(500L);
            if (!lock.exists()) continue;
            return false;
        }
        return !lock.exists();
    }

    private void waitForFullProfileToBeCreated(long timeout) {
        File testFile = new File(this.customProfileDir, "extensions.ini");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (!testFile.exists()) continue;
        }
        if (!testFile.exists()) {
            throw new RuntimeException("Timed out waiting for profile to be created!");
        }
        long subTimeout = timeout - (System.currentTimeMillis() - start);
        try {
            this.waitForFileLockToGoAway(subTimeout, 500L);
        }
        catch (FileLockRemainedException e) {
            throw new RuntimeException("Firefox refused shutdown while preparing a profile", e);
        }
    }

    protected void setCustomProfileDir(File value) {
        this.customProfileDir = value;
    }

    protected void setProcess(Process p) {
        this.process = p;
    }

    public static void setChangeMaxConnections(boolean changeMaxConnections) {
        FirefoxChromeLauncher.changeMaxConnections = changeMaxConnections;
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL, boolean multiWindow, String defaultLogLevel) {
        if (suiteUrl != null && suiteUrl.startsWith("TestPrompt.html?")) {
            suiteUrl = suiteUrl.replaceFirst("^TestPrompt\\.html\\?", "chrome://src/content/TestPrompt.html?");
        }
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl(browserURL, suiteUrl, multiWindow, this.getPort(), defaultLogLevel), null);
    }

    public void launchRemoteSession(String browserURL, boolean multiWindow, BrowserConfigurationOptions config) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(browserURL, this.sessionId, multiWindow, this.getPort()), config);
    }

    public static class ChromeUrlConvert {
        public String convert(String httpUrl) throws MalformedURLException {
            String query = LauncherUtils.getQueryString(httpUrl);
            String file = new File(new URL(httpUrl).getPath()).getName();
            return "chrome://src/content/" + file + "?" + query;
        }
    }

    protected class FileLockRemainedException
    extends Exception {
        FileLockRemainedException(String message) {
            super(message);
        }
    }
}

