/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Environment;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WindowsUtils {
    static Log log = LogFactory.getLog(WindowsUtils.class);
    private static final boolean THIS_IS_WINDOWS = File.pathSeparator.equals(";");
    private static String wmic = null;
    private static File wbem = null;
    private static String taskkill = null;
    private static String reg = null;
    private static Boolean regVersion1 = null;
    private static Properties env = null;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Kills Windows processes by matching their command lines");
            System.out.println("usage: " + WindowsUtils.class.getName() + " command arg1 arg2 ...");
        }
        WindowsUtils.kill(args);
    }

    public static void kill(String[] cmdarray) throws Exception {
        StringBuffer pattern = new StringBuffer();
        File executable = new File(cmdarray[0]);
        pattern.append("\"?.*?\\\\");
        pattern.append(executable.getName());
        pattern.append("\"?");
        for (int i = 1; i < cmdarray.length; ++i) {
            pattern.append("\\s?\"?\\Q");
            String arg = cmdarray[i];
            pattern.append(arg);
            pattern.append("\\E\"?");
        }
        pattern.append("\\s*");
        Pattern cmd = Pattern.compile(pattern.toString(), 2);
        Map procMap = WindowsUtils.procMap();
        boolean killedOne = false;
        for (String commandLine : procMap.keySet()) {
            Matcher m;
            if (commandLine == null || !(m = cmd.matcher(commandLine)).matches()) continue;
            String processID = (String)procMap.get(commandLine);
            StringBuffer logMessage = new StringBuffer("Killing PID ");
            logMessage.append(processID);
            logMessage.append(": ");
            logMessage.append(commandLine);
            log.info((Object)logMessage);
            WindowsUtils.killPID(processID);
            log.info((Object)"Killed");
            killedOne = true;
        }
        if (!killedOne) {
            StringBuffer errorMessage = new StringBuffer("Didn't find any matches for");
            for (int i = 0; i < cmdarray.length; ++i) {
                errorMessage.append(" '");
                errorMessage.append(cmdarray[i]);
                errorMessage.append('\'');
            }
            log.warn((Object)errorMessage);
        }
    }

    private static void killPID(String processID) {
        Project p = new Project();
        ExecTask exec = new ExecTask();
        exec.setProject(p);
        exec.setExecutable("taskkill");
        Environment.Variable path = new Environment.Variable();
        path.setKey(WindowsUtils.getExactPathEnvKey());
        path.setFile(WindowsUtils.findWBEM());
        exec.addEnv(path);
        exec.setTaskType("taskkill");
        exec.setFailonerror(false);
        exec.createArg().setValue("/pid");
        exec.createArg().setValue(processID);
        exec.setResultProperty("result");
        exec.setOutputproperty("output");
        exec.execute();
        String result = p.getProperty("result");
        String output = p.getProperty("output");
        log.info((Object)output);
        if (!"0".equals(result)) {
            throw new WindowsRegistryException("exec return code " + result + ": " + output);
        }
    }

    public static Map procMap() throws Exception {
        Project p = new Project();
        ExecTask exec = new ExecTask();
        exec.setProject(p);
        exec.setTaskType("wmic");
        exec.setExecutable(WindowsUtils.findWMIC());
        exec.setFailonerror(true);
        exec.createArg().setValue("process");
        exec.createArg().setValue("list");
        exec.createArg().setValue("full");
        exec.createArg().setValue("/format:rawxml.xsl");
        exec.setOutputproperty("proclist");
        log.info((Object)"Reading Windows Process List...");
        exec.execute();
        log.info((Object)"Done, searching for processes to kill...");
        File TempWmicBatchFile = new File("TempWmicBatchFile.bat");
        if (TempWmicBatchFile.exists()) {
            TempWmicBatchFile.delete();
        }
        String output = p.getProperty("proclist");
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(output.getBytes()));
        NodeList procList = doc.getElementsByTagName("INSTANCE");
        HashMap<String, String> processes = new HashMap<String, String>();
        for (int i = 0; i < procList.getLength(); ++i) {
            Element process = (Element)procList.item(i);
            NodeList propList = process.getElementsByTagName("PROPERTY");
            HashMap<String, String> procProps = new HashMap<String, String>();
            for (int j = 0; j < propList.getLength(); ++j) {
                Element property = (Element)propList.item(j);
                String propName = property.getAttribute("NAME");
                NodeList valList = property.getElementsByTagName("VALUE");
                String value = null;
                if (valList.getLength() != 0) {
                    Element valueElement = (Element)valList.item(0);
                    Text valueNode = (Text)valueElement.getFirstChild();
                    value = valueNode.getData();
                }
                procProps.put(propName, value);
            }
            String processID = (String)procProps.get("ProcessId");
            String commandLine = (String)procProps.get("CommandLine");
            processes.put(commandLine, processID);
        }
        return processes;
    }

    public static synchronized Properties loadEnvironment() {
        if (env != null) {
            return env;
        }
        env = new Properties();
        Vector osEnv = Execute.getProcEnvironment();
        Enumeration e = osEnv.elements();
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            int pos = entry.indexOf(61);
            if (pos == -1) {
                log.warn((Object)("Ignoring: " + entry));
                continue;
            }
            env.put(entry.substring(0, pos), entry.substring(pos + 1));
        }
        return env;
    }

    public static String getExactPathEnvKey() {
        WindowsUtils.loadEnvironment();
        for (String string : env.keySet()) {
            if (!string.equalsIgnoreCase("PATH")) continue;
            return string;
        }
        return "PATH";
    }

    public static String getPath() {
        WindowsUtils.loadEnvironment();
        return WindowsUtils.getEnvVarIgnoreCase("PATH");
    }

    public static String getProgramFilesPath() {
        File ProgramFiles;
        WindowsUtils.loadEnvironment();
        String pf = WindowsUtils.getEnvVarIgnoreCase("ProgramFiles");
        if (pf != null && (ProgramFiles = new File(pf)).exists()) {
            return ProgramFiles.getAbsolutePath();
        }
        return new File("C:\\Program Files").getAbsolutePath();
    }

    public static String getLocalAppDataPath() {
        WindowsUtils.loadEnvironment();
        String keyLocalAppData = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\\Local AppData";
        String localAppDataPath = WindowsUtils.readStringRegistryValue("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\\Local AppData");
        String userProfile = WindowsUtils.getEnvVarIgnoreCase("USERPROFILE");
        if (userProfile != null) {
            return localAppDataPath.replace("%USERPROFILE%", userProfile);
        }
        return localAppDataPath;
    }

    public static String getEnvVarIgnoreCase(String var) {
        WindowsUtils.loadEnvironment();
        for (String string : env.keySet()) {
            if (!string.equalsIgnoreCase(var)) continue;
            return env.getProperty(string);
        }
        return null;
    }

    public static File findSystemRoot() {
        Properties p = WindowsUtils.loadEnvironment();
        String systemRootPath = (String)p.get("SystemRoot");
        if (systemRootPath == null) {
            systemRootPath = (String)p.get("SYSTEMROOT");
        }
        if (systemRootPath == null) {
            systemRootPath = (String)p.get("systemroot");
        }
        if (systemRootPath == null) {
            throw new RuntimeException("SystemRoot apparently not set!");
        }
        File systemRoot = new File(systemRootPath);
        if (!systemRoot.exists()) {
            throw new RuntimeException("SystemRoot doesn't exist: " + systemRootPath);
        }
        return systemRoot;
    }

    public static String findWMIC() {
        File wmicExe;
        if (wmic != null) {
            return wmic;
        }
        WindowsUtils.findWBEM();
        if (null != wbem && (wmicExe = new File(WindowsUtils.findWBEM(), "wmic.exe")).exists()) {
            wmic = wmicExe.getAbsolutePath();
            return wmic;
        }
        log.warn((Object)"Couldn't find wmic! Hope it's on the path...");
        wmic = "wmic";
        return wmic;
    }

    public static File findWBEM() {
        if (wbem != null) {
            return wbem;
        }
        File systemRoot = WindowsUtils.findSystemRoot();
        wbem = new File(systemRoot, "system32/wbem");
        if (!wbem.exists()) {
            log.error((Object)"Couldn't find wbem!");
            return null;
        }
        return wbem;
    }

    public static String findTaskKill() {
        if (taskkill != null) {
            return taskkill;
        }
        File systemRoot = WindowsUtils.findSystemRoot();
        File taskkillExe = new File(systemRoot, "system32/taskkill.exe");
        if (taskkillExe.exists()) {
            taskkill = taskkillExe.getAbsolutePath();
            return taskkill;
        }
        log.warn((Object)"Couldn't find taskkill! Hope it's on the path...");
        taskkill = "taskkill";
        return taskkill;
    }

    public static String findReg() {
        if (reg != null) {
            return reg;
        }
        File systemRoot = WindowsUtils.findSystemRoot();
        File regExe = new File(systemRoot, "system32/reg.exe");
        if (regExe.exists()) {
            reg = regExe.getAbsolutePath();
            return reg;
        }
        regExe = new File("c:\\ntreskit\\reg.exe");
        if (regExe.exists()) {
            reg = regExe.getAbsolutePath();
            return reg;
        }
        regExe = AsyncExecute.whichExec("reg.exe");
        if (regExe != null && regExe.exists()) {
            reg = regExe.getAbsolutePath();
            return reg;
        }
        log.error((Object)("OS Version: " + System.getProperty("os.version")));
        throw new WindowsRegistryException("Couldn't find reg.exe!\nPlease download it from Microsoft and install it in a standard location.\nSee here for details: http://wiki.openqa.org/display/SRC/Windows+Registry+Support");
    }

    public static boolean isRegExeVersion1() {
        if (regVersion1 != null) {
            return regVersion1;
        }
        Project p = new Project();
        ExecTask exec = new ExecTask();
        exec.setProject(p);
        exec.setTaskType("reg");
        exec.setExecutable(WindowsUtils.findReg());
        exec.setFailonerror(false);
        exec.createArg().setValue("/?");
        exec.setOutputproperty("regout");
        exec.setResultProperty("result");
        exec.execute();
        String output = p.getProperty("regout");
        boolean version1 = output.indexOf("version 1.0") != -1;
        regVersion1 = new Boolean(version1);
        return version1;
    }

    public static Class discoverRegistryKeyType(String key) {
        if (!WindowsUtils.doesRegistryValueExist(key)) {
            return null;
        }
        RegKeyValue r = new RegKeyValue(key);
        String output = WindowsUtils.runRegQuery(key);
        Pattern pat = WindowsUtils.isRegExeVersion1() ? Pattern.compile("\\s*(REG_\\S+)") : Pattern.compile("\\Q" + r.value + "\\E\\s+(REG_\\S+)\\s+(.*)");
        Matcher m = pat.matcher(output);
        if (!m.find()) {
            throw new WindowsRegistryException("Output didn't look right: " + output);
        }
        String type = m.group(1);
        if ("REG_SZ".equals(type) || "REG_EXPAND_SZ".equals(type)) {
            return String.class;
        }
        if ("REG_DWORD".equals(type)) {
            return Integer.TYPE;
        }
        throw new WindowsRegistryException("Unknown type: " + type);
    }

    public static String readStringRegistryValue(String key) {
        RegKeyValue r = new RegKeyValue(key);
        String output = WindowsUtils.runRegQuery(key);
        Pattern pat = WindowsUtils.isRegExeVersion1() ? Pattern.compile("\\s*(REG_\\S+)\\s+\\Q" + r.value + "\\E\\s+(.*)") : Pattern.compile("\\Q" + r.value + "\\E\\s+(REG_\\S+)\\s+(.*)");
        Matcher m = pat.matcher(output);
        if (!m.find()) {
            throw new WindowsRegistryException("Output didn't look right: " + output);
        }
        String type = m.group(1);
        if (!"REG_SZ".equals(type) && !"REG_EXPAND_SZ".equals(type)) {
            throw new WindowsRegistryException(r.value + " was not a REG_SZ or a REG_EXPAND_SZ (String): " + type);
        }
        String value = m.group(2);
        return value;
    }

    public static int readIntRegistryValue(String key) {
        RegKeyValue r = new RegKeyValue(key);
        String output = WindowsUtils.runRegQuery(key);
        Pattern pat = WindowsUtils.isRegExeVersion1() ? Pattern.compile("\\s*(REG_\\S+)\\s+\\Q" + r.value + "\\E\\s+(.*)") : Pattern.compile("\\Q" + r.value + "\\E\\s+(REG_\\S+)\\s+0x(.*)");
        Matcher m = pat.matcher(output);
        if (!m.find()) {
            throw new WindowsRegistryException("Output didn't look right: " + output);
        }
        String type = m.group(1);
        if (!"REG_DWORD".equals(type)) {
            throw new WindowsRegistryException(r.value + " was not a REG_DWORD (int): " + type);
        }
        String strValue = m.group(2);
        int value = WindowsUtils.isRegExeVersion1() ? Integer.parseInt(strValue) : Integer.parseInt(strValue, 16);
        return value;
    }

    public static boolean readBooleanRegistryValue(String key) {
        RegKeyValue r = new RegKeyValue(key);
        int value = WindowsUtils.readIntRegistryValue(key);
        if (0 == value) {
            return false;
        }
        if (1 == value) {
            return true;
        }
        throw new WindowsRegistryException(r.value + " was not either 0 or 1: " + value);
    }

    public static boolean doesRegistryValueExist(String key) {
        Project p = new Project();
        ExecTask exec = new ExecTask();
        exec.setProject(p);
        exec.setTaskType("reg");
        exec.setExecutable(WindowsUtils.findReg());
        exec.setFailonerror(false);
        exec.createArg().setValue("query");
        if (WindowsUtils.isRegExeVersion1()) {
            exec.createArg().setValue(key);
        } else {
            RegKeyValue r = new RegKeyValue(key);
            exec.createArg().setValue(r.key);
            exec.createArg().setValue("/v");
            exec.createArg().setValue(r.value);
        }
        exec.setOutputproperty("regout");
        exec.setResultProperty("result");
        exec.execute();
        int result = Integer.parseInt(p.getProperty("result"));
        return 0 == result;
    }

    public static void writeStringRegistryValue(String key, String data) throws WindowsRegistryException {
        Project p = new Project();
        ExecTask exec = new ExecTask();
        exec.setProject(p);
        exec.setTaskType("reg");
        exec.setExecutable(WindowsUtils.findReg());
        exec.setFailonerror(false);
        exec.setResultProperty("result");
        exec.setOutputproperty("output");
        if (WindowsUtils.isRegExeVersion1()) {
            if (WindowsUtils.doesRegistryValueExist(key)) {
                exec.createArg().setValue("update");
            } else {
                exec.createArg().setValue("add");
            }
            exec.createArg().setValue(key + "=" + data);
        } else {
            exec.createArg().setValue("add");
            RegKeyValue r = new RegKeyValue(key);
            exec.createArg().setValue(r.key);
            exec.createArg().setValue("/v");
            exec.createArg().setValue(r.value);
            exec.createArg().setValue("/d");
            exec.createArg().setValue(data);
            exec.createArg().setValue("/f");
        }
        exec.execute();
        String result = p.getProperty("result");
        String output = p.getProperty("output");
        if (!"0".equals(result)) {
            throw new WindowsRegistryException("exec return code " + result + ": " + output);
        }
    }

    public static void writeIntRegistryValue(String key, int data) {
        Project p = new Project();
        ExecTask exec = new ExecTask();
        exec.setProject(p);
        exec.setTaskType("reg");
        exec.setExecutable(WindowsUtils.findReg());
        exec.setFailonerror(false);
        exec.setResultProperty("result");
        exec.setOutputproperty("output");
        if (WindowsUtils.isRegExeVersion1()) {
            if (WindowsUtils.doesRegistryValueExist(key)) {
                exec.createArg().setValue("update");
                exec.createArg().setValue(key + "=" + Integer.toString(data));
            } else {
                exec.createArg().setValue("add");
                exec.createArg().setValue(key + "=" + Integer.toString(data));
                exec.createArg().setValue("REG_DWORD");
            }
        } else {
            exec.createArg().setValue("add");
            RegKeyValue r = new RegKeyValue(key);
            exec.createArg().setValue(r.key);
            exec.createArg().setValue("/v");
            exec.createArg().setValue(r.value);
            exec.createArg().setValue("/t");
            exec.createArg().setValue("REG_DWORD");
            exec.createArg().setValue("/d");
            exec.createArg().setValue(Integer.toString(data));
            exec.createArg().setValue("/f");
        }
        exec.execute();
        String result = p.getProperty("result");
        String output = p.getProperty("output");
        if (!"0".equals(result)) {
            throw new WindowsRegistryException("exec return code " + result + ": " + output);
        }
    }

    public static void writeBooleanRegistryValue(String key, boolean data) {
        WindowsUtils.writeIntRegistryValue(key, data ? 1 : 0);
    }

    public static void deleteRegistryValue(String key) {
        Project p = new Project();
        ExecTask exec = new ExecTask();
        exec.setProject(p);
        exec.setTaskType("reg");
        exec.setExecutable(WindowsUtils.findReg());
        exec.setFailonerror(false);
        exec.setResultProperty("result");
        exec.setOutputproperty("output");
        if (WindowsUtils.isRegExeVersion1()) {
            exec.createArg().setValue("delete");
            exec.createArg().setValue(key);
            exec.createArg().setValue("/FORCE");
        } else {
            RegKeyValue r = new RegKeyValue(key);
            exec.createArg().setValue("delete");
            exec.createArg().setValue(r.key);
            exec.createArg().setValue("/v");
            exec.createArg().setValue(r.value);
            exec.createArg().setValue("/f");
        }
        exec.execute();
        String result = p.getProperty("result");
        String output = p.getProperty("output");
        if (!"0".equals(result)) {
            throw new WindowsRegistryException("exec return code " + result + ": " + output);
        }
    }

    private static String runRegQuery(String key) {
        Project p = new Project();
        ExecTask exec = new ExecTask();
        exec.setProject(p);
        exec.setTaskType("reg");
        exec.setExecutable(WindowsUtils.findReg());
        exec.setFailonerror(false);
        exec.setResultProperty("result");
        exec.setOutputproperty("output");
        exec.createArg().setValue("query");
        if (WindowsUtils.isRegExeVersion1()) {
            exec.createArg().setValue(key);
        } else {
            RegKeyValue r = new RegKeyValue(key);
            exec.createArg().setValue(r.key);
            exec.createArg().setValue("/v");
            exec.createArg().setValue(r.value);
        }
        exec.setOutputproperty("regout");
        exec.execute();
        String output = p.getProperty("regout");
        return output;
    }

    public static boolean thisIsWindows() {
        return THIS_IS_WINDOWS;
    }

    static class WindowsRegistryException
    extends RuntimeException {
        WindowsRegistryException(Exception e) {
            super(WindowsRegistryException.generateMessage(), e);
        }

        private static String generateMessage() {
            return "Problem while managing the registry, OS Version '" + System.getProperty("os.version") + "', regVersion1 = " + regVersion1;
        }

        WindowsRegistryException(String message) {
            this(new RuntimeException(message));
        }
    }

    private static class RegKeyValue {
        private String key;
        private String value;

        public RegKeyValue(String path) {
            int i = path.lastIndexOf(92);
            this.key = path.substring(0, i);
            this.value = path.substring(i + 1);
        }
    }
}

