# Generated by Django 3.0.4 on 2020-05-01 00:18

import _socket
from django.conf import settings
import django.contrib.sites.managers
from django.db import migrations, models
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_model.models.fields.date_estimated
import edc_model.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("sites", "0002_alter_domain_unique"),
        ("mapitio_subject", "0008_auto_20200501_0052"),
    ]

    operations = [
        migrations.RemoveField(model_name="followup", name="death_cause",),
        migrations.RemoveField(model_name="followup", name="death_date",),
        migrations.RemoveField(model_name="followup", name="death_date_estimated",),
        migrations.RemoveField(model_name="followup", name="last_seen_date",),
        migrations.RemoveField(model_name="historicalfollowup", name="death_cause",),
        migrations.RemoveField(model_name="historicalfollowup", name="death_date",),
        migrations.RemoveField(
            model_name="historicalfollowup", name="death_date_estimated",
        ),
        migrations.RemoveField(model_name="historicalfollowup", name="last_seen_date",),
        migrations.AddField(
            model_name="followup",
            name="survival_status",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="Yes",
                max_length=25,
                verbose_name="Is the patient known to be alive?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalfollowup",
            name="survival_status",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="Yes",
                max_length=25,
                verbose_name="Is the patient known to be alive?",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="complications",
            name="cardiomyopathy_dx_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of ischaemic cardiomyopathy",
            ),
        ),
        migrations.AlterField(
            model_name="complications",
            name="chronic_renal_failure_dx_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of chronic renal failure",
            ),
        ),
        migrations.AlterField(
            model_name="complications",
            name="complications_other",
            field=models.TextField(
                blank=True, help_text="Please include dates", null=True
            ),
        ),
        migrations.AlterField(
            model_name="complications",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="complications",
            name="diabetic_foot_dx_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of diabetic foot diagnosis",
            ),
        ),
        migrations.AlterField(
            model_name="complications",
            name="diabetic_retinopathy_dx_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of diabetic retinopathy diagnosis",
            ),
        ),
        migrations.AlterField(
            model_name="complications",
            name="peripheral_neuropathy_dx_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of peripheral neuropathy diagnosis",
            ),
        ),
        migrations.AlterField(
            model_name="complications",
            name="peripheral_vascular_dx_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of peripheral vascular disease diagnosis",
            ),
        ),
        migrations.AlterField(
            model_name="complications",
            name="stroke_dx_date",
            field=models.DateField(
                blank=True,
                help_text="If patient has a history of more than one stroke, report the date of the first stroke.",
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of stroke diagnosis",
            ),
        ),
        migrations.AlterField(
            model_name="followup",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="followup",
            name="has_next_appointment",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                null=True,
                verbose_name="Has the patient been scheduled for their next apointment?",
            ),
        ),
        migrations.AlterField(
            model_name="followup",
            name="in_care",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=25,
                verbose_name="Is the patient still receiving HIV care in this clinic?",
            ),
        ),
        migrations.AlterField(
            model_name="followup",
            name="reason_not_in_care",
            field=models.CharField(
                blank=True,
                choices=[
                    ("transferred", "Transferred"),
                    ("LTFU", "Lost to followup"),
                    ("OTHER", "Other, please specify..."),
                ],
                max_length=25,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcomplications",
            name="cardiomyopathy_dx_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of ischaemic cardiomyopathy",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcomplications",
            name="chronic_renal_failure_dx_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of chronic renal failure",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcomplications",
            name="complications_other",
            field=models.TextField(
                blank=True, help_text="Please include dates", null=True
            ),
        ),
        migrations.AlterField(
            model_name="historicalcomplications",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcomplications",
            name="diabetic_foot_dx_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of diabetic foot diagnosis",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcomplications",
            name="diabetic_retinopathy_dx_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of diabetic retinopathy diagnosis",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcomplications",
            name="peripheral_neuropathy_dx_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of peripheral neuropathy diagnosis",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcomplications",
            name="peripheral_vascular_dx_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of peripheral vascular disease diagnosis",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcomplications",
            name="stroke_dx_date",
            field=models.DateField(
                blank=True,
                help_text="If patient has a history of more than one stroke, report the date of the first stroke.",
                null=True,
                validators=[
                    edc_model.validators.date.date_is_past,
                    edc_model.validators.date.date_is_not_now,
                ],
                verbose_name="If YES, date of stroke diagnosis",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfollowup",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfollowup",
            name="has_next_appointment",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                null=True,
                verbose_name="Has the patient been scheduled for their next apointment?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfollowup",
            name="in_care",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=25,
                verbose_name="Is the patient still receiving HIV care in this clinic?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfollowup",
            name="reason_not_in_care",
            field=models.CharField(
                blank=True,
                choices=[
                    ("transferred", "Transferred"),
                    ("LTFU", "Lost to followup"),
                    ("OTHER", "Other, please specify..."),
                ],
                max_length=25,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="historicalhivhistory",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalindicators",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalinvestigations",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalncdfollowup",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalncdhistory",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="hivhistory",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="indicators",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="investigations",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="ncdfollowup",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="ncdhistory",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                help_text="If some data is still pending, flag this CRF as incomplete",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.CreateModel(
            name="HistoricalDeathReport",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "death_date",
                    models.DateField(
                        verbose_name="If 'Died', provide the date of death"
                    ),
                ),
                (
                    "death_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("-", "No"),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="Is the <u>date of death</u> estimated?",
                    ),
                ),
                (
                    "death_cause",
                    models.TextField(
                        verbose_name="The cause of death as recorded in the patient notes"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Death Report",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="DeathReport",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "death_date",
                    models.DateField(
                        verbose_name="If 'Died', provide the date of death"
                    ),
                ),
                (
                    "death_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("-", "No"),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="Is the <u>date of death</u> estimated?",
                    ),
                ),
                (
                    "death_cause",
                    models.TextField(
                        verbose_name="The cause of death as recorded in the patient notes"
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Death Report",
                "verbose_name_plural": "Death Reports",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.AddIndex(
            model_name="deathreport",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="mapitio_sub_subject_769b01_idx",
            ),
        ),
    ]
