# Generated by Django 3.0.4 on 2020-05-01 03:07

from django.db import migrations, models
import edc_model.models.fields.date_estimated
import edc_model.validators.date


class Migration(migrations.Migration):

    dependencies = [
        ("mapitio_subject", "0010_auto_20200501_0327"),
    ]

    operations = [
        migrations.AlterField(
            model_name="deathreport",
            name="death_date",
            field=models.DateField(verbose_name="Date of death"),
        ),
        migrations.AlterField(
            model_name="deathreport",
            name="death_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedField(
                choices=[
                    ("-", "No"),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is the date of death estimated?",
            ),
        ),
        migrations.AlterField(
            model_name="followup",
            name="in_care",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                null=True,
                verbose_name="Is the patient still receiving HIV care in this clinic?",
            ),
        ),
        migrations.AlterField(
            model_name="followup",
            name="next_appointment_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_is_future],
                verbose_name="Date of patient's next clinic appointment?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="death_date",
            field=models.DateField(verbose_name="Date of death"),
        ),
        migrations.AlterField(
            model_name="historicaldeathreport",
            name="death_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedField(
                choices=[
                    ("-", "No"),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is the date of death estimated?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfollowup",
            name="in_care",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                null=True,
                verbose_name="Is the patient still receiving HIV care in this clinic?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfollowup",
            name="next_appointment_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_is_future],
                verbose_name="Date of patient's next clinic appointment?",
            ),
        ),
    ]
