# Generated by Django 3.0.4 on 2020-04-30 17:49

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("mapitio_subject", "0005_auto_20200430_1638"),
    ]

    operations = [
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="albumin",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=6,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>Serum Albumin</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="albumin_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum Albumin date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="albumin_units",
            field=models.CharField(
                blank=True,
                choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                default="g/L",
                max_length=15,
                null=True,
                verbose_name="<i>Serum Albumin units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="alp",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>ALP</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="alp_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>ALP date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="alt",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>ALT</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="alt_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>ALT date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="amylase",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>Serum Amylase</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="amylase_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum Amylase date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="ast",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>AST</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="ast_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>AST date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="cd4",
            field=models.IntegerField(
                blank=True,
                help_text="cells/mm<sup>3</sup>",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(3000),
                ],
                verbose_name="<u>CD4 count</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="cd4_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>CD4 date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="egfr",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="mL/min/1.73 m2 (system calculated)",
                max_digits=8,
                null=True,
                verbose_name="<u>eGFR</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="ggt",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>GGT</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="ggt_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>GGT date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="hbsag",
            field=models.CharField(
                blank=True,
                choices=[
                    ("POS", "Positive"),
                    ("NEG", "Negative"),
                    ("not_done", "Not done"),
                ],
                max_length=15,
                null=True,
                verbose_name="<u>HbSAg</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="hbsag_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>HbSAg date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="hcv",
            field=models.CharField(
                blank=True,
                choices=[
                    ("POS", "Positive"),
                    ("NEG", "Negative"),
                    ("not_done", "Not done"),
                ],
                max_length=15,
                null=True,
                verbose_name="<u>HCV</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="hcv_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>HCV date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="hdl",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>HDL</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="hdl_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>HDL date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="ldl",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>LDL</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="ldl_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>LDL date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="serum_creatinine",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                verbose_name="<u>Serum creatinine</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="serum_creatinine_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum creatinine date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="serum_creatinine_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                max_length=15,
                null=True,
                verbose_name="<i>Serum creatinine units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="serum_urea",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                verbose_name="<u>Serum urea</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="serum_urea_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum urea date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="serum_urea_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                max_length=15,
                null=True,
                verbose_name="<i>Serum urea units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="serum_uric_acid",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                verbose_name="<u>Serum uric acid</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="serum_uric_acid_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum uric acid date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="serum_uric_acid_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                default="mg/dL",
                max_length=15,
                null=True,
                verbose_name="<i>Serum uric acid units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="total_cholesterol",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>Total cholesterol</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="total_cholesterol_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Total cholesterol date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="triglycerides",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>Triglycerides</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="triglycerides_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Triglycerides date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="vl",
            field=models.IntegerField(
                blank=True,
                help_text="copies/mL",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="<u>Viral load</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalfollowup",
            name="vl_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Viral load date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="albumin",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=6,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>Serum Albumin</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="albumin_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum Albumin date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="albumin_units",
            field=models.CharField(
                blank=True,
                choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                default="g/L",
                max_length=15,
                null=True,
                verbose_name="<i>Serum Albumin units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="alp",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>ALP</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="alp_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>ALP date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="alt",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>ALT</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="alt_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>ALT date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="amylase",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>Serum Amylase</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="amylase_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum Amylase date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="ast",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>AST</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="ast_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>AST date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="cd4",
            field=models.IntegerField(
                blank=True,
                help_text="cells/mm<sup>3</sup>",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(3000),
                ],
                verbose_name="<u>CD4 count</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="cd4_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>CD4 date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="egfr",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="mL/min/1.73 m2 (system calculated)",
                max_digits=8,
                null=True,
                verbose_name="<u>eGFR</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="ggt",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>GGT</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="ggt_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>GGT date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="hbsag",
            field=models.CharField(
                blank=True,
                choices=[
                    ("POS", "Positive"),
                    ("NEG", "Negative"),
                    ("not_done", "Not done"),
                ],
                max_length=15,
                null=True,
                verbose_name="<u>HbSAg</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="hbsag_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>HbSAg date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="hcv",
            field=models.CharField(
                blank=True,
                choices=[
                    ("POS", "Positive"),
                    ("NEG", "Negative"),
                    ("not_done", "Not done"),
                ],
                max_length=15,
                null=True,
                verbose_name="<u>HCV</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="hcv_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>HCV date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="hdl",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>HDL</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="hdl_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>HDL date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="ldl",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>LDL</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="ldl_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>LDL date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="serum_creatinine",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                verbose_name="<u>Serum creatinine</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="serum_creatinine_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum creatinine date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="serum_creatinine_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                max_length=15,
                null=True,
                verbose_name="<i>Serum creatinine units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="serum_urea",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                verbose_name="<u>Serum urea</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="serum_urea_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum urea date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="serum_urea_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                max_length=15,
                null=True,
                verbose_name="<i>Serum urea units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="serum_uric_acid",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                verbose_name="<u>Serum uric acid</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="serum_uric_acid_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum uric acid date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="serum_uric_acid_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                default="mg/dL",
                max_length=15,
                null=True,
                verbose_name="<i>Serum uric acid units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="total_cholesterol",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>Total cholesterol</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="total_cholesterol_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Total cholesterol date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="triglycerides",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>Triglycerides</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="triglycerides_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Triglycerides date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="vl",
            field=models.IntegerField(
                blank=True,
                help_text="copies/mL",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="<u>Viral load</u>",
            ),
        ),
        migrations.AlterField(
            model_name="biomedicalhistory",
            name="vl_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Viral load date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="complications",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="followup",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="albumin",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=6,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>Serum Albumin</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="albumin_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum Albumin date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="albumin_units",
            field=models.CharField(
                blank=True,
                choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                default="g/L",
                max_length=15,
                null=True,
                verbose_name="<i>Serum Albumin units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="alp",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>ALP</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="alp_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>ALP date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="alt",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>ALT</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="alt_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>ALT date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="amylase",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>Serum Amylase</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="amylase_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum Amylase date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="ast",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>AST</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="ast_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>AST date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="cd4",
            field=models.IntegerField(
                blank=True,
                help_text="cells/mm<sup>3</sup>",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(3000),
                ],
                verbose_name="<u>CD4 count</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="cd4_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>CD4 date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="egfr",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="mL/min/1.73 m2 (system calculated)",
                max_digits=8,
                null=True,
                verbose_name="<u>eGFR</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="ggt",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>GGT</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="ggt_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>GGT date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="hbsag",
            field=models.CharField(
                blank=True,
                choices=[
                    ("POS", "Positive"),
                    ("NEG", "Negative"),
                    ("not_done", "Not done"),
                ],
                max_length=15,
                null=True,
                verbose_name="<u>HbSAg</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="hbsag_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>HbSAg date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="hcv",
            field=models.CharField(
                blank=True,
                choices=[
                    ("POS", "Positive"),
                    ("NEG", "Negative"),
                    ("not_done", "Not done"),
                ],
                max_length=15,
                null=True,
                verbose_name="<u>HCV</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="hcv_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>HCV date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="hdl",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>HDL</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="hdl_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>HDL date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="ldl",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>LDL</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="ldl_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>LDL date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="serum_creatinine",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                verbose_name="<u>Serum creatinine</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="serum_creatinine_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum creatinine date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="serum_creatinine_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                max_length=15,
                null=True,
                verbose_name="<i>Serum creatinine units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="serum_urea",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                verbose_name="<u>Serum urea</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="serum_urea_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum urea date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="serum_urea_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                max_length=15,
                null=True,
                verbose_name="<i>Serum urea units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="serum_uric_acid",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                verbose_name="<u>Serum uric acid</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="serum_uric_acid_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum uric acid date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="serum_uric_acid_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                default="mg/dL",
                max_length=15,
                null=True,
                verbose_name="<i>Serum uric acid units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="total_cholesterol",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>Total cholesterol</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="total_cholesterol_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Total cholesterol date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="triglycerides",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>Triglycerides</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="triglycerides_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Triglycerides date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="vl",
            field=models.IntegerField(
                blank=True,
                help_text="copies/mL",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="<u>Viral load</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalfollowup",
            name="vl_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Viral load date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="albumin",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=6,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>Serum Albumin</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="albumin_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum Albumin date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="albumin_units",
            field=models.CharField(
                blank=True,
                choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                default="g/L",
                max_length=15,
                null=True,
                verbose_name="<i>Serum Albumin units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="alp",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>ALP</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="alp_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>ALP date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="alt",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>ALT</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="alt_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>ALT date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="amylase",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>Serum Amylase</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="amylase_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum Amylase date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="ast",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>AST</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="ast_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>AST date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="cd4",
            field=models.IntegerField(
                blank=True,
                help_text="cells/mm<sup>3</sup>",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(3000),
                ],
                verbose_name="<u>CD4 count</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="cd4_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>CD4 date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="egfr",
            field=models.DecimalField(
                blank=True,
                decimal_places=4,
                help_text="mL/min/1.73 m2 (system calculated)",
                max_digits=8,
                null=True,
                verbose_name="<u>eGFR</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="ggt",
            field=models.IntegerField(
                blank=True,
                help_text="U/L",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(999),
                ],
                verbose_name="<u>GGT</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="ggt_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>GGT date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="hbsag",
            field=models.CharField(
                blank=True,
                choices=[
                    ("POS", "Positive"),
                    ("NEG", "Negative"),
                    ("not_done", "Not done"),
                ],
                max_length=15,
                null=True,
                verbose_name="<u>HbSAg</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="hbsag_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>HbSAg date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="hcv",
            field=models.CharField(
                blank=True,
                choices=[
                    ("POS", "Positive"),
                    ("NEG", "Negative"),
                    ("not_done", "Not done"),
                ],
                max_length=15,
                null=True,
                verbose_name="<u>HCV</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="hcv_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>HCV date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="hdl",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>HDL</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="hdl_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>HDL date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="ldl",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>LDL</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="ldl_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>LDL date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="serum_creatinine",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                verbose_name="<u>Serum creatinine</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="serum_creatinine_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum creatinine date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="serum_creatinine_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                max_length=15,
                null=True,
                verbose_name="<i>Serum creatinine units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="serum_urea",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                verbose_name="<u>Serum urea</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="serum_urea_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum urea date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="serum_urea_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                max_length=15,
                null=True,
                verbose_name="<i>Serum urea units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="serum_uric_acid",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                verbose_name="<u>Serum uric acid</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="serum_uric_acid_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Serum uric acid date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="serum_uric_acid_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                default="mg/dL",
                max_length=15,
                null=True,
                verbose_name="<i>Serum uric acid units</i>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="total_cholesterol",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>Total cholesterol</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="total_cholesterol_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Total cholesterol date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="triglycerides",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                help_text="mmol/L",
                max_digits=4,
                null=True,
                verbose_name="<u>Triglycerides</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="triglycerides_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Triglycerides date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="vl",
            field=models.IntegerField(
                blank=True,
                help_text="copies/mL",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="<u>Viral load</u>",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbiomedicalhistory",
            name="vl_date",
            field=models.DateField(
                blank=True, null=True, verbose_name="<i>Viral load date</i>"
            ),
        ),
        migrations.AlterField(
            model_name="historicalcomplications",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfollowup",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalhivhistory",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalindicators",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalinvestigations",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalncdfollowup",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="historicalncdhistory",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="hivhistory",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="indicators",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="investigations",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="ncdfollowup",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
        migrations.AlterField(
            model_name="ncdhistory",
            name="crf_status",
            field=models.CharField(
                choices=[
                    ("INCOMPLETE", "Incomplete (some data pending)"),
                    ("COMPLETE", "Complete"),
                ],
                default="INCOMPLETE",
                max_length=25,
                verbose_name="CRF status",
            ),
        ),
    ]
