# -*- coding: utf-8 -*-
"""
C# language-specific code review checklist.
"""

CHECKLIST = """
## C# 代码审查检查清单

### 命名和代码风格
- [ ] 是否遵循 .NET 命名规范 (PascalCase, camelCase)
- [ ] 命名空间是否符合公司或项目规范
- [ ] 类、方法、属性名称是否清晰表达其用途
- [ ] 是否保持一致的代码格式和缩进
- [ ] 是否遵循微软的 C# 编码约定

### 资源管理
- [ ] 是否正确使用 IDisposable 和 using 语句
- [ ] 是否合理处理非托管资源
- [ ] 是否避免内存泄漏
- [ ] 文件句柄、数据库连接等是否及时关闭
- [ ] 是否实现了正确的析构函数

### 异常处理
- [ ] 异常是否被适当捕获和处理
- [ ] 是否避免了空泛的 catch 块
- [ ] 是否使用适当的异常类型
- [ ] 是否重新抛出了保留堆栈信息的异常
- [ ] 是否记录了异常详情

### 并发和异步编程
- [ ] 是否正确使用 async/await
- [ ] 共享资源访问是否有同步保护
- [ ] 是否避免了潜在的死锁
- [ ] 是否正确使用 Task 和 Task<T>
- [ ] 是否使用了 ConfigureAwait(false) 避免上下文切换

### LINQ 和集合
- [ ] LINQ 查询是否高效
- [ ] 是否使用了合适的集合类型
- [ ] 是否考虑了大数据集的性能影响
- [ ] 是否避免了不必要的多次枚举

### 性能
- [ ] 是否避免了不必要的装箱/拆箱
- [ ] 是否正确使用值类型和引用类型
- [ ] 字符串操作是否高效
- [ ] 是否使用了适当的缓存策略
- [ ] 数据库查询和 I/O 操作是否优化

### 安全性
- [ ] 是否安全处理用户输入
- [ ] 是否防范 SQL 注入攻击
- [ ] 是否正确实施身份验证和授权
- [ ] 敏感数据是否加密存储
- [ ] 是否遵循最小权限原则

### 依赖注入和松耦合
- [ ] 是否恰当使用依赖注入
- [ ] 类之间的耦合度是否最小化
- [ ] 是否使用接口进行依赖抽象
- [ ] 服务生命周期是否设置合理
- [ ] 是否避免了服务定位器反模式

### 测试
- [ ] 是否有单元测试覆盖核心功能
- [ ] 是否使用了测试替身 (模拟、存根)
- [ ] 测试是否覆盖了异常路径
- [ ] 测试是否独立且可重复执行
- [ ] 测试代码是否简洁明了

### 代码文档
- [ ] 是否使用 XML 文档注释
- [ ] 公共 API 是否有文档说明
- [ ] 复杂逻辑是否有注释
- [ ] 注释是否与代码保持同步
"""
