import * as cdk from '.';
/**
 * Properties for defining a `AWS::CloudFormation::CustomResource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html
 * @external
 */
export interface CfnCustomResourceProps {
    /**
     * `AWS::CloudFormation::CustomResource.ServiceToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#cfn-customresource-servicetoken
     * @external
     */
    readonly serviceToken: string;
}
/**
 * A CloudFormation `AWS::CloudFormation::CustomResource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html
 * @external
 * @cloudformationResource AWS::CloudFormation::CustomResource
 */
export declare class CfnCustomResource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::CustomResource";
    /**
     * `AWS::CloudFormation::CustomResource.ServiceToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#cfn-customresource-servicetoken
     * @external
     */
    serviceToken: string;
    /**
     * Create a new `AWS::CloudFormation::CustomResource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCustomResourceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CloudFormation::Macro`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html
 * @external
 */
export interface CfnMacroProps {
    /**
     * `AWS::CloudFormation::Macro.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-functionname
     * @external
     */
    readonly functionName: string;
    /**
     * `AWS::CloudFormation::Macro.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::CloudFormation::Macro.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::CloudFormation::Macro.LogGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-loggroupname
     * @external
     */
    readonly logGroupName?: string;
    /**
     * `AWS::CloudFormation::Macro.LogRoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-logrolearn
     * @external
     */
    readonly logRoleArn?: string;
}
/**
 * A CloudFormation `AWS::CloudFormation::Macro`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html
 * @external
 * @cloudformationResource AWS::CloudFormation::Macro
 */
export declare class CfnMacro extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::Macro";
    /**
     * `AWS::CloudFormation::Macro.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-functionname
     * @external
     */
    functionName: string;
    /**
     * `AWS::CloudFormation::Macro.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-name
     * @external
     */
    name: string;
    /**
     * `AWS::CloudFormation::Macro.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::CloudFormation::Macro.LogGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-loggroupname
     * @external
     */
    logGroupName: string | undefined;
    /**
     * `AWS::CloudFormation::Macro.LogRoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-logrolearn
     * @external
     */
    logRoleArn: string | undefined;
    /**
     * Create a new `AWS::CloudFormation::Macro`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMacroProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CloudFormation::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html
 * @external
 */
export interface CfnStackProps {
    /**
     * `AWS::CloudFormation::Stack.TemplateURL`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-templateurl
     * @external
     */
    readonly templateUrl: string;
    /**
     * `AWS::CloudFormation::Stack.NotificationARNs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-notificationarns
     * @external
     */
    readonly notificationArns?: string[];
    /**
     * `AWS::CloudFormation::Stack.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-parameters
     * @external
     */
    readonly parameters?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::CloudFormation::Stack.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CloudFormation::Stack.TimeoutInMinutes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-timeoutinminutes
     * @external
     */
    readonly timeoutInMinutes?: number;
}
/**
 * A CloudFormation `AWS::CloudFormation::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html
 * @external
 * @cloudformationResource AWS::CloudFormation::Stack
 */
export declare class CfnStack extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::Stack";
    /**
     * `AWS::CloudFormation::Stack.TemplateURL`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-templateurl
     * @external
     */
    templateUrl: string;
    /**
     * `AWS::CloudFormation::Stack.NotificationARNs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-notificationarns
     * @external
     */
    notificationArns: string[] | undefined;
    /**
     * `AWS::CloudFormation::Stack.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-parameters
     * @external
     */
    parameters: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudFormation::Stack.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CloudFormation::Stack.TimeoutInMinutes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-timeoutinminutes
     * @external
     */
    timeoutInMinutes: number | undefined;
    /**
     * Create a new `AWS::CloudFormation::Stack`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStackProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CloudFormation::StackSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html
 * @external
 */
export interface CfnStackSetProps {
    /**
     * `AWS::CloudFormation::StackSet.AdministrationRoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-administrationrolearn
     * @external
     */
    readonly administrationRoleArn?: string;
    /**
     * `AWS::CloudFormation::StackSet.AutoDeployment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-autodeployment
     * @external
     */
    readonly autoDeployment?: CfnStackSet.AutoDeploymentProperty | cdk.IResolvable;
    /**
     * `AWS::CloudFormation::StackSet.Capabilities`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-capabilities
     * @external
     */
    readonly capabilities?: string[];
    /**
     * `AWS::CloudFormation::StackSet.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::CloudFormation::StackSet.ExecutionRoleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-executionrolename
     * @external
     */
    readonly executionRoleName?: string;
    /**
     * `AWS::CloudFormation::StackSet.OperationPreferences`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-operationpreferences
     * @external
     */
    readonly operationPreferences?: CfnStackSet.OperationPreferencesProperty | cdk.IResolvable;
    /**
     * `AWS::CloudFormation::StackSet.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-parameters
     * @external
     */
    readonly parameters?: Array<CfnStackSet.ParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudFormation::StackSet.PermissionModel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-permissionmodel
     * @external
     */
    readonly permissionModel?: string;
    /**
     * `AWS::CloudFormation::StackSet.StackInstancesGroup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-stackinstancesgroup
     * @external
     */
    readonly stackInstancesGroup?: Array<CfnStackSet.StackInstancesProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudFormation::StackSet.StackSetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-stacksetname
     * @external
     */
    readonly stackSetName?: string;
    /**
     * `AWS::CloudFormation::StackSet.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CloudFormation::StackSet.TemplateBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-templatebody
     * @external
     */
    readonly templateBody?: string;
    /**
     * `AWS::CloudFormation::StackSet.TemplateURL`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-templateurl
     * @external
     */
    readonly templateUrl?: string;
}
/**
 * A CloudFormation `AWS::CloudFormation::StackSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html
 * @external
 * @cloudformationResource AWS::CloudFormation::StackSet
 */
export declare class CfnStackSet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::StackSet";
    /**
     * @external
     * @cloudformationAttribute StackSetId
     */
    readonly attrStackSetId: string;
    /**
     * `AWS::CloudFormation::StackSet.AdministrationRoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-administrationrolearn
     * @external
     */
    administrationRoleArn: string | undefined;
    /**
     * `AWS::CloudFormation::StackSet.AutoDeployment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-autodeployment
     * @external
     */
    autoDeployment: CfnStackSet.AutoDeploymentProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudFormation::StackSet.Capabilities`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-capabilities
     * @external
     */
    capabilities: string[] | undefined;
    /**
     * `AWS::CloudFormation::StackSet.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::CloudFormation::StackSet.ExecutionRoleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-executionrolename
     * @external
     */
    executionRoleName: string | undefined;
    /**
     * `AWS::CloudFormation::StackSet.OperationPreferences`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-operationpreferences
     * @external
     */
    operationPreferences: CfnStackSet.OperationPreferencesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudFormation::StackSet.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-parameters
     * @external
     */
    parameters: Array<CfnStackSet.ParameterProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudFormation::StackSet.PermissionModel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-permissionmodel
     * @external
     */
    permissionModel: string | undefined;
    /**
     * `AWS::CloudFormation::StackSet.StackInstancesGroup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-stackinstancesgroup
     * @external
     */
    stackInstancesGroup: Array<CfnStackSet.StackInstancesProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudFormation::StackSet.StackSetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-stacksetname
     * @external
     */
    stackSetName: string | undefined;
    /**
     * `AWS::CloudFormation::StackSet.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CloudFormation::StackSet.TemplateBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-templatebody
     * @external
     */
    templateBody: string | undefined;
    /**
     * `AWS::CloudFormation::StackSet.TemplateURL`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-templateurl
     * @external
     */
    templateUrl: string | undefined;
    /**
     * Create a new `AWS::CloudFormation::StackSet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnStackSetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudFormation::StackSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html
 * @external
 * @cloudformationResource AWS::CloudFormation::StackSet
 */
export declare namespace CfnStackSet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-autodeployment.html
     * @external
     */
    interface AutoDeploymentProperty {
        /**
         * `CfnStackSet.AutoDeploymentProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-autodeployment.html#cfn-cloudformation-stackset-autodeployment-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnStackSet.AutoDeploymentProperty.RetainStacksOnAccountRemoval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-autodeployment.html#cfn-cloudformation-stackset-autodeployment-retainstacksonaccountremoval
         * @external
         */
        readonly retainStacksOnAccountRemoval?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CloudFormation::StackSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html
 * @external
 * @cloudformationResource AWS::CloudFormation::StackSet
 */
export declare namespace CfnStackSet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-deploymenttargets.html
     * @external
     */
    interface DeploymentTargetsProperty {
        /**
         * `CfnStackSet.DeploymentTargetsProperty.Accounts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-deploymenttargets.html#cfn-cloudformation-stackset-deploymenttargets-accounts
         * @external
         */
        readonly accounts?: string[];
        /**
         * `CfnStackSet.DeploymentTargetsProperty.OrganizationalUnitIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-deploymenttargets.html#cfn-cloudformation-stackset-deploymenttargets-organizationalunitids
         * @external
         */
        readonly organizationalUnitIds?: string[];
    }
}
/**
 * A CloudFormation `AWS::CloudFormation::StackSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html
 * @external
 * @cloudformationResource AWS::CloudFormation::StackSet
 */
export declare namespace CfnStackSet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-operationpreferences.html
     * @external
     */
    interface OperationPreferencesProperty {
        /**
         * `CfnStackSet.OperationPreferencesProperty.FailureToleranceCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-operationpreferences.html#cfn-cloudformation-stackset-operationpreferences-failuretolerancecount
         * @external
         */
        readonly failureToleranceCount?: number;
        /**
         * `CfnStackSet.OperationPreferencesProperty.FailureTolerancePercentage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-operationpreferences.html#cfn-cloudformation-stackset-operationpreferences-failuretolerancepercentage
         * @external
         */
        readonly failureTolerancePercentage?: number;
        /**
         * `CfnStackSet.OperationPreferencesProperty.MaxConcurrentCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-operationpreferences.html#cfn-cloudformation-stackset-operationpreferences-maxconcurrentcount
         * @external
         */
        readonly maxConcurrentCount?: number;
        /**
         * `CfnStackSet.OperationPreferencesProperty.MaxConcurrentPercentage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-operationpreferences.html#cfn-cloudformation-stackset-operationpreferences-maxconcurrentpercentage
         * @external
         */
        readonly maxConcurrentPercentage?: number;
        /**
         * `CfnStackSet.OperationPreferencesProperty.RegionOrder`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-operationpreferences.html#cfn-cloudformation-stackset-operationpreferences-regionorder
         * @external
         */
        readonly regionOrder?: string[];
    }
}
/**
 * A CloudFormation `AWS::CloudFormation::StackSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html
 * @external
 * @cloudformationResource AWS::CloudFormation::StackSet
 */
export declare namespace CfnStackSet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-parameter.html
     * @external
     */
    interface ParameterProperty {
        /**
         * `CfnStackSet.ParameterProperty.ParameterKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-parameter.html#cfn-cloudformation-stackset-parameter-parameterkey
         * @external
         */
        readonly parameterKey: string;
        /**
         * `CfnStackSet.ParameterProperty.ParameterValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-parameter.html#cfn-cloudformation-stackset-parameter-parametervalue
         * @external
         */
        readonly parameterValue: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFormation::StackSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html
 * @external
 * @cloudformationResource AWS::CloudFormation::StackSet
 */
export declare namespace CfnStackSet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-stackinstances.html
     * @external
     */
    interface StackInstancesProperty {
        /**
         * `CfnStackSet.StackInstancesProperty.DeploymentTargets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-stackinstances.html#cfn-cloudformation-stackset-stackinstances-deploymenttargets
         * @external
         */
        readonly deploymentTargets: CfnStackSet.DeploymentTargetsProperty | cdk.IResolvable;
        /**
         * `CfnStackSet.StackInstancesProperty.ParameterOverrides`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-stackinstances.html#cfn-cloudformation-stackset-stackinstances-parameteroverrides
         * @external
         */
        readonly parameterOverrides?: Array<CfnStackSet.ParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnStackSet.StackInstancesProperty.Regions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stackset-stackinstances.html#cfn-cloudformation-stackset-stackinstances-regions
         * @external
         */
        readonly regions: string[];
    }
}
/**
 * Properties for defining a `AWS::CloudFormation::WaitCondition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html
 * @external
 */
export interface CfnWaitConditionProps {
    /**
     * `AWS::CloudFormation::WaitCondition.Count`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html#cfn-waitcondition-count
     * @external
     */
    readonly count?: number;
    /**
     * `AWS::CloudFormation::WaitCondition.Handle`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html#cfn-waitcondition-handle
     * @external
     */
    readonly handle?: string;
    /**
     * `AWS::CloudFormation::WaitCondition.Timeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html#cfn-waitcondition-timeout
     * @external
     */
    readonly timeout?: string;
}
/**
 * A CloudFormation `AWS::CloudFormation::WaitCondition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html
 * @external
 * @cloudformationResource AWS::CloudFormation::WaitCondition
 */
export declare class CfnWaitCondition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::WaitCondition";
    /**
     * @external
     * @cloudformationAttribute Data
     */
    readonly attrData: cdk.IResolvable;
    /**
     * `AWS::CloudFormation::WaitCondition.Count`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html#cfn-waitcondition-count
     * @external
     */
    count: number | undefined;
    /**
     * `AWS::CloudFormation::WaitCondition.Handle`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html#cfn-waitcondition-handle
     * @external
     */
    handle: string | undefined;
    /**
     * `AWS::CloudFormation::WaitCondition.Timeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html#cfn-waitcondition-timeout
     * @external
     */
    timeout: string | undefined;
    /**
     * Create a new `AWS::CloudFormation::WaitCondition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnWaitConditionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudFormation::WaitConditionHandle`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitconditionhandle.html
 * @external
 * @cloudformationResource AWS::CloudFormation::WaitConditionHandle
 */
export declare class CfnWaitConditionHandle extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::WaitConditionHandle";
    /**
     * Create a new `AWS::CloudFormation::WaitConditionHandle`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @external
     */
    constructor(scope: cdk.Construct, id: string);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
}
