# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SelfServiceProfileCustomTextArgs', 'SelfServiceProfileCustomText']

@pulumi.input_type
class SelfServiceProfileCustomTextArgs:
    def __init__(__self__, *,
                 body: pulumi.Input[str],
                 language: pulumi.Input[str],
                 page: pulumi.Input[str],
                 sso_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a SelfServiceProfileCustomText resource.
        :param pulumi.Input[str] body: The list of text keys and values to customize the self-service SSO page. Values can be plain text or rich HTML content limited to basic styling tags and hyperlinks
        :param pulumi.Input[str] language: The language of the custom text
        :param pulumi.Input[str] page: The page where the custom text is shown
        :param pulumi.Input[str] sso_id: The id of the self-service profile
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "page", page)
        pulumi.set(__self__, "sso_id", sso_id)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Input[str]:
        """
        The list of text keys and values to customize the self-service SSO page. Values can be plain text or rich HTML content limited to basic styling tags and hyperlinks
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: pulumi.Input[str]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def language(self) -> pulumi.Input[str]:
        """
        The language of the custom text
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: pulumi.Input[str]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def page(self) -> pulumi.Input[str]:
        """
        The page where the custom text is shown
        """
        return pulumi.get(self, "page")

    @page.setter
    def page(self, value: pulumi.Input[str]):
        pulumi.set(self, "page", value)

    @property
    @pulumi.getter(name="ssoId")
    def sso_id(self) -> pulumi.Input[str]:
        """
        The id of the self-service profile
        """
        return pulumi.get(self, "sso_id")

    @sso_id.setter
    def sso_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sso_id", value)


@pulumi.input_type
class _SelfServiceProfileCustomTextState:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[str]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 page: Optional[pulumi.Input[str]] = None,
                 sso_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SelfServiceProfileCustomText resources.
        :param pulumi.Input[str] body: The list of text keys and values to customize the self-service SSO page. Values can be plain text or rich HTML content limited to basic styling tags and hyperlinks
        :param pulumi.Input[str] language: The language of the custom text
        :param pulumi.Input[str] page: The page where the custom text is shown
        :param pulumi.Input[str] sso_id: The id of the self-service profile
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if page is not None:
            pulumi.set(__self__, "page", page)
        if sso_id is not None:
            pulumi.set(__self__, "sso_id", sso_id)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        The list of text keys and values to customize the self-service SSO page. Values can be plain text or rich HTML content limited to basic styling tags and hyperlinks
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        The language of the custom text
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def page(self) -> Optional[pulumi.Input[str]]:
        """
        The page where the custom text is shown
        """
        return pulumi.get(self, "page")

    @page.setter
    def page(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "page", value)

    @property
    @pulumi.getter(name="ssoId")
    def sso_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the self-service profile
        """
        return pulumi.get(self, "sso_id")

    @sso_id.setter
    def sso_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sso_id", value)


class SelfServiceProfileCustomText(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 page: Optional[pulumi.Input[str]] = None,
                 sso_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        With this resource, you can set custom text for Self-Service Profile

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        sso_custom_text = auth0.SelfServiceProfileCustomText("sso_custom_text",
            sso_id="some-sso-id",
            language="en",
            page="get-started",
            body=json.dumps({
                "introduction": "Welcome! With only a few steps you'll be able to setup your new custom text.",
            }))
        ```

        ## Import

        This resource can be imported by specifying the

        sso-profile-id, language and page separated by "::" (note the double colon)

        <sso-profile-id>::<language>::<page>

        # 

        Example

        ```sh
        $ pulumi import auth0:index/selfServiceProfileCustomText:SelfServiceProfileCustomText example "some-sso-id::en::get-started"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body: The list of text keys and values to customize the self-service SSO page. Values can be plain text or rich HTML content limited to basic styling tags and hyperlinks
        :param pulumi.Input[str] language: The language of the custom text
        :param pulumi.Input[str] page: The page where the custom text is shown
        :param pulumi.Input[str] sso_id: The id of the self-service profile
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SelfServiceProfileCustomTextArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can set custom text for Self-Service Profile

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        sso_custom_text = auth0.SelfServiceProfileCustomText("sso_custom_text",
            sso_id="some-sso-id",
            language="en",
            page="get-started",
            body=json.dumps({
                "introduction": "Welcome! With only a few steps you'll be able to setup your new custom text.",
            }))
        ```

        ## Import

        This resource can be imported by specifying the

        sso-profile-id, language and page separated by "::" (note the double colon)

        <sso-profile-id>::<language>::<page>

        # 

        Example

        ```sh
        $ pulumi import auth0:index/selfServiceProfileCustomText:SelfServiceProfileCustomText example "some-sso-id::en::get-started"
        ```

        :param str resource_name: The name of the resource.
        :param SelfServiceProfileCustomTextArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SelfServiceProfileCustomTextArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 page: Optional[pulumi.Input[str]] = None,
                 sso_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SelfServiceProfileCustomTextArgs.__new__(SelfServiceProfileCustomTextArgs)

            if body is None and not opts.urn:
                raise TypeError("Missing required property 'body'")
            __props__.__dict__["body"] = body
            if language is None and not opts.urn:
                raise TypeError("Missing required property 'language'")
            __props__.__dict__["language"] = language
            if page is None and not opts.urn:
                raise TypeError("Missing required property 'page'")
            __props__.__dict__["page"] = page
            if sso_id is None and not opts.urn:
                raise TypeError("Missing required property 'sso_id'")
            __props__.__dict__["sso_id"] = sso_id
        super(SelfServiceProfileCustomText, __self__).__init__(
            'auth0:index/selfServiceProfileCustomText:SelfServiceProfileCustomText',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body: Optional[pulumi.Input[str]] = None,
            language: Optional[pulumi.Input[str]] = None,
            page: Optional[pulumi.Input[str]] = None,
            sso_id: Optional[pulumi.Input[str]] = None) -> 'SelfServiceProfileCustomText':
        """
        Get an existing SelfServiceProfileCustomText resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body: The list of text keys and values to customize the self-service SSO page. Values can be plain text or rich HTML content limited to basic styling tags and hyperlinks
        :param pulumi.Input[str] language: The language of the custom text
        :param pulumi.Input[str] page: The page where the custom text is shown
        :param pulumi.Input[str] sso_id: The id of the self-service profile
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SelfServiceProfileCustomTextState.__new__(_SelfServiceProfileCustomTextState)

        __props__.__dict__["body"] = body
        __props__.__dict__["language"] = language
        __props__.__dict__["page"] = page
        __props__.__dict__["sso_id"] = sso_id
        return SelfServiceProfileCustomText(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[str]:
        """
        The list of text keys and values to customize the self-service SSO page. Values can be plain text or rich HTML content limited to basic styling tags and hyperlinks
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[str]:
        """
        The language of the custom text
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def page(self) -> pulumi.Output[str]:
        """
        The page where the custom text is shown
        """
        return pulumi.get(self, "page")

    @property
    @pulumi.getter(name="ssoId")
    def sso_id(self) -> pulumi.Output[str]:
        """
        The id of the self-service profile
        """
        return pulumi.get(self, "sso_id")

