# isort: off
# Try import ray[tune] core requirements (defined in setup.py)
try:
    import fsspec  # noqa: F401
    import pandas  # noqa: F401
    import pyarrow  # noqa: F401
    import requests  # noqa: F401
except ImportError as exc:
    raise ImportError(
        "Can't import ray.tune as some dependencies are missing. "
        'Run `pip install "ray[tune]"` to fix.'
    ) from exc
# isort: on

from ray.air.result import Result
from ray.tune.analysis import ExperimentAnalysis
from ray.tune.callback import Callback
from ray.tune.context import TuneContext, get_context
from ray.tune.error import TuneError
from ray.tune.execution.placement_groups import PlacementGroupFactory
from ray.tune.experiment import Experiment
from ray.tune.impl.config import CheckpointConfig, FailureConfig, RunConfig
from ray.tune.progress_reporter import (
    CLIReporter,
    JupyterNotebookReporter,
    ProgressReporter,
)
from ray.tune.registry import register_env, register_trainable
from ray.tune.result_grid import ResultGrid
from ray.tune.schedulers import create_scheduler
from ray.tune.search import create_searcher, grid_search
from ray.tune.search.sample import (
    choice,
    lograndint,
    loguniform,
    qlograndint,
    qloguniform,
    qrandint,
    qrandn,
    quniform,
    randint,
    randn,
    sample_from,
    uniform,
)
from ray.tune.stopper import Stopper
from ray.tune.syncer import SyncConfig
from ray.tune.trainable import Trainable
from ray.tune.trainable.trainable_fn_utils import Checkpoint, get_checkpoint, report
from ray.tune.trainable.util import with_parameters, with_resources
from ray.tune.tune import run, run_experiments
from ray.tune.tune_config import ResumeConfig, TuneConfig
from ray.tune.tuner import Tuner

__all__ = [
    "Trainable",
    "Callback",
    "TuneError",
    "grid_search",
    "register_env",
    "register_trainable",
    "run",
    "run_experiments",
    "with_parameters",
    "with_resources",
    "Stopper",
    "Experiment",
    "sample_from",
    "uniform",
    "quniform",
    "choice",
    "randint",
    "lograndint",
    "qrandint",
    "qlograndint",
    "randn",
    "qrandn",
    "loguniform",
    "qloguniform",
    "ExperimentAnalysis",
    "CLIReporter",
    "JupyterNotebookReporter",
    "ProgressReporter",
    "ResultGrid",
    "create_searcher",
    "create_scheduler",
    "PlacementGroupFactory",
    "Tuner",
    "TuneConfig",
    "ResumeConfig",
    "RunConfig",
    "CheckpointConfig",
    "FailureConfig",
    "Result",
    "Checkpoint",
    "get_checkpoint",
    "report",
    "get_context",
    "TuneContext",
    # TODO(justinvyu): [Deprecated]
    "SyncConfig",
]

report.__module__ = "ray.tune"
get_checkpoint.__module__ = "ray.tune"
get_context.__module__ = "ray.tune"
TuneContext.__module__ = "ray.tune"
Checkpoint.__module__ = "ray.tune"
Result.__module__ = "ray.tune"
RunConfig.__module__ = "ray.tune"
CheckpointConfig.__module__ = "ray.tune"
FailureConfig.__module__ = "ray.tune"


# DO NOT ADD ANYTHING AFTER THIS LINE.
