# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 7.1.2439
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from vrt_lss_account.models.service import Service
from typing import Optional, Set
from typing_extensions import Self

class Tracedata(BaseModel):
    """
    Data for request tracing.
    """ # noqa: E501
    process_code: StrictStr = Field(description="Unique process identifier. One is created per process, the same for different requests for the same process. ")
    request_code: StrictStr = Field(description="Unique identifier of the request. A new one is created for each request. ")
    username: Annotated[str, Field(min_length=2, strict=True, max_length=256)] = Field(description="Unique username for login.")
    company: Annotated[str, Field(min_length=3, strict=True, max_length=256)] = Field(description="Unique company key.")
    service: Service
    operation: Annotated[str, Field(min_length=3, strict=True, max_length=256)] = Field(description="Operation (request) name.")
    env: Annotated[str, Field(min_length=2, strict=True, max_length=256)] = Field(description="Environment identifier.")
    pod: Annotated[str, Field(min_length=2, strict=True, max_length=256)] = Field(description="Pod identifier.")
    time: datetime = Field(description="Date and time service method run in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format.")
    __properties: ClassVar[List[str]] = ["process_code", "request_code", "username", "company", "service", "operation", "env", "pod", "time"]

    @field_validator('username')
    def username_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    @field_validator('company')
    def company_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    @field_validator('env')
    def env_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    @field_validator('pod')
    def pod_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Tracedata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Tracedata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "process_code": obj.get("process_code"),
            "request_code": obj.get("request_code"),
            "username": obj.get("username"),
            "company": obj.get("company"),
            "service": obj.get("service"),
            "operation": obj.get("operation"),
            "env": obj.get("env"),
            "pod": obj.get("pod"),
            "time": obj.get("time")
        })
        return _obj


