# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSecurityPolicyResult',
    'AwaitableGetSecurityPolicyResult',
    'get_security_policy',
    'get_security_policy_output',
]

@pulumi.output_type
class GetSecurityPolicyResult:
    """
    A collection of values returned by getSecurityPolicy.
    """
    def __init__(__self__, category=None, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, friendly_name=None, id=None, lifecycle_details=None, owner=None, security_policy_id=None, services=None, state=None, time_created=None, time_updated=None):
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if friendly_name and not isinstance(friendly_name, str):
            raise TypeError("Expected argument 'friendly_name' to be a str")
        pulumi.set(__self__, "friendly_name", friendly_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if security_policy_id and not isinstance(security_policy_id, str):
            raise TypeError("Expected argument 'security_policy_id' to be a str")
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The category of the security policy
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the security policy's compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The security policy's description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The security policy's display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> str:
        """
        A shorter version of the security policy's name
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, this can be used to provide actionable information for a resource in a `Failed` state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        The owner of the security policy
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> str:
        return pulumi.get(self, "security_policy_id")

    @property
    @pulumi.getter
    def services(self) -> Sequence[str]:
        """
        The list of services that the security policy protects
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the security policy
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the security policy was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the security policy was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetSecurityPolicyResult(GetSecurityPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityPolicyResult(
            category=self.category,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            friendly_name=self.friendly_name,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            owner=self.owner,
            security_policy_id=self.security_policy_id,
            services=self.services,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_security_policy(security_policy_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityPolicyResult:
    """
    This data source provides details about a specific Security Policy resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a security zone policy (SecurityPolicy resource), identified by its unique ID
    (securityPolicyId). When a policy is enabled in a security zone, then any action in
    the zone that attempts to violate that policy is blocked.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policy = oci.CloudGuard.get_security_policy(security_policy_id=test_security_policy_oci_cloud_guard_security_policy["id"])
    ```


    :param str security_policy_id: The unique identifier of the security zone policy. (`SecurityPolicy`)
    """
    __args__ = dict()
    __args__['securityPolicyId'] = security_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getSecurityPolicy:getSecurityPolicy', __args__, opts=opts, typ=GetSecurityPolicyResult).value

    return AwaitableGetSecurityPolicyResult(
        category=pulumi.get(__ret__, 'category'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        friendly_name=pulumi.get(__ret__, 'friendly_name'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        owner=pulumi.get(__ret__, 'owner'),
        security_policy_id=pulumi.get(__ret__, 'security_policy_id'),
        services=pulumi.get(__ret__, 'services'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_security_policy_output(security_policy_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecurityPolicyResult]:
    """
    This data source provides details about a specific Security Policy resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a security zone policy (SecurityPolicy resource), identified by its unique ID
    (securityPolicyId). When a policy is enabled in a security zone, then any action in
    the zone that attempts to violate that policy is blocked.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policy = oci.CloudGuard.get_security_policy(security_policy_id=test_security_policy_oci_cloud_guard_security_policy["id"])
    ```


    :param str security_policy_id: The unique identifier of the security zone policy. (`SecurityPolicy`)
    """
    __args__ = dict()
    __args__['securityPolicyId'] = security_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudGuard/getSecurityPolicy:getSecurityPolicy', __args__, opts=opts, typ=GetSecurityPolicyResult)
    return __ret__.apply(lambda __response__: GetSecurityPolicyResult(
        category=pulumi.get(__response__, 'category'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        friendly_name=pulumi.get(__response__, 'friendly_name'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        owner=pulumi.get(__response__, 'owner'),
        security_policy_id=pulumi.get(__response__, 'security_policy_id'),
        services=pulumi.get(__response__, 'services'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
