# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVnicAttachmentsResult',
    'AwaitableGetVnicAttachmentsResult',
    'get_vnic_attachments',
    'get_vnic_attachments_output',
]

@pulumi.output_type
class GetVnicAttachmentsResult:
    """
    A collection of values returned by getVnicAttachments.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, filters=None, id=None, instance_id=None, vnic_attachments=None, vnic_id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if vnic_attachments and not isinstance(vnic_attachments, list):
            raise TypeError("Expected argument 'vnic_attachments' to be a list")
        pulumi.set(__self__, "vnic_attachments", vnic_attachments)
        if vnic_id and not isinstance(vnic_id, str):
            raise TypeError("Expected argument 'vnic_id' to be a str")
        pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        The availability domain of the instance.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment the VNIC attachment is in, which is the same compartment the instance is in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVnicAttachmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The OCID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="vnicAttachments")
    def vnic_attachments(self) -> Sequence['outputs.GetVnicAttachmentsVnicAttachmentResult']:
        """
        The list of vnic_attachments.
        """
        return pulumi.get(self, "vnic_attachments")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[str]:
        """
        The OCID of the VNIC. Available after the attachment process is complete.
        """
        return pulumi.get(self, "vnic_id")


class AwaitableGetVnicAttachmentsResult(GetVnicAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVnicAttachmentsResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            instance_id=self.instance_id,
            vnic_attachments=self.vnic_attachments,
            vnic_id=self.vnic_id)


def get_vnic_attachments(availability_domain: Optional[str] = None,
                         compartment_id: Optional[str] = None,
                         filters: Optional[Sequence[Union['GetVnicAttachmentsFilterArgs', 'GetVnicAttachmentsFilterArgsDict']]] = None,
                         instance_id: Optional[str] = None,
                         vnic_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVnicAttachmentsResult:
    """
    This data source provides the list of Vnic Attachments in Oracle Cloud Infrastructure Core service.

    Lists the VNIC attachments in the specified compartment. A VNIC attachment
    resides in the same compartment as the attached instance. The list can be
    filtered by instance, VNIC, or availability domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vnic_attachments = oci.Core.get_vnic_attachments(compartment_id=compartment_id,
        availability_domain=vnic_attachment_availability_domain,
        instance_id=test_instance["id"],
        vnic_id=test_vnic["id"])
    ```


    :param str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str instance_id: The OCID of the instance.
    :param str vnic_id: The OCID of the VNIC.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['instanceId'] = instance_id
    __args__['vnicId'] = vnic_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getVnicAttachments:getVnicAttachments', __args__, opts=opts, typ=GetVnicAttachmentsResult).value

    return AwaitableGetVnicAttachmentsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        vnic_attachments=pulumi.get(__ret__, 'vnic_attachments'),
        vnic_id=pulumi.get(__ret__, 'vnic_id'))
def get_vnic_attachments_output(availability_domain: Optional[pulumi.Input[Optional[str]]] = None,
                                compartment_id: Optional[pulumi.Input[str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVnicAttachmentsFilterArgs', 'GetVnicAttachmentsFilterArgsDict']]]]] = None,
                                instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                                vnic_id: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVnicAttachmentsResult]:
    """
    This data source provides the list of Vnic Attachments in Oracle Cloud Infrastructure Core service.

    Lists the VNIC attachments in the specified compartment. A VNIC attachment
    resides in the same compartment as the attached instance. The list can be
    filtered by instance, VNIC, or availability domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vnic_attachments = oci.Core.get_vnic_attachments(compartment_id=compartment_id,
        availability_domain=vnic_attachment_availability_domain,
        instance_id=test_instance["id"],
        vnic_id=test_vnic["id"])
    ```


    :param str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str instance_id: The OCID of the instance.
    :param str vnic_id: The OCID of the VNIC.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['instanceId'] = instance_id
    __args__['vnicId'] = vnic_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getVnicAttachments:getVnicAttachments', __args__, opts=opts, typ=GetVnicAttachmentsResult)
    return __ret__.apply(lambda __response__: GetVnicAttachmentsResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        vnic_attachments=pulumi.get(__response__, 'vnic_attachments'),
        vnic_id=pulumi.get(__response__, 'vnic_id')))
