# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVolumeBackupPolicyAssignmentsResult',
    'AwaitableGetVolumeBackupPolicyAssignmentsResult',
    'get_volume_backup_policy_assignments',
    'get_volume_backup_policy_assignments_output',
]

@pulumi.output_type
class GetVolumeBackupPolicyAssignmentsResult:
    """
    A collection of values returned by getVolumeBackupPolicyAssignments.
    """
    def __init__(__self__, asset_id=None, filters=None, id=None, volume_backup_policy_assignments=None):
        if asset_id and not isinstance(asset_id, str):
            raise TypeError("Expected argument 'asset_id' to be a str")
        pulumi.set(__self__, "asset_id", asset_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if volume_backup_policy_assignments and not isinstance(volume_backup_policy_assignments, list):
            raise TypeError("Expected argument 'volume_backup_policy_assignments' to be a list")
        pulumi.set(__self__, "volume_backup_policy_assignments", volume_backup_policy_assignments)

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> str:
        """
        The OCID of the volume the policy has been assigned to.
        """
        return pulumi.get(self, "asset_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVolumeBackupPolicyAssignmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="volumeBackupPolicyAssignments")
    def volume_backup_policy_assignments(self) -> Sequence['outputs.GetVolumeBackupPolicyAssignmentsVolumeBackupPolicyAssignmentResult']:
        """
        The list of volume_backup_policy_assignments.
        """
        return pulumi.get(self, "volume_backup_policy_assignments")


class AwaitableGetVolumeBackupPolicyAssignmentsResult(GetVolumeBackupPolicyAssignmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeBackupPolicyAssignmentsResult(
            asset_id=self.asset_id,
            filters=self.filters,
            id=self.id,
            volume_backup_policy_assignments=self.volume_backup_policy_assignments)


def get_volume_backup_policy_assignments(asset_id: Optional[str] = None,
                                         filters: Optional[Sequence[Union['GetVolumeBackupPolicyAssignmentsFilterArgs', 'GetVolumeBackupPolicyAssignmentsFilterArgsDict']]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeBackupPolicyAssignmentsResult:
    """
    This data source provides the list of Volume Backup Policy Assignments in Oracle Cloud Infrastructure Core service.

    Gets the volume backup policy assignment for the specified volume. The
    `assetId` query parameter is required, and the returned list will contain at most
    one item, since volume can only have one volume backup policy assigned at a time.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_volume_backup_policy_assignments = oci.Core.get_volume_backup_policy_assignments(asset_id=test_volume["id"])
    ```


    :param str asset_id: The OCID of an asset (e.g. a volume).
    """
    __args__ = dict()
    __args__['assetId'] = asset_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getVolumeBackupPolicyAssignments:getVolumeBackupPolicyAssignments', __args__, opts=opts, typ=GetVolumeBackupPolicyAssignmentsResult).value

    return AwaitableGetVolumeBackupPolicyAssignmentsResult(
        asset_id=pulumi.get(__ret__, 'asset_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        volume_backup_policy_assignments=pulumi.get(__ret__, 'volume_backup_policy_assignments'))
def get_volume_backup_policy_assignments_output(asset_id: Optional[pulumi.Input[str]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVolumeBackupPolicyAssignmentsFilterArgs', 'GetVolumeBackupPolicyAssignmentsFilterArgsDict']]]]] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVolumeBackupPolicyAssignmentsResult]:
    """
    This data source provides the list of Volume Backup Policy Assignments in Oracle Cloud Infrastructure Core service.

    Gets the volume backup policy assignment for the specified volume. The
    `assetId` query parameter is required, and the returned list will contain at most
    one item, since volume can only have one volume backup policy assigned at a time.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_volume_backup_policy_assignments = oci.Core.get_volume_backup_policy_assignments(asset_id=test_volume["id"])
    ```


    :param str asset_id: The OCID of an asset (e.g. a volume).
    """
    __args__ = dict()
    __args__['assetId'] = asset_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getVolumeBackupPolicyAssignments:getVolumeBackupPolicyAssignments', __args__, opts=opts, typ=GetVolumeBackupPolicyAssignmentsResult)
    return __ret__.apply(lambda __response__: GetVolumeBackupPolicyAssignmentsResult(
        asset_id=pulumi.get(__response__, 'asset_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        volume_backup_policy_assignments=pulumi.get(__response__, 'volume_backup_policy_assignments')))
