# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExascaleDbStorageVaultResult',
    'AwaitableGetExascaleDbStorageVaultResult',
    'get_exascale_db_storage_vault',
    'get_exascale_db_storage_vault_output',
]

@pulumi.output_type
class GetExascaleDbStorageVaultResult:
    """
    A collection of values returned by getExascaleDbStorageVault.
    """
    def __init__(__self__, additional_flash_cache_in_percent=None, availability_domain=None, compartment_id=None, defined_tags=None, description=None, display_name=None, exascale_db_storage_vault_id=None, freeform_tags=None, high_capacity_database_storages=None, id=None, lifecycle_details=None, state=None, system_tags=None, time_created=None, time_zone=None, vm_cluster_count=None, vm_cluster_ids=None):
        if additional_flash_cache_in_percent and not isinstance(additional_flash_cache_in_percent, int):
            raise TypeError("Expected argument 'additional_flash_cache_in_percent' to be a int")
        pulumi.set(__self__, "additional_flash_cache_in_percent", additional_flash_cache_in_percent)
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exascale_db_storage_vault_id and not isinstance(exascale_db_storage_vault_id, str):
            raise TypeError("Expected argument 'exascale_db_storage_vault_id' to be a str")
        pulumi.set(__self__, "exascale_db_storage_vault_id", exascale_db_storage_vault_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if high_capacity_database_storages and not isinstance(high_capacity_database_storages, list):
            raise TypeError("Expected argument 'high_capacity_database_storages' to be a list")
        pulumi.set(__self__, "high_capacity_database_storages", high_capacity_database_storages)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_zone and not isinstance(time_zone, str):
            raise TypeError("Expected argument 'time_zone' to be a str")
        pulumi.set(__self__, "time_zone", time_zone)
        if vm_cluster_count and not isinstance(vm_cluster_count, int):
            raise TypeError("Expected argument 'vm_cluster_count' to be a int")
        pulumi.set(__self__, "vm_cluster_count", vm_cluster_count)
        if vm_cluster_ids and not isinstance(vm_cluster_ids, list):
            raise TypeError("Expected argument 'vm_cluster_ids' to be a list")
        pulumi.set(__self__, "vm_cluster_ids", vm_cluster_ids)

    @property
    @pulumi.getter(name="additionalFlashCacheInPercent")
    def additional_flash_cache_in_percent(self) -> int:
        """
        The size of additional Flash Cache in percentage of High Capacity database storage.
        """
        return pulumi.get(self, "additional_flash_cache_in_percent")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The name of the availability domain in which the Exadata Database Storage Vault is located.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Exadata Database Storage Vault description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exascaleDbStorageVaultId")
    def exascale_db_storage_vault_id(self) -> str:
        return pulumi.get(self, "exascale_db_storage_vault_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="highCapacityDatabaseStorages")
    def high_capacity_database_storages(self) -> Sequence['outputs.GetExascaleDbStorageVaultHighCapacityDatabaseStorageResult']:
        """
        Exadata Database Storage Details
        """
        return pulumi.get(self, "high_capacity_database_storages")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time that the Exadata Database Storage Vault was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        The time zone that you want to use for the Exadata Database Storage Vault. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="vmClusterCount")
    def vm_cluster_count(self) -> int:
        """
        The number of Exadata VM clusters used the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "vm_cluster_count")

    @property
    @pulumi.getter(name="vmClusterIds")
    def vm_cluster_ids(self) -> Sequence[str]:
        """
        The List of Exadata VM cluster on Exascale Infrastructure [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) **Note:** If Exadata Database Storage Vault is not used for any Exadata VM cluster on Exascale Infrastructure, this list is empty.
        """
        return pulumi.get(self, "vm_cluster_ids")


class AwaitableGetExascaleDbStorageVaultResult(GetExascaleDbStorageVaultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExascaleDbStorageVaultResult(
            additional_flash_cache_in_percent=self.additional_flash_cache_in_percent,
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            exascale_db_storage_vault_id=self.exascale_db_storage_vault_id,
            freeform_tags=self.freeform_tags,
            high_capacity_database_storages=self.high_capacity_database_storages,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_zone=self.time_zone,
            vm_cluster_count=self.vm_cluster_count,
            vm_cluster_ids=self.vm_cluster_ids)


def get_exascale_db_storage_vault(exascale_db_storage_vault_id: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExascaleDbStorageVaultResult:
    """
    This data source provides details about a specific Exascale Db Storage Vault resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Exadata Database Storage Vaults in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exascale_db_storage_vault = oci.Database.get_exascale_db_storage_vault(exascale_db_storage_vault_id=test_exascale_db_storage_vault_oci_database_exascale_db_storage_vault["id"])
    ```


    :param str exascale_db_storage_vault_id: The Exadata Database Storage Vault [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['exascaleDbStorageVaultId'] = exascale_db_storage_vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExascaleDbStorageVault:getExascaleDbStorageVault', __args__, opts=opts, typ=GetExascaleDbStorageVaultResult).value

    return AwaitableGetExascaleDbStorageVaultResult(
        additional_flash_cache_in_percent=pulumi.get(__ret__, 'additional_flash_cache_in_percent'),
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exascale_db_storage_vault_id=pulumi.get(__ret__, 'exascale_db_storage_vault_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        high_capacity_database_storages=pulumi.get(__ret__, 'high_capacity_database_storages'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_zone=pulumi.get(__ret__, 'time_zone'),
        vm_cluster_count=pulumi.get(__ret__, 'vm_cluster_count'),
        vm_cluster_ids=pulumi.get(__ret__, 'vm_cluster_ids'))
def get_exascale_db_storage_vault_output(exascale_db_storage_vault_id: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExascaleDbStorageVaultResult]:
    """
    This data source provides details about a specific Exascale Db Storage Vault resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Exadata Database Storage Vaults in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exascale_db_storage_vault = oci.Database.get_exascale_db_storage_vault(exascale_db_storage_vault_id=test_exascale_db_storage_vault_oci_database_exascale_db_storage_vault["id"])
    ```


    :param str exascale_db_storage_vault_id: The Exadata Database Storage Vault [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['exascaleDbStorageVaultId'] = exascale_db_storage_vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getExascaleDbStorageVault:getExascaleDbStorageVault', __args__, opts=opts, typ=GetExascaleDbStorageVaultResult)
    return __ret__.apply(lambda __response__: GetExascaleDbStorageVaultResult(
        additional_flash_cache_in_percent=pulumi.get(__response__, 'additional_flash_cache_in_percent'),
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        exascale_db_storage_vault_id=pulumi.get(__response__, 'exascale_db_storage_vault_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        high_capacity_database_storages=pulumi.get(__response__, 'high_capacity_database_storages'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_zone=pulumi.get(__response__, 'time_zone'),
        vm_cluster_count=pulumi.get(__response__, 'vm_cluster_count'),
        vm_cluster_ids=pulumi.get(__response__, 'vm_cluster_ids')))
