# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSqlEndpointResult',
    'AwaitableGetSqlEndpointResult',
    'get_sql_endpoint',
    'get_sql_endpoint_output',
]

@pulumi.output_type
class GetSqlEndpointResult:
    """
    A collection of values returned by getSqlEndpoint.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, driver_shape=None, driver_shape_configs=None, executor_shape=None, executor_shape_configs=None, freeform_tags=None, id=None, jdbc_endpoint_url=None, lake_id=None, max_executor_count=None, metastore_id=None, min_executor_count=None, network_configurations=None, spark_advanced_configurations=None, sql_endpoint_id=None, sql_endpoint_version=None, state=None, state_message=None, system_tags=None, time_created=None, time_updated=None, warehouse_bucket_uri=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if driver_shape and not isinstance(driver_shape, str):
            raise TypeError("Expected argument 'driver_shape' to be a str")
        pulumi.set(__self__, "driver_shape", driver_shape)
        if driver_shape_configs and not isinstance(driver_shape_configs, list):
            raise TypeError("Expected argument 'driver_shape_configs' to be a list")
        pulumi.set(__self__, "driver_shape_configs", driver_shape_configs)
        if executor_shape and not isinstance(executor_shape, str):
            raise TypeError("Expected argument 'executor_shape' to be a str")
        pulumi.set(__self__, "executor_shape", executor_shape)
        if executor_shape_configs and not isinstance(executor_shape_configs, list):
            raise TypeError("Expected argument 'executor_shape_configs' to be a list")
        pulumi.set(__self__, "executor_shape_configs", executor_shape_configs)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if jdbc_endpoint_url and not isinstance(jdbc_endpoint_url, str):
            raise TypeError("Expected argument 'jdbc_endpoint_url' to be a str")
        pulumi.set(__self__, "jdbc_endpoint_url", jdbc_endpoint_url)
        if lake_id and not isinstance(lake_id, str):
            raise TypeError("Expected argument 'lake_id' to be a str")
        pulumi.set(__self__, "lake_id", lake_id)
        if max_executor_count and not isinstance(max_executor_count, int):
            raise TypeError("Expected argument 'max_executor_count' to be a int")
        pulumi.set(__self__, "max_executor_count", max_executor_count)
        if metastore_id and not isinstance(metastore_id, str):
            raise TypeError("Expected argument 'metastore_id' to be a str")
        pulumi.set(__self__, "metastore_id", metastore_id)
        if min_executor_count and not isinstance(min_executor_count, int):
            raise TypeError("Expected argument 'min_executor_count' to be a int")
        pulumi.set(__self__, "min_executor_count", min_executor_count)
        if network_configurations and not isinstance(network_configurations, list):
            raise TypeError("Expected argument 'network_configurations' to be a list")
        pulumi.set(__self__, "network_configurations", network_configurations)
        if spark_advanced_configurations and not isinstance(spark_advanced_configurations, dict):
            raise TypeError("Expected argument 'spark_advanced_configurations' to be a dict")
        pulumi.set(__self__, "spark_advanced_configurations", spark_advanced_configurations)
        if sql_endpoint_id and not isinstance(sql_endpoint_id, str):
            raise TypeError("Expected argument 'sql_endpoint_id' to be a str")
        pulumi.set(__self__, "sql_endpoint_id", sql_endpoint_id)
        if sql_endpoint_version and not isinstance(sql_endpoint_version, str):
            raise TypeError("Expected argument 'sql_endpoint_version' to be a str")
        pulumi.set(__self__, "sql_endpoint_version", sql_endpoint_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_message and not isinstance(state_message, str):
            raise TypeError("Expected argument 'state_message' to be a str")
        pulumi.set(__self__, "state_message", state_message)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if warehouse_bucket_uri and not isinstance(warehouse_bucket_uri, str):
            raise TypeError("Expected argument 'warehouse_bucket_uri' to be a str")
        pulumi.set(__self__, "warehouse_bucket_uri", warehouse_bucket_uri)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of a compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the SQL Endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The SQL Endpoint name, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> str:
        """
        The shape of the SQL Endpoint driver instance.
        """
        return pulumi.get(self, "driver_shape")

    @property
    @pulumi.getter(name="driverShapeConfigs")
    def driver_shape_configs(self) -> Sequence['outputs.GetSqlEndpointDriverShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_configs")

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> str:
        """
        The shape of the SQL Endpoint executor instance.
        """
        return pulumi.get(self, "executor_shape")

    @property
    @pulumi.getter(name="executorShapeConfigs")
    def executor_shape_configs(self) -> Sequence['outputs.GetSqlEndpointExecutorShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_configs")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provision identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jdbcEndpointUrl")
    def jdbc_endpoint_url(self) -> str:
        """
        The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        """
        return pulumi.get(self, "jdbc_endpoint_url")

    @property
    @pulumi.getter(name="lakeId")
    def lake_id(self) -> str:
        """
        The OCID of Oracle Cloud Infrastructure Lake.
        """
        return pulumi.get(self, "lake_id")

    @property
    @pulumi.getter(name="maxExecutorCount")
    def max_executor_count(self) -> int:
        """
        The maximum number of executors.
        """
        return pulumi.get(self, "max_executor_count")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> str:
        """
        The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="minExecutorCount")
    def min_executor_count(self) -> int:
        """
        The minimum number of executors.
        """
        return pulumi.get(self, "min_executor_count")

    @property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetSqlEndpointNetworkConfigurationResult']:
        """
        The network configuration of a SQL Endpoint.
        """
        return pulumi.get(self, "network_configurations")

    @property
    @pulumi.getter(name="sparkAdvancedConfigurations")
    def spark_advanced_configurations(self) -> Mapping[str, str]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "spark_advanced_configurations")

    @property
    @pulumi.getter(name="sqlEndpointId")
    def sql_endpoint_id(self) -> str:
        return pulumi.get(self, "sql_endpoint_id")

    @property
    @pulumi.getter(name="sqlEndpointVersion")
    def sql_endpoint_version(self) -> str:
        """
        The version of SQL Endpoint.
        """
        return pulumi.get(self, "sql_endpoint_version")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Sql Endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        """
        A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> str:
        """
        The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
        """
        return pulumi.get(self, "warehouse_bucket_uri")


class AwaitableGetSqlEndpointResult(GetSqlEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSqlEndpointResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            driver_shape=self.driver_shape,
            driver_shape_configs=self.driver_shape_configs,
            executor_shape=self.executor_shape,
            executor_shape_configs=self.executor_shape_configs,
            freeform_tags=self.freeform_tags,
            id=self.id,
            jdbc_endpoint_url=self.jdbc_endpoint_url,
            lake_id=self.lake_id,
            max_executor_count=self.max_executor_count,
            metastore_id=self.metastore_id,
            min_executor_count=self.min_executor_count,
            network_configurations=self.network_configurations,
            spark_advanced_configurations=self.spark_advanced_configurations,
            sql_endpoint_id=self.sql_endpoint_id,
            sql_endpoint_version=self.sql_endpoint_version,
            state=self.state,
            state_message=self.state_message,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            warehouse_bucket_uri=self.warehouse_bucket_uri)


def get_sql_endpoint(sql_endpoint_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSqlEndpointResult:
    """
    This data source provides details about a specific Sql Endpoint resource in Oracle Cloud Infrastructure Data Flow service.

    Retrieves a SQL Endpoint using a sqlEndpointId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_endpoint = oci.DataFlow.get_sql_endpoint(sql_endpoint_id=test_sql_endpoint_oci_dataflow_sql_endpoint["id"])
    ```


    :param str sql_endpoint_id: The unique id of the SQL Endpoint.
    """
    __args__ = dict()
    __args__['sqlEndpointId'] = sql_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataFlow/getSqlEndpoint:getSqlEndpoint', __args__, opts=opts, typ=GetSqlEndpointResult).value

    return AwaitableGetSqlEndpointResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        driver_shape=pulumi.get(__ret__, 'driver_shape'),
        driver_shape_configs=pulumi.get(__ret__, 'driver_shape_configs'),
        executor_shape=pulumi.get(__ret__, 'executor_shape'),
        executor_shape_configs=pulumi.get(__ret__, 'executor_shape_configs'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        jdbc_endpoint_url=pulumi.get(__ret__, 'jdbc_endpoint_url'),
        lake_id=pulumi.get(__ret__, 'lake_id'),
        max_executor_count=pulumi.get(__ret__, 'max_executor_count'),
        metastore_id=pulumi.get(__ret__, 'metastore_id'),
        min_executor_count=pulumi.get(__ret__, 'min_executor_count'),
        network_configurations=pulumi.get(__ret__, 'network_configurations'),
        spark_advanced_configurations=pulumi.get(__ret__, 'spark_advanced_configurations'),
        sql_endpoint_id=pulumi.get(__ret__, 'sql_endpoint_id'),
        sql_endpoint_version=pulumi.get(__ret__, 'sql_endpoint_version'),
        state=pulumi.get(__ret__, 'state'),
        state_message=pulumi.get(__ret__, 'state_message'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        warehouse_bucket_uri=pulumi.get(__ret__, 'warehouse_bucket_uri'))
def get_sql_endpoint_output(sql_endpoint_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSqlEndpointResult]:
    """
    This data source provides details about a specific Sql Endpoint resource in Oracle Cloud Infrastructure Data Flow service.

    Retrieves a SQL Endpoint using a sqlEndpointId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_endpoint = oci.DataFlow.get_sql_endpoint(sql_endpoint_id=test_sql_endpoint_oci_dataflow_sql_endpoint["id"])
    ```


    :param str sql_endpoint_id: The unique id of the SQL Endpoint.
    """
    __args__ = dict()
    __args__['sqlEndpointId'] = sql_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataFlow/getSqlEndpoint:getSqlEndpoint', __args__, opts=opts, typ=GetSqlEndpointResult)
    return __ret__.apply(lambda __response__: GetSqlEndpointResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        driver_shape=pulumi.get(__response__, 'driver_shape'),
        driver_shape_configs=pulumi.get(__response__, 'driver_shape_configs'),
        executor_shape=pulumi.get(__response__, 'executor_shape'),
        executor_shape_configs=pulumi.get(__response__, 'executor_shape_configs'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        jdbc_endpoint_url=pulumi.get(__response__, 'jdbc_endpoint_url'),
        lake_id=pulumi.get(__response__, 'lake_id'),
        max_executor_count=pulumi.get(__response__, 'max_executor_count'),
        metastore_id=pulumi.get(__response__, 'metastore_id'),
        min_executor_count=pulumi.get(__response__, 'min_executor_count'),
        network_configurations=pulumi.get(__response__, 'network_configurations'),
        spark_advanced_configurations=pulumi.get(__response__, 'spark_advanced_configurations'),
        sql_endpoint_id=pulumi.get(__response__, 'sql_endpoint_id'),
        sql_endpoint_version=pulumi.get(__response__, 'sql_endpoint_version'),
        state=pulumi.get(__response__, 'state'),
        state_message=pulumi.get(__response__, 'state_message'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        warehouse_bucket_uri=pulumi.get(__response__, 'warehouse_bucket_uri')))
