# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAuditProfileCollectedAuditVolumeResult',
    'AwaitableGetAuditProfileCollectedAuditVolumeResult',
    'get_audit_profile_collected_audit_volume',
    'get_audit_profile_collected_audit_volume_output',
]

@pulumi.output_type
class GetAuditProfileCollectedAuditVolumeResult:
    """
    A collection of values returned by getAuditProfileCollectedAuditVolume.
    """
    def __init__(__self__, audit_profile_id=None, id=None, items=None, month_in_consideration_greater_than=None, month_in_consideration_less_than=None, work_request_id=None):
        if audit_profile_id and not isinstance(audit_profile_id, str):
            raise TypeError("Expected argument 'audit_profile_id' to be a str")
        pulumi.set(__self__, "audit_profile_id", audit_profile_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if month_in_consideration_greater_than and not isinstance(month_in_consideration_greater_than, str):
            raise TypeError("Expected argument 'month_in_consideration_greater_than' to be a str")
        pulumi.set(__self__, "month_in_consideration_greater_than", month_in_consideration_greater_than)
        if month_in_consideration_less_than and not isinstance(month_in_consideration_less_than, str):
            raise TypeError("Expected argument 'month_in_consideration_less_than' to be a str")
        pulumi.set(__self__, "month_in_consideration_less_than", month_in_consideration_less_than)
        if work_request_id and not isinstance(work_request_id, str):
            raise TypeError("Expected argument 'work_request_id' to be a str")
        pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> str:
        """
        The OCID of the audit profile resource.
        """
        return pulumi.get(self, "audit_profile_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAuditProfileCollectedAuditVolumeItemResult']:
        """
        Array of collected audit volume summary.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="monthInConsiderationGreaterThan")
    def month_in_consideration_greater_than(self) -> Optional[str]:
        return pulumi.get(self, "month_in_consideration_greater_than")

    @property
    @pulumi.getter(name="monthInConsiderationLessThan")
    def month_in_consideration_less_than(self) -> Optional[str]:
        return pulumi.get(self, "month_in_consideration_less_than")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> str:
        return pulumi.get(self, "work_request_id")


class AwaitableGetAuditProfileCollectedAuditVolumeResult(GetAuditProfileCollectedAuditVolumeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuditProfileCollectedAuditVolumeResult(
            audit_profile_id=self.audit_profile_id,
            id=self.id,
            items=self.items,
            month_in_consideration_greater_than=self.month_in_consideration_greater_than,
            month_in_consideration_less_than=self.month_in_consideration_less_than,
            work_request_id=self.work_request_id)


def get_audit_profile_collected_audit_volume(audit_profile_id: Optional[str] = None,
                                             month_in_consideration_greater_than: Optional[str] = None,
                                             month_in_consideration_less_than: Optional[str] = None,
                                             work_request_id: Optional[str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuditProfileCollectedAuditVolumeResult:
    """
    This data source provides details about a specific Audit Profile Collected Audit Volume resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of all collected audit volume data points.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_profile_collected_audit_volume = oci.DataSafe.get_audit_profile_collected_audit_volume(audit_profile_id=test_audit_profile["id"],
        work_request_id=test_work_request["id"],
        month_in_consideration_greater_than=audit_profile_collected_audit_volume_month_in_consideration_greater_than,
        month_in_consideration_less_than=audit_profile_collected_audit_volume_month_in_consideration_less_than)
    ```


    :param str audit_profile_id: The OCID of the audit.
    :param str month_in_consideration_greater_than: Specifying `monthInConsiderationGreaterThan` parameter will retrieve all items for which the event month is greater than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T00:00:00.000Z
    :param str month_in_consideration_less_than: Specifying `monthInConsiderationLessThan` parameter will retrieve all items for which the event month is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T00:00:00.000Z
    :param str work_request_id: The OCID of the work request.
    """
    __args__ = dict()
    __args__['auditProfileId'] = audit_profile_id
    __args__['monthInConsiderationGreaterThan'] = month_in_consideration_greater_than
    __args__['monthInConsiderationLessThan'] = month_in_consideration_less_than
    __args__['workRequestId'] = work_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAuditProfileCollectedAuditVolume:getAuditProfileCollectedAuditVolume', __args__, opts=opts, typ=GetAuditProfileCollectedAuditVolumeResult).value

    return AwaitableGetAuditProfileCollectedAuditVolumeResult(
        audit_profile_id=pulumi.get(__ret__, 'audit_profile_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        month_in_consideration_greater_than=pulumi.get(__ret__, 'month_in_consideration_greater_than'),
        month_in_consideration_less_than=pulumi.get(__ret__, 'month_in_consideration_less_than'),
        work_request_id=pulumi.get(__ret__, 'work_request_id'))
def get_audit_profile_collected_audit_volume_output(audit_profile_id: Optional[pulumi.Input[str]] = None,
                                                    month_in_consideration_greater_than: Optional[pulumi.Input[Optional[str]]] = None,
                                                    month_in_consideration_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                                    work_request_id: Optional[pulumi.Input[str]] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuditProfileCollectedAuditVolumeResult]:
    """
    This data source provides details about a specific Audit Profile Collected Audit Volume resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of all collected audit volume data points.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_profile_collected_audit_volume = oci.DataSafe.get_audit_profile_collected_audit_volume(audit_profile_id=test_audit_profile["id"],
        work_request_id=test_work_request["id"],
        month_in_consideration_greater_than=audit_profile_collected_audit_volume_month_in_consideration_greater_than,
        month_in_consideration_less_than=audit_profile_collected_audit_volume_month_in_consideration_less_than)
    ```


    :param str audit_profile_id: The OCID of the audit.
    :param str month_in_consideration_greater_than: Specifying `monthInConsiderationGreaterThan` parameter will retrieve all items for which the event month is greater than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T00:00:00.000Z
    :param str month_in_consideration_less_than: Specifying `monthInConsiderationLessThan` parameter will retrieve all items for which the event month is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T00:00:00.000Z
    :param str work_request_id: The OCID of the work request.
    """
    __args__ = dict()
    __args__['auditProfileId'] = audit_profile_id
    __args__['monthInConsiderationGreaterThan'] = month_in_consideration_greater_than
    __args__['monthInConsiderationLessThan'] = month_in_consideration_less_than
    __args__['workRequestId'] = work_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getAuditProfileCollectedAuditVolume:getAuditProfileCollectedAuditVolume', __args__, opts=opts, typ=GetAuditProfileCollectedAuditVolumeResult)
    return __ret__.apply(lambda __response__: GetAuditProfileCollectedAuditVolumeResult(
        audit_profile_id=pulumi.get(__response__, 'audit_profile_id'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        month_in_consideration_greater_than=pulumi.get(__response__, 'month_in_consideration_greater_than'),
        month_in_consideration_less_than=pulumi.get(__response__, 'month_in_consideration_less_than'),
        work_request_id=pulumi.get(__response__, 'work_request_id')))
