# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetsResult',
    'AwaitableGetFleetsResult',
    'get_fleets',
    'get_fleets_output',
]

@pulumi.output_type
class GetFleetsResult:
    """
    A collection of values returned by getFleets.
    """
    def __init__(__self__, application_type=None, compartment_id=None, display_name=None, environment_type=None, filters=None, fleet_collections=None, fleet_type=None, id=None, product=None, state=None):
        if application_type and not isinstance(application_type, str):
            raise TypeError("Expected argument 'application_type' to be a str")
        pulumi.set(__self__, "application_type", application_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if environment_type and not isinstance(environment_type, str):
            raise TypeError("Expected argument 'environment_type' to be a str")
        pulumi.set(__self__, "environment_type", environment_type)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_collections and not isinstance(fleet_collections, list):
            raise TypeError("Expected argument 'fleet_collections' to be a list")
        pulumi.set(__self__, "fleet_collections", fleet_collections)
        if fleet_type and not isinstance(fleet_type, str):
            raise TypeError("Expected argument 'fleet_type' to be a str")
        pulumi.set(__self__, "fleet_type", fleet_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if product and not isinstance(product, str):
            raise TypeError("Expected argument 'product' to be a str")
        pulumi.set(__self__, "product", product)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> Optional[str]:
        """
        Application Type associated with the Fleet.Applicable for ENVIRONMENT fleet types.
        """
        return pulumi.get(self, "application_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Please provide the root compartmentId (TenancyId).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> Optional[str]:
        """
        Environment Type associated with the Fleet.Applicable for ENVIRONMENT fleet types.
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetCollections")
    def fleet_collections(self) -> Sequence['outputs.GetFleetsFleetCollectionResult']:
        """
        The list of fleet_collection.
        """
        return pulumi.get(self, "fleet_collections")

    @property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> Optional[str]:
        """
        Type of the Fleet.
        """
        return pulumi.get(self, "fleet_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def product(self) -> Optional[str]:
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The lifecycle state of the Fleet.
        """
        return pulumi.get(self, "state")


class AwaitableGetFleetsResult(GetFleetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetsResult(
            application_type=self.application_type,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            environment_type=self.environment_type,
            filters=self.filters,
            fleet_collections=self.fleet_collections,
            fleet_type=self.fleet_type,
            id=self.id,
            product=self.product,
            state=self.state)


def get_fleets(application_type: Optional[str] = None,
               compartment_id: Optional[str] = None,
               display_name: Optional[str] = None,
               environment_type: Optional[str] = None,
               filters: Optional[Sequence[Union['GetFleetsFilterArgs', 'GetFleetsFilterArgsDict']]] = None,
               fleet_type: Optional[str] = None,
               id: Optional[str] = None,
               product: Optional[str] = None,
               state: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetsResult:
    """
    This data source provides the list of Fleets in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of Fleets in the specified Tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleets = oci.FleetAppsManagement.get_fleets(application_type=fleet_application_type,
        compartment_id=compartment_id,
        display_name=fleet_display_name,
        environment_type=fleet_environment_type,
        fleet_type=fleet_fleet_type,
        id=fleet_id,
        product=fleet_product,
        state=fleet_state)
    ```


    :param str application_type: A filter to return only resources that match the Application Type given.
    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str environment_type: A filter to return only resources that match the Environment Type given.
    :param str fleet_type: A filter to return only resources their fleetType matches the given fleetType.
    :param str id: unique Fleet identifier
    :param str product: A filter to return only resources that match the Product Type given.
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['applicationType'] = application_type
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['environmentType'] = environment_type
    __args__['filters'] = filters
    __args__['fleetType'] = fleet_type
    __args__['id'] = id
    __args__['product'] = product
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getFleets:getFleets', __args__, opts=opts, typ=GetFleetsResult).value

    return AwaitableGetFleetsResult(
        application_type=pulumi.get(__ret__, 'application_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        environment_type=pulumi.get(__ret__, 'environment_type'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_collections=pulumi.get(__ret__, 'fleet_collections'),
        fleet_type=pulumi.get(__ret__, 'fleet_type'),
        id=pulumi.get(__ret__, 'id'),
        product=pulumi.get(__ret__, 'product'),
        state=pulumi.get(__ret__, 'state'))
def get_fleets_output(application_type: Optional[pulumi.Input[Optional[str]]] = None,
                      compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                      display_name: Optional[pulumi.Input[Optional[str]]] = None,
                      environment_type: Optional[pulumi.Input[Optional[str]]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetsFilterArgs', 'GetFleetsFilterArgsDict']]]]] = None,
                      fleet_type: Optional[pulumi.Input[Optional[str]]] = None,
                      id: Optional[pulumi.Input[Optional[str]]] = None,
                      product: Optional[pulumi.Input[Optional[str]]] = None,
                      state: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFleetsResult]:
    """
    This data source provides the list of Fleets in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of Fleets in the specified Tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleets = oci.FleetAppsManagement.get_fleets(application_type=fleet_application_type,
        compartment_id=compartment_id,
        display_name=fleet_display_name,
        environment_type=fleet_environment_type,
        fleet_type=fleet_fleet_type,
        id=fleet_id,
        product=fleet_product,
        state=fleet_state)
    ```


    :param str application_type: A filter to return only resources that match the Application Type given.
    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str environment_type: A filter to return only resources that match the Environment Type given.
    :param str fleet_type: A filter to return only resources their fleetType matches the given fleetType.
    :param str id: unique Fleet identifier
    :param str product: A filter to return only resources that match the Product Type given.
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['applicationType'] = application_type
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['environmentType'] = environment_type
    __args__['filters'] = filters
    __args__['fleetType'] = fleet_type
    __args__['id'] = id
    __args__['product'] = product
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getFleets:getFleets', __args__, opts=opts, typ=GetFleetsResult)
    return __ret__.apply(lambda __response__: GetFleetsResult(
        application_type=pulumi.get(__response__, 'application_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        environment_type=pulumi.get(__response__, 'environment_type'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_collections=pulumi.get(__response__, 'fleet_collections'),
        fleet_type=pulumi.get(__response__, 'fleet_type'),
        id=pulumi.get(__response__, 'id'),
        product=pulumi.get(__response__, 'product'),
        state=pulumi.get(__response__, 'state')))
