# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'FleetCredentialEntitySpecifics',
    'FleetCredentialPassword',
    'FleetCredentialUser',
    'FleetNotificationPreferences',
    'FleetNotificationPreferencesPreferences',
    'FleetRuleSelectionCriteria',
    'FleetRuleSelectionCriteriaRule',
    'FleetRuleSelectionCriteriaRuleCondition',
    'SchedulerDefinitionActionGroup',
    'SchedulerDefinitionRunBook',
    'SchedulerDefinitionRunBookInputParameter',
    'SchedulerDefinitionRunBookInputParameterArgument',
    'SchedulerDefinitionSchedule',
    'GetAnnouncementsAnnouncementCollectionResult',
    'GetAnnouncementsAnnouncementCollectionItemResult',
    'GetAnnouncementsFilterResult',
    'GetFleetComplianceReportResourceResult',
    'GetFleetComplianceReportResourceProductResult',
    'GetFleetComplianceReportResourceProductTargetResult',
    'GetFleetComplianceReportResourceProductTargetInstalledPatchResult',
    'GetFleetComplianceReportResourceProductTargetRecommendedPatchResult',
    'GetFleetCredentialEntitySpecificResult',
    'GetFleetCredentialPasswordResult',
    'GetFleetCredentialUserResult',
    'GetFleetCredentialsFilterResult',
    'GetFleetCredentialsFleetCredentialCollectionResult',
    'GetFleetCredentialsFleetCredentialCollectionItemResult',
    'GetFleetCredentialsFleetCredentialCollectionItemEntitySpecificResult',
    'GetFleetCredentialsFleetCredentialCollectionItemPasswordResult',
    'GetFleetCredentialsFleetCredentialCollectionItemUserResult',
    'GetFleetNotificationPreferenceResult',
    'GetFleetNotificationPreferencePreferenceResult',
    'GetFleetProductsFilterResult',
    'GetFleetProductsFleetProductCollectionResult',
    'GetFleetProductsFleetProductCollectionItemResult',
    'GetFleetProductsFleetProductCollectionItemResourceResult',
    'GetFleetPropertiesFilterResult',
    'GetFleetPropertiesFleetPropertyCollectionResult',
    'GetFleetPropertiesFleetPropertyCollectionItemResult',
    'GetFleetResourcesFilterResult',
    'GetFleetResourcesFleetResourceCollectionResult',
    'GetFleetResourcesFleetResourceCollectionItemResult',
    'GetFleetRuleSelectionCriteriaResult',
    'GetFleetRuleSelectionCriteriaRuleResult',
    'GetFleetRuleSelectionCriteriaRuleConditionResult',
    'GetFleetTargetsFilterResult',
    'GetFleetTargetsFleetTargetCollectionResult',
    'GetFleetTargetsFleetTargetCollectionItemResult',
    'GetFleetTargetsFleetTargetCollectionItemResourceResult',
    'GetFleetsFilterResult',
    'GetFleetsFleetCollectionResult',
    'GetFleetsFleetCollectionItemResult',
    'GetFleetsFleetCollectionItemNotificationPreferenceResult',
    'GetFleetsFleetCollectionItemNotificationPreferencePreferenceResult',
    'GetFleetsFleetCollectionItemRuleSelectionCriteriaResult',
    'GetFleetsFleetCollectionItemRuleSelectionCriteriaRuleResult',
    'GetFleetsFleetCollectionItemRuleSelectionCriteriaRuleConditionResult',
    'GetInventoryResourcesFilterResult',
    'GetInventoryResourcesInventoryResourceCollectionResult',
    'GetInventoryResourcesInventoryResourceCollectionItemResult',
    'GetMaintenanceWindowsFilterResult',
    'GetMaintenanceWindowsMaintenanceWindowCollectionResult',
    'GetMaintenanceWindowsMaintenanceWindowCollectionItemResult',
    'GetOnboardingPoliciesFilterResult',
    'GetOnboardingPoliciesOnboardingPolicyCollectionResult',
    'GetOnboardingPoliciesOnboardingPolicyCollectionItemResult',
    'GetOnboardingsFilterResult',
    'GetOnboardingsOnboardingCollectionResult',
    'GetOnboardingsOnboardingCollectionItemResult',
    'GetPropertiesFilterResult',
    'GetPropertiesPropertyCollectionResult',
    'GetPropertiesPropertyCollectionItemResult',
    'GetRunbookAssociationResult',
    'GetRunbookAssociationExecutionWorkflowDetailResult',
    'GetRunbookAssociationExecutionWorkflowDetailWorkflowResult',
    'GetRunbookAssociationExecutionWorkflowDetailWorkflowStepResult',
    'GetRunbookAssociationGroupResult',
    'GetRunbookAssociationGroupPropertyResult',
    'GetRunbookAssociationTaskResult',
    'GetRunbookAssociationTaskOutputVariableMappingResult',
    'GetRunbookAssociationTaskOutputVariableMappingOutputVariableDetailResult',
    'GetRunbookAssociationTaskStepPropertyResult',
    'GetRunbookAssociationTaskTaskRecordDetailResult',
    'GetRunbookAssociationTaskTaskRecordDetailExecutionDetailResult',
    'GetRunbookAssociationTaskTaskRecordDetailExecutionDetailContentResult',
    'GetRunbookAssociationTaskTaskRecordDetailExecutionDetailVariableResult',
    'GetRunbookAssociationTaskTaskRecordDetailExecutionDetailVariableInputVariableResult',
    'GetRunbookAssociationTaskTaskRecordDetailPropertyResult',
    'GetRunbooksFilterResult',
    'GetRunbooksRunbookCollectionResult',
    'GetRunbooksRunbookCollectionItemResult',
    'GetRunbooksRunbookCollectionItemAssociationResult',
    'GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailResult',
    'GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailWorkflowResult',
    'GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailWorkflowStepResult',
    'GetRunbooksRunbookCollectionItemAssociationGroupResult',
    'GetRunbooksRunbookCollectionItemAssociationGroupPropertyResult',
    'GetRunbooksRunbookCollectionItemAssociationTaskResult',
    'GetRunbooksRunbookCollectionItemAssociationTaskOutputVariableMappingResult',
    'GetRunbooksRunbookCollectionItemAssociationTaskOutputVariableMappingOutputVariableDetailResult',
    'GetRunbooksRunbookCollectionItemAssociationTaskStepPropertyResult',
    'GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailResult',
    'GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailResult',
    'GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailContentResult',
    'GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailVariableResult',
    'GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailVariableInputVariableResult',
    'GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailPropertyResult',
    'GetSchedulerDefinitionActionGroupResult',
    'GetSchedulerDefinitionRunBookResult',
    'GetSchedulerDefinitionRunBookInputParameterResult',
    'GetSchedulerDefinitionRunBookInputParameterArgumentResult',
    'GetSchedulerDefinitionScheduleResult',
    'GetSchedulerDefinitionScheduledFleetsFilterResult',
    'GetSchedulerDefinitionScheduledFleetsScheduledFleetCollectionResult',
    'GetSchedulerDefinitionScheduledFleetsScheduledFleetCollectionItemResult',
    'GetSchedulerDefinitionsFilterResult',
    'GetSchedulerDefinitionsSchedulerDefinitionCollectionResult',
    'GetSchedulerDefinitionsSchedulerDefinitionCollectionItemResult',
    'GetSchedulerDefinitionsSchedulerDefinitionCollectionItemActionGroupResult',
    'GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookResult',
    'GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookInputParameterResult',
    'GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookInputParameterArgumentResult',
    'GetSchedulerDefinitionsSchedulerDefinitionCollectionItemScheduleResult',
    'GetTaskRecordDetailResult',
    'GetTaskRecordDetailExecutionDetailResult',
    'GetTaskRecordDetailExecutionDetailContentResult',
    'GetTaskRecordDetailExecutionDetailVariableResult',
    'GetTaskRecordDetailExecutionDetailVariableInputVariableResult',
    'GetTaskRecordDetailPropertyResult',
    'GetTaskRecordsFilterResult',
    'GetTaskRecordsTaskRecordCollectionResult',
    'GetTaskRecordsTaskRecordCollectionItemResult',
    'GetTaskRecordsTaskRecordCollectionItemDetailResult',
    'GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailResult',
    'GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailContentResult',
    'GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailVariableResult',
    'GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailVariableInputVariableResult',
    'GetTaskRecordsTaskRecordCollectionItemDetailPropertyResult',
]

@pulumi.output_type
class FleetCredentialEntitySpecifics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialLevel":
            suggest = "credential_level"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetCredentialEntitySpecifics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetCredentialEntitySpecifics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetCredentialEntitySpecifics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential_level: str,
                 resource_id: str,
                 target: str):
        """
        :param str credential_level: (Updatable) Credential Level.
        :param str resource_id: (Updatable) OCID of the resource associated with the target for which credential is created
        :param str target: (Updatable) Target associated with the Credential
        """
        pulumi.set(__self__, "credential_level", credential_level)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="credentialLevel")
    def credential_level(self) -> str:
        """
        (Updatable) Credential Level.
        """
        return pulumi.get(self, "credential_level")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        (Updatable) OCID of the resource associated with the target for which credential is created
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        (Updatable) Target associated with the Credential
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class FleetCredentialPassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialType":
            suggest = "credential_type"
        elif key == "keyId":
            suggest = "key_id"
        elif key == "keyVersion":
            suggest = "key_version"
        elif key == "secretId":
            suggest = "secret_id"
        elif key == "secretVersion":
            suggest = "secret_version"
        elif key == "vaultId":
            suggest = "vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetCredentialPassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetCredentialPassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetCredentialPassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential_type: str,
                 key_id: Optional[str] = None,
                 key_version: Optional[str] = None,
                 secret_id: Optional[str] = None,
                 secret_version: Optional[str] = None,
                 value: Optional[str] = None,
                 vault_id: Optional[str] = None):
        """
        :param str credential_type: (Updatable) Credential Type
        :param str key_id: (Updatable) OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        :param str key_version: (Updatable) The Vault Key version.
        :param str secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        :param str secret_version: (Updatable) The secret version.
        :param str value: (Updatable) The value corresponding to the credential
        :param str vault_id: (Updatable) OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
        pulumi.set(__self__, "credential_type", credential_type)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        """
        (Updatable) Credential Type
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[str]:
        """
        (Updatable) OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[str]:
        """
        (Updatable) The Vault Key version.
        """
        return pulumi.get(self, "key_version")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[str]:
        """
        (Updatable) The secret version.
        """
        return pulumi.get(self, "secret_version")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        (Updatable) The value corresponding to the credential
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[str]:
        """
        (Updatable) OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class FleetCredentialUser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialType":
            suggest = "credential_type"
        elif key == "keyId":
            suggest = "key_id"
        elif key == "keyVersion":
            suggest = "key_version"
        elif key == "secretId":
            suggest = "secret_id"
        elif key == "secretVersion":
            suggest = "secret_version"
        elif key == "vaultId":
            suggest = "vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetCredentialUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetCredentialUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetCredentialUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential_type: str,
                 key_id: Optional[str] = None,
                 key_version: Optional[str] = None,
                 secret_id: Optional[str] = None,
                 secret_version: Optional[str] = None,
                 value: Optional[str] = None,
                 vault_id: Optional[str] = None):
        """
        :param str credential_type: (Updatable) Credential Type
        :param str key_id: (Updatable) OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        :param str key_version: (Updatable) The Vault Key version.
        :param str secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        :param str secret_version: (Updatable) The secret version.
        :param str value: (Updatable) The value corresponding to the credential
        :param str vault_id: (Updatable) OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "credential_type", credential_type)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        """
        (Updatable) Credential Type
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[str]:
        """
        (Updatable) OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[str]:
        """
        (Updatable) The Vault Key version.
        """
        return pulumi.get(self, "key_version")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[str]:
        """
        (Updatable) The secret version.
        """
        return pulumi.get(self, "secret_version")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        (Updatable) The value corresponding to the credential
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[str]:
        """
        (Updatable) OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class FleetNotificationPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "topicId":
            suggest = "topic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetNotificationPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetNotificationPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetNotificationPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: str,
                 topic_id: str,
                 preferences: Optional['outputs.FleetNotificationPreferencesPreferences'] = None):
        """
        :param str compartment_id: (Updatable) Copartment Id of the topic where the notifications will be directed
        :param str topic_id: (Updatable) Topic Id where the notifications will be directed
        :param 'FleetNotificationPreferencesPreferencesArgs' preferences: (Updatable) Preferences to send notifications on the fleet activities
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "topic_id", topic_id)
        if preferences is not None:
            pulumi.set(__self__, "preferences", preferences)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        (Updatable) Copartment Id of the topic where the notifications will be directed
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        (Updatable) Topic Id where the notifications will be directed
        """
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter
    def preferences(self) -> Optional['outputs.FleetNotificationPreferencesPreferences']:
        """
        (Updatable) Preferences to send notifications on the fleet activities
        """
        return pulumi.get(self, "preferences")


@pulumi.output_type
class FleetNotificationPreferencesPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onJobFailure":
            suggest = "on_job_failure"
        elif key == "onTopologyModification":
            suggest = "on_topology_modification"
        elif key == "onUpcomingSchedule":
            suggest = "on_upcoming_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetNotificationPreferencesPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetNotificationPreferencesPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetNotificationPreferencesPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_job_failure: Optional[bool] = None,
                 on_topology_modification: Optional[bool] = None,
                 on_upcoming_schedule: Optional[bool] = None):
        """
        :param bool on_job_failure: (Updatable) Enables or disables notification on Job Failures.'
        :param bool on_topology_modification: (Updatable) Enables or disables notification on Environment Fleet Topology Modification.
        :param bool on_upcoming_schedule: (Updatable) Enables notification on upcoming schedule.
        """
        if on_job_failure is not None:
            pulumi.set(__self__, "on_job_failure", on_job_failure)
        if on_topology_modification is not None:
            pulumi.set(__self__, "on_topology_modification", on_topology_modification)
        if on_upcoming_schedule is not None:
            pulumi.set(__self__, "on_upcoming_schedule", on_upcoming_schedule)

    @property
    @pulumi.getter(name="onJobFailure")
    def on_job_failure(self) -> Optional[bool]:
        """
        (Updatable) Enables or disables notification on Job Failures.'
        """
        return pulumi.get(self, "on_job_failure")

    @property
    @pulumi.getter(name="onTopologyModification")
    def on_topology_modification(self) -> Optional[bool]:
        """
        (Updatable) Enables or disables notification on Environment Fleet Topology Modification.
        """
        return pulumi.get(self, "on_topology_modification")

    @property
    @pulumi.getter(name="onUpcomingSchedule")
    def on_upcoming_schedule(self) -> Optional[bool]:
        """
        (Updatable) Enables notification on upcoming schedule.
        """
        return pulumi.get(self, "on_upcoming_schedule")


@pulumi.output_type
class FleetRuleSelectionCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchCondition":
            suggest = "match_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetRuleSelectionCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetRuleSelectionCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetRuleSelectionCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_condition: str,
                 rules: Sequence['outputs.FleetRuleSelectionCriteriaRule']):
        """
        :param str match_condition: (Updatable) Rule selection match condition.
        :param Sequence['FleetRuleSelectionCriteriaRuleArgs'] rules: (Updatable) Rules.
        """
        pulumi.set(__self__, "match_condition", match_condition)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="matchCondition")
    def match_condition(self) -> str:
        """
        (Updatable) Rule selection match condition.
        """
        return pulumi.get(self, "match_condition")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.FleetRuleSelectionCriteriaRule']:
        """
        (Updatable) Rules.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class FleetRuleSelectionCriteriaRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "resourceCompartmentId":
            suggest = "resource_compartment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetRuleSelectionCriteriaRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetRuleSelectionCriteriaRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetRuleSelectionCriteriaRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: str,
                 conditions: Sequence['outputs.FleetRuleSelectionCriteriaRuleCondition'],
                 resource_compartment_id: str,
                 basis: Optional[str] = None):
        """
        :param str compartment_id: (Updatable) Please provide the root compartmentId (TenancyId).
        :param Sequence['FleetRuleSelectionCriteriaRuleConditionArgs'] conditions: (Updatable) Rule Conditions
        :param str resource_compartment_id: (Updatable) Resource Compartment Id.Provide the compartmentId the resource belongs to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param str basis: (Updatable) Rule to be be applied on.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "resource_compartment_id", resource_compartment_id)
        if basis is not None:
            pulumi.set(__self__, "basis", basis)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        (Updatable) Please provide the root compartmentId (TenancyId).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.FleetRuleSelectionCriteriaRuleCondition']:
        """
        (Updatable) Rule Conditions
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> str:
        """
        (Updatable) Resource Compartment Id.Provide the compartmentId the resource belongs to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_compartment_id")

    @property
    @pulumi.getter
    def basis(self) -> Optional[str]:
        """
        (Updatable) Rule to be be applied on.
        """
        return pulumi.get(self, "basis")


@pulumi.output_type
class FleetRuleSelectionCriteriaRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attrGroup":
            suggest = "attr_group"
        elif key == "attrKey":
            suggest = "attr_key"
        elif key == "attrValue":
            suggest = "attr_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetRuleSelectionCriteriaRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetRuleSelectionCriteriaRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetRuleSelectionCriteriaRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attr_group: str,
                 attr_key: str,
                 attr_value: str):
        """
        :param str attr_group: (Updatable) Attribute Group.
        :param str attr_key: (Updatable) Attribute Key.
        :param str attr_value: (Updatable) Attribute Value.
        """
        pulumi.set(__self__, "attr_group", attr_group)
        pulumi.set(__self__, "attr_key", attr_key)
        pulumi.set(__self__, "attr_value", attr_value)

    @property
    @pulumi.getter(name="attrGroup")
    def attr_group(self) -> str:
        """
        (Updatable) Attribute Group.
        """
        return pulumi.get(self, "attr_group")

    @property
    @pulumi.getter(name="attrKey")
    def attr_key(self) -> str:
        """
        (Updatable) Attribute Key.
        """
        return pulumi.get(self, "attr_key")

    @property
    @pulumi.getter(name="attrValue")
    def attr_value(self) -> str:
        """
        (Updatable) Attribute Value.
        """
        return pulumi.get(self, "attr_value")


@pulumi.output_type
class SchedulerDefinitionActionGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "runbookId":
            suggest = "runbook_id"
        elif key == "applicationType":
            suggest = "application_type"
        elif key == "lifecycleOperation":
            suggest = "lifecycle_operation"
        elif key == "targetId":
            suggest = "target_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulerDefinitionActionGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulerDefinitionActionGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulerDefinitionActionGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: str,
                 runbook_id: str,
                 application_type: Optional[str] = None,
                 lifecycle_operation: Optional[str] = None,
                 product: Optional[str] = None,
                 subjects: Optional[Sequence[str]] = None,
                 target_id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str resource_id: (Updatable) Provide the ID of the resource; Ex- fleetId.
        :param str runbook_id: (Updatable) ID of the runbook
        :param str application_type: (Updatable) Application Type associated. Only applicable if type is ENVIRONMENT.
        :param str lifecycle_operation: (Updatable) LifeCycle Operation
        :param str product: (Updatable) Product associated. Only applicable if type is PRODUCT.
        :param Sequence[str] subjects: (Updatable) Provide subjects that need to be considered for the schedule.
        :param str target_id: (Updatable) Provide the target if schedule is created against the target
        :param str type: (Updatable) ActionGroup Type associated.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "runbook_id", runbook_id)
        if application_type is not None:
            pulumi.set(__self__, "application_type", application_type)
        if lifecycle_operation is not None:
            pulumi.set(__self__, "lifecycle_operation", lifecycle_operation)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if subjects is not None:
            pulumi.set(__self__, "subjects", subjects)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        (Updatable) Provide the ID of the resource; Ex- fleetId.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> str:
        """
        (Updatable) ID of the runbook
        """
        return pulumi.get(self, "runbook_id")

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> Optional[str]:
        """
        (Updatable) Application Type associated. Only applicable if type is ENVIRONMENT.
        """
        return pulumi.get(self, "application_type")

    @property
    @pulumi.getter(name="lifecycleOperation")
    def lifecycle_operation(self) -> Optional[str]:
        """
        (Updatable) LifeCycle Operation
        """
        return pulumi.get(self, "lifecycle_operation")

    @property
    @pulumi.getter
    def product(self) -> Optional[str]:
        """
        (Updatable) Product associated. Only applicable if type is PRODUCT.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def subjects(self) -> Optional[Sequence[str]]:
        """
        (Updatable) Provide subjects that need to be considered for the schedule.
        """
        return pulumi.get(self, "subjects")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        """
        (Updatable) Provide the target if schedule is created against the target
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Updatable) ActionGroup Type associated.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SchedulerDefinitionRunBook(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputParameters":
            suggest = "input_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulerDefinitionRunBook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulerDefinitionRunBook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulerDefinitionRunBook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 input_parameters: Optional[Sequence['outputs.SchedulerDefinitionRunBookInputParameter']] = None):
        """
        :param str id: (Updatable) The ID of the Runbook
        :param Sequence['SchedulerDefinitionRunBookInputParameterArgs'] input_parameters: (Updatable) Input Parameters for the Task
        """
        pulumi.set(__self__, "id", id)
        if input_parameters is not None:
            pulumi.set(__self__, "input_parameters", input_parameters)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        (Updatable) The ID of the Runbook
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Optional[Sequence['outputs.SchedulerDefinitionRunBookInputParameter']]:
        """
        (Updatable) Input Parameters for the Task
        """
        return pulumi.get(self, "input_parameters")


@pulumi.output_type
class SchedulerDefinitionRunBookInputParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stepName":
            suggest = "step_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulerDefinitionRunBookInputParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulerDefinitionRunBookInputParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulerDefinitionRunBookInputParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 step_name: str,
                 arguments: Optional[Sequence['outputs.SchedulerDefinitionRunBookInputParameterArgument']] = None):
        """
        :param str step_name: (Updatable) stepName for which the input parameters are provided
        :param Sequence['SchedulerDefinitionRunBookInputParameterArgumentArgs'] arguments: (Updatable) Arguments for the Task
        """
        pulumi.set(__self__, "step_name", step_name)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> str:
        """
        (Updatable) stepName for which the input parameters are provided
        """
        return pulumi.get(self, "step_name")

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Sequence['outputs.SchedulerDefinitionRunBookInputParameterArgument']]:
        """
        (Updatable) Arguments for the Task
        """
        return pulumi.get(self, "arguments")


@pulumi.output_type
class SchedulerDefinitionRunBookInputParameterArgument(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: (Updatable) Name of the output variable
        :param str value: (Updatable) The task output
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) Name of the output variable
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        (Updatable) The task output
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SchedulerDefinitionSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionStartdate":
            suggest = "execution_startdate"
        elif key == "maintenanceWindowId":
            suggest = "maintenance_window_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulerDefinitionSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulerDefinitionSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulerDefinitionSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_startdate: str,
                 type: str,
                 duration: Optional[str] = None,
                 maintenance_window_id: Optional[str] = None,
                 recurrences: Optional[str] = None):
        """
        :param str execution_startdate: (Updatable) Start Date for the schedule. An RFC3339 formatted datetime string
        :param str type: (Updatable) Schedule Type
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param str duration: (Updatable) Duration if schedule type is Custom
        :param str maintenance_window_id: (Updatable) Provide MaintenanceWindowId if Schedule Type is Maintenance Window
        :param str recurrences: (Updatable) Recurrence rule specification if Schedule Type is Custom and Recurring
        """
        pulumi.set(__self__, "execution_startdate", execution_startdate)
        pulumi.set(__self__, "type", type)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if maintenance_window_id is not None:
            pulumi.set(__self__, "maintenance_window_id", maintenance_window_id)
        if recurrences is not None:
            pulumi.set(__self__, "recurrences", recurrences)

    @property
    @pulumi.getter(name="executionStartdate")
    def execution_startdate(self) -> str:
        """
        (Updatable) Start Date for the schedule. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "execution_startdate")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) Schedule Type


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def duration(self) -> Optional[str]:
        """
        (Updatable) Duration if schedule type is Custom
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="maintenanceWindowId")
    def maintenance_window_id(self) -> Optional[str]:
        """
        (Updatable) Provide MaintenanceWindowId if Schedule Type is Maintenance Window
        """
        return pulumi.get(self, "maintenance_window_id")

    @property
    @pulumi.getter
    def recurrences(self) -> Optional[str]:
        """
        (Updatable) Recurrence rule specification if Schedule Type is Custom and Recurring
        """
        return pulumi.get(self, "recurrences")


@pulumi.output_type
class GetAnnouncementsAnnouncementCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAnnouncementsAnnouncementCollectionItemResult']):
        """
        :param Sequence['GetAnnouncementsAnnouncementCollectionItemArgs'] items: List of AnnouncementSummary items
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAnnouncementsAnnouncementCollectionItemResult']:
        """
        List of AnnouncementSummary items
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAnnouncementsAnnouncementCollectionItemResult(dict):
    def __init__(__self__, *,
                 announcement_end: str,
                 announcement_start: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 description: str,
                 details: str,
                 display_name: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 resource_region: str,
                 state: str,
                 summary: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str,
                 type: str,
                 url: str):
        """
        :param str announcement_end: Date to end displaying annonucement to user
        :param str announcement_start: Date to start displaying announcement to user
        :param str compartment_id: Tenancy OCID
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param str details: Details of the announcement
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The OCID of the resource.
        :param str resource_region: Associated region
        :param str state: The lifecycle state of the announcement.
        :param str summary: Summary of the announcement
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param str type: Type of announcement
        :param str url: URL to the announcement
        """
        pulumi.set(__self__, "announcement_end", announcement_end)
        pulumi.set(__self__, "announcement_start", announcement_start)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_region", resource_region)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "summary", summary)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="announcementEnd")
    def announcement_end(self) -> str:
        """
        Date to end displaying annonucement to user
        """
        return pulumi.get(self, "announcement_end")

    @property
    @pulumi.getter(name="announcementStart")
    def announcement_start(self) -> str:
        """
        Date to start displaying announcement to user
        """
        return pulumi.get(self, "announcement_start")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def details(self) -> str:
        """
        Details of the announcement
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the announcement.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def summary(self) -> str:
        """
        Summary of the announcement
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of announcement
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL to the announcement
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetAnnouncementsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFleetComplianceReportResourceResult(dict):
    def __init__(__self__, *,
                 compartment: str,
                 compliance_state: str,
                 products: Sequence['outputs.GetFleetComplianceReportResourceProductResult'],
                 resource_id: str,
                 resource_name: str,
                 resource_region: str,
                 resource_type: str,
                 tenancy_id: str,
                 tenancy_name: str):
        """
        :param str compartment: Compartment the resource belongs to.
        :param str compliance_state: Last known compliance state of target.
        :param Sequence['GetFleetComplianceReportResourceProductArgs'] products: Products assocaited with the Fleet.Only products belonging to managed targets will be shown.
        :param str resource_id: The OCID to identify the resource.
        :param str resource_name: Display name of the resource.
        :param str resource_region: Region the resource belongs to.
        :param str resource_type: Type of the resource.
        :param str tenancy_id: TenancyId of the resource.
        :param str tenancy_name: Tenancy the resource belongs to.
        """
        pulumi.set(__self__, "compartment", compartment)
        pulumi.set(__self__, "compliance_state", compliance_state)
        pulumi.set(__self__, "products", products)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_region", resource_region)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "tenancy_name", tenancy_name)

    @property
    @pulumi.getter
    def compartment(self) -> str:
        """
        Compartment the resource belongs to.
        """
        return pulumi.get(self, "compartment")

    @property
    @pulumi.getter(name="complianceState")
    def compliance_state(self) -> str:
        """
        Last known compliance state of target.
        """
        return pulumi.get(self, "compliance_state")

    @property
    @pulumi.getter
    def products(self) -> Sequence['outputs.GetFleetComplianceReportResourceProductResult']:
        """
        Products assocaited with the Fleet.Only products belonging to managed targets will be shown.
        """
        return pulumi.get(self, "products")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The OCID to identify the resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        Display name of the resource.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> str:
        """
        Region the resource belongs to.
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        TenancyId of the resource.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="tenancyName")
    def tenancy_name(self) -> str:
        """
        Tenancy the resource belongs to.
        """
        return pulumi.get(self, "tenancy_name")


@pulumi.output_type
class GetFleetComplianceReportResourceProductResult(dict):
    def __init__(__self__, *,
                 product_name: str,
                 targets: Sequence['outputs.GetFleetComplianceReportResourceProductTargetResult']):
        """
        :param str product_name: Product Name
        :param Sequence['GetFleetComplianceReportResourceProductTargetArgs'] targets: Managed Targets associated with the Product.
        """
        pulumi.set(__self__, "product_name", product_name)
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> str:
        """
        Product Name
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetFleetComplianceReportResourceProductTargetResult']:
        """
        Managed Targets associated with the Product.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class GetFleetComplianceReportResourceProductTargetResult(dict):
    def __init__(__self__, *,
                 compliance_state: str,
                 installed_patches: Sequence['outputs.GetFleetComplianceReportResourceProductTargetInstalledPatchResult'],
                 recommended_patches: Sequence['outputs.GetFleetComplianceReportResourceProductTargetRecommendedPatchResult'],
                 target_id: str,
                 target_name: str,
                 version: str):
        """
        :param str compliance_state: Last known compliance state of target.
        :param Sequence['GetFleetComplianceReportResourceProductTargetInstalledPatchArgs'] installed_patches: Installed Patches for the Target.
        :param Sequence['GetFleetComplianceReportResourceProductTargetRecommendedPatchArgs'] recommended_patches: Recommended Patches for the Target.
        :param str target_id: Target Identifier.
        :param str target_name: Target Name.
        :param str version: Current version.
        """
        pulumi.set(__self__, "compliance_state", compliance_state)
        pulumi.set(__self__, "installed_patches", installed_patches)
        pulumi.set(__self__, "recommended_patches", recommended_patches)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_name", target_name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="complianceState")
    def compliance_state(self) -> str:
        """
        Last known compliance state of target.
        """
        return pulumi.get(self, "compliance_state")

    @property
    @pulumi.getter(name="installedPatches")
    def installed_patches(self) -> Sequence['outputs.GetFleetComplianceReportResourceProductTargetInstalledPatchResult']:
        """
        Installed Patches for the Target.
        """
        return pulumi.get(self, "installed_patches")

    @property
    @pulumi.getter(name="recommendedPatches")
    def recommended_patches(self) -> Sequence['outputs.GetFleetComplianceReportResourceProductTargetRecommendedPatchResult']:
        """
        Recommended Patches for the Target.
        """
        return pulumi.get(self, "recommended_patches")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        Target Identifier.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> str:
        """
        Target Name.
        """
        return pulumi.get(self, "target_name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Current version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFleetComplianceReportResourceProductTargetInstalledPatchResult(dict):
    def __init__(__self__, *,
                 patch_description: str,
                 patch_name: str,
                 patch_type: str,
                 time_applied: str,
                 time_released: str):
        """
        :param str patch_description: The OCID of the work request to start the analysis.
        :param str patch_name: The OCID to identify this analysis results.
        :param str patch_type: Type of patch.
        :param str time_applied: Time the patch was applied
        :param str time_released: Date on which patch was released.
        """
        pulumi.set(__self__, "patch_description", patch_description)
        pulumi.set(__self__, "patch_name", patch_name)
        pulumi.set(__self__, "patch_type", patch_type)
        pulumi.set(__self__, "time_applied", time_applied)
        pulumi.set(__self__, "time_released", time_released)

    @property
    @pulumi.getter(name="patchDescription")
    def patch_description(self) -> str:
        """
        The OCID of the work request to start the analysis.
        """
        return pulumi.get(self, "patch_description")

    @property
    @pulumi.getter(name="patchName")
    def patch_name(self) -> str:
        """
        The OCID to identify this analysis results.
        """
        return pulumi.get(self, "patch_name")

    @property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> str:
        """
        Type of patch.
        """
        return pulumi.get(self, "patch_type")

    @property
    @pulumi.getter(name="timeApplied")
    def time_applied(self) -> str:
        """
        Time the patch was applied
        """
        return pulumi.get(self, "time_applied")

    @property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> str:
        """
        Date on which patch was released.
        """
        return pulumi.get(self, "time_released")


@pulumi.output_type
class GetFleetComplianceReportResourceProductTargetRecommendedPatchResult(dict):
    def __init__(__self__, *,
                 patch_description: str,
                 patch_name: str,
                 patch_type: str,
                 time_applied: str,
                 time_released: str):
        """
        :param str patch_description: The OCID of the work request to start the analysis.
        :param str patch_name: The OCID to identify this analysis results.
        :param str patch_type: Type of patch.
        :param str time_applied: Time the patch was applied
        :param str time_released: Date on which patch was released.
        """
        pulumi.set(__self__, "patch_description", patch_description)
        pulumi.set(__self__, "patch_name", patch_name)
        pulumi.set(__self__, "patch_type", patch_type)
        pulumi.set(__self__, "time_applied", time_applied)
        pulumi.set(__self__, "time_released", time_released)

    @property
    @pulumi.getter(name="patchDescription")
    def patch_description(self) -> str:
        """
        The OCID of the work request to start the analysis.
        """
        return pulumi.get(self, "patch_description")

    @property
    @pulumi.getter(name="patchName")
    def patch_name(self) -> str:
        """
        The OCID to identify this analysis results.
        """
        return pulumi.get(self, "patch_name")

    @property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> str:
        """
        Type of patch.
        """
        return pulumi.get(self, "patch_type")

    @property
    @pulumi.getter(name="timeApplied")
    def time_applied(self) -> str:
        """
        Time the patch was applied
        """
        return pulumi.get(self, "time_applied")

    @property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> str:
        """
        Date on which patch was released.
        """
        return pulumi.get(self, "time_released")


@pulumi.output_type
class GetFleetCredentialEntitySpecificResult(dict):
    def __init__(__self__, *,
                 credential_level: str,
                 resource_id: str,
                 target: str):
        """
        :param str credential_level: Credential Level.
        :param str resource_id: OCID of the resource associated with the target for which credential is created
        :param str target: Target associated with the Credential
        """
        pulumi.set(__self__, "credential_level", credential_level)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="credentialLevel")
    def credential_level(self) -> str:
        """
        Credential Level.
        """
        return pulumi.get(self, "credential_level")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        OCID of the resource associated with the target for which credential is created
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Target associated with the Credential
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class GetFleetCredentialPasswordResult(dict):
    def __init__(__self__, *,
                 credential_type: str,
                 key_id: str,
                 key_version: str,
                 secret_id: str,
                 secret_version: str,
                 value: str,
                 vault_id: str):
        """
        :param str credential_type: Credential Type
        :param str key_id: OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        :param str key_version: The Vault Key version.
        :param str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        :param str secret_version: The secret version.
        :param str value: The value corresponding to the credential
        :param str vault_id: OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
        pulumi.set(__self__, "credential_type", credential_type)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_version", key_version)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "secret_version", secret_version)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        """
        Credential Type
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> str:
        """
        The Vault Key version.
        """
        return pulumi.get(self, "key_version")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> str:
        """
        The secret version.
        """
        return pulumi.get(self, "secret_version")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value corresponding to the credential
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetFleetCredentialUserResult(dict):
    def __init__(__self__, *,
                 credential_type: str,
                 key_id: str,
                 key_version: str,
                 secret_id: str,
                 secret_version: str,
                 value: str,
                 vault_id: str):
        """
        :param str credential_type: Credential Type
        :param str key_id: OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        :param str key_version: The Vault Key version.
        :param str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        :param str secret_version: The secret version.
        :param str value: The value corresponding to the credential
        :param str vault_id: OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
        pulumi.set(__self__, "credential_type", credential_type)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_version", key_version)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "secret_version", secret_version)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        """
        Credential Type
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> str:
        """
        The Vault Key version.
        """
        return pulumi.get(self, "key_version")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> str:
        """
        The secret version.
        """
        return pulumi.get(self, "secret_version")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value corresponding to the credential
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetFleetCredentialsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFleetCredentialsFleetCredentialCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFleetCredentialsFleetCredentialCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFleetCredentialsFleetCredentialCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFleetCredentialsFleetCredentialCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 display_name: str,
                 entity_specifics: Sequence['outputs.GetFleetCredentialsFleetCredentialCollectionItemEntitySpecificResult'],
                 fleet_id: str,
                 id: str,
                 lifecycle_details: str,
                 passwords: Sequence['outputs.GetFleetCredentialsFleetCredentialCollectionItemPasswordResult'],
                 state: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str,
                 users: Sequence['outputs.GetFleetCredentialsFleetCredentialCollectionItemUserResult']):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Sequence['GetFleetCredentialsFleetCredentialCollectionItemEntitySpecificArgs'] entity_specifics: Credential Details
        :param str fleet_id: unique Fleet identifier
        :param str id: unique FleetCredential identifier
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence['GetFleetCredentialsFleetCredentialCollectionItemPasswordArgs'] passwords: Credential Details
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param Sequence['GetFleetCredentialsFleetCredentialCollectionItemUserArgs'] users: Credential Details
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "entity_specifics", entity_specifics)
        pulumi.set(__self__, "fleet_id", fleet_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "passwords", passwords)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="entitySpecifics")
    def entity_specifics(self) -> Sequence['outputs.GetFleetCredentialsFleetCredentialCollectionItemEntitySpecificResult']:
        """
        Credential Details
        """
        return pulumi.get(self, "entity_specifics")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        """
        unique Fleet identifier
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique FleetCredential identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def passwords(self) -> Sequence['outputs.GetFleetCredentialsFleetCredentialCollectionItemPasswordResult']:
        """
        Credential Details
        """
        return pulumi.get(self, "passwords")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetFleetCredentialsFleetCredentialCollectionItemUserResult']:
        """
        Credential Details
        """
        return pulumi.get(self, "users")


@pulumi.output_type
class GetFleetCredentialsFleetCredentialCollectionItemEntitySpecificResult(dict):
    def __init__(__self__, *,
                 credential_level: str,
                 resource_id: str,
                 target: str):
        """
        :param str credential_level: Credential Level.
        :param str resource_id: OCID of the resource associated with the target for which credential is created
        :param str target: Target associated with the Credential
        """
        pulumi.set(__self__, "credential_level", credential_level)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="credentialLevel")
    def credential_level(self) -> str:
        """
        Credential Level.
        """
        return pulumi.get(self, "credential_level")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        OCID of the resource associated with the target for which credential is created
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Target associated with the Credential
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class GetFleetCredentialsFleetCredentialCollectionItemPasswordResult(dict):
    def __init__(__self__, *,
                 credential_type: str,
                 key_id: str,
                 key_version: str,
                 secret_id: str,
                 secret_version: str,
                 value: str,
                 vault_id: str):
        """
        :param str credential_type: Credential Type
        :param str key_id: OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        :param str key_version: The Vault Key version.
        :param str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        :param str secret_version: The secret version.
        :param str value: The value corresponding to the credential
        :param str vault_id: OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
        pulumi.set(__self__, "credential_type", credential_type)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_version", key_version)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "secret_version", secret_version)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        """
        Credential Type
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> str:
        """
        The Vault Key version.
        """
        return pulumi.get(self, "key_version")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> str:
        """
        The secret version.
        """
        return pulumi.get(self, "secret_version")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value corresponding to the credential
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetFleetCredentialsFleetCredentialCollectionItemUserResult(dict):
    def __init__(__self__, *,
                 credential_type: str,
                 key_id: str,
                 key_version: str,
                 secret_id: str,
                 secret_version: str,
                 value: str,
                 vault_id: str):
        """
        :param str credential_type: Credential Type
        :param str key_id: OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        :param str key_version: The Vault Key version.
        :param str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        :param str secret_version: The secret version.
        :param str value: The value corresponding to the credential
        :param str vault_id: OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
        pulumi.set(__self__, "credential_type", credential_type)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_version", key_version)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "secret_version", secret_version)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        """
        Credential Type
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> str:
        """
        The Vault Key version.
        """
        return pulumi.get(self, "key_version")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> str:
        """
        The secret version.
        """
        return pulumi.get(self, "secret_version")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value corresponding to the credential
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetFleetNotificationPreferenceResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 preferences: Sequence['outputs.GetFleetNotificationPreferencePreferenceResult'],
                 topic_id: str):
        """
        :param str compartment_id: Please provide the root compartmentId (TenancyId).
        :param Sequence['GetFleetNotificationPreferencePreferenceArgs'] preferences: Preferences to send notifications on the fleet activities
        :param str topic_id: Topic Id where the notifications will be directed
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "preferences", preferences)
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Please provide the root compartmentId (TenancyId).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def preferences(self) -> Sequence['outputs.GetFleetNotificationPreferencePreferenceResult']:
        """
        Preferences to send notifications on the fleet activities
        """
        return pulumi.get(self, "preferences")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        Topic Id where the notifications will be directed
        """
        return pulumi.get(self, "topic_id")


@pulumi.output_type
class GetFleetNotificationPreferencePreferenceResult(dict):
    def __init__(__self__, *,
                 on_job_failure: bool,
                 on_topology_modification: bool,
                 on_upcoming_schedule: bool):
        """
        :param bool on_job_failure: Enables or disables notification on Job Failures.'
        :param bool on_topology_modification: Enables or disables notification on Environment Fleet Topology Modification.
        :param bool on_upcoming_schedule: Enables notification on upcoming schedule.
        """
        pulumi.set(__self__, "on_job_failure", on_job_failure)
        pulumi.set(__self__, "on_topology_modification", on_topology_modification)
        pulumi.set(__self__, "on_upcoming_schedule", on_upcoming_schedule)

    @property
    @pulumi.getter(name="onJobFailure")
    def on_job_failure(self) -> bool:
        """
        Enables or disables notification on Job Failures.'
        """
        return pulumi.get(self, "on_job_failure")

    @property
    @pulumi.getter(name="onTopologyModification")
    def on_topology_modification(self) -> bool:
        """
        Enables or disables notification on Environment Fleet Topology Modification.
        """
        return pulumi.get(self, "on_topology_modification")

    @property
    @pulumi.getter(name="onUpcomingSchedule")
    def on_upcoming_schedule(self) -> bool:
        """
        Enables notification on upcoming schedule.
        """
        return pulumi.get(self, "on_upcoming_schedule")


@pulumi.output_type
class GetFleetProductsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFleetProductsFleetProductCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFleetProductsFleetProductCollectionItemResult']):
        """
        :param Sequence['GetFleetProductsFleetProductCollectionItemArgs'] items: List of fleetProducts.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFleetProductsFleetProductCollectionItemResult']:
        """
        List of fleetProducts.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFleetProductsFleetProductCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 display_name: str,
                 resources: Sequence['outputs.GetFleetProductsFleetProductCollectionItemResourceResult'],
                 system_tags: Mapping[str, str],
                 target_count: int):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Sequence['GetFleetProductsFleetProductCollectionItemResourceArgs'] resources: Resource Information for the Target
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param int target_count: Count of targets associated with the Product
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "target_count", target_count)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetFleetProductsFleetProductCollectionItemResourceResult']:
        """
        Resource Information for the Target
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetCount")
    def target_count(self) -> int:
        """
        Count of targets associated with the Product
        """
        return pulumi.get(self, "target_count")


@pulumi.output_type
class GetFleetProductsFleetProductCollectionItemResourceResult(dict):
    def __init__(__self__, *,
                 resource_display_name: str,
                 resource_id: str):
        """
        :param str resource_display_name: Resource Display Name
        :param str resource_id: Resource Identifier
        """
        pulumi.set(__self__, "resource_display_name", resource_display_name)
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="resourceDisplayName")
    def resource_display_name(self) -> str:
        """
        Resource Display Name
        """
        return pulumi.get(self, "resource_display_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        Resource Identifier
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class GetFleetPropertiesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFleetPropertiesFleetPropertyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFleetPropertiesFleetPropertyCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFleetPropertiesFleetPropertyCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFleetPropertiesFleetPropertyCollectionItemResult(dict):
    def __init__(__self__, *,
                 allowed_values: Sequence[str],
                 compartment_id: str,
                 display_name: str,
                 fleet_id: str,
                 id: str,
                 property_id: str,
                 selection_type: str,
                 state: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str,
                 value: str,
                 value_type: str):
        """
        :param Sequence[str] allowed_values: Values of the category (must be a single value if selection = 'single choice')
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str fleet_id: unique Fleet identifier
        :param str id: unique FleetProperty identifier
        :param str property_id: Property Id Ocid.
        :param str selection_type: Text selection of the category
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param str value: Value of the Property
        :param str value_type: Format of the value
        """
        pulumi.set(__self__, "allowed_values", allowed_values)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "fleet_id", fleet_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "property_id", property_id)
        pulumi.set(__self__, "selection_type", selection_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Sequence[str]:
        """
        Values of the category (must be a single value if selection = 'single choice')
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        """
        unique Fleet identifier
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique FleetProperty identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> str:
        """
        Property Id Ocid.
        """
        return pulumi.get(self, "property_id")

    @property
    @pulumi.getter(name="selectionType")
    def selection_type(self) -> str:
        """
        Text selection of the category
        """
        return pulumi.get(self, "selection_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the Property
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        Format of the value
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetFleetResourcesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFleetResourcesFleetResourceCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFleetResourcesFleetResourceCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFleetResourcesFleetResourceCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFleetResourcesFleetResourceCollectionItemResult(dict):
    def __init__(__self__, *,
                 application_type: str,
                 compartment: str,
                 compartment_id: str,
                 compliance_state: str,
                 display_name: str,
                 environment_type: str,
                 fleet_id: str,
                 id: str,
                 lifecycle_details: str,
                 product: str,
                 product_count: int,
                 resource_id: str,
                 resource_region: str,
                 resource_type: str,
                 state: str,
                 system_tags: Mapping[str, str],
                 target_count: int,
                 tenancy_id: str,
                 tenancy_name: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str application_type: Application Type associated with the resource when resource type is fleet.Will only be returned for ENVIRONMENT fleets that are part of a GROUP Fleet.
        :param str compartment: Resource Compartment
        :param str compartment_id: OCID of the compartment to which the resource belongs to.
        :param str compliance_state: Compliance State of the Resource
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str environment_type: Environment Type associated with the Fleet when resource type is fleet.Will only be returned for ENVIRONMENT fleets that are part of a GROUP Fleet.
        :param str fleet_id: unique Fleet identifier
        :param str id: unique FleetResource identifier
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str product: Product associated with the resource when resource type is fleet.Will only be returned for PRODUCT fleets that are part of a GROUP Fleet
        :param int product_count: Count of products within the resource.
        :param str resource_id: The OCID of the resource.
        :param str resource_region: Associated region
        :param str resource_type: Type of the Resource.
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param int target_count: Count of targets  within the resource.
        :param str tenancy_id: Resource Tenancy Id
        :param str tenancy_name: Resource Tenancy Name
        :param str time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "application_type", application_type)
        pulumi.set(__self__, "compartment", compartment)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compliance_state", compliance_state)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "environment_type", environment_type)
        pulumi.set(__self__, "fleet_id", fleet_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "product_count", product_count)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_region", resource_region)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "target_count", target_count)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "tenancy_name", tenancy_name)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> str:
        """
        Application Type associated with the resource when resource type is fleet.Will only be returned for ENVIRONMENT fleets that are part of a GROUP Fleet.
        """
        return pulumi.get(self, "application_type")

    @property
    @pulumi.getter
    def compartment(self) -> str:
        """
        Resource Compartment
        """
        return pulumi.get(self, "compartment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        OCID of the compartment to which the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="complianceState")
    def compliance_state(self) -> str:
        """
        Compliance State of the Resource
        """
        return pulumi.get(self, "compliance_state")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> str:
        """
        Environment Type associated with the Fleet when resource type is fleet.Will only be returned for ENVIRONMENT fleets that are part of a GROUP Fleet.
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        """
        unique Fleet identifier
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique FleetResource identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def product(self) -> str:
        """
        Product associated with the resource when resource type is fleet.Will only be returned for PRODUCT fleets that are part of a GROUP Fleet
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="productCount")
    def product_count(self) -> int:
        """
        Count of products within the resource.
        """
        return pulumi.get(self, "product_count")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of the Resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetCount")
    def target_count(self) -> int:
        """
        Count of targets  within the resource.
        """
        return pulumi.get(self, "target_count")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        Resource Tenancy Id
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="tenancyName")
    def tenancy_name(self) -> str:
        """
        Resource Tenancy Name
        """
        return pulumi.get(self, "tenancy_name")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetFleetRuleSelectionCriteriaResult(dict):
    def __init__(__self__, *,
                 match_condition: str,
                 rules: Sequence['outputs.GetFleetRuleSelectionCriteriaRuleResult']):
        """
        :param str match_condition: Rule selection match condition.
        :param Sequence['GetFleetRuleSelectionCriteriaRuleArgs'] rules: Rules.
        """
        pulumi.set(__self__, "match_condition", match_condition)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="matchCondition")
    def match_condition(self) -> str:
        """
        Rule selection match condition.
        """
        return pulumi.get(self, "match_condition")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetFleetRuleSelectionCriteriaRuleResult']:
        """
        Rules.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class GetFleetRuleSelectionCriteriaRuleResult(dict):
    def __init__(__self__, *,
                 basis: str,
                 compartment_id: str,
                 conditions: Sequence['outputs.GetFleetRuleSelectionCriteriaRuleConditionResult'],
                 resource_compartment_id: str):
        """
        :param str basis: Rule to be be applied on.
        :param str compartment_id: Please provide the root compartmentId (TenancyId).
        :param Sequence['GetFleetRuleSelectionCriteriaRuleConditionArgs'] conditions: Rule Conditions
        :param str resource_compartment_id: Resource Compartment Id.Provide the compartmentId the resource belongs to.
        """
        pulumi.set(__self__, "basis", basis)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "resource_compartment_id", resource_compartment_id)

    @property
    @pulumi.getter
    def basis(self) -> str:
        """
        Rule to be be applied on.
        """
        return pulumi.get(self, "basis")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Please provide the root compartmentId (TenancyId).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetFleetRuleSelectionCriteriaRuleConditionResult']:
        """
        Rule Conditions
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> str:
        """
        Resource Compartment Id.Provide the compartmentId the resource belongs to.
        """
        return pulumi.get(self, "resource_compartment_id")


@pulumi.output_type
class GetFleetRuleSelectionCriteriaRuleConditionResult(dict):
    def __init__(__self__, *,
                 attr_group: str,
                 attr_key: str,
                 attr_value: str):
        """
        :param str attr_group: Attribute Group.
        :param str attr_key: Attribute Key.
        :param str attr_value: Attribute Value.
        """
        pulumi.set(__self__, "attr_group", attr_group)
        pulumi.set(__self__, "attr_key", attr_key)
        pulumi.set(__self__, "attr_value", attr_value)

    @property
    @pulumi.getter(name="attrGroup")
    def attr_group(self) -> str:
        """
        Attribute Group.
        """
        return pulumi.get(self, "attr_group")

    @property
    @pulumi.getter(name="attrKey")
    def attr_key(self) -> str:
        """
        Attribute Key.
        """
        return pulumi.get(self, "attr_key")

    @property
    @pulumi.getter(name="attrValue")
    def attr_value(self) -> str:
        """
        Attribute Value.
        """
        return pulumi.get(self, "attr_value")


@pulumi.output_type
class GetFleetTargetsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFleetTargetsFleetTargetCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFleetTargetsFleetTargetCollectionItemResult']):
        """
        :param Sequence['GetFleetTargetsFleetTargetCollectionItemArgs'] items: List of fleetTargets.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFleetTargetsFleetTargetCollectionItemResult']:
        """
        List of fleetTargets.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFleetTargetsFleetTargetCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 compliance_state: str,
                 display_name: str,
                 id: str,
                 product: str,
                 resources: Sequence['outputs.GetFleetTargetsFleetTargetCollectionItemResourceResult'],
                 state: str,
                 system_tags: Mapping[str, str],
                 version: str):
        """
        :param str compartment_id: Tenancy OCID
        :param str compliance_state: Last known compliance state of Target.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str id: The OCID of the resource.
        :param str product: Product Name
        :param Sequence['GetFleetTargetsFleetTargetCollectionItemResourceArgs'] resources: Resource Information for the Target
        :param str state: The current state of the FleetTarget.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str version: Current version of Target
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compliance_state", compliance_state)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="complianceState")
    def compliance_state(self) -> str:
        """
        Last known compliance state of Target.
        """
        return pulumi.get(self, "compliance_state")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def product(self) -> str:
        """
        Product Name
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetFleetTargetsFleetTargetCollectionItemResourceResult']:
        """
        Resource Information for the Target
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the FleetTarget.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Current version of Target
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFleetTargetsFleetTargetCollectionItemResourceResult(dict):
    def __init__(__self__, *,
                 resource_display_name: str,
                 resource_id: str):
        """
        :param str resource_display_name: Resource Display Name
        :param str resource_id: Resource Identifier
        """
        pulumi.set(__self__, "resource_display_name", resource_display_name)
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="resourceDisplayName")
    def resource_display_name(self) -> str:
        """
        Resource Display Name
        """
        return pulumi.get(self, "resource_display_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        Resource Identifier
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class GetFleetsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFleetsFleetCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFleetsFleetCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFleetsFleetCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFleetsFleetCollectionItemResult(dict):
    def __init__(__self__, *,
                 application_type: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 description: str,
                 display_name: str,
                 environment_type: str,
                 fleet_type: str,
                 freeform_tags: Mapping[str, str],
                 group_type: str,
                 id: str,
                 is_target_auto_confirm: bool,
                 lifecycle_details: str,
                 notification_preferences: Sequence['outputs.GetFleetsFleetCollectionItemNotificationPreferenceResult'],
                 products: Sequence[str],
                 resource_region: str,
                 resource_selection_type: str,
                 rule_selection_criterias: Sequence['outputs.GetFleetsFleetCollectionItemRuleSelectionCriteriaResult'],
                 state: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str):
        """
        :param str application_type: A filter to return only resources that match the Application Type given.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str environment_type: A filter to return only resources that match the Environment Type given.
        :param str fleet_type: A filter to return only resources their fleetType matches the given fleetType.
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str group_type: Group Type associated with Group Fleet.Applicable for GROUP fleet types.
        :param str id: unique Fleet identifier
        :param bool is_target_auto_confirm: A value which represents if auto confirming of the targets can be enabled
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence['GetFleetsFleetCollectionItemNotificationPreferenceArgs'] notification_preferences: Conditions when met to send notifications on the fleet activities
        :param Sequence[str] products: Products associated with the Fleet
        :param str resource_region: Associated region
        :param str resource_selection_type: Type of resource selection in a fleet.
        :param Sequence['GetFleetsFleetCollectionItemRuleSelectionCriteriaArgs'] rule_selection_criterias: Rule Selection Criteria
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "application_type", application_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "environment_type", environment_type)
        pulumi.set(__self__, "fleet_type", fleet_type)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "group_type", group_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_target_auto_confirm", is_target_auto_confirm)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "notification_preferences", notification_preferences)
        pulumi.set(__self__, "products", products)
        pulumi.set(__self__, "resource_region", resource_region)
        pulumi.set(__self__, "resource_selection_type", resource_selection_type)
        pulumi.set(__self__, "rule_selection_criterias", rule_selection_criterias)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> str:
        """
        A filter to return only resources that match the Application Type given.
        """
        return pulumi.get(self, "application_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> str:
        """
        A filter to return only resources that match the Environment Type given.
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> str:
        """
        A filter to return only resources their fleetType matches the given fleetType.
        """
        return pulumi.get(self, "fleet_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> str:
        """
        Group Type associated with Group Fleet.Applicable for GROUP fleet types.
        """
        return pulumi.get(self, "group_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique Fleet identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isTargetAutoConfirm")
    def is_target_auto_confirm(self) -> bool:
        """
        A value which represents if auto confirming of the targets can be enabled
        """
        return pulumi.get(self, "is_target_auto_confirm")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="notificationPreferences")
    def notification_preferences(self) -> Sequence['outputs.GetFleetsFleetCollectionItemNotificationPreferenceResult']:
        """
        Conditions when met to send notifications on the fleet activities
        """
        return pulumi.get(self, "notification_preferences")

    @property
    @pulumi.getter
    def products(self) -> Sequence[str]:
        """
        Products associated with the Fleet
        """
        return pulumi.get(self, "products")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter(name="resourceSelectionType")
    def resource_selection_type(self) -> str:
        """
        Type of resource selection in a fleet.
        """
        return pulumi.get(self, "resource_selection_type")

    @property
    @pulumi.getter(name="ruleSelectionCriterias")
    def rule_selection_criterias(self) -> Sequence['outputs.GetFleetsFleetCollectionItemRuleSelectionCriteriaResult']:
        """
        Rule Selection Criteria
        """
        return pulumi.get(self, "rule_selection_criterias")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetFleetsFleetCollectionItemNotificationPreferenceResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 preferences: Sequence['outputs.GetFleetsFleetCollectionItemNotificationPreferencePreferenceResult'],
                 topic_id: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetFleetsFleetCollectionItemNotificationPreferencePreferenceArgs'] preferences: Preferences to send notifications on the fleet activities
        :param str topic_id: Topic Id where the notifications will be directed
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "preferences", preferences)
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def preferences(self) -> Sequence['outputs.GetFleetsFleetCollectionItemNotificationPreferencePreferenceResult']:
        """
        Preferences to send notifications on the fleet activities
        """
        return pulumi.get(self, "preferences")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        Topic Id where the notifications will be directed
        """
        return pulumi.get(self, "topic_id")


@pulumi.output_type
class GetFleetsFleetCollectionItemNotificationPreferencePreferenceResult(dict):
    def __init__(__self__, *,
                 on_job_failure: bool,
                 on_topology_modification: bool,
                 on_upcoming_schedule: bool):
        """
        :param bool on_job_failure: Enables or disables notification on Job Failures.'
        :param bool on_topology_modification: Enables or disables notification on Environment Fleet Topology Modification.
        :param bool on_upcoming_schedule: Enables notification on upcoming schedule.
        """
        pulumi.set(__self__, "on_job_failure", on_job_failure)
        pulumi.set(__self__, "on_topology_modification", on_topology_modification)
        pulumi.set(__self__, "on_upcoming_schedule", on_upcoming_schedule)

    @property
    @pulumi.getter(name="onJobFailure")
    def on_job_failure(self) -> bool:
        """
        Enables or disables notification on Job Failures.'
        """
        return pulumi.get(self, "on_job_failure")

    @property
    @pulumi.getter(name="onTopologyModification")
    def on_topology_modification(self) -> bool:
        """
        Enables or disables notification on Environment Fleet Topology Modification.
        """
        return pulumi.get(self, "on_topology_modification")

    @property
    @pulumi.getter(name="onUpcomingSchedule")
    def on_upcoming_schedule(self) -> bool:
        """
        Enables notification on upcoming schedule.
        """
        return pulumi.get(self, "on_upcoming_schedule")


@pulumi.output_type
class GetFleetsFleetCollectionItemRuleSelectionCriteriaResult(dict):
    def __init__(__self__, *,
                 match_condition: str,
                 rules: Sequence['outputs.GetFleetsFleetCollectionItemRuleSelectionCriteriaRuleResult']):
        """
        :param str match_condition: Rule selection match condition.
        :param Sequence['GetFleetsFleetCollectionItemRuleSelectionCriteriaRuleArgs'] rules: Rules.
        """
        pulumi.set(__self__, "match_condition", match_condition)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="matchCondition")
    def match_condition(self) -> str:
        """
        Rule selection match condition.
        """
        return pulumi.get(self, "match_condition")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetFleetsFleetCollectionItemRuleSelectionCriteriaRuleResult']:
        """
        Rules.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class GetFleetsFleetCollectionItemRuleSelectionCriteriaRuleResult(dict):
    def __init__(__self__, *,
                 basis: str,
                 compartment_id: str,
                 conditions: Sequence['outputs.GetFleetsFleetCollectionItemRuleSelectionCriteriaRuleConditionResult'],
                 resource_compartment_id: str):
        """
        :param str basis: Rule to be be applied on.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetFleetsFleetCollectionItemRuleSelectionCriteriaRuleConditionArgs'] conditions: Rule Conditions
        :param str resource_compartment_id: Resource Compartment Id.Provide the compartmentId the resource belongs to.
        """
        pulumi.set(__self__, "basis", basis)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "resource_compartment_id", resource_compartment_id)

    @property
    @pulumi.getter
    def basis(self) -> str:
        """
        Rule to be be applied on.
        """
        return pulumi.get(self, "basis")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetFleetsFleetCollectionItemRuleSelectionCriteriaRuleConditionResult']:
        """
        Rule Conditions
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> str:
        """
        Resource Compartment Id.Provide the compartmentId the resource belongs to.
        """
        return pulumi.get(self, "resource_compartment_id")


@pulumi.output_type
class GetFleetsFleetCollectionItemRuleSelectionCriteriaRuleConditionResult(dict):
    def __init__(__self__, *,
                 attr_group: str,
                 attr_key: str,
                 attr_value: str):
        """
        :param str attr_group: Attribute Group.
        :param str attr_key: Attribute Key.
        :param str attr_value: Attribute Value.
        """
        pulumi.set(__self__, "attr_group", attr_group)
        pulumi.set(__self__, "attr_key", attr_key)
        pulumi.set(__self__, "attr_value", attr_value)

    @property
    @pulumi.getter(name="attrGroup")
    def attr_group(self) -> str:
        """
        Attribute Group.
        """
        return pulumi.get(self, "attr_group")

    @property
    @pulumi.getter(name="attrKey")
    def attr_key(self) -> str:
        """
        Attribute Key.
        """
        return pulumi.get(self, "attr_key")

    @property
    @pulumi.getter(name="attrValue")
    def attr_value(self) -> str:
        """
        Attribute Value.
        """
        return pulumi.get(self, "attr_value")


@pulumi.output_type
class GetInventoryResourcesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetInventoryResourcesInventoryResourceCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetInventoryResourcesInventoryResourceCollectionItemResult']):
        """
        :param Sequence['GetInventoryResourcesInventoryResourceCollectionItemArgs'] items: List of InventoryResources.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetInventoryResourcesInventoryResourceCollectionItemResult']:
        """
        List of InventoryResources.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetInventoryResourcesInventoryResourceCollectionItemResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 display_name: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 lifecycle_details: str,
                 resource_compartment_id: str,
                 resource_region: str,
                 state: str,
                 system_tags: Mapping[str, str],
                 type: str):
        """
        :param str availability_domain: Availability Domain of the resource
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The OCID of the resource.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str resource_compartment_id: Resource Compartment ID
        :param str resource_region: Resource Region
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str type: Type of the Resource.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "resource_compartment_id", resource_compartment_id)
        pulumi.set(__self__, "resource_region", resource_region)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        Availability Domain of the resource
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> str:
        """
        Resource Compartment ID
        """
        return pulumi.get(self, "resource_compartment_id")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> str:
        """
        Resource Region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the Resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMaintenanceWindowsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMaintenanceWindowsMaintenanceWindowCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetMaintenanceWindowsMaintenanceWindowCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetMaintenanceWindowsMaintenanceWindowCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetMaintenanceWindowsMaintenanceWindowCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 description: str,
                 display_name: str,
                 duration: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 is_outage: bool,
                 is_recurring: bool,
                 lifecycle_details: str,
                 maintenance_window_type: str,
                 recurrences: str,
                 resource_region: str,
                 state: str,
                 system_tags: Mapping[str, str],
                 task_initiation_cutoff: int,
                 time_created: str,
                 time_schedule_start: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str duration: Duration if schedule type is Custom
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: unique MaintenanceWindow identifier
        :param bool is_outage: Does the maintenenace window cause outage?
        :param bool is_recurring: Is this is a recurring maintenance window
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str maintenance_window_type: Type of the MaintenanceWindow.
        :param str recurrences: Recurrence rule specification if recurring
        :param str resource_region: Associated region
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param int task_initiation_cutoff: Task initiation cutoff
        :param str time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param str time_schedule_start: Start time of schedule
        :param str time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_outage", is_outage)
        pulumi.set(__self__, "is_recurring", is_recurring)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "maintenance_window_type", maintenance_window_type)
        pulumi.set(__self__, "recurrences", recurrences)
        pulumi.set(__self__, "resource_region", resource_region)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "task_initiation_cutoff", task_initiation_cutoff)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_schedule_start", time_schedule_start)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration if schedule type is Custom
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique MaintenanceWindow identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isOutage")
    def is_outage(self) -> bool:
        """
        Does the maintenenace window cause outage?
        """
        return pulumi.get(self, "is_outage")

    @property
    @pulumi.getter(name="isRecurring")
    def is_recurring(self) -> bool:
        """
        Is this is a recurring maintenance window
        """
        return pulumi.get(self, "is_recurring")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceWindowType")
    def maintenance_window_type(self) -> str:
        """
        Type of the MaintenanceWindow.
        """
        return pulumi.get(self, "maintenance_window_type")

    @property
    @pulumi.getter
    def recurrences(self) -> str:
        """
        Recurrence rule specification if recurring
        """
        return pulumi.get(self, "recurrences")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="taskInitiationCutoff")
    def task_initiation_cutoff(self) -> int:
        """
        Task initiation cutoff
        """
        return pulumi.get(self, "task_initiation_cutoff")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeScheduleStart")
    def time_schedule_start(self) -> str:
        """
        Start time of schedule
        """
        return pulumi.get(self, "time_schedule_start")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetOnboardingPoliciesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOnboardingPoliciesOnboardingPolicyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOnboardingPoliciesOnboardingPolicyCollectionItemResult']):
        """
        :param Sequence['GetOnboardingPoliciesOnboardingPolicyCollectionItemArgs'] items: List of FleetAppManagementService Onboard policies.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOnboardingPoliciesOnboardingPolicyCollectionItemResult']:
        """
        List of FleetAppManagementService Onboard policies.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOnboardingPoliciesOnboardingPolicyCollectionItemResult(dict):
    def __init__(__self__, *,
                 id: str,
                 statements: Sequence[str],
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str):
        """
        :param str id: The unique id of the resource.
        :param Sequence[str] statements: Policy statements.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "statements", statements)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique id of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def statements(self) -> Sequence[str]:
        """
        Policy statements.
        """
        return pulumi.get(self, "statements")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetOnboardingsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOnboardingsOnboardingCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOnboardingsOnboardingCollectionItemResult']):
        """
        :param Sequence['GetOnboardingsOnboardingCollectionItemArgs'] items: List of FleetAppManagementService Onboardings.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOnboardingsOnboardingCollectionItemResult']:
        """
        List of FleetAppManagementService Onboardings.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOnboardingsOnboardingCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 id: str,
                 is_cost_tracking_tag_enabled: bool,
                 is_fams_tag_enabled: bool,
                 resource_region: str,
                 state: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str,
                 version: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str id: unique onboarding identifier
        :param bool is_cost_tracking_tag_enabled: A value determining if cost tracking tag is enabled or not
        :param bool is_fams_tag_enabled: A value determining FAMS tag is enabled or not
        :param str resource_region: Associated region
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param str version: Version of FAMS the tenant is onboarded to.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_cost_tracking_tag_enabled", is_cost_tracking_tag_enabled)
        pulumi.set(__self__, "is_fams_tag_enabled", is_fams_tag_enabled)
        pulumi.set(__self__, "resource_region", resource_region)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique onboarding identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCostTrackingTagEnabled")
    def is_cost_tracking_tag_enabled(self) -> bool:
        """
        A value determining if cost tracking tag is enabled or not
        """
        return pulumi.get(self, "is_cost_tracking_tag_enabled")

    @property
    @pulumi.getter(name="isFamsTagEnabled")
    def is_fams_tag_enabled(self) -> bool:
        """
        A value determining FAMS tag is enabled or not
        """
        return pulumi.get(self, "is_fams_tag_enabled")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of FAMS the tenant is onboarded to.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetPropertiesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param Sequence[str] values: Values of the property (must be a single value if selection = 'single choice')
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Values of the property (must be a single value if selection = 'single choice')
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPropertiesPropertyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPropertiesPropertyCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPropertiesPropertyCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPropertiesPropertyCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 display_name: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 lifecycle_details: str,
                 resource_region: str,
                 scope: str,
                 selection: str,
                 state: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str,
                 type: str,
                 value_type: str,
                 values: Sequence[str]):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: unique Property identifier
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str resource_region: Associated region
        :param str scope: A filter to return only resources their scope matches the given lifecycleState.
        :param str selection: Text selection of the category
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param str type: The type of the property.
        :param str value_type: Format of the value
        :param Sequence[str] values: Values of the property (must be a single value if selection = 'single choice')
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "resource_region", resource_region)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "selection", selection)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value_type", value_type)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique Property identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        A filter to return only resources their scope matches the given lifecycleState.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def selection(self) -> str:
        """
        Text selection of the category
        """
        return pulumi.get(self, "selection")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the property.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        Format of the value
        """
        return pulumi.get(self, "value_type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Values of the property (must be a single value if selection = 'single choice')
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetRunbookAssociationResult(dict):
    def __init__(__self__, *,
                 execution_workflow_details: Sequence['outputs.GetRunbookAssociationExecutionWorkflowDetailResult'],
                 groups: Sequence['outputs.GetRunbookAssociationGroupResult'],
                 tasks: Sequence['outputs.GetRunbookAssociationTaskResult'],
                 version: str):
        """
        :param Sequence['GetRunbookAssociationExecutionWorkflowDetailArgs'] execution_workflow_details: Execution Workflow.
        :param Sequence['GetRunbookAssociationGroupArgs'] groups: The groups of the runbook
        :param Sequence['GetRunbookAssociationTaskArgs'] tasks: A set of tasks to execute in the runbook
        :param str version: The version of the runbook.
        """
        pulumi.set(__self__, "execution_workflow_details", execution_workflow_details)
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "tasks", tasks)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="executionWorkflowDetails")
    def execution_workflow_details(self) -> Sequence['outputs.GetRunbookAssociationExecutionWorkflowDetailResult']:
        """
        Execution Workflow.
        """
        return pulumi.get(self, "execution_workflow_details")

    @property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetRunbookAssociationGroupResult']:
        """
        The groups of the runbook
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def tasks(self) -> Sequence['outputs.GetRunbookAssociationTaskResult']:
        """
        A set of tasks to execute in the runbook
        """
        return pulumi.get(self, "tasks")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the runbook.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetRunbookAssociationExecutionWorkflowDetailResult(dict):
    def __init__(__self__, *,
                 workflows: Sequence['outputs.GetRunbookAssociationExecutionWorkflowDetailWorkflowResult']):
        """
        :param Sequence['GetRunbookAssociationExecutionWorkflowDetailWorkflowArgs'] workflows: Execution Workflow for the runbook.
        """
        pulumi.set(__self__, "workflows", workflows)

    @property
    @pulumi.getter
    def workflows(self) -> Sequence['outputs.GetRunbookAssociationExecutionWorkflowDetailWorkflowResult']:
        """
        Execution Workflow for the runbook.
        """
        return pulumi.get(self, "workflows")


@pulumi.output_type
class GetRunbookAssociationExecutionWorkflowDetailWorkflowResult(dict):
    def __init__(__self__, *,
                 group_name: str,
                 steps: Sequence['outputs.GetRunbookAssociationExecutionWorkflowDetailWorkflowStepResult'],
                 type: str):
        """
        :param str group_name: Provide the name of the group.
        :param Sequence['GetRunbookAssociationExecutionWorkflowDetailWorkflowStepArgs'] steps: Tasks within the Group. Provide the stepName for all tasks that are applicable
        :param str type: The type of the runbook.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        Provide the name of the group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.GetRunbookAssociationExecutionWorkflowDetailWorkflowStepResult']:
        """
        Tasks within the Group. Provide the stepName for all tasks that are applicable
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the runbook.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRunbookAssociationExecutionWorkflowDetailWorkflowStepResult(dict):
    def __init__(__self__, *,
                 group_name: str,
                 step_name: str,
                 steps: Sequence[str],
                 type: str):
        """
        :param str group_name: Provide the name of the group.
        :param str step_name: The name of the task step.
        :param Sequence[str] steps: Tasks within the Group. Provide the stepName for all tasks that are applicable
        :param str type: The type of the runbook.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "step_name", step_name)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        Provide the name of the group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> str:
        """
        The name of the task step.
        """
        return pulumi.get(self, "step_name")

    @property
    @pulumi.getter
    def steps(self) -> Sequence[str]:
        """
        Tasks within the Group. Provide the stepName for all tasks that are applicable
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the runbook.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRunbookAssociationGroupResult(dict):
    def __init__(__self__, *,
                 name: str,
                 properties: Sequence['outputs.GetRunbookAssociationGroupPropertyResult'],
                 type: str):
        """
        :param str name: The name of the task
        :param Sequence['GetRunbookAssociationGroupPropertyArgs'] properties: The properties of the task.
        :param str type: The type of the runbook.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the task
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetRunbookAssociationGroupPropertyResult']:
        """
        The properties of the task.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the runbook.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRunbookAssociationGroupPropertyResult(dict):
    def __init__(__self__, *,
                 action_on_failure: str,
                 condition: str,
                 run_on: str):
        """
        :param str action_on_failure: The action to be taken in case of task failure.
        :param str condition: The condition in which the task is to be executed.
        :param str run_on: The hosts to execute on.
        """
        pulumi.set(__self__, "action_on_failure", action_on_failure)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "run_on", run_on)

    @property
    @pulumi.getter(name="actionOnFailure")
    def action_on_failure(self) -> str:
        """
        The action to be taken in case of task failure.
        """
        return pulumi.get(self, "action_on_failure")

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        The condition in which the task is to be executed.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="runOn")
    def run_on(self) -> str:
        """
        The hosts to execute on.
        """
        return pulumi.get(self, "run_on")


@pulumi.output_type
class GetRunbookAssociationTaskResult(dict):
    def __init__(__self__, *,
                 association_type: str,
                 output_variable_mappings: Sequence['outputs.GetRunbookAssociationTaskOutputVariableMappingResult'],
                 step_name: str,
                 step_properties: Sequence['outputs.GetRunbookAssociationTaskStepPropertyResult'],
                 task_record_details: Sequence['outputs.GetRunbookAssociationTaskTaskRecordDetailResult']):
        """
        :param str association_type: The association type of the task
        :param Sequence['GetRunbookAssociationTaskOutputVariableMappingArgs'] output_variable_mappings: Mapping output variables of previous tasks to the input variables of the current task.
        :param str step_name: The name of the task step.
        :param Sequence['GetRunbookAssociationTaskStepPropertyArgs'] step_properties: The properties of the task.
        :param Sequence['GetRunbookAssociationTaskTaskRecordDetailArgs'] task_record_details: The details of the task.
        """
        pulumi.set(__self__, "association_type", association_type)
        pulumi.set(__self__, "output_variable_mappings", output_variable_mappings)
        pulumi.set(__self__, "step_name", step_name)
        pulumi.set(__self__, "step_properties", step_properties)
        pulumi.set(__self__, "task_record_details", task_record_details)

    @property
    @pulumi.getter(name="associationType")
    def association_type(self) -> str:
        """
        The association type of the task
        """
        return pulumi.get(self, "association_type")

    @property
    @pulumi.getter(name="outputVariableMappings")
    def output_variable_mappings(self) -> Sequence['outputs.GetRunbookAssociationTaskOutputVariableMappingResult']:
        """
        Mapping output variables of previous tasks to the input variables of the current task.
        """
        return pulumi.get(self, "output_variable_mappings")

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> str:
        """
        The name of the task step.
        """
        return pulumi.get(self, "step_name")

    @property
    @pulumi.getter(name="stepProperties")
    def step_properties(self) -> Sequence['outputs.GetRunbookAssociationTaskStepPropertyResult']:
        """
        The properties of the task.
        """
        return pulumi.get(self, "step_properties")

    @property
    @pulumi.getter(name="taskRecordDetails")
    def task_record_details(self) -> Sequence['outputs.GetRunbookAssociationTaskTaskRecordDetailResult']:
        """
        The details of the task.
        """
        return pulumi.get(self, "task_record_details")


@pulumi.output_type
class GetRunbookAssociationTaskOutputVariableMappingResult(dict):
    def __init__(__self__, *,
                 name: str,
                 output_variable_details: Sequence['outputs.GetRunbookAssociationTaskOutputVariableMappingOutputVariableDetailResult']):
        """
        :param str name: The name of the task
        :param Sequence['GetRunbookAssociationTaskOutputVariableMappingOutputVariableDetailArgs'] output_variable_details: The details of the output variable that will be used for mapping.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "output_variable_details", output_variable_details)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the task
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputVariableDetails")
    def output_variable_details(self) -> Sequence['outputs.GetRunbookAssociationTaskOutputVariableMappingOutputVariableDetailResult']:
        """
        The details of the output variable that will be used for mapping.
        """
        return pulumi.get(self, "output_variable_details")


@pulumi.output_type
class GetRunbookAssociationTaskOutputVariableMappingOutputVariableDetailResult(dict):
    def __init__(__self__, *,
                 output_variable_name: str,
                 step_name: str):
        """
        :param str output_variable_name: The name of the output variable whose value that has to be mapped.
        :param str step_name: The name of the task step.
        """
        pulumi.set(__self__, "output_variable_name", output_variable_name)
        pulumi.set(__self__, "step_name", step_name)

    @property
    @pulumi.getter(name="outputVariableName")
    def output_variable_name(self) -> str:
        """
        The name of the output variable whose value that has to be mapped.
        """
        return pulumi.get(self, "output_variable_name")

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> str:
        """
        The name of the task step.
        """
        return pulumi.get(self, "step_name")


@pulumi.output_type
class GetRunbookAssociationTaskStepPropertyResult(dict):
    def __init__(__self__, *,
                 action_on_failure: str,
                 condition: str,
                 run_on: str):
        """
        :param str action_on_failure: The action to be taken in case of task failure.
        :param str condition: The condition in which the task is to be executed.
        :param str run_on: The hosts to execute on.
        """
        pulumi.set(__self__, "action_on_failure", action_on_failure)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "run_on", run_on)

    @property
    @pulumi.getter(name="actionOnFailure")
    def action_on_failure(self) -> str:
        """
        The action to be taken in case of task failure.
        """
        return pulumi.get(self, "action_on_failure")

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        The condition in which the task is to be executed.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="runOn")
    def run_on(self) -> str:
        """
        The hosts to execute on.
        """
        return pulumi.get(self, "run_on")


@pulumi.output_type
class GetRunbookAssociationTaskTaskRecordDetailResult(dict):
    def __init__(__self__, *,
                 description: str,
                 execution_details: Sequence['outputs.GetRunbookAssociationTaskTaskRecordDetailExecutionDetailResult'],
                 is_copy_to_library_enabled: bool,
                 name: str,
                 os_type: str,
                 platform: str,
                 properties: Sequence['outputs.GetRunbookAssociationTaskTaskRecordDetailPropertyResult'],
                 scope: str,
                 task_record_id: str):
        """
        :param str description: A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param Sequence['GetRunbookAssociationTaskTaskRecordDetailExecutionDetailArgs'] execution_details: Content Source Details
        :param bool is_copy_to_library_enabled: Make a copy of this task in Library
        :param str name: The name of the task
        :param str os_type: The OS type for the runbook.
        :param str platform: The platform of the runbook.
        :param Sequence['GetRunbookAssociationTaskTaskRecordDetailPropertyArgs'] properties: The properties of the task.
        :param str scope: The scope of the task.
        :param str task_record_id: The ID of taskRecord.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "execution_details", execution_details)
        pulumi.set(__self__, "is_copy_to_library_enabled", is_copy_to_library_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "task_record_id", task_record_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executionDetails")
    def execution_details(self) -> Sequence['outputs.GetRunbookAssociationTaskTaskRecordDetailExecutionDetailResult']:
        """
        Content Source Details
        """
        return pulumi.get(self, "execution_details")

    @property
    @pulumi.getter(name="isCopyToLibraryEnabled")
    def is_copy_to_library_enabled(self) -> bool:
        """
        Make a copy of this task in Library
        """
        return pulumi.get(self, "is_copy_to_library_enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the task
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The OS type for the runbook.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        The platform of the runbook.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetRunbookAssociationTaskTaskRecordDetailPropertyResult']:
        """
        The properties of the task.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        The scope of the task.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="taskRecordId")
    def task_record_id(self) -> str:
        """
        The ID of taskRecord.
        """
        return pulumi.get(self, "task_record_id")


@pulumi.output_type
class GetRunbookAssociationTaskTaskRecordDetailExecutionDetailResult(dict):
    def __init__(__self__, *,
                 command: str,
                 contents: Sequence['outputs.GetRunbookAssociationTaskTaskRecordDetailExecutionDetailContentResult'],
                 endpoint: str,
                 execution_type: str,
                 variables: Sequence['outputs.GetRunbookAssociationTaskTaskRecordDetailExecutionDetailVariableResult']):
        """
        :param str command: Optional Command to execute the content.
        :param Sequence['GetRunbookAssociationTaskTaskRecordDetailExecutionDetailContentArgs'] contents: Content Source Details.
        :param str endpoint: Endpoint to be invoked.
        :param str execution_type: The action type of the task
        :param Sequence['GetRunbookAssociationTaskTaskRecordDetailExecutionDetailVariableArgs'] variables: The variable of the task.Atleast one of dynamicArguments or output needs to be provided.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "contents", contents)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "execution_type", execution_type)
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def command(self) -> str:
        """
        Optional Command to execute the content.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def contents(self) -> Sequence['outputs.GetRunbookAssociationTaskTaskRecordDetailExecutionDetailContentResult']:
        """
        Content Source Details.
        """
        return pulumi.get(self, "contents")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Endpoint to be invoked.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="executionType")
    def execution_type(self) -> str:
        """
        The action type of the task
        """
        return pulumi.get(self, "execution_type")

    @property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.GetRunbookAssociationTaskTaskRecordDetailExecutionDetailVariableResult']:
        """
        The variable of the task.Atleast one of dynamicArguments or output needs to be provided.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class GetRunbookAssociationTaskTaskRecordDetailExecutionDetailContentResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 checksum: str,
                 namespace: str,
                 object: str,
                 source_type: str):
        """
        :param str bucket: Bucket Name.
        :param str checksum: SHA256 checksum of the artifact.
        :param str namespace: Namespace.
        :param str object: Object Name.
        :param str source_type: Content Source Details.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket Name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        SHA256 checksum of the artifact.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Object Name.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Content Source Details.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetRunbookAssociationTaskTaskRecordDetailExecutionDetailVariableResult(dict):
    def __init__(__self__, *,
                 input_variables: Sequence['outputs.GetRunbookAssociationTaskTaskRecordDetailExecutionDetailVariableInputVariableResult'],
                 output_variables: Sequence[str]):
        """
        :param Sequence['GetRunbookAssociationTaskTaskRecordDetailExecutionDetailVariableInputVariableArgs'] input_variables: The input variables for the task.
        :param Sequence[str] output_variables: The list of output variables.
        """
        pulumi.set(__self__, "input_variables", input_variables)
        pulumi.set(__self__, "output_variables", output_variables)

    @property
    @pulumi.getter(name="inputVariables")
    def input_variables(self) -> Sequence['outputs.GetRunbookAssociationTaskTaskRecordDetailExecutionDetailVariableInputVariableResult']:
        """
        The input variables for the task.
        """
        return pulumi.get(self, "input_variables")

    @property
    @pulumi.getter(name="outputVariables")
    def output_variables(self) -> Sequence[str]:
        """
        The list of output variables.
        """
        return pulumi.get(self, "output_variables")


@pulumi.output_type
class GetRunbookAssociationTaskTaskRecordDetailExecutionDetailVariableInputVariableResult(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str,
                 type: str):
        """
        :param str description: A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param str name: The name of the task
        :param str type: The type of the runbook.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the task
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the runbook.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRunbookAssociationTaskTaskRecordDetailPropertyResult(dict):
    def __init__(__self__, *,
                 num_retries: int,
                 timeout_in_seconds: int):
        """
        :param int num_retries: The number of retries allowed.
        :param int timeout_in_seconds: The timeout in seconds for the task.
        """
        pulumi.set(__self__, "num_retries", num_retries)
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="numRetries")
    def num_retries(self) -> int:
        """
        The number of retries allowed.
        """
        return pulumi.get(self, "num_retries")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> int:
        """
        The timeout in seconds for the task.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class GetRunbooksFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the task
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the task
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRunbooksRunbookCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRunbooksRunbookCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemResult(dict):
    def __init__(__self__, *,
                 associations: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationResult'],
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 description: str,
                 display_name: str,
                 estimated_time: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 is_default: bool,
                 lifecycle_details: str,
                 operation: str,
                 os_type: str,
                 platform: str,
                 resource_region: str,
                 runbook_relevance: str,
                 state: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str,
                 type: str):
        """
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationArgs'] associations: JSON content with required associations
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str estimated_time: Estimated time to successfully complete the runbook execution
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: unique Runbook identifier
        :param bool is_default: Is the runbook default?
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str operation: The runbook lifecycle.
        :param str os_type: The OS type for the runbook.
        :param str platform: The ID of the runbook platform.
        :param str resource_region: Associated region
        :param str runbook_relevance: The runbook relevance of product or full-stack.
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param str type: The ID of the runbook type.
        """
        pulumi.set(__self__, "associations", associations)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "estimated_time", estimated_time)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "resource_region", resource_region)
        pulumi.set(__self__, "runbook_relevance", runbook_relevance)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def associations(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationResult']:
        """
        JSON content with required associations
        """
        return pulumi.get(self, "associations")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedTime")
    def estimated_time(self) -> str:
        """
        Estimated time to successfully complete the runbook execution
        """
        return pulumi.get(self, "estimated_time")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique Runbook identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Is the runbook default?
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def operation(self) -> str:
        """
        The runbook lifecycle.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The OS type for the runbook.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        The ID of the runbook platform.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter(name="runbookRelevance")
    def runbook_relevance(self) -> str:
        """
        The runbook relevance of product or full-stack.
        """
        return pulumi.get(self, "runbook_relevance")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The ID of the runbook type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationResult(dict):
    def __init__(__self__, *,
                 execution_workflow_details: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailResult'],
                 groups: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationGroupResult'],
                 tasks: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskResult'],
                 version: str):
        """
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailArgs'] execution_workflow_details: Execution Workflow.
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationGroupArgs'] groups: The groups of the runbook
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationTaskArgs'] tasks: A set of tasks to execute in the runbook
        :param str version: The version of the runbook.
        """
        pulumi.set(__self__, "execution_workflow_details", execution_workflow_details)
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "tasks", tasks)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="executionWorkflowDetails")
    def execution_workflow_details(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailResult']:
        """
        Execution Workflow.
        """
        return pulumi.get(self, "execution_workflow_details")

    @property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationGroupResult']:
        """
        The groups of the runbook
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def tasks(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskResult']:
        """
        A set of tasks to execute in the runbook
        """
        return pulumi.get(self, "tasks")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the runbook.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailResult(dict):
    def __init__(__self__, *,
                 workflows: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailWorkflowResult']):
        """
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailWorkflowArgs'] workflows: Execution Workflow for the runbook.
        """
        pulumi.set(__self__, "workflows", workflows)

    @property
    @pulumi.getter
    def workflows(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailWorkflowResult']:
        """
        Execution Workflow for the runbook.
        """
        return pulumi.get(self, "workflows")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailWorkflowResult(dict):
    def __init__(__self__, *,
                 group_name: str,
                 steps: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailWorkflowStepResult'],
                 type: str):
        """
        :param str group_name: Provide the name of the group.
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailWorkflowStepArgs'] steps: Tasks within the Group. Provide the stepName for all tasks that are applicable
        :param str type: The ID of the runbook type.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        Provide the name of the group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailWorkflowStepResult']:
        """
        Tasks within the Group. Provide the stepName for all tasks that are applicable
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The ID of the runbook type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationExecutionWorkflowDetailWorkflowStepResult(dict):
    def __init__(__self__, *,
                 group_name: str,
                 step_name: str,
                 steps: Sequence[str],
                 type: str):
        """
        :param str group_name: Provide the name of the group.
        :param str step_name: The name of the task step.
        :param Sequence[str] steps: Tasks within the Group. Provide the stepName for all tasks that are applicable
        :param str type: The ID of the runbook type.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "step_name", step_name)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        Provide the name of the group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> str:
        """
        The name of the task step.
        """
        return pulumi.get(self, "step_name")

    @property
    @pulumi.getter
    def steps(self) -> Sequence[str]:
        """
        Tasks within the Group. Provide the stepName for all tasks that are applicable
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The ID of the runbook type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationGroupResult(dict):
    def __init__(__self__, *,
                 name: str,
                 properties: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationGroupPropertyResult'],
                 type: str):
        """
        :param str name: The name of the task
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationGroupPropertyArgs'] properties: The properties of the task.
        :param str type: The ID of the runbook type.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the task
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationGroupPropertyResult']:
        """
        The properties of the task.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The ID of the runbook type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationGroupPropertyResult(dict):
    def __init__(__self__, *,
                 action_on_failure: str,
                 condition: str,
                 run_on: str):
        """
        :param str action_on_failure: The action to be taken in case of task failure.
        :param str condition: The condition in which the task is to be executed.
        :param str run_on: The hosts to execute on.
        """
        pulumi.set(__self__, "action_on_failure", action_on_failure)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "run_on", run_on)

    @property
    @pulumi.getter(name="actionOnFailure")
    def action_on_failure(self) -> str:
        """
        The action to be taken in case of task failure.
        """
        return pulumi.get(self, "action_on_failure")

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        The condition in which the task is to be executed.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="runOn")
    def run_on(self) -> str:
        """
        The hosts to execute on.
        """
        return pulumi.get(self, "run_on")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationTaskResult(dict):
    def __init__(__self__, *,
                 association_type: str,
                 output_variable_mappings: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskOutputVariableMappingResult'],
                 step_name: str,
                 step_properties: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskStepPropertyResult'],
                 task_record_details: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailResult']):
        """
        :param str association_type: The association type of the task
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationTaskOutputVariableMappingArgs'] output_variable_mappings: Mapping output variables of previous tasks to the input variables of the current task.
        :param str step_name: The name of the task step.
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationTaskStepPropertyArgs'] step_properties: The properties of the task.
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailArgs'] task_record_details: The details of the task.
        """
        pulumi.set(__self__, "association_type", association_type)
        pulumi.set(__self__, "output_variable_mappings", output_variable_mappings)
        pulumi.set(__self__, "step_name", step_name)
        pulumi.set(__self__, "step_properties", step_properties)
        pulumi.set(__self__, "task_record_details", task_record_details)

    @property
    @pulumi.getter(name="associationType")
    def association_type(self) -> str:
        """
        The association type of the task
        """
        return pulumi.get(self, "association_type")

    @property
    @pulumi.getter(name="outputVariableMappings")
    def output_variable_mappings(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskOutputVariableMappingResult']:
        """
        Mapping output variables of previous tasks to the input variables of the current task.
        """
        return pulumi.get(self, "output_variable_mappings")

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> str:
        """
        The name of the task step.
        """
        return pulumi.get(self, "step_name")

    @property
    @pulumi.getter(name="stepProperties")
    def step_properties(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskStepPropertyResult']:
        """
        The properties of the task.
        """
        return pulumi.get(self, "step_properties")

    @property
    @pulumi.getter(name="taskRecordDetails")
    def task_record_details(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailResult']:
        """
        The details of the task.
        """
        return pulumi.get(self, "task_record_details")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationTaskOutputVariableMappingResult(dict):
    def __init__(__self__, *,
                 name: str,
                 output_variable_details: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskOutputVariableMappingOutputVariableDetailResult']):
        """
        :param str name: The name of the task
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationTaskOutputVariableMappingOutputVariableDetailArgs'] output_variable_details: The details of the output variable that will be used for mapping.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "output_variable_details", output_variable_details)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the task
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputVariableDetails")
    def output_variable_details(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskOutputVariableMappingOutputVariableDetailResult']:
        """
        The details of the output variable that will be used for mapping.
        """
        return pulumi.get(self, "output_variable_details")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationTaskOutputVariableMappingOutputVariableDetailResult(dict):
    def __init__(__self__, *,
                 output_variable_name: str,
                 step_name: str):
        """
        :param str output_variable_name: The name of the output variable whose value that has to be mapped.
        :param str step_name: The name of the task step.
        """
        pulumi.set(__self__, "output_variable_name", output_variable_name)
        pulumi.set(__self__, "step_name", step_name)

    @property
    @pulumi.getter(name="outputVariableName")
    def output_variable_name(self) -> str:
        """
        The name of the output variable whose value that has to be mapped.
        """
        return pulumi.get(self, "output_variable_name")

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> str:
        """
        The name of the task step.
        """
        return pulumi.get(self, "step_name")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationTaskStepPropertyResult(dict):
    def __init__(__self__, *,
                 action_on_failure: str,
                 condition: str,
                 run_on: str):
        """
        :param str action_on_failure: The action to be taken in case of task failure.
        :param str condition: The condition in which the task is to be executed.
        :param str run_on: The hosts to execute on.
        """
        pulumi.set(__self__, "action_on_failure", action_on_failure)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "run_on", run_on)

    @property
    @pulumi.getter(name="actionOnFailure")
    def action_on_failure(self) -> str:
        """
        The action to be taken in case of task failure.
        """
        return pulumi.get(self, "action_on_failure")

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        The condition in which the task is to be executed.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="runOn")
    def run_on(self) -> str:
        """
        The hosts to execute on.
        """
        return pulumi.get(self, "run_on")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailResult(dict):
    def __init__(__self__, *,
                 description: str,
                 execution_details: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailResult'],
                 is_copy_to_library_enabled: bool,
                 name: str,
                 os_type: str,
                 platform: str,
                 properties: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailPropertyResult'],
                 scope: str,
                 task_record_id: str):
        """
        :param str description: A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailArgs'] execution_details: Content Source Details
        :param bool is_copy_to_library_enabled: Make a copy of this task in Library
        :param str name: The name of the task
        :param str os_type: The OS type for the runbook.
        :param str platform: The ID of the runbook platform.
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailPropertyArgs'] properties: The properties of the task.
        :param str scope: The scope of the task.
        :param str task_record_id: The ID of taskRecord.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "execution_details", execution_details)
        pulumi.set(__self__, "is_copy_to_library_enabled", is_copy_to_library_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "task_record_id", task_record_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executionDetails")
    def execution_details(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailResult']:
        """
        Content Source Details
        """
        return pulumi.get(self, "execution_details")

    @property
    @pulumi.getter(name="isCopyToLibraryEnabled")
    def is_copy_to_library_enabled(self) -> bool:
        """
        Make a copy of this task in Library
        """
        return pulumi.get(self, "is_copy_to_library_enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the task
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The OS type for the runbook.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        The ID of the runbook platform.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailPropertyResult']:
        """
        The properties of the task.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        The scope of the task.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="taskRecordId")
    def task_record_id(self) -> str:
        """
        The ID of taskRecord.
        """
        return pulumi.get(self, "task_record_id")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailResult(dict):
    def __init__(__self__, *,
                 command: str,
                 contents: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailContentResult'],
                 endpoint: str,
                 execution_type: str,
                 variables: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailVariableResult']):
        """
        :param str command: Optional Command to execute the content.
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailContentArgs'] contents: Content Source Details.
        :param str endpoint: Endpoint to be invoked.
        :param str execution_type: The action type of the task
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailVariableArgs'] variables: The variable of the task.Atleast one of dynamicArguments or output needs to be provided.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "contents", contents)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "execution_type", execution_type)
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def command(self) -> str:
        """
        Optional Command to execute the content.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def contents(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailContentResult']:
        """
        Content Source Details.
        """
        return pulumi.get(self, "contents")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Endpoint to be invoked.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="executionType")
    def execution_type(self) -> str:
        """
        The action type of the task
        """
        return pulumi.get(self, "execution_type")

    @property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailVariableResult']:
        """
        The variable of the task.Atleast one of dynamicArguments or output needs to be provided.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailContentResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 checksum: str,
                 namespace: str,
                 object: str,
                 source_type: str):
        """
        :param str bucket: Bucket Name.
        :param str checksum: SHA256 checksum of the artifact.
        :param str namespace: Namespace.
        :param str object: Object Name.
        :param str source_type: Content Source Details.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket Name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        SHA256 checksum of the artifact.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Object Name.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Content Source Details.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailVariableResult(dict):
    def __init__(__self__, *,
                 input_variables: Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailVariableInputVariableResult'],
                 output_variables: Sequence[str]):
        """
        :param Sequence['GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailVariableInputVariableArgs'] input_variables: The input variables for the task.
        :param Sequence[str] output_variables: The list of output variables.
        """
        pulumi.set(__self__, "input_variables", input_variables)
        pulumi.set(__self__, "output_variables", output_variables)

    @property
    @pulumi.getter(name="inputVariables")
    def input_variables(self) -> Sequence['outputs.GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailVariableInputVariableResult']:
        """
        The input variables for the task.
        """
        return pulumi.get(self, "input_variables")

    @property
    @pulumi.getter(name="outputVariables")
    def output_variables(self) -> Sequence[str]:
        """
        The list of output variables.
        """
        return pulumi.get(self, "output_variables")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailExecutionDetailVariableInputVariableResult(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str,
                 type: str):
        """
        :param str description: A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param str name: The name of the task
        :param str type: The ID of the runbook type.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the task
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The ID of the runbook type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRunbooksRunbookCollectionItemAssociationTaskTaskRecordDetailPropertyResult(dict):
    def __init__(__self__, *,
                 num_retries: int,
                 timeout_in_seconds: int):
        """
        :param int num_retries: The number of retries allowed.
        :param int timeout_in_seconds: The timeout in seconds for the task.
        """
        pulumi.set(__self__, "num_retries", num_retries)
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="numRetries")
    def num_retries(self) -> int:
        """
        The number of retries allowed.
        """
        return pulumi.get(self, "num_retries")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> int:
        """
        The timeout in seconds for the task.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class GetSchedulerDefinitionActionGroupResult(dict):
    def __init__(__self__, *,
                 application_type: str,
                 lifecycle_operation: str,
                 product: str,
                 resource_id: str,
                 runbook_id: str,
                 subjects: Sequence[str],
                 target_id: str,
                 type: str):
        """
        :param str application_type: Application Type associated. Only applicable if type is ENVIRONMENT.
        :param str lifecycle_operation: LifeCycle Operation
        :param str product: Product associated. Only applicable if type is PRODUCT.
        :param str resource_id: Provide the ID of the resource; Ex- fleetId.
        :param str runbook_id: ID of the runbook
        :param Sequence[str] subjects: Provide subjects that need to be considered for the schedule.
        :param str target_id: Provide the target if schedule is created against the target
        :param str type: Schedule Type
        """
        pulumi.set(__self__, "application_type", application_type)
        pulumi.set(__self__, "lifecycle_operation", lifecycle_operation)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "runbook_id", runbook_id)
        pulumi.set(__self__, "subjects", subjects)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> str:
        """
        Application Type associated. Only applicable if type is ENVIRONMENT.
        """
        return pulumi.get(self, "application_type")

    @property
    @pulumi.getter(name="lifecycleOperation")
    def lifecycle_operation(self) -> str:
        """
        LifeCycle Operation
        """
        return pulumi.get(self, "lifecycle_operation")

    @property
    @pulumi.getter
    def product(self) -> str:
        """
        Product associated. Only applicable if type is PRODUCT.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        Provide the ID of the resource; Ex- fleetId.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> str:
        """
        ID of the runbook
        """
        return pulumi.get(self, "runbook_id")

    @property
    @pulumi.getter
    def subjects(self) -> Sequence[str]:
        """
        Provide subjects that need to be considered for the schedule.
        """
        return pulumi.get(self, "subjects")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        Provide the target if schedule is created against the target
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Schedule Type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetSchedulerDefinitionRunBookResult(dict):
    def __init__(__self__, *,
                 id: str,
                 input_parameters: Sequence['outputs.GetSchedulerDefinitionRunBookInputParameterResult']):
        """
        :param str id: The ID of the Runbook
        :param Sequence['GetSchedulerDefinitionRunBookInputParameterArgs'] input_parameters: Input Parameters for the Task
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "input_parameters", input_parameters)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Runbook
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Sequence['outputs.GetSchedulerDefinitionRunBookInputParameterResult']:
        """
        Input Parameters for the Task
        """
        return pulumi.get(self, "input_parameters")


@pulumi.output_type
class GetSchedulerDefinitionRunBookInputParameterResult(dict):
    def __init__(__self__, *,
                 arguments: Sequence['outputs.GetSchedulerDefinitionRunBookInputParameterArgumentResult'],
                 step_name: str):
        """
        :param Sequence['GetSchedulerDefinitionRunBookInputParameterArgumentArgs'] arguments: Arguments for the Task
        :param str step_name: stepName for which the input parameters are provided
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "step_name", step_name)

    @property
    @pulumi.getter
    def arguments(self) -> Sequence['outputs.GetSchedulerDefinitionRunBookInputParameterArgumentResult']:
        """
        Arguments for the Task
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> str:
        """
        stepName for which the input parameters are provided
        """
        return pulumi.get(self, "step_name")


@pulumi.output_type
class GetSchedulerDefinitionRunBookInputParameterArgumentResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Name of the output variable
        :param str value: The task output
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the output variable
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The task output
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetSchedulerDefinitionScheduleResult(dict):
    def __init__(__self__, *,
                 duration: str,
                 execution_startdate: str,
                 maintenance_window_id: str,
                 recurrences: str,
                 type: str):
        """
        :param str duration: Duration if schedule type is Custom
        :param str execution_startdate: Start Date for the schedule. An RFC3339 formatted datetime string
        :param str maintenance_window_id: Provide MaintenanceWindowId if Schedule Type is Maintenance Window
        :param str recurrences: Recurrence rule specification if Schedule Type is Custom and Recurring
        :param str type: Schedule Type
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "execution_startdate", execution_startdate)
        pulumi.set(__self__, "maintenance_window_id", maintenance_window_id)
        pulumi.set(__self__, "recurrences", recurrences)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration if schedule type is Custom
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="executionStartdate")
    def execution_startdate(self) -> str:
        """
        Start Date for the schedule. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "execution_startdate")

    @property
    @pulumi.getter(name="maintenanceWindowId")
    def maintenance_window_id(self) -> str:
        """
        Provide MaintenanceWindowId if Schedule Type is Maintenance Window
        """
        return pulumi.get(self, "maintenance_window_id")

    @property
    @pulumi.getter
    def recurrences(self) -> str:
        """
        Recurrence rule specification if Schedule Type is Custom and Recurring
        """
        return pulumi.get(self, "recurrences")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Schedule Type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetSchedulerDefinitionScheduledFleetsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSchedulerDefinitionScheduledFleetsScheduledFleetCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSchedulerDefinitionScheduledFleetsScheduledFleetCollectionItemResult']):
        """
        :param Sequence['GetSchedulerDefinitionScheduledFleetsScheduledFleetCollectionItemArgs'] items: List of ScheduledFleets.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSchedulerDefinitionScheduledFleetsScheduledFleetCollectionItemResult']:
        """
        List of ScheduledFleets.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSchedulerDefinitionScheduledFleetsScheduledFleetCollectionItemResult(dict):
    def __init__(__self__, *,
                 action_group_types: Sequence[str],
                 application_types: Sequence[str],
                 count_of_affected_resources: int,
                 count_of_affected_targets: int,
                 display_name: str,
                 id: str,
                 system_tags: Mapping[str, str],
                 tenancy_id: str):
        """
        :param Sequence[str] action_group_types: All ActionGroup Types part of the schedule.
        :param Sequence[str] application_types: All application types part of the schedule.
        :param int count_of_affected_resources: Count of Resources affected by the Schedule
        :param int count_of_affected_targets: Count of Targets affected by the Schedule
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str id: The OCID of the resource.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str tenancy_id: OCID of the tenancy to which the resource belongs to.
        """
        pulumi.set(__self__, "action_group_types", action_group_types)
        pulumi.set(__self__, "application_types", application_types)
        pulumi.set(__self__, "count_of_affected_resources", count_of_affected_resources)
        pulumi.set(__self__, "count_of_affected_targets", count_of_affected_targets)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "tenancy_id", tenancy_id)

    @property
    @pulumi.getter(name="actionGroupTypes")
    def action_group_types(self) -> Sequence[str]:
        """
        All ActionGroup Types part of the schedule.
        """
        return pulumi.get(self, "action_group_types")

    @property
    @pulumi.getter(name="applicationTypes")
    def application_types(self) -> Sequence[str]:
        """
        All application types part of the schedule.
        """
        return pulumi.get(self, "application_types")

    @property
    @pulumi.getter(name="countOfAffectedResources")
    def count_of_affected_resources(self) -> int:
        """
        Count of Resources affected by the Schedule
        """
        return pulumi.get(self, "count_of_affected_resources")

    @property
    @pulumi.getter(name="countOfAffectedTargets")
    def count_of_affected_targets(self) -> int:
        """
        Count of Targets affected by the Schedule
        """
        return pulumi.get(self, "count_of_affected_targets")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        OCID of the tenancy to which the resource belongs to.
        """
        return pulumi.get(self, "tenancy_id")


@pulumi.output_type
class GetSchedulerDefinitionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the output variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the output variable
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSchedulerDefinitionsSchedulerDefinitionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSchedulerDefinitionsSchedulerDefinitionCollectionItemResult(dict):
    def __init__(__self__, *,
                 action_group_types: Sequence[str],
                 action_groups: Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionItemActionGroupResult'],
                 activity_initiation_cut_off: int,
                 application_types: Sequence[str],
                 compartment_id: str,
                 count_of_affected_action_groups: int,
                 count_of_affected_resources: int,
                 count_of_affected_targets: int,
                 defined_tags: Mapping[str, str],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 lifecycle_details: str,
                 lifecycle_operations: Sequence[str],
                 products: Sequence[str],
                 resource_region: str,
                 run_books: Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookResult'],
                 schedules: Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionItemScheduleResult'],
                 state: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_of_next_run: str,
                 time_updated: str):
        """
        :param Sequence[str] action_group_types: All ActionGroup Types part of the schedule.
        :param Sequence['GetSchedulerDefinitionsSchedulerDefinitionCollectionItemActionGroupArgs'] action_groups: Action Groups associated with the Schedule.
        :param int activity_initiation_cut_off: Activity Initiation Cut Off
        :param Sequence[str] application_types: All application types part of the schedule for ENVIRONMENT ActionGroup Type.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param int count_of_affected_action_groups: Count of Action Groups affected by the Schedule.
        :param int count_of_affected_resources: Count of Resources affected by the Schedule
        :param int count_of_affected_targets: Count of Targets affected by the Schedule
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: unique SchedulerDefinition identifier
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence[str] lifecycle_operations: All LifeCycle Operations part of the schedule
        :param Sequence[str] products: All products part of the schedule for PRODUCT ActionGroup Type.
        :param str resource_region: Associated region
        :param Sequence['GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookArgs'] run_books: Runbooks.
        :param Sequence['GetSchedulerDefinitionsSchedulerDefinitionCollectionItemScheduleArgs'] schedules: Schedule Information.
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param str time_of_next_run: Scheduled date for the next run of the Job.
        :param str time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "action_group_types", action_group_types)
        pulumi.set(__self__, "action_groups", action_groups)
        pulumi.set(__self__, "activity_initiation_cut_off", activity_initiation_cut_off)
        pulumi.set(__self__, "application_types", application_types)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "count_of_affected_action_groups", count_of_affected_action_groups)
        pulumi.set(__self__, "count_of_affected_resources", count_of_affected_resources)
        pulumi.set(__self__, "count_of_affected_targets", count_of_affected_targets)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "lifecycle_operations", lifecycle_operations)
        pulumi.set(__self__, "products", products)
        pulumi.set(__self__, "resource_region", resource_region)
        pulumi.set(__self__, "run_books", run_books)
        pulumi.set(__self__, "schedules", schedules)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_of_next_run", time_of_next_run)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="actionGroupTypes")
    def action_group_types(self) -> Sequence[str]:
        """
        All ActionGroup Types part of the schedule.
        """
        return pulumi.get(self, "action_group_types")

    @property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionItemActionGroupResult']:
        """
        Action Groups associated with the Schedule.
        """
        return pulumi.get(self, "action_groups")

    @property
    @pulumi.getter(name="activityInitiationCutOff")
    def activity_initiation_cut_off(self) -> int:
        """
        Activity Initiation Cut Off
        """
        return pulumi.get(self, "activity_initiation_cut_off")

    @property
    @pulumi.getter(name="applicationTypes")
    def application_types(self) -> Sequence[str]:
        """
        All application types part of the schedule for ENVIRONMENT ActionGroup Type.
        """
        return pulumi.get(self, "application_types")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="countOfAffectedActionGroups")
    def count_of_affected_action_groups(self) -> int:
        """
        Count of Action Groups affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_action_groups")

    @property
    @pulumi.getter(name="countOfAffectedResources")
    def count_of_affected_resources(self) -> int:
        """
        Count of Resources affected by the Schedule
        """
        return pulumi.get(self, "count_of_affected_resources")

    @property
    @pulumi.getter(name="countOfAffectedTargets")
    def count_of_affected_targets(self) -> int:
        """
        Count of Targets affected by the Schedule
        """
        return pulumi.get(self, "count_of_affected_targets")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique SchedulerDefinition identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleOperations")
    def lifecycle_operations(self) -> Sequence[str]:
        """
        All LifeCycle Operations part of the schedule
        """
        return pulumi.get(self, "lifecycle_operations")

    @property
    @pulumi.getter
    def products(self) -> Sequence[str]:
        """
        All products part of the schedule for PRODUCT ActionGroup Type.
        """
        return pulumi.get(self, "products")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter(name="runBooks")
    def run_books(self) -> Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookResult']:
        """
        Runbooks.
        """
        return pulumi.get(self, "run_books")

    @property
    @pulumi.getter
    def schedules(self) -> Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionItemScheduleResult']:
        """
        Schedule Information.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfNextRun")
    def time_of_next_run(self) -> str:
        """
        Scheduled date for the next run of the Job.
        """
        return pulumi.get(self, "time_of_next_run")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetSchedulerDefinitionsSchedulerDefinitionCollectionItemActionGroupResult(dict):
    def __init__(__self__, *,
                 application_type: str,
                 lifecycle_operation: str,
                 product: str,
                 resource_id: str,
                 runbook_id: str,
                 subjects: Sequence[str],
                 target_id: str,
                 type: str):
        """
        :param str application_type: Application Type associated. Only applicable if type is ENVIRONMENT.
        :param str lifecycle_operation: LifeCycle Operation
        :param str product: A filter to return only Scheduler Definitions whose assocaited product matches the given product
        :param str resource_id: Provide the ID of the resource; Ex- fleetId.
        :param str runbook_id: ID of the runbook
        :param Sequence[str] subjects: Provide subjects that need to be considered for the schedule.
        :param str target_id: Provide the target if schedule is created against the target
        :param str type: Schedule Type
        """
        pulumi.set(__self__, "application_type", application_type)
        pulumi.set(__self__, "lifecycle_operation", lifecycle_operation)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "runbook_id", runbook_id)
        pulumi.set(__self__, "subjects", subjects)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> str:
        """
        Application Type associated. Only applicable if type is ENVIRONMENT.
        """
        return pulumi.get(self, "application_type")

    @property
    @pulumi.getter(name="lifecycleOperation")
    def lifecycle_operation(self) -> str:
        """
        LifeCycle Operation
        """
        return pulumi.get(self, "lifecycle_operation")

    @property
    @pulumi.getter
    def product(self) -> str:
        """
        A filter to return only Scheduler Definitions whose assocaited product matches the given product
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        Provide the ID of the resource; Ex- fleetId.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> str:
        """
        ID of the runbook
        """
        return pulumi.get(self, "runbook_id")

    @property
    @pulumi.getter
    def subjects(self) -> Sequence[str]:
        """
        Provide subjects that need to be considered for the schedule.
        """
        return pulumi.get(self, "subjects")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        Provide the target if schedule is created against the target
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Schedule Type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookResult(dict):
    def __init__(__self__, *,
                 id: str,
                 input_parameters: Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookInputParameterResult']):
        """
        :param str id: unique SchedulerDefinition identifier
        :param Sequence['GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookInputParameterArgs'] input_parameters: Input Parameters for the Task
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "input_parameters", input_parameters)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique SchedulerDefinition identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookInputParameterResult']:
        """
        Input Parameters for the Task
        """
        return pulumi.get(self, "input_parameters")


@pulumi.output_type
class GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookInputParameterResult(dict):
    def __init__(__self__, *,
                 arguments: Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookInputParameterArgumentResult'],
                 step_name: str):
        """
        :param Sequence['GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookInputParameterArgumentArgs'] arguments: Arguments for the Task
        :param str step_name: stepName for which the input parameters are provided
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "step_name", step_name)

    @property
    @pulumi.getter
    def arguments(self) -> Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookInputParameterArgumentResult']:
        """
        Arguments for the Task
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> str:
        """
        stepName for which the input parameters are provided
        """
        return pulumi.get(self, "step_name")


@pulumi.output_type
class GetSchedulerDefinitionsSchedulerDefinitionCollectionItemRunBookInputParameterArgumentResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Name of the output variable
        :param str value: The task output
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the output variable
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The task output
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetSchedulerDefinitionsSchedulerDefinitionCollectionItemScheduleResult(dict):
    def __init__(__self__, *,
                 duration: str,
                 execution_startdate: str,
                 maintenance_window_id: str,
                 recurrences: str,
                 type: str):
        """
        :param str duration: Duration if schedule type is Custom
        :param str execution_startdate: Start Date for the schedule. An RFC3339 formatted datetime string
        :param str maintenance_window_id: unique MaintenanceWindow identifier
        :param str recurrences: Recurrence rule specification if Schedule Type is Custom and Recurring
        :param str type: Schedule Type
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "execution_startdate", execution_startdate)
        pulumi.set(__self__, "maintenance_window_id", maintenance_window_id)
        pulumi.set(__self__, "recurrences", recurrences)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration if schedule type is Custom
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="executionStartdate")
    def execution_startdate(self) -> str:
        """
        Start Date for the schedule. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "execution_startdate")

    @property
    @pulumi.getter(name="maintenanceWindowId")
    def maintenance_window_id(self) -> str:
        """
        unique MaintenanceWindow identifier
        """
        return pulumi.get(self, "maintenance_window_id")

    @property
    @pulumi.getter
    def recurrences(self) -> str:
        """
        Recurrence rule specification if Schedule Type is Custom and Recurring
        """
        return pulumi.get(self, "recurrences")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Schedule Type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTaskRecordDetailResult(dict):
    def __init__(__self__, *,
                 execution_details: Sequence['outputs.GetTaskRecordDetailExecutionDetailResult'],
                 os_type: str,
                 platform: str,
                 properties: Sequence['outputs.GetTaskRecordDetailPropertyResult'],
                 scope: str):
        """
        :param Sequence['GetTaskRecordDetailExecutionDetailArgs'] execution_details: Content Source Details
        :param str os_type: The OS for the task
        :param str platform: The platform of the runbook.
        :param Sequence['GetTaskRecordDetailPropertyArgs'] properties: The properties of the task.
        :param str scope: The scope of the task
        """
        pulumi.set(__self__, "execution_details", execution_details)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="executionDetails")
    def execution_details(self) -> Sequence['outputs.GetTaskRecordDetailExecutionDetailResult']:
        """
        Content Source Details
        """
        return pulumi.get(self, "execution_details")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The OS for the task
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        The platform of the runbook.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetTaskRecordDetailPropertyResult']:
        """
        The properties of the task.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        The scope of the task
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class GetTaskRecordDetailExecutionDetailResult(dict):
    def __init__(__self__, *,
                 command: str,
                 contents: Sequence['outputs.GetTaskRecordDetailExecutionDetailContentResult'],
                 endpoint: str,
                 execution_type: str,
                 variables: Sequence['outputs.GetTaskRecordDetailExecutionDetailVariableResult']):
        """
        :param str command: Optional Command to execute the content.
        :param Sequence['GetTaskRecordDetailExecutionDetailContentArgs'] contents: Content Source Details.
        :param str endpoint: Endpoint to be invoked.
        :param str execution_type: The action type of the task
        :param Sequence['GetTaskRecordDetailExecutionDetailVariableArgs'] variables: The variable of the task.Atleast one of dynamicArguments or output needs to be provided.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "contents", contents)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "execution_type", execution_type)
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def command(self) -> str:
        """
        Optional Command to execute the content.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def contents(self) -> Sequence['outputs.GetTaskRecordDetailExecutionDetailContentResult']:
        """
        Content Source Details.
        """
        return pulumi.get(self, "contents")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Endpoint to be invoked.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="executionType")
    def execution_type(self) -> str:
        """
        The action type of the task
        """
        return pulumi.get(self, "execution_type")

    @property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.GetTaskRecordDetailExecutionDetailVariableResult']:
        """
        The variable of the task.Atleast one of dynamicArguments or output needs to be provided.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class GetTaskRecordDetailExecutionDetailContentResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 checksum: str,
                 namespace: str,
                 object: str,
                 source_type: str):
        """
        :param str bucket: Bucket Name.
        :param str checksum: SHA256 checksum of the artifact.
        :param str namespace: Namespace.
        :param str object: Object Name.
        :param str source_type: Content Source Details.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket Name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        SHA256 checksum of the artifact.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Object Name.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Content Source Details.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetTaskRecordDetailExecutionDetailVariableResult(dict):
    def __init__(__self__, *,
                 input_variables: Sequence['outputs.GetTaskRecordDetailExecutionDetailVariableInputVariableResult'],
                 output_variables: Sequence[str]):
        """
        :param Sequence['GetTaskRecordDetailExecutionDetailVariableInputVariableArgs'] input_variables: The input variables for the task.
        :param Sequence[str] output_variables: The list of output variables.
        """
        pulumi.set(__self__, "input_variables", input_variables)
        pulumi.set(__self__, "output_variables", output_variables)

    @property
    @pulumi.getter(name="inputVariables")
    def input_variables(self) -> Sequence['outputs.GetTaskRecordDetailExecutionDetailVariableInputVariableResult']:
        """
        The input variables for the task.
        """
        return pulumi.get(self, "input_variables")

    @property
    @pulumi.getter(name="outputVariables")
    def output_variables(self) -> Sequence[str]:
        """
        The list of output variables.
        """
        return pulumi.get(self, "output_variables")


@pulumi.output_type
class GetTaskRecordDetailExecutionDetailVariableInputVariableResult(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str,
                 type: str):
        """
        :param str description: The description of the argument.
        :param str name: The name of the argument
        :param str type: Task type.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the argument.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the argument
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Task type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTaskRecordDetailPropertyResult(dict):
    def __init__(__self__, *,
                 num_retries: int,
                 timeout_in_seconds: int):
        """
        :param int num_retries: The number of retries allowed.
        :param int timeout_in_seconds: The timeout in seconds for the task.
        """
        pulumi.set(__self__, "num_retries", num_retries)
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="numRetries")
    def num_retries(self) -> int:
        """
        The number of retries allowed.
        """
        return pulumi.get(self, "num_retries")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> int:
        """
        The timeout in seconds for the task.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class GetTaskRecordsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the argument
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the argument
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetTaskRecordsTaskRecordCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetTaskRecordsTaskRecordCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 description: str,
                 details: Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemDetailResult'],
                 display_name: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 lifecycle_details: str,
                 resource_region: str,
                 state: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str,
                 type: str,
                 version: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: The description of the argument.
        :param Sequence['GetTaskRecordsTaskRecordCollectionItemDetailArgs'] details: The details of the task.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: unique TaskDetail identifier
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str resource_region: Associated region
        :param str state: The current state of the Task.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param str type: The type of the Task.
        :param str version: The version of the task
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "resource_region", resource_region)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the argument.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemDetailResult']:
        """
        The details of the task.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique TaskDetail identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Task.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the Task.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the task
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetTaskRecordsTaskRecordCollectionItemDetailResult(dict):
    def __init__(__self__, *,
                 execution_details: Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailResult'],
                 os_type: str,
                 platform: str,
                 properties: Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemDetailPropertyResult'],
                 scope: str):
        """
        :param Sequence['GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailArgs'] execution_details: Content Source Details
        :param str os_type: The OS for the task
        :param str platform: The platform for the Task.
        :param Sequence['GetTaskRecordsTaskRecordCollectionItemDetailPropertyArgs'] properties: The properties of the task.
        :param str scope: The scope of the task
        """
        pulumi.set(__self__, "execution_details", execution_details)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="executionDetails")
    def execution_details(self) -> Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailResult']:
        """
        Content Source Details
        """
        return pulumi.get(self, "execution_details")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The OS for the task
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        The platform for the Task.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemDetailPropertyResult']:
        """
        The properties of the task.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        The scope of the task
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailResult(dict):
    def __init__(__self__, *,
                 command: str,
                 contents: Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailContentResult'],
                 endpoint: str,
                 execution_type: str,
                 variables: Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailVariableResult']):
        """
        :param str command: Optional Command to execute the content.
        :param Sequence['GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailContentArgs'] contents: Content Source Details.
        :param str endpoint: Endpoint to be invoked.
        :param str execution_type: The action type of the task
        :param Sequence['GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailVariableArgs'] variables: The variable of the task.Atleast one of dynamicArguments or output needs to be provided.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "contents", contents)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "execution_type", execution_type)
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def command(self) -> str:
        """
        Optional Command to execute the content.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def contents(self) -> Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailContentResult']:
        """
        Content Source Details.
        """
        return pulumi.get(self, "contents")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Endpoint to be invoked.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="executionType")
    def execution_type(self) -> str:
        """
        The action type of the task
        """
        return pulumi.get(self, "execution_type")

    @property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailVariableResult']:
        """
        The variable of the task.Atleast one of dynamicArguments or output needs to be provided.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailContentResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 checksum: str,
                 namespace: str,
                 object: str,
                 source_type: str):
        """
        :param str bucket: Bucket Name.
        :param str checksum: SHA256 checksum of the artifact.
        :param str namespace: Namespace.
        :param str object: Object Name.
        :param str source_type: Content Source Details.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket Name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        SHA256 checksum of the artifact.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Object Name.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Content Source Details.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailVariableResult(dict):
    def __init__(__self__, *,
                 input_variables: Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailVariableInputVariableResult'],
                 output_variables: Sequence[str]):
        """
        :param Sequence['GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailVariableInputVariableArgs'] input_variables: The input variables for the task.
        :param Sequence[str] output_variables: The list of output variables.
        """
        pulumi.set(__self__, "input_variables", input_variables)
        pulumi.set(__self__, "output_variables", output_variables)

    @property
    @pulumi.getter(name="inputVariables")
    def input_variables(self) -> Sequence['outputs.GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailVariableInputVariableResult']:
        """
        The input variables for the task.
        """
        return pulumi.get(self, "input_variables")

    @property
    @pulumi.getter(name="outputVariables")
    def output_variables(self) -> Sequence[str]:
        """
        The list of output variables.
        """
        return pulumi.get(self, "output_variables")


@pulumi.output_type
class GetTaskRecordsTaskRecordCollectionItemDetailExecutionDetailVariableInputVariableResult(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str,
                 type: str):
        """
        :param str description: The description of the argument.
        :param str name: The name of the argument
        :param str type: The type of the Task.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the argument.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the argument
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the Task.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTaskRecordsTaskRecordCollectionItemDetailPropertyResult(dict):
    def __init__(__self__, *,
                 num_retries: int,
                 timeout_in_seconds: int):
        """
        :param int num_retries: The number of retries allowed.
        :param int timeout_in_seconds: The timeout in seconds for the task.
        """
        pulumi.set(__self__, "num_retries", num_retries)
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="numRetries")
    def num_retries(self) -> int:
        """
        The number of retries allowed.
        """
        return pulumi.get(self, "num_retries")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> int:
        """
        The timeout in seconds for the task.
        """
        return pulumi.get(self, "timeout_in_seconds")


