# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetQueriesResult',
    'AwaitableGetQueriesResult',
    'get_queries',
    'get_queries_output',
]

@pulumi.output_type
class GetQueriesResult:
    """
    A collection of values returned by getQueries.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, query_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if query_collections and not isinstance(query_collections, list):
            raise TypeError("Expected argument 'query_collections' to be a list")
        pulumi.set(__self__, "query_collections", query_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetQueriesFilterResult']]:
        """
        The filter object for query usage.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="queryCollections")
    def query_collections(self) -> Sequence['outputs.GetQueriesQueryCollectionResult']:
        """
        The list of query_collection.
        """
        return pulumi.get(self, "query_collections")


class AwaitableGetQueriesResult(GetQueriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueriesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            query_collections=self.query_collections)


def get_queries(compartment_id: Optional[str] = None,
                filters: Optional[Sequence[Union['GetQueriesFilterArgs', 'GetQueriesFilterArgsDict']]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueriesResult:
    """
    This data source provides the list of Queries in Oracle Cloud Infrastructure Metering Computation service.

    Returns the saved query list.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_queries = oci.MeteringComputation.get_queries(compartment_id=compartment_id)
    ```


    :param str compartment_id: The compartment ID in which to list resources.
    :param Sequence[Union['GetQueriesFilterArgs', 'GetQueriesFilterArgsDict']] filters: The filter object for query usage.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MeteringComputation/getQueries:getQueries', __args__, opts=opts, typ=GetQueriesResult).value

    return AwaitableGetQueriesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        query_collections=pulumi.get(__ret__, 'query_collections'))
def get_queries_output(compartment_id: Optional[pulumi.Input[str]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetQueriesFilterArgs', 'GetQueriesFilterArgsDict']]]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetQueriesResult]:
    """
    This data source provides the list of Queries in Oracle Cloud Infrastructure Metering Computation service.

    Returns the saved query list.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_queries = oci.MeteringComputation.get_queries(compartment_id=compartment_id)
    ```


    :param str compartment_id: The compartment ID in which to list resources.
    :param Sequence[Union['GetQueriesFilterArgs', 'GetQueriesFilterArgsDict']] filters: The filter object for query usage.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:MeteringComputation/getQueries:getQueries', __args__, opts=opts, typ=GetQueriesResult)
    return __ret__.apply(lambda __response__: GetQueriesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        query_collections=pulumi.get(__response__, 'query_collections')))
